/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml;

import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.data.xml.XmlCutter;
import com.bmw.gki.logging.GKILogManager;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SchemaVersionRetriever {
    private static final Log LOG = GKILogManager.getInstance().getLogger(SchemaVersionRetriever.class);
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public String getRefSchema(String xml) throws XMLBearbeitungsException {
        String sReturn = this.getSchemaAttribute(xml, "refSchema");
        if (sReturn == null || sReturn.equals("")) {
            sReturn = this.getRefSchemaFromXmlData(xml);
        }
        return sReturn;
    }

    private String getRefSchemaFromXmlData(String xmlData) {
        XmlCutter cutter = new XmlCutter(xmlData);
        return cutter.getRefSchema();
    }

    private String getSchemaAttribute(String xml, String attributeName) throws XMLBearbeitungsException {
        Element schemaRef;
        NodeList nodeList;
        Document document = this.createDocument(xml);
        Element rootElement = document.getDocumentElement();
        String attribute = rootElement.getAttribute(attributeName);
        if ((attribute == null || attribute.length() == 0) && (nodeList = rootElement.getElementsByTagName("schemaRef")) != null && nodeList.getLength() > 0) {
            schemaRef = (Element)nodeList.item(0);
            attribute = schemaRef.getAttribute(attributeName);
        }
        if ((attribute == null || attribute.length() == 0) && (nodeList = rootElement.getElementsByTagName("refSchema")) != null && nodeList.getLength() > 0) {
            schemaRef = (Element)nodeList.item(0);
            attribute = schemaRef.getAttribute(attributeName);
        }
        return attribute;
    }

    public String getVersion(String xml) throws XMLBearbeitungsException {
        String sReturn = this.getSchemaAttribute(xml, "version");
        if (sReturn == null || sReturn.equals("")) {
            sReturn = this.getVersionFromXmlData(xml);
        }
        return sReturn;
    }

    private String getVersionFromXmlData(String xmlData) {
        XmlCutter cutter = new XmlCutter(xmlData);
        return cutter.getVersion();
    }

    public String getVersionAsPackageName(String xml) throws XMLBearbeitungsException {
        return StringUtils.replaceChars((String)this.getVersion(xml), (char)'.', (char)'_');
    }

    private Document createDocument(String xml) throws XMLBearbeitungsException {
        Document document = null;
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            document = builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            String message = "SchemaVersionRetriever - create XML  document error";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            LOG.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return document;
    }
}

