/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.data.apitransformation.SIDataMapper;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.si_V01_03_00.ServicePackageBaseResponse;
import com.bmw.gki.klib.si_V01_03_00.ServicePackageType;
import com.bmw.gki.klib.si_V01_03_00.TypeError;
import com.bmw.gki.klib.si_V01_03_00.impl.TypeSchemaVersionReferenceImpl;
import com.bmw.gki.logging.GKILogManager;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class ServicePackageBaseResponseTransformer {
    private static final Log LOG = GKILogManager.getInstance().getLogger(ServicePackageBaseResponseTransformer.class);
    private static final String ROOT_PACKAGE_NAME = "com.bmw.gki.klib.si_";
    private List<ServicePackageType> servicepackage;
    private List<BSIServicePaket> bsiServicePackageList = null;
    private TypeError error;
    private boolean ssiNotSupported = false;
    private String saOptionCode = null;

    public TypeError getError() {
        return this.error;
    }

    public List<ServicePackageType> getServicePackages() {
        return this.servicepackage;
    }

    public void transformToTyped(String xml) throws XMLBearbeitungsException {
        ServicePackageBaseResponse response = (ServicePackageBaseResponse)this.parseObject(xml);
        if (response != null) {
            this.servicepackage = response.getServicePackage();
            if (this.servicepackage != null) {
                this.bsiServicePackageList = new ArrayList<BSIServicePaket>();
                for (ServicePackageType element : this.servicepackage) {
                    this.bsiServicePackageList.add(SIDataMapper.createBSIServicePackage(element));
                }
            }
            this.ssiNotSupported = response.isSetBadFuelEquipmentNotSupported();
            if (response.isSetBadFuelEquipment() && response.getBadFuelEquipment().isSetCode() && !response.getBadFuelEquipment().getCode().equals("")) {
                this.saOptionCode = response.getBadFuelEquipment().getCode();
            }
            this.error = response.getException();
        }
    }

    public List<BSIServicePaket> getBsiServicePackageList() {
        return this.bsiServicePackageList;
    }

    public boolean isSSInotSupported() {
        return this.ssiNotSupported;
    }

    public String getSAOptionCode() {
        return this.saOptionCode;
    }

    protected Object parseObject(String srcXml) throws XMLBearbeitungsException {
        Object dstObj = null;
        String version = GKISettingsRessource.getString("siVersion");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getJaxbPackageName(version));
            Unmarshaller u = jc.createUnmarshaller();
            dstObj = u.unmarshal((Source)new StreamSource(new StringReader(srcXml)));
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".parseObject(" + srcXml + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        return dstObj;
    }

    public String transformServicePackageResponseToXml(ServicePackageBaseResponse servicePackageResponse) throws XMLBearbeitungsException {
        String version = GKISettingsRessource.getString("siVersion");
        if (servicePackageResponse.getSchemaRef() == null) {
            TypeSchemaVersionReferenceImpl ref = new TypeSchemaVersionReferenceImpl();
            ref.setVersion(version);
            ref.setRefSchema(GKISettingsRessource.getString("siRefSchema"));
            servicePackageResponse.setSchemaRef(ref);
        }
        String xmlSource = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getJaxbPackageName(version));
            Marshaller mSource = jc.createMarshaller();
            mSource.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter stringWriter = new StringWriter();
            mSource.marshal((Object)servicePackageResponse, (Writer)stringWriter);
            xmlSource = stringWriter.toString();
        }
        catch (Exception ex) {
            LOG.fatal((Object)"unknown error occured ", (Throwable)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String srcObjClassName = null;
            srcObjClassName = servicePackageResponse.getClass().getName();
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".formatObjectToString(" + version + "," + srcObjClassName + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        return xmlSource;
    }

    private String getJaxbPackageName(String version) {
        String packageName = ROOT_PACKAGE_NAME + this.versionToPackageName(version);
        return packageName;
    }

    private String versionToPackageName(String xmlVersion) {
        String packageName = ROOT_PACKAGE_NAME;
        String version = "V" + StringUtils.replace((String)xmlVersion, (String)".", (String)"_");
        packageName = packageName + version;
        return version;
    }
}

