/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.data.xml.XmlCutter;
import com.bmw.gki.klib.data.xml.transformer.GKIXmlTransformer;
import com.bmw.gki.logging.GKILogManager;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class XMLMapper {
    protected static final Log LOG = GKILogManager.getInstance().getLogger(XMLMapper.class);
    protected static final String REF_SCHEMA = "interpretKeyGKI";
    protected static final String VERSION_PACKAGENAME_ACTUAL_SCHEMA = "current";
    private static final String CURRENT_INTERPRET_KEY_VERSION = GKISettingsRessource.getString("interpretKeyCurrentVersion");
    private String rootPackageName = "com.bmw.gki.klib.api_";
    private boolean validating = true;
    private String destinationVersion;
    private boolean currentApi;
    private static Map<String, JAXBContext> contextMap;
    private static Map<String, Schema> schemaMap;

    public XMLMapper() {
        this(null);
        this.currentApi = true;
    }

    public XMLMapper(String dstVersion) {
        this.destinationVersion = dstVersion == null ? CURRENT_INTERPRET_KEY_VERSION : dstVersion;
    }

    private JAXBContext getContext(String packageNameSource) throws JAXBException {
        LOG.info((Object)("getContext " + packageNameSource));
        if (contextMap == null) {
            contextMap = new HashMap<String, JAXBContext>();
        }
        if (!contextMap.containsKey(packageNameSource)) {
            LOG.info((Object)("create new content " + packageNameSource));
            contextMap.put(packageNameSource, JAXBContext.newInstance((String)packageNameSource));
        }
        return contextMap.get(packageNameSource);
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    protected Object parseObject(String srcXml) throws XMLBearbeitungsException {
        long startTime = new Date().getTime();
        LOG.info((Object)("start parseObject " + startTime));
        Object dstObj = null;
        try {
            String srcVersion = this.getVersionFromXmlData(srcXml);
            String dstXml = null;
            dstXml = !StringUtils.equals((String)this.destinationVersion, (String)srcVersion) ? this.mapToXmlVersion(this.destinationVersion, srcVersion, srcXml) : srcXml;
            Unmarshaller u = this.createUnmarshaller(dstXml);
            dstObj = u.unmarshal((Source)new StreamSource(new BufferedReader(new StringReader(dstXml), 100000)));
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".parseObject(" + srcXml + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        LOG.info((Object)"end parseObject ");
        if (duration != 0L) {
            LOG.info((Object)("duration parseObject time : " + duration));
        }
        return dstObj;
    }

    protected String transformObjectToString(Object srcObj) throws XMLBearbeitungsException {
        return this.transformObjectToString(srcObj, this.destinationVersion);
    }

    protected String transformObjectToString(Object srcObj, String version) throws XMLBearbeitungsException {
        String xmlData = null;
        long startTime = new Date().getTime();
        LOG.info((Object)("start transformObjectToString " + startTime));
        try {
            String packageNameSource = this.getJaxbPackageName(srcObj);
            JAXBContext jcSource = this.getContext(packageNameSource);
            Marshaller mSource = jcSource.createMarshaller();
            mSource.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter stringWriter = new StringWriter(50000);
            mSource.marshal(srcObj, (Writer)stringWriter);
            String xmlSource = stringWriter.toString();
            xmlData = this.mapToXmlVersion(version, xmlSource);
        }
        catch (Exception ex) {
            LOG.fatal((Object)"unknown error occured ", (Throwable)ex);
            String shortClassName = ClassUtils.getShortClassName(this.getClass());
            String srcObjClassName = null;
            srcObjClassName = srcObj != null ? srcObj.getClass().getName() : "null";
            String errorText = "Error:Exception:" + ex + " - " + shortClassName + ".formatObjectToString(" + version + "," + srcObjClassName + ")";
            throw new XMLBearbeitungsException(errorText, ex);
        }
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        LOG.info((Object)"end transformObjectToString");
        if (duration != 0L) {
            LOG.info((Object)("duration transformObjectToString time : " + duration));
        }
        return xmlData;
    }

    private Unmarshaller createUnmarshaller(String srcXml) throws JAXBException, SAXException, IOException {
        Schema schema;
        String srcVersion = this.getVersionFromXmlData(srcXml);
        String srcPackage = this.getJaxbPackageName(srcVersion);
        JAXBContext context = this.getContext(srcPackage);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        String srcValidation = this.getRefSchemaFromXmlData(srcXml) + "_V" + srcVersion;
        if (schemaMap == null) {
            schemaMap = new HashMap<String, Schema>(10);
        }
        if ((schema = schemaMap.get(srcValidation)) == null) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL xsdURL = this.getClass().getResource("/xsd/" + srcValidation + ".xsd");
            schema = sf.newSchema(xsdURL);
            schemaMap.put(srcValidation, schema);
        }
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    private String getVersionFromXmlData(String xmlData) {
        XmlCutter cutter = new XmlCutter(xmlData);
        return cutter.getVersion();
    }

    private String getRefSchemaFromXmlData(String xmlData) {
        XmlCutter cutter = new XmlCutter(xmlData);
        return cutter.getRefSchema();
    }

    private String getJaxbPackageName(Object obj) {
        String packageName = ClassUtils.getPackageName(obj.getClass());
        packageName = StringUtils.substringBeforeLast((String)packageName, (String)".impl");
        return packageName;
    }

    private String getJaxbPackageName(String version) {
        String packageName = null;
        packageName = this.currentApi && CURRENT_INTERPRET_KEY_VERSION.equals(version) ? this.rootPackageName + VERSION_PACKAGENAME_ACTUAL_SCHEMA : this.rootPackageName + this.versionToPackageName(version);
        return packageName;
    }

    private String versionToPackageName(String xmlVersion) {
        String packageName = this.rootPackageName;
        String version = "V" + StringUtils.replace((String)xmlVersion, (String)".", (String)"_");
        packageName = packageName + "." + version;
        return version;
    }

    public String mapToXmlVersion(String dstVersion, String srcXml) throws InstantiationException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String srcVersion = this.getVersionFromXmlData(srcXml);
        return this.mapToXmlVersion(dstVersion, srcVersion, srcXml);
    }

    public String mapToXmlVersion(String dstVersion, String srcVersion, String srcXml) throws InstantiationException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String dstXml = srcXml;
        if (dstVersion != null && srcVersion != null && !StringUtils.equals((String)dstVersion, (String)srcVersion)) {
            String requestElementType = new XmlCutter(srcXml).getRefSchema();
            GKIXmlTransformer transformer = new GKIXmlTransformer(srcVersion, dstVersion);
            dstXml = transformer.transformInterpretKey(srcXml);
            dstXml = dstXml.replaceAll("^[\\t]*[\\n\\r]$", "");
            LOG.info((Object)("requested schema is " + requestElementType + " in version " + srcVersion));
        }
        return dstXml;
    }

    private Object createObjectFromFactory(Object objectFactory, String shortObjectClassName) throws IllegalAccessException, InvocationTargetException {
        Object object = null;
        String methodName = shortObjectClassName;
        methodName = StringUtils.capitalize((String)methodName);
        methodName = StringUtils.remove((String)methodName, (String)"Impl.");
        methodName = StringUtils.removeEnd((String)methodName, (String)"Impl");
        methodName = StringUtils.remove((String)methodName, (char)'.');
        methodName = "create" + methodName;
        try {
            object = MethodUtils.invokeExactMethod((Object)objectFactory, (String)methodName, null);
        }
        catch (NoSuchMethodException ex) {
            object = null;
        }
        return object;
    }

    private void copyObject(Object objectFactory, Object dstObj, Object srcObj) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        BeanUtilsBean bu = BeanUtilsBean.getInstance();
        if (srcObj instanceof List) {
            for (Object srcValue : (List)srcObj) {
                this.copyListElement(objectFactory, (List)dstObj, srcValue);
            }
        } else {
            PropertyDescriptor[] origDescriptors = bu.getPropertyUtils().getPropertyDescriptors(srcObj);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !bu.getPropertyUtils().isReadable(dstObj, name)) continue;
                if (bu.getPropertyUtils().isWriteable(dstObj, name)) {
                    try {
                        Object srcValue = bu.getPropertyUtils().getSimpleProperty(srcObj, name);
                        this.copyProperty(objectFactory, dstObj, name, srcValue);
                    }
                    catch (NoSuchMethodException e) {}
                    continue;
                }
                List interfaces = ClassUtils.getAllInterfaces((Class)bu.getPropertyUtils().getPropertyType(srcObj, name));
                if (!interfaces.contains(Class.forName("java.util.Collection"))) continue;
                Object srcValue = bu.getPropertyUtils().getSimpleProperty(srcObj, name);
                Object dstValue = bu.getPropertyUtils().getSimpleProperty(dstObj, name);
                this.copyObject(objectFactory, dstValue, srcValue);
            }
        }
    }

    private void copyProperty(Object objectFactory, Object dstObj, String name, Object srcValue) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (srcValue != null) {
            String srcSubType = ClassUtils.getShortClassName(srcValue.getClass());
            Object dstSubObj = this.createObjectFromFactory(objectFactory, srcSubType);
            if (dstSubObj != null) {
                this.copyObject(objectFactory, dstSubObj, srcValue);
                this.copyBeanElement(dstObj, name, dstSubObj);
            } else {
                this.copyBeanElement(dstObj, name, srcValue);
            }
        } else {
            this.copyBeanElement(dstObj, name, srcValue);
        }
    }

    private void copyBeanElement(Object dstObj, String name, Object srcValue) throws IllegalAccessException, InvocationTargetException {
        if (srcValue != null) {
            BeanUtilsBean bu = BeanUtilsBean.getInstance();
            bu.copyProperty(dstObj, name, srcValue);
        }
    }

    private void copyListElement(Object objectFactory, List<Object> dstList, Object srcValue) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String srcSubType = ClassUtils.getShortClassName(srcValue.getClass());
        Object dstSubObj = this.createObjectFromFactory(objectFactory, srcSubType);
        if (dstSubObj != null) {
            this.copyObject(objectFactory, dstSubObj, srcValue);
            dstList.add(dstSubObj);
        } else {
            dstList.add(srcValue);
        }
    }
}

