/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml;

import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;

public class XmlCutter {
    private static final String VERSION = "version";
    private static final String REFSCHEMA = "refSchema";
    private String xmlSrc = null;

    public XmlCutter(String xmlSrc) {
        this.xmlSrc = xmlSrc.replaceAll("[\\t\\n\\r\\f\\v]", "");
    }

    public String getVersion() {
        return this.getValueByName(this.getStartTag(), VERSION);
    }

    public String getVersion(String tagName) {
        return this.getValueByName(this.getStartTag(tagName), VERSION);
    }

    public String getRefSchema() {
        return this.getValueByName(this.getStartTag(), REFSCHEMA);
    }

    public String getRefSchema(String tagName) {
        return this.getValueByName(this.getStartTag(tagName), REFSCHEMA);
    }

    public String getStartTag() {
        String startTag = null;
        if (this.xmlSrc != null) {
            String[] tags = this.xmlSrc.split("<");
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] == null || tags[i].length() <= 0 || !CharUtils.isAsciiAlpha((char)tags[i].charAt(0)) || !StringUtils.contains((String)tags[i], (String)REFSCHEMA) || !StringUtils.contains((String)tags[i], (String)VERSION)) continue;
                startTag = StringUtils.substringBeforeLast((String)tags[i], (String)">");
                break;
            }
        }
        return startTag;
    }

    public String getStartTag(String rootTag) {
        String startTag = null;
        if (this.xmlSrc != null) {
            String[] tags = this.xmlSrc.split("<");
            for (int i = 0; i < tags.length; ++i) {
                if (!tags[i].startsWith(rootTag)) continue;
                startTag = StringUtils.substringBeforeLast((String)tags[i], (String)">");
                break;
            }
        }
        return startTag;
    }

    public String getValueByName(String line, String name) {
        String value = null;
        if (line != null && name != null) {
            String[] subTags = StringUtils.split((String)line);
            for (int j = 0; !(j >= subTags.length || value != null || subTags[j].startsWith(name) && (value = StringUtils.substringBetween((String)subTags[j], (String)"\"")) != null); ++j) {
            }
        }
        return value;
    }

    public static void main(String[] args) {
        String testXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--Sample XML file generated by XMLSPY v5 rel. 4 U (http://www.xmlspy.com)--><requestMeasures xmlns=\"http://www.bmw.com/SAM\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.bmw.com/SAM\nC:\\projekte\\cmsyn\\sam2_ism\\utc\\resources\\xmlschemas\\measureV0100.xsd\" refSchema=\"measure\" version=\"01.00.00\"><warrantyDealerNumber identification=\"0\"/><language>en-us</language> <code>String</code><code>String</code><code>String</code><eSeries>String</eSeries><connection>URL_INTERNET</connection></requestMeasures>";
        String result = null;
        XmlCutter cutter = new XmlCutter(testXml);
        result = cutter.getVersion("requestMeasures");
        System.out.println("Version=\"" + result + "\"");
        result = cutter.getVersion();
        System.out.println("Version=\"" + result + "\"");
        result = cutter.getRefSchema();
        System.out.println("RefSchema=\"" + result + "\"");
    }
}

