/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xml.transformer;

import com.bmw.gki.klib.api.GKISettingsRessource;
import com.bmw.gki.klib.api.exception.TransformerException;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

class XSLCache {
    private static Log log = GKILogManager.getInstance().getLogger(XSLCache.class);
    private String xslDirectory;
    private Map<?, ?> cache = new HashMap();
    private static XSLCache instance = new XSLCache();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected XSLCache() {
        this.xslDirectory = GKISettingsRessource.getString("gki.xsldirectory");
        log.info((Object)("xsl directory set to " + this.xslDirectory));
        log.info((Object)("XSL Transformer: " + this.transformerFactory));
    }

    public Transformer retrieveXSLT(String sheet) {
        Transformer transformer = null;
        transformer = (Transformer)this.cache.get(sheet);
        if (transformer == null) {
            String xslPath = this.xslDirectory + "/" + sheet;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                InputStream stream = loader.getResourceAsStream(xslPath);
                if (stream == null) {
                    throw new FileNotFoundException("file '" + xslPath + "' not found");
                }
                log.trace((Object)("create xsl transformer for xslPath '" + xslPath + "'"));
                transformer = this.transformerFactory.newTransformer(new StreamSource(stream));
                log.trace((Object)("created transformer " + transformer));
            }
            catch (Exception e) {
                System.out.println("Tranformer could not be created");
                e.printStackTrace();
                log.warn((Object)"Tranformer could not be created", (Throwable)e);
                throw new TransformerException("error.xsltransformer", e);
            }
        }
        return transformer;
    }

    public static XSLCache getInstance() {
        return instance;
    }
}

