/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.NotFoundException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.DescriptionType;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.CbsApiDaten;
import com.bmw.gki.klib.data.apiparams.RemainingDisplayValueData;
import com.bmw.gki.klib.data.apiparams.RemainingUnitData;
import com.bmw.gki.klib.data.apiparams.RemainingValueData;
import com.bmw.gki.klib.data.ksd.cbs.BOSVorziehwert;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.data.xsd.Description;
import com.bmw.gki.klib.data.xsd.FlatRateUnit;
import com.bmw.gki.klib.data.xsd.Mileage;
import com.bmw.gki.klib.external.cache.BOSVorziehwertReader;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.StatusMeasureReader;
import com.bmw.gki.klib.util.Translator;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class ConditionBasedService
extends CbsApiDaten {
    private static Log log = GKILogManager.getInstance().getLogger(ConditionBasedService.class);
    public static final String UNIT_TEMPERATURE_CELSIUS = "\u00b0C";
    public static final String UNIT_TEMPERATURE_FAHRENHEIT = "\u00b0F";
    public static final String UNIT_VOLTAGE = "V";
    public static final String UNIT_LITER = "l";
    public static final String UNIT_US_GALLON = "US.liq.gal";
    public static final String UNIT_UK_GALLON = "Imp.gal";
    public static final String COLOUR_VALUE_GREEN = "Green";
    public static final String COLOUR_VALUE_YELLOW = "Yellow";
    public static final String COLOUR_VALUE_RED = "Red";
    public static final String COLOUR_VALUE_NONE = "None";
    public static final String UNITS_TIME_DAY = "day";
    private static final String UNITS_FORECAST_DISTANCE = "Tkm";
    private static final String UNITS_FORECAST_TIME = "month";
    private Vector<BOSAWPosition> linkedCbsPositions;
    private BigDecimal availability;
    private Integer statusTeleserviceCall;
    private Double forecastRemainingDistance;
    private Double forecastRemainingTime;
    private Long cbsId;
    private String dueDate;
    private Integer statusMeasure;

    public ConditionBasedService(BOSAWPosition bosAwPosition, Date keyUpdateDate, int shortTimeDrivingPerformance, GKISettings settings) throws GKIException {
        Locale locale = settings.getLocale();
        if (bosAwPosition != null) {
            this.setAssociatedLabourOperation(new Boolean(bosAwPosition.getVerbundFlag()));
            this.setSelectionFlag(bosAwPosition.getSelectionFlag());
            boolean isBSI = false;
            isBSI = bosAwPosition.isInSI() && !bosAwPosition.isUebergabedurchsicht();
            this.setIsInBSIPackage(new Boolean(isBSI));
            boolean inCBSandDue = bosAwPosition.getKennungEmpfehlung() == '\u0002';
            this.setIsCBSUnitBSIDue(new Boolean(inCBSandDue));
            this.setIsUnselectable(new Boolean(bosAwPosition.isFestSelektiert()));
            this.setIsRecommended(new Boolean(bosAwPosition.isRecommended()));
            this.setDescription(new Description(bosAwPosition, locale).createDesriptionType());
            this.setState(ConditionBasedService.getXSDState(bosAwPosition));
            this.setStateSAM(this.getXSDStateSAM(bosAwPosition, locale));
            if (bosAwPosition.bosAWNummerFound()) {
                this.setFlatRateUnit(new FlatRateUnit(bosAwPosition));
            }
            this.setRemainingValue(this.getXSDRemaining(bosAwPosition, keyUpdateDate, shortTimeDrivingPerformance, settings.isMiles()));
            this.setRemainingUnits(this.getXSDRemainingUnits(bosAwPosition, keyUpdateDate, shortTimeDrivingPerformance, settings.isMiles()));
            this.setRemainingValueInDisplayFormat(this.getXSDRemainingInDisplayFormat(bosAwPosition, keyUpdateDate, shortTimeDrivingPerformance, settings));
            this.setRemainingUnitsInDisplayFormat(this.getXSDRemainingUnitsInDisplayFormat(bosAwPosition, keyUpdateDate, shortTimeDrivingPerformance, settings));
            this.setIncludeRange(ConditionBasedService.getXSDIncludeRange(bosAwPosition, settings.isMiles(), settings));
            this.setIncludeRangeUnits(ConditionBasedService.getXSDIncludeRangeUnits(bosAwPosition, settings.isMiles(), settings));
            if (bosAwPosition.getServiceZaehler() != 65535 && bosAwPosition.getBosNr().getBosNr() != 33 && bosAwPosition.getBosNr().getBosNr() != 32) {
                this.setServiceCounter(new Integer(bosAwPosition.getServiceZaehler()));
            }
            if (bosAwPosition.getBOSPosition() != null) {
                if (bosAwPosition.getBOSPosition().getAvailability() != 65535) {
                    this.setAvailability(new BigDecimal(bosAwPosition.getBOSPosition().getAvailability()));
                }
                this.setStatusMeasure(bosAwPosition.getBOSPosition().getStatusMeasure());
                this.setStatusTeleserviceCall(bosAwPosition.getBOSPosition().getStatusTeleserviceCall());
                if (bosAwPosition.getBOSPosition().getForecastRemainingTime() != null && bosAwPosition.getBOSPosition().getForecastRemainingTime().intValue() != 255) {
                    this.setForecastRemainingTime(bosAwPosition.getBOSPosition().getForecastRemainingTime());
                }
                if (bosAwPosition.getBOSPosition().getForecastRemainingDistance() != null && bosAwPosition.getBOSPosition().getForecastRemainingDistance().intValue() != 255) {
                    this.setForecastRemainingDistance(bosAwPosition.getBOSPosition().getForecastRemainingDistance());
                }
                this.setCbsId(bosAwPosition.getBOSPosition().getCbsId());
                if (bosAwPosition.getBOSPosition().getServiceZaehler() != 65535L && bosAwPosition.getBOSPosition().getBosNr().getBosNr() != 33 && bosAwPosition.getBOSPosition().getBosNr().getBosNr() != 32) {
                    this.setServiceCounter(new Integer((int)bosAwPosition.getBOSPosition().getServiceZaehler()));
                }
                if (bosAwPosition.getBOSPosition().getDueDateMonth() > 0 && bosAwPosition.getBOSPosition().getDueDateMonth() < 15 && bosAwPosition.getBOSPosition().getDueDateYear() > 0 && bosAwPosition.getBOSPosition().getDueDateYear() < 2063) {
                    this.setDueDate(bosAwPosition.getBOSPosition().getDueDateMonth() + "." + bosAwPosition.getBOSPosition().getDueDateYear());
                }
            }
            this.setIdentifier(new Integer(bosAwPosition.getBosNr().getBosNr()));
            this.linkedCbsPositions = bosAwPosition.getVerknuepfungsliste();
        }
    }

    private void setDueDate(String string) {
        this.dueDate = string;
    }

    private void setCbsId(Long cbsId) {
        this.cbsId = cbsId;
    }

    private void setForecastRemainingDistance(Double forecastRemainingDistance) {
        this.forecastRemainingDistance = forecastRemainingDistance;
    }

    private void setForecastRemainingTime(Double forecastRemainingTime) {
        this.forecastRemainingTime = forecastRemainingTime;
    }

    private void setStatusTeleserviceCall(Integer statusTeleserviceCall) {
        this.statusTeleserviceCall = statusTeleserviceCall;
    }

    private void setStatusMeasure(Integer statusMeasure) {
        this.statusMeasure = statusMeasure;
    }

    private void setAvailability(BigDecimal availability) {
        this.availability = availability;
    }

    private RemainingValueData getXSDRemaining(BOSAWPosition bosAWPos, Date keyUpdateDate, int shortTimeDrivingPerformance, boolean isMiles) {
        return bosAWPos.getRestlauf(isMiles, keyUpdateDate, shortTimeDrivingPerformance);
    }

    private RemainingDisplayValueData getXSDRemainingInDisplayFormat(BOSAWPosition bosAWPos, Date keyUpdateDate, int shortTimeDrivingPerformance, GKISettings settings) {
        if (bosAWPos.getZuVerknuepfendeBosPosition() != null) {
            return this.getXSDRemainingInDisplayFormat(bosAWPos.getZuVerknuepfendeBosPosition(), keyUpdateDate, shortTimeDrivingPerformance, settings);
        }
        RemainingDisplayValueData remainingInDisplayFormat = new RemainingDisplayValueData();
        int restweg = bosAWPos.getRestweg(keyUpdateDate);
        String zieltermin = bosAWPos.getDueDateMonth() + "." + bosAWPos.getDueDateYear();
        NumberFormat dformat = GKIHelper.determineNumberFormatter(settings.getLocale());
        if (restweg == 65535 && !bosAWPos.isDueDate()) {
            return remainingInDisplayFormat;
        }
        if (bosAWPos.isCombinedCBS()) {
            if (settings.isMiles()) {
                restweg = (int)Utilities.roundDistance(bosAWPos.getEinheitAbstand(), Utilities.convertToMiles(restweg));
            }
            remainingInDisplayFormat.setRemainingDisplayValueDistance(dformat.format(Math.round(restweg)));
            remainingInDisplayFormat.setRemainingDisplayValueTime(zieltermin);
        } else if (bosAWPos.isDueDate()) {
            remainingInDisplayFormat.setRemainingDisplayValueTime(zieltermin);
        } else if (bosAWPos.getEinheitRestlaufleistung() == 1) {
            if (settings.isMiles() && !bosAWPos.getBOSPosition().isMiles()) {
                restweg = (int)Utilities.roundDistance(bosAWPos.getEinheitAbstand(), Utilities.convertToMiles(restweg));
            } else if (!settings.isMiles() && bosAWPos.getBOSPosition().isMiles()) {
                restweg = (int)Utilities.roundDistance(bosAWPos.getEinheitAbstand(), Utilities.convertToKm(restweg));
            }
            remainingInDisplayFormat.setRemainingDisplayValueDistance(dformat.format(Math.round(restweg)));
        } else {
            restweg = Math.round(bosAWPos.getWertAbstand());
            remainingInDisplayFormat.setRemainingDisplayValueTime(dformat.format(Math.round(restweg)));
        }
        return remainingInDisplayFormat;
    }

    private RemainingUnitData getXSDRemainingUnits(BOSAWPosition bosAWPos, Date keyUpdateDate, int shortTimeDrivingPerformance, boolean isMiles) throws GKIException {
        RemainingUnitData unit = new RemainingUnitData();
        if (bosAWPos.getZuVerknuepfendeBosPosition() != null) {
            return this.getXSDRemainingUnits(bosAWPos.getZuVerknuepfendeBosPosition(), keyUpdateDate, shortTimeDrivingPerformance, isMiles);
        }
        try {
            if (bosAWPos.getRestweg(keyUpdateDate) == 65535 && !bosAWPos.isDueDate()) {
                return unit;
            }
            if (bosAWPos.isCombinedCBS()) {
                unit.setRemainingDistanceUnit(isMiles ? "miles" : "km");
                unit.setRemainingTimeUnit(UNITS_TIME_DAY);
            } else if (bosAWPos.isDueDate()) {
                unit.setRemainingTimeUnit(UNITS_TIME_DAY);
            } else if (bosAWPos.getEinheitRestlaufleistung() == 2) {
                unit.setRemainingTimeUnit(UNITS_TIME_DAY);
            } else if (bosAWPos.getEinheitRestlaufleistung() == 1) {
                String localUnit = isMiles ? "miles" : "km";
                unit.setRemainingDistanceUnit(localUnit);
            }
        }
        catch (Exception e) {
            log.fatal((Object)("getXSDRemainingUnits:Exception(" + e.getMessage() + ")"), (Throwable)e);
            throw new GKIException("getXSDRemainingUnits.Unerwartete Exception.", e);
        }
        return unit;
    }

    private RemainingUnitData getXSDRemainingUnitsInDisplayFormat(BOSAWPosition bosAWPos, Date keyUpdateDate, int shortTimeDrivingPerformance, GKISettings settings) {
        RemainingUnitData unitInDisplayFormat = new RemainingUnitData();
        if (bosAWPos.getZuVerknuepfendeBosPosition() != null) {
            return this.getXSDRemainingUnitsInDisplayFormat(bosAWPos.getZuVerknuepfendeBosPosition(), keyUpdateDate, shortTimeDrivingPerformance, settings);
        }
        if (bosAWPos.getRestweg(keyUpdateDate) == 65535 && !bosAWPos.isDueDate()) {
            return unitInDisplayFormat;
        }
        try {
            if (bosAWPos.isCombinedCBS()) {
                unitInDisplayFormat.setRemainingDistanceUnit(this.displayUnitUnitDistance(settings));
            } else if (bosAWPos.getEinheitRestlaufleistung() == 2) {
                unitInDisplayFormat.setRemainingTimeUnit(this.displayFormatUnitTime(bosAWPos, settings));
            } else if (bosAWPos.getEinheitRestlaufleistung() == 1) {
                unitInDisplayFormat.setRemainingDistanceUnit(this.displayUnitUnitDistance(settings));
            }
        }
        catch (GKIException e) {
            e.printStackTrace();
        }
        return unitInDisplayFormat;
    }

    private String displayUnitUnitDistance(GKISettings settings) throws GKIException {
        return settings.isMiles() ? ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.miles", settings.getLocale()) : ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.km", settings.getLocale());
    }

    private String displayFormatUnitTime(BOSAWPosition bosAWPos, GKISettings settings) throws GKIException {
        float wertabstand = bosAWPos.getWertAbstand();
        String timeUnitInDisplayFormat = null;
        if (!bosAWPos.isDueDate()) {
            switch (bosAWPos.getEinheitAbstand()) {
                case 0: {
                    timeUnitInDisplayFormat = wertabstand == 1.0f ? ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.tag", settings.getLocale()) : ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.tage", settings.getLocale());
                    break;
                }
                case 1: {
                    timeUnitInDisplayFormat = wertabstand == 1.0f ? ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.woche", settings.getLocale()) : ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.wochen", settings.getLocale());
                    break;
                }
                case 2: {
                    timeUnitInDisplayFormat = wertabstand == 1.0f ? ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.monat", settings.getLocale()) : ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.monate", settings.getLocale());
                    break;
                }
                case 3: {
                    timeUnitInDisplayFormat = wertabstand == 1.0f ? ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.jahr", settings.getLocale()) : ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.restlaufColumn.jahre", settings.getLocale());
                }
            }
        }
        return timeUnitInDisplayFormat;
    }

    public static OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService createConditionBasedService(BOSAWPosition bosAWPos, Date keyUpdateDate, int shortTimeDrivingPerformance, boolean isMiles, GKISettings settings) {
        try {
            ConditionBasedService cbs = new ConditionBasedService(bosAWPos, keyUpdateDate, shortTimeDrivingPerformance, settings);
            return cbs.create(settings);
        }
        catch (Exception e) {
            String message = "ConditionBasedService  XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
    }

    private OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService create(GKISettings settings) {
        Locale locale = settings.getLocale();
        OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl element = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl();
        Boolean bool = null;
        String stringValue = null;
        String stringValueUnits = null;
        Integer integerValue = null;
        try {
            DescriptionType description;
            bool = this.getAssociatedLabourOperation();
            if (bool != null) {
                element.setAssociatedLabourOperation(bool);
            }
            if ((bool = this.getSelectionFlag()) != null) {
                element.setSelectionFlag(bool);
            }
            if ((bool = this.getIsRecommended()) != null) {
                element.setIsRecommended(bool);
            }
            if ((bool = this.getIsInBSIPackage()) != null) {
                element.setIsInBSIPackage(bool);
            }
            if ((bool = this.getIsCBSUnitBSIDue()) != null) {
                element.setIsCBSUnitBSIDue(bool);
            }
            if ((bool = this.getIsUnselectable()) != null) {
                element.setIsUnselectable(bool);
            }
            if ((description = this.getDescription()) != null) {
                element.setDescription(description);
            }
            if ((stringValue = this.getState()) != null) {
                element.setState(stringValue);
            }
            stringValue = (stringValue = this.getStateSAM()) != null ? stringValue : "";
            OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StateSAMImpl samType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StateSAMImpl();
            StringBuffer language = new StringBuffer(locale.getLanguage());
            if (locale.getCountry() != null) {
                language.append("-").append(locale.getCountry());
            }
            samType.setLanguage(language.toString());
            samType.setValue(stringValue);
            element.setStateSAM(samType);
            FlatRateUnit flatRateUnit = this.getFlatRateUnit();
            if (flatRateUnit != null) {
                BigDecimal quantity;
                OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.FlatRateUnitImpl flatType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.FlatRateUnitImpl();
                flatType.setIsLocal(flatRateUnit.getIsLocal());
                flatType.setNumber(flatRateUnit.getNumber());
                if (flatRateUnit.getDescription() != null) {
                    flatType.setDescription(flatRateUnit.getDescription().createDesriptionType());
                }
                TypeUnitValueImpl unitVal = new TypeUnitValueImpl();
                unitVal.setUnits(flatRateUnit.getQuantityUnits());
                unitVal.setValue(new BigDecimal(flatRateUnit.getQuantity()));
                String unitsInDisplayFormat = GKIHelper.getTableString("detailsichtDialog.detailsichtTableModel.awWert", locale);
                unitVal.setUnitsInDisplayFormat(unitsInDisplayFormat);
                if (flatRateUnit.getQuantity() != null && (quantity = new BigDecimal(flatRateUnit.getQuantity())) != null) {
                    unitVal.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(quantity));
                }
                flatType.setQuantity(unitVal);
                element.setFlatRateUnit(flatType);
            }
            RemainingUnitData dataValueUnits = this.getRemainingUnits();
            RemainingValueData dataValue = this.getRemainingValue();
            if (dataValue != null) {
                if (dataValue.getRemainingDistanceValue() != null) {
                    OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.RemainingDistanceImpl remainingDistanceType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.RemainingDistanceImpl();
                    remainingDistanceType.setUnits(dataValueUnits.getRemainingDistanceUnit());
                    remainingDistanceType.setValue(new BigDecimal(dataValue.getRemainingDistanceValue()));
                    remainingDistanceType.setValueInDisplayFormat(this.getRemainingValueInDisplayFormat().getRemainingDisplayValueDistance());
                    remainingDistanceType.setUnitsInDisplayFormat(this.getRemainingUnitsInDisplayFormat().getRemainingDistanceUnit());
                    remainingDistanceType.setIsNextDue(1 == dataValue.getEarliestDueType());
                    element.setRemainingDistance(remainingDistanceType);
                }
                if (dataValue.getRemainingTimeValue() != null) {
                    OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.RemainingTimeImpl remainingTimeType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.RemainingTimeImpl();
                    remainingTimeType.setUnits(dataValueUnits.getRemainingTimeUnit());
                    remainingTimeType.setValue(new BigDecimal(dataValue.getRemainingTimeValue()));
                    remainingTimeType.setValueInDisplayFormat(this.getRemainingValueInDisplayFormat().getRemainingDisplayValueTime());
                    remainingTimeType.setUnitsInDisplayFormat(this.getRemainingUnitsInDisplayFormat().getRemainingTimeUnit());
                    remainingTimeType.setIsNextDue(2 == dataValue.getEarliestDueType());
                    element.setRemainingTime(remainingTimeType);
                }
            }
            stringValueUnits = this.getIncludeRangeUnits();
            stringValue = this.getIncludeRange();
            if (stringValue != null) {
                TypeUnitValueImpl includeRangeType = new TypeUnitValueImpl();
                includeRangeType.setUnits(stringValueUnits);
                includeRangeType.setValue(new BigDecimal(stringValue));
                includeRangeType.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(new Double(stringValue).intValue()));
                includeRangeType.setUnitsInDisplayFormat(new Mileage(stringValue, stringValueUnits).getXSDUnitsInDisplayFormat(locale));
                element.setIncludeRange(includeRangeType);
            }
            if ((integerValue = this.getServiceCounter()) != null && integerValue != 65535) {
                element.setServiceCounter(integerValue.longValue());
            }
            if ((integerValue = this.getIdentifier()) != null) {
                element.setIdentifier(Utilities.getBOSNummerAsString(integerValue));
            }
            if (this.getAvailability() != null && this.getAvailability().intValue() != 65535) {
                element.setAvailability(this.getAvailability());
            }
            if (this.getStatusTeleserviceCall() != null) {
                OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StatusTeleserviceCbsCallImpl teleserviceType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StatusTeleserviceCbsCallImpl();
                teleserviceType.setCode(this.getStatusTeleserviceCall().toString());
                teleserviceType.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                teleserviceType.setValue(GKIHelper.getTableString("cbs.positions.statusTeleserviceCall." + this.getStatusTeleserviceCall().toString(), locale));
                element.setStatusTeleserviceCbsCall(teleserviceType);
            }
            if (this.getForecastRemainingDistance() != null) {
                TypeUnitValueImpl typeUnitDistance = new TypeUnitValueImpl();
                String units = UNITS_FORECAST_DISTANCE;
                String key = "cbs.positions.forecastdistance.unit.tkm";
                double value = this.getForecastRemainingDistance();
                if (settings.isMiles()) {
                    value = Utilities.roundDistance(-1, Utilities.convertToMiles(value));
                    units = "TM";
                    key = "cbs.positions.forecastdistance.unit.tm";
                }
                typeUnitDistance.setUnits(units);
                typeUnitDistance.setUnitsInDisplayFormat(GKIHelper.getTableString(key, locale));
                typeUnitDistance.setValue(new BigDecimal(value));
                typeUnitDistance.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(value));
                element.setForecastRemainingDistance(typeUnitDistance);
            }
            if (this.getForecastRemainingTime() != null) {
                TypeUnitValueImpl typeUnitTime = new TypeUnitValueImpl();
                typeUnitTime.setUnits(UNITS_FORECAST_TIME);
                typeUnitTime.setUnitsInDisplayFormat(GKIHelper.getTableString("cbs.positions.forecasttime.unit", locale));
                typeUnitTime.setValue(new BigDecimal(this.getForecastRemainingTime()));
                typeUnitTime.setValueInDisplayFormat(GKIHelper.determineNumberFormatter(locale).format(this.getForecastRemainingTime().intValue()));
                element.setForecastRemainingTime(typeUnitTime);
            }
            if (this.getStatusMeasure() != null) {
                OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StatusMeasureImpl statusMeasureType = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StatusMeasureImpl();
                statusMeasureType.setCode(this.getStatusMeasure().toString());
                statusMeasureType.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                List<OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService.StatusMeasure.Message> messageList = statusMeasureType.getMessage();
                this.getMessagesForStatusMeasure(messageList, this.getStatusMeasure(), locale);
                element.setStatusMeasure(statusMeasureType);
            }
            if (this.linkedCbsPositions != null && this.linkedCbsPositions.size() > 0) {
                for (BOSAWPosition bosElement : this.linkedCbsPositions) {
                    element.getLinkedCBSPositions().add(Utilities.getBOSNummerAsString(bosElement.getBosNr().getBosNr()));
                }
            }
            if (this.getDueDate() != null) {
                element.setDueDate(this.getDueDate());
            }
        }
        catch (Exception e) {
            String message = "ConditionBasedServices XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return element;
    }

    private void getMessagesForStatusMeasure(List<OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService.StatusMeasure.Message> messageList, int value, Locale locale) {
        StatusMeasureReader statusMeasureReader = StatusMeasureReader.getInstance();
        Set<Map.Entry<Object, Object>> statusSet = statusMeasureReader.readMeasureStatus();
        for (Map.Entry<Object, Object> element : statusSet) {
            String elemKey = element.getKey().toString();
            if (!statusMeasureReader.hasFlag(element.getKey().toString(), value)) continue;
            OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StatusMeasureImpl.MessageImpl message = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.StatusMeasureImpl.MessageImpl();
            String transValue = null;
            try {
                transValue = GKIHelper.getTableString("cbs.positions.statusMeasure." + elemKey, locale);
            }
            catch (GKIException e) {
                // empty catch block
            }
            message.setName(elemKey);
            if (transValue != null) {
                message.setValue(transValue);
            }
            messageList.add(message);
        }
    }

    private static String getXSDState(BOSAWPosition bosAWPos) {
        String colour = "";
        int bosZustand = bosAWPos.getBosZustand();
        switch (bosZustand) {
            case 0: {
                colour = COLOUR_VALUE_GREEN;
                break;
            }
            case 1: {
                colour = COLOUR_VALUE_YELLOW;
                break;
            }
            case 2: {
                colour = COLOUR_VALUE_RED;
                break;
            }
            default: {
                colour = COLOUR_VALUE_NONE;
                log.debug((Object)("getXSDState:unbekannter bosZustand(" + bosZustand + "), setze (" + colour + ")!"));
            }
        }
        return colour;
    }

    private String getXSDStateSAM(BOSAWPosition pos, Locale locale) throws GKIException {
        if (pos.hasZuVerknuepfendeBosPosition()) {
            return ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.serviceColumn.verknuepftMit", locale) + " " + pos.getZuVerknuepfendeBosPosition().getBosBezeichnung(locale);
        }
        if (pos.getKennungEmpfehlung() == '\u0002') {
            if (pos.getBosZustand() == 0 && pos.isDueDate() && !pos.isAusserhalbServicePaketUmfang()) {
                return ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.serviceColumn.zukuenftig", locale) + " (SI)";
            }
            return ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.serviceColumn.faellig", locale) + " (SI)";
        }
        if (pos.isFestSelektiert()) {
            return ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.serviceColumn.faellig", locale);
        }
        switch (pos.getBosZustand()) {
            case 0: {
                if (pos.getKennungEmpfehlung() != '\u0001') break;
                return ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.serviceColumn.zukuenftig", locale);
            }
            case 1: 
            case 2: {
                return ConditionBasedService.getTableString("auftragsbasisDialog.auftragsbasisTable.serviceColumn.faellig", locale);
            }
        }
        return "";
    }

    private static String getTableString(String key, Locale locale) throws GKIException {
        Translator translator = Translator.getInstance(locale);
        return translator.getString(key);
    }

    private static String getXSDIncludeRangeUnits(BOSAWPosition bosAWPos, boolean isMiles, GKISettings settings) throws GKIException {
        String vorziehWertEinheit = null;
        try {
            BOSVorziehwert vorziehwert = BOSVorziehwertReader.find(settings.getRegionCode(), bosAWPos.getBosNr());
            vorziehWertEinheit = vorziehwert.getEinheit();
            vorziehWertEinheit = vorziehWertEinheit.equals("k") ? (isMiles ? "miles" : "km") : UNITS_TIME_DAY;
        }
        catch (NotFoundException ex) {
        }
        catch (GKIException e) {
            throw e;
        }
        return vorziehWertEinheit;
    }

    private static String getXSDIncludeRange(BOSAWPosition bosAWPos, boolean isMiles, GKISettings settings) throws GKIException {
        if (bosAWPos.getBosZustand() == 255) {
            return null;
        }
        String vorziehWert = null;
        try {
            BOSVorziehwert vorziehwert = BOSVorziehwertReader.find(settings.getRegionCode(), bosAWPos.getBosNr());
            vorziehWert = isMiles && !vorziehwert.getEinheit().equals("w") ? String.valueOf(Utilities.convertToMiles(vorziehwert.getWert())) : String.valueOf(vorziehwert.getWert());
        }
        catch (NotFoundException ex) {
        }
        catch (GKIException e) {
            throw e;
        }
        return vorziehWert;
    }

    public BigDecimal getAvailability() {
        return this.availability;
    }

    public Long getCbsId() {
        return this.cbsId;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public Double getForecastRemainingDistance() {
        return this.forecastRemainingDistance;
    }

    public Double getForecastRemainingTime() {
        return this.forecastRemainingTime;
    }

    public Integer getStatusTeleserviceCall() {
        return this.statusTeleserviceCall;
    }

    public Integer getStatusMeasure() {
        return this.statusMeasure;
    }
}

