/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.DescriptionType;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.TypeUnitValueImpl;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.data.xsd.Description;
import com.bmw.gki.logging.GKILogManager;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class FlatRateUnit {
    private static final Log LOG = GKILogManager.getInstance().getLogger(FlatRateUnit.class);
    public static final String CLASS_NAME = "FlatRateUnit";
    public static final String TAG_FLAT_RATE_UNIT = "flatRateUnit";
    public static final String ATT_NUMBER = "number";
    public static final String ATT_IS_LOCAL = "isLocal";
    public static final String TAG_QUANTITY = "quantity";
    public static final String ATT_UNITS = "units";
    public static final Boolean DEFAULT_SAM2_IS_LOCAL = Boolean.FALSE;
    public static final String DEFAULT_SAM2_QUANTITY_UNITS = "AW";
    private String number = null;
    private Boolean isLocal = null;
    private Description description = null;
    private String quantity = null;
    private String quantityUnits = null;

    public FlatRateUnit(BOSAWPosition bosAwPositon) throws GKIException {
        if (bosAwPositon != null && bosAwPositon.bosAWNummerFound()) {
            this.setNumber(bosAwPositon.getBosAwNr());
            this.setIsLocal(DEFAULT_SAM2_IS_LOCAL);
            this.setQuantityUnits(DEFAULT_SAM2_QUANTITY_UNITS);
            this.setQuantity(bosAwPositon.getBosAwWert());
        }
    }

    public FlatRateUnit(OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService.FlatRateUnit flatRateUnit) {
        if (flatRateUnit != null) {
            this.setNumber(flatRateUnit.getNumber());
            this.setIsLocal(new Boolean(flatRateUnit.isIsLocal()));
            this.setQuantityUnits(flatRateUnit.getQuantity().getUnits());
            this.setQuantity(flatRateUnit.getQuantity().getValue().toString());
            DescriptionType descrType = flatRateUnit.getDescription();
            if (descrType != null) {
                Description desc = new Description(descrType.getValue(), descrType.getLanguage());
                this.setDescription(desc);
            }
        }
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Boolean getIsLocal() {
        return this.isLocal;
    }

    public void setIsLocal(Boolean isLocal) {
        this.isLocal = isLocal;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public String getQuantityUnits() {
        return this.quantityUnits;
    }

    public void setQuantityUnits(String quantityUnits) {
        this.quantityUnits = quantityUnits;
    }

    public OrderBaseType.ServiceInformation.TimeLine.CbsList.ConditionBasedService.FlatRateUnit create(Locale locale) throws GKIException {
        OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.FlatRateUnitImpl element = new OrderBaseTypeImpl.ServiceInformationImpl.TimeLineImpl.CbsListImpl.ConditionBasedServiceImpl.FlatRateUnitImpl();
        try {
            if (this.getNumber() != null) {
                element.setNumber(this.getNumber());
            }
            if (this.getIsLocal() != null) {
                element.setIsLocal(this.getIsLocal());
            }
            if (this.getDescription() != null) {
                element.setDescription(this.getDescription().createDesriptionType());
            }
            String quantityUnits = this.getQuantityUnits();
            String quantityValue = this.getQuantity();
            if (quantityValue != null && quantityUnits != null) {
                TypeUnitValueImpl quantityType = new TypeUnitValueImpl();
                quantityType.setUnits(quantityUnits);
                quantityType.setValue(new BigDecimal(quantityValue));
                element.setQuantity(quantityType);
            }
        }
        catch (Exception e) {
            String message = "FlatRateUnit - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            LOG.fatal((Object)("error code: " + be.getErrorCode() + " " + message));
            throw be;
        }
        return element;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("FlatRateUnit:");
        buff.append("\nnumber: " + this.getNumber());
        buff.append("\nisLocal: " + this.getIsLocal());
        buff.append("\ndescription: " + this.getDescription());
        buff.append("\nquantity: " + this.getQuantity());
        buff.append("\nquantityUnits: " + this.getQuantityUnits());
        return buff.toString();
    }
}

