/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.OrderBaseType;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenVorE65;
import com.bmw.gki.klib.data.xsd.ServiceIntervalDisplay;
import com.bmw.gki.klib.data.xsd.TimeLine;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.klib.util.BuildVersionReader;
import com.bmw.gki.logging.GKILogManager;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class ServiceInformation {
    private static Log log = GKILogManager.getInstance().getLogger(ServiceInformation.class);
    public static final String CLASS_NAME = "ServiceInformation";
    public static final String TAG_SERVICE_INFORMATION = "serviceInformation";
    public static Properties p = new Properties();

    private ServiceInformation() {
    }

    public static OrderBaseType.ServiceInformation createServiceInformationType(AuftragsbasisGrunddatenIF ab, TimeZone timeZone, GKISettings usersettings) {
        String gkiVersion;
        Locale locale = usersettings.getLocale();
        OrderBaseTypeImpl.ServiceInformationImpl element = new OrderBaseTypeImpl.ServiceInformationImpl();
        String ksdVersion = KSDCache.getInstance().getKSDVersion();
        if (ksdVersion != null) {
            element.setKsdVersion(ksdVersion);
        }
        if ((gkiVersion = BuildVersionReader.getInstance().getGKIVersion()) != null) {
            element.setGenkiVersion(gkiVersion);
        }
        try {
            if (ab.getSchluesseldaten().isE65upward()) {
                element.setTimeLine(TimeLine.createTimeline(ab, timeZone, usersettings, locale));
            } else {
                element.setServiceIntervalDisplay(ServiceIntervalDisplay.createServiceIntervalDisplay((SchluesseldatenVorE65)ab.getSchluesseldaten(), usersettings, locale));
            }
        }
        catch (Exception e) {
            String message = "ServiceInformation createServiceInformation XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return element;
    }
}

