/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.data.xsd;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.exception.XMLBearbeitungsException;
import com.bmw.gki.klib.api_current.TypeProductType;
import com.bmw.gki.klib.api_current.VehicleBasicType;
import com.bmw.gki.klib.api_current.impl.DescriptionTypeImpl;
import com.bmw.gki.klib.api_current.impl.OrderBaseTypeImpl;
import com.bmw.gki.klib.api_current.impl.StateInformationTypeImpl;
import com.bmw.gki.klib.api_current.impl.VehicleBasicTypeImpl;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.KeyDataHelper;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.xsd.StateInformation;
import com.bmw.gki.klib.data.xsd.VehicleBasic;
import com.bmw.gki.klib.util.GKIHelper;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class Vehicle
extends VehicleBasic {
    private static Log log = GKILogManager.getInstance().getLogger(Vehicle.class);
    public static final String CLASS_NAME = "OrderBase";
    public static final String TAG_VEHICLE = "vehicle";
    public static final String ATT_MANUFACTURING_DATE = "manufacturingDate";
    public static final String AUTOMATICALLY = "K";
    public static final String MANUALLY = "M";
    public static final String ATT_CODE = "code";
    public static final String ATT_INPUT_INDICATOR = "inputIndicator";
    public static final String TAG_BRAND = "brand";
    public static final String BRAND_BMW = "BMW";
    public static final String BRAND_MINI = "MINI";
    public static final String BRAND_RR = "RR";
    private static final String BRAND_BMWi = "BI";
    private String manufacturingDate = null;
    private String brand = null;
    private StateInformation stateInformation = null;

    private Vehicle() {
    }

    public String getManufacturingDate() {
        return this.manufacturingDate;
    }

    public void setManufacturingDate(String manufacturingDate) {
        this.manufacturingDate = manufacturingDate;
    }

    public StateInformation getStateInformation() {
        return this.stateInformation;
    }

    public void setStateInformation(StateInformation stateInformation) {
        this.stateInformation = stateInformation;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    private static String getXSDBrand(String marke) {
        String brand = null;
        if (marke.startsWith("B")) {
            brand = BRAND_BMW;
        } else if (marke.startsWith(MANUALLY)) {
            brand = BRAND_MINI;
        } else if (marke.startsWith("R")) {
            brand = BRAND_RR;
        } else if (marke.startsWith("I")) {
            brand = BRAND_BMWi;
        }
        return brand;
    }

    public static OrderBaseTypeImpl.VehicleImpl createVehicleType(AuftragsbasisGrunddatenIF ab, TimeZone timeZone, GKISettings usersettings) throws GKIException {
        OrderBaseTypeImpl.VehicleImpl vehicleImpl = new OrderBaseTypeImpl.VehicleImpl();
        Locale locale = usersettings.getLocale();
        try {
            DescriptionTypeImpl descr;
            String code;
            SchluesseldatenE65 sdsE65;
            String upholsteryCode;
            Object modelType;
            vehicleImpl.setManufacturingDate(Utilities.getBaustandToXMLGregorianCalendar(ab.getFgnrKreisInfo().getBaustand()));
            log.debug((Object)("manufacturing date is : " + vehicleImpl.getManufacturingDate()));
            String fgnr = ab.getSchluesseldaten().getFgnr();
            vehicleImpl.setVehicleIdentification(fgnr);
            if (ab.getSchluesseldaten().getMarke() != null) {
                vehicleImpl.setBrand(Vehicle.getXSDBrand(ab.getSchluesseldaten().getMarke()).toString());
            }
            if (ab.getFgnrKreisInfo().getLeittyp() != null) {
                modelType = new VehicleBasicTypeImpl.LeadModelImpl();
                modelType.setCode(ab.getFgnrKreisInfo().getLeittyp());
                vehicleImpl.setLeadModel((VehicleBasicType.LeadModel)modelType);
            }
            modelType = new VehicleBasicTypeImpl.ModelImpl();
            modelType.setCode(ab.getFgnrKreisInfo().getTypschluessel());
            modelType.setModelDesignation(ab.getFgnrKreisInfo().getModelBezeichnung());
            vehicleImpl.setModel((VehicleBasicType.Model)modelType);
            String colourCode = ab.getSchluesseldaten().getFarbCode();
            if (colourCode != null && colourCode.length() > 0) {
                VehicleBasicTypeImpl.ColourImpl colourType = new VehicleBasicTypeImpl.ColourImpl();
                colourType.setCode(colourCode);
                vehicleImpl.setColour(colourType);
            }
            if ((upholsteryCode = ab.getSchluesseldaten().getPolsterCode()) != null && upholsteryCode.length() > 0) {
                VehicleBasicTypeImpl.UpholsteryImpl upholstery = new VehicleBasicTypeImpl.UpholsteryImpl();
                upholstery.setCode(upholsteryCode);
                vehicleImpl.setUpholstery(upholstery);
            }
            if (ab.getSchluesseldaten().isE65upward() && (sdsE65 = (SchluesseldatenE65)ab.getSchluesseldaten()).getErstzulassung() != null) {
                vehicleImpl.setFirstRegistrationDate(KeyDataHelper.retrieveXMLGregorianCalendar(sdsE65.getErstzulassung(), timeZone));
            }
            vehicleImpl.setStateInformation(StateInformation.writeXMLNode(new StateInformationTypeImpl(), ab, usersettings));
            vehicleImpl.setProduct(TypeProductType.fromValue("car"));
            vehicleImpl.setESeries(ab.getFgnrKreisInfo().getEngineeringSeries());
            double d = ab.getSchluesseldaten().getData().getVehicle().isSetCubicCapacity() ? ab.getSchluesseldaten().getData().getVehicle().getCubicCapacity() : 0.0;
            if (d > 0.0) {
                vehicleImpl.setCubicCapacity(ab.getSchluesseldaten().getData().getVehicle().getCubicCapacity());
            }
            if ((ab.getSchluesseldaten().getData().getVehicle().isSetCylinderCount() ? ab.getSchluesseldaten().getData().getVehicle().getCylinderCount() : 0) > 0) {
                VehicleBasicTypeImpl.CylinderImpl cylinderType = new VehicleBasicTypeImpl.CylinderImpl();
                code = "" + ab.getSchluesseldaten().getData().getVehicle().getCylinderCount();
                cylinderType.setCode(code);
                descr = new DescriptionTypeImpl();
                descr.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                descr.setValue(GKIHelper.getTableString("vehicle.cylinder." + code, locale));
                cylinderType.setDescription(descr);
                vehicleImpl.setCylinder(cylinderType);
            }
            if ((ab.getSchluesseldaten().getData().getVehicle().isSetGearCount() ? ab.getSchluesseldaten().getData().getVehicle().getGearCount() : 0) > 0) {
                vehicleImpl.setGearCount(ab.getSchluesseldaten().getData().getVehicle().getGearCount());
            }
            if ((ab.getSchluesseldaten().getData().getVehicle().isSetBodyType() ? ab.getSchluesseldaten().getData().getVehicle().getBodyType() : 0) > 0) {
                VehicleBasicTypeImpl.BodyTypeImpl bodyType = new VehicleBasicTypeImpl.BodyTypeImpl();
                code = "" + ab.getSchluesseldaten().getData().getVehicle().getBodyType();
                bodyType.setCode(code);
                descr = new DescriptionTypeImpl();
                descr.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                descr.setValue(GKIHelper.getTableString("vehicle.bodyType." + code, locale));
                bodyType.setDescription(descr);
                vehicleImpl.setBodyType(bodyType);
            }
            if ((ab.getSchluesseldaten().getData().getVehicle().isSetSteering() ? ab.getSchluesseldaten().getData().getVehicle().getSteering() : 0) > 0) {
                VehicleBasicTypeImpl.SteeringImpl steeringType = new VehicleBasicTypeImpl.SteeringImpl();
                code = "" + ab.getSchluesseldaten().getData().getVehicle().getSteering();
                steeringType.setCode(code);
                descr = new DescriptionTypeImpl();
                descr.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                descr.setValue(GKIHelper.getTableString("vehicle.steeringType." + code, locale));
                steeringType.setDescription(descr);
                vehicleImpl.setSteering(steeringType);
            }
            if (ab.getSchluesseldaten().getData().getVehicle().isSetTransmission() && ab.getSchluesseldaten().getData().getVehicle().getTransmission() >= 0 && ab.getSchluesseldaten().getData().getVehicle().getTransmission() <= 15) {
                VehicleBasicTypeImpl.TransmissionImpl transmissionType = new VehicleBasicTypeImpl.TransmissionImpl();
                code = "" + ab.getSchluesseldaten().getData().getVehicle().getTransmission();
                transmissionType.setCode(code);
                descr = new DescriptionTypeImpl();
                descr.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                descr.setValue(GKIHelper.getTableString("vehicle.transmissionType." + code, locale));
                transmissionType.setDescription(descr);
                vehicleImpl.setTransmission(transmissionType);
            }
            if ((ab.getSchluesseldaten().getData().getVehicle().isSetEngine() ? ab.getSchluesseldaten().getData().getVehicle().getEngine() : 0) > 0) {
                VehicleBasicTypeImpl.EngineImpl engineType = new VehicleBasicTypeImpl.EngineImpl();
                code = "" + ab.getSchluesseldaten().getData().getVehicle().getEngine();
                engineType.setCode(code);
                descr = new DescriptionTypeImpl();
                descr.setLanguage(Utilities.getLocaleToXSDLanguage(locale));
                descr.setValue(GKIHelper.getTableString("vehicle.engine." + code, locale));
                engineType.setDescription(descr);
                vehicleImpl.setEngine(engineType);
            }
        }
        catch (GKIException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Vehicle createVehicleType - XML failure";
            XMLBearbeitungsException be = new XMLBearbeitungsException(message, e);
            log.fatal((Object)("error code: " + be.getErrorCode() + " " + message), (Throwable)e);
            throw be;
        }
        return vehicleImpl;
    }
}

