/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.BosNotFoundException;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class BOSNummerReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(BOSNummerReader.class);
    private static final String RESOURCE = "/ident_";
    private static final String SUFFIX = ".properties";
    private static Map<Integer, BOSNummer> BOS_NUMBERS = new HashMap<Integer, BOSNummer>();

    public static void einlesenTabelle(String path, Locale[] locales) throws KSDPropertyFormatException, SettingsException {
        File dir = new File(path);
        log.info((Object)"start reading BOSNummer into cache.");
        for (int i = 0; i < locales.length; ++i) {
            SettingsException ke;
            String message;
            String language = locales[i].getLanguage();
            String country = locales[i].getCountry();
            if (language == null || language.length() == 0) {
                message = "mandatory field language (GKI Settings) is not set: " + language;
                ke = new SettingsException(message);
                log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
                throw ke;
            }
            if (country == null || country.length() == 0) {
                message = "mandatory field country (GKI Settings) is not set: " + country;
                ke = new SettingsException(message);
                log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
                throw ke;
            }
            File file = new File(dir, RESOURCE + language + "_" + country + SUFFIX);
            if (!file.exists()) {
                file = new File(dir, RESOURCE + language + SUFFIX);
            }
            log.debug((Object)("Try to read file:" + file));
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file), 40000);
                Properties p = new Properties();
                p.load(in);
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = p.getProperty(key);
                    int id = BOSValue.testAndGetInt(key, 5, 5, "unknown", 0);
                    BOSNummer bosNumber = BOS_NUMBERS.get(new Integer(id));
                    if (bosNumber == null) {
                        bosNumber = new BOSNummer(id);
                        log.debug((Object)("bosnummer:" + id));
                    }
                    bosNumber.getBezeichnungen().put(locales[i], value);
                    bosNumber.getBezeichnungen().put(locales[i].getLanguage(), value);
                    BOS_NUMBERS.put(new Integer(id), bosNumber);
                }
                continue;
            }
            catch (FileNotFoundException fnf) {
                log.debug((Object)("Not found data: " + path));
                continue;
            }
            catch (IOException ioe) {
                String message2 = "BosNummerReader IO Exception path: " + path;
                throw new KSDPropertyFormatException(message2, ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        log.info((Object)"end reading BOSNummer into cache.");
    }

    public static BOSNummer find(int id) throws GKIException {
        BOSNummer bosNumber = BOS_NUMBERS.get(new Integer(id));
        if (bosNumber != null) {
            return bosNumber;
        }
        if (PreProdHolder.getIsPreProd()) {
            String message = PreProdLogMessages.getParameterString("CODE_BOS_NR_NOT_FOUND", new Object[]{"" + id});
            PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_BOS_NR_NOT_FOUND", message));
        }
        BosNotFoundException ex = new BosNotFoundException("CBS id: " + id + " not found");
        throw ex;
    }

    public static void reset() {
        BOS_NUMBERS = new HashMap<Integer, BOSNummer>();
    }
}

