/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.SettingsException;
import com.bmw.gki.klib.config.GKICache;
import com.bmw.gki.klib.config.GKICacheObject;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSValue;
import com.bmw.gki.klib.data.ksd.cbs.BOSVerknuepfung;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.external.cache.ObjectCache;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class BOSVerknuepfungReader2
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(BOSVerknuepfungReader2.class);
    private static Hashtable<String, Vector<BOSVerknuepfung>> bosVerknuepfungen = new Hashtable();
    public static final String ASC = "ASC";
    public static final String PSC = "PSC";
    public static final String APD = "APD";
    public static final String FILENAME = "_con1.properties";
    public static final String FILENAME_V6 = "_con2.properties";
    public static boolean v6DataSource = false;
    public static Map<String, Vector<BOSVerknuepfung>> leitTypMap;

    public static void einlesenTabelle(String path, String[] regionCodes, GKICache ksdCache) throws KSDPropertyFormatException, SettingsException {
        if (path == null || path.length() == 0) {
            String message = "BOS Verknuepfungsreader path (GKI Settings)  not set: " + path;
            SettingsException ke = new SettingsException(message);
            log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
            throw ke;
        }
        log.info((Object)"Reading BOSVerknuepfungen");
        GKICacheObject bosCache = null;
        if (ksdCache != null) {
            bosCache = ksdCache.getCacheObject("CACHE_BOSVALUECACHE");
        }
        if (bosCache == null) {
            bosCache = new GKICacheObject("CACHE_BOSVALUECACHE");
            bosCache.setCacheActivated(false);
        }
        bosCache.setReadDirect(true);
        if (bosCache.isCacheActivated()) {
            bosCache = BOSVerknuepfungReader2.checkCache(bosCache);
        }
        if (bosCache.isReadDirect()) {
            BOSVerknuepfungReader2.readBOSVerknuepfungen(path, regionCodes);
            if (bosCache.isCacheActivated()) {
                ObjectCache.writeCache(bosCache.getCompleteCachePath(), bosVerknuepfungen);
            }
            log.info((Object)"from Data into cache.");
        }
    }

    private static GKICacheObject checkCache(GKICacheObject bosCache) {
        boolean toCache;
        String targetDirectory = null;
        String cacheFilePath = null;
        if (bosCache.isCacheActivated() && (targetDirectory = bosCache.getFileDirectoryOrTemp()) == null) {
            log.warn((Object)"BOSCache not activated: GKI_BOSVALUECACHE_DIRECTORY or ENV.TEMP not set.");
            bosCache.setCacheActivated(false);
        }
        if (bosCache.isCacheActivated() && (toCache = ObjectCache.checkCacheExists(cacheFilePath = bosCache.createCompleteCachePath()))) {
            Object object = null;
            try {
                object = ObjectCache.readCache(cacheFilePath);
            }
            catch (KSDAccessException e) {
                log.info((Object)("Error in ObjectCache: " + e.getMessage()));
            }
            if (object != null) {
                bosVerknuepfungen = (Hashtable)object;
                log.info((Object)"From Localfile:");
                log.info((Object)(cacheFilePath + " into cache."));
                bosCache.setReadDirect(false);
                bosCache.setCached(true);
                return bosCache;
            }
            ObjectCache.cleanCache(cacheFilePath);
        }
        return bosCache;
    }

    private static void readBOSVerknuepfungen(String path, String[] regionCodes) throws KSDPropertyFormatException, SettingsException {
        for (int i = 0; i < regionCodes.length; ++i) {
            String region = regionCodes[i];
            if (region == null || region.length() == 0) {
                String message = "BOSVerknuepfungsreader mandatory field region not set: " + path;
                SettingsException ke = new SettingsException(message);
                log.info((Object)("exception code: " + ke.getErrorCode() + " " + message));
                throw ke;
            }
            Vector<Object> verknuepfungsliste = null;
            if (bosVerknuepfungen != null && bosVerknuepfungen.get(region) != null) {
                verknuepfungsliste = bosVerknuepfungen.get(region);
            } else {
                verknuepfungsliste = new Vector();
                bosVerknuepfungen.put(region, verknuepfungsliste);
            }
            File file = new File(path, region + FILENAME_V6);
            v6DataSource = true;
            if (!file.exists()) {
                v6DataSource = false;
                file = new File(path, region + FILENAME);
            }
            String filePath = file.getAbsolutePath();
            log.info((Object)("Reading region: " + filePath));
            if (PreProdHolder.getIsPreProd() && !file.exists()) continue;
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new BufferedReader(new FileReader(file), 200000));
                while (reader.ready()) {
                    String line = ((LineNumberReader)reader).readLine();
                    int lineNr = ((LineNumberReader)reader).getLineNumber();
                    if (Utilities.isCommentLine(line)) continue;
                    int equal = line.indexOf(61);
                    String key = line.substring(0, equal);
                    String data = line.substring(equal + 1, line.length());
                    StringTokenizer tokenizer = new StringTokenizer(key, ";");
                    if (tokenizer.countTokens() != 3) {
                        String message;
                        if (PreProdHolder.getIsPreProd()) {
                            message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{filePath, "" + lineNr, "token count"});
                            PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
                        }
                        message = "BOSVerknuepfungReader token count != 3";
                        KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                        log.info((Object)message);
                        throw pex;
                    }
                    String leittyp = BOSValue.testAndGetString(tokenizer.nextToken(), 4, 4, filePath, lineNr);
                    int idFrom = BOSValue.testAndGetInt(tokenizer.nextToken(), 1, 5, filePath, lineNr);
                    String typ = tokenizer.nextToken().trim();
                    BOSNummer bosNrFrom = null;
                    try {
                        bosNrFrom = BOSNummerReader.find(idFrom);
                    }
                    catch (GKIException e) {
                        String message = "BOSVerknuepfungReader id " + idFrom + " not found";
                        KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                        log.info((Object)message);
                        throw pex;
                    }
                    tokenizer = new StringTokenizer(data, ";");
                    if (tokenizer.countTokens() < 5) {
                        if (PreProdHolder.getIsPreProd()) {
                            String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{filePath, "" + lineNr, "token count"});
                            PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
                        }
                        throw new KSDPropertyFormatException("BOSVerknuepfungReader token count < 5", new String[]{"5", "" + tokenizer.countTokens(), filePath, "" + lineNr});
                    }
                    int letzterBaustand = 0;
                    String letzterLeittyp = "";
                    leitTypMap = new HashMap<String, Vector<BOSVerknuepfung>>();
                    Vector<BOSVerknuepfung> vBosverknuepfungenLeittyp = null;
                    while (tokenizer.hasMoreElements()) {
                        String parseSichtbarkeit;
                        int baustandAnfang = 0;
                        int baustandEnde = 0;
                        String baustandAll = tokenizer.nextToken();
                        int posDivider = baustandAll.indexOf("-");
                        if (v6DataSource && posDivider > -1) {
                            String baustandEndeS = baustandAll.substring(posDivider + 1);
                            if (baustandEndeS.length() != 6) {
                                throw new KSDPropertyFormatException("baustand v6 fuer '" + leittyp + "' [" + baustandAll + "] hat inkorrektes format");
                            }
                            baustandAnfang = BOSValue.testAndGetBaustand(baustandAll.substring(0, posDivider), filePath, lineNr);
                            baustandEnde = Integer.parseInt(baustandEndeS);
                        } else {
                            baustandAnfang = BOSValue.testAndGetBaustand(baustandAll, filePath, lineNr);
                        }
                        int idTo = BOSValue.testAndGetInt(tokenizer.nextToken(), 1, 5, filePath, lineNr);
                        int faelligAb = BOSValue.testAndGetInt(tokenizer.nextToken(), 1, 6, filePath, lineNr);
                        int faelligBis = BOSValue.testAndGetInt(tokenizer.nextToken(), 1, 6, filePath, lineNr);
                        String einheit = tokenizer.nextToken().trim();
                        int sichtbarkeit = 1;
                        if (tokenizer.hasMoreTokens() && "0".equals(parseSichtbarkeit = tokenizer.nextToken().trim())) {
                            sichtbarkeit = 0;
                        }
                        BOSNummer bosNrTo = null;
                        try {
                            bosNrTo = BOSNummerReader.find(idTo);
                        }
                        catch (GKIException e) {
                            String message = "BOSVerknuepfungReader id: " + idTo + " not found";
                            KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                            log.info((Object)message);
                            throw pex;
                        }
                        if (letzterBaustand != 0 && baustandAnfang > letzterBaustand) {
                            if (PreProdHolder.getIsPreProd()) {
                                String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{filePath, "" + lineNr, "Baustand: Invalid temporal sequence"});
                                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_READING_REF_FILES_NOT_VALID", message));
                            }
                            KSDPropertyFormatException ex = new KSDPropertyFormatException("BOSVerknuepfungReader invalid temporal sequence", new String[]{filePath, "" + lineNr});
                            throw ex;
                        }
                        int index = -1;
                        int baustandEndeErmittelt = 0;
                        if (!verknuepfungsliste.isEmpty()) {
                            index = BOSVerknuepfungReader2.proof(region, leittyp, bosNrFrom, bosNrTo, baustandAnfang, faelligAb, faelligBis);
                            if (index >= 0) {
                                verknuepfungsliste.removeElementAt(index);
                            }
                            baustandEndeErmittelt = BOSVerknuepfungReader2.ermittelnBaustandEnde(region, leittyp, bosNrFrom, bosNrTo);
                        }
                        if (!v6DataSource) {
                            baustandEnde = baustandEndeErmittelt;
                        } else if (baustandEnde == 0) {
                            baustandEnde = baustandEndeErmittelt;
                        }
                        BOSVerknuepfung bv = new BOSVerknuepfung(leittyp, baustandAnfang, baustandEnde, typ, faelligAb, faelligBis, einheit, bosNrFrom, bosNrTo, sichtbarkeit);
                        verknuepfungsliste.addElement(bv);
                        if (letzterLeittyp.equals(leittyp)) {
                            vBosverknuepfungenLeittyp.addElement(bv);
                        } else {
                            if (!letzterLeittyp.isEmpty()) {
                                leitTypMap.put(letzterLeittyp, vBosverknuepfungenLeittyp);
                                log.info((Object)("LTT:" + vBosverknuepfungenLeittyp.size()));
                            }
                            vBosverknuepfungenLeittyp = new Vector<BOSVerknuepfung>();
                            vBosverknuepfungenLeittyp.addElement(bv);
                        }
                        letzterBaustand = baustandAnfang;
                    }
                    leitTypMap.put(letzterLeittyp, vBosverknuepfungenLeittyp);
                }
                continue;
            }
            catch (IOException ex) {
                String message = "BosVerknuepfungReader IO Exception file: " + file;
                KSDPropertyFormatException kfe = new KSDPropertyFormatException(message, ex);
                log.info((Object)("exception code: " + kfe.getErrorCode() + ", message: " + message));
                throw kfe;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public static Vector<BOSVerknuepfung> find(String region, String leittyp, BOSNummer bosNummer, int baustand) {
        Vector<BOSVerknuepfung> verknuefungsliste = leitTypMap.get(leittyp);
        Vector<BOSVerknuepfung> verknuepfungen = new Vector<BOSVerknuepfung>();
        if (verknuefungsliste != null) {
            for (BOSVerknuepfung bosVerknuepfung : verknuefungsliste) {
                if (!bosVerknuepfung.isValid(leittyp, bosNummer, baustand)) continue;
                verknuepfungen.addElement(bosVerknuepfung);
                log.info((Object)(" BOSNr. " + bosNummer + " VON: " + bosVerknuepfung.getBosNrVon() + " NACH : " + bosVerknuepfung.getBosNrNach() + "Leittyp: " + bosVerknuepfung.getLeittyp() + "  Bau Anfang: " + bosVerknuepfung.getBaustandAnfang() + " testBauEnd+ " + bosVerknuepfung.getBaustandEnde()));
            }
        }
        return verknuepfungen;
    }

    private static int proof(String region, String leittyp, BOSNummer bosNrVon, BOSNummer bosNrNach, int baustandAnfang, int ab, int bis) {
        int retval = -1;
        Vector<BOSVerknuepfung> verknuepfungsliste = bosVerknuepfungen.get(region);
        for (int i = 0; i < verknuepfungsliste.size(); ++i) {
            BOSVerknuepfung testVerk = verknuepfungsliste.elementAt(i);
            if (!testVerk.isValidWiederholungswert(leittyp, bosNrVon, bosNrNach, ab, bis)) continue;
            for (BOSVerknuepfung pruefVerk : verknuepfungsliste) {
                int pruefBaustand = pruefVerk.getBaustandAnfang();
                int pruefFaelligAb = pruefVerk.getFaelligAb();
                int pruefFaelligBis = pruefVerk.getFaelligBis();
                BOSNummer pruefFrom = pruefVerk.getBosNrVon();
                BOSNummer pruefTo = pruefVerk.getBosNrNach();
                if (pruefFrom != bosNrVon || pruefTo != bosNrNach || pruefBaustand < baustandAnfang || pruefFaelligAb == ab && pruefFaelligBis == bis) continue;
                retval = -1;
                return -1;
            }
            retval = i;
        }
        return retval;
    }

    private static int ermittelnBaustandEnde(String region, String leittyp, BOSNummer bosFrom, BOSNummer bosTo) {
        int retval = 0;
        Vector<BOSVerknuepfung> verknuepfungsliste = bosVerknuepfungen.get(region);
        for (int i = 0; i < verknuepfungsliste.size(); ++i) {
            BOSVerknuepfung testVerk = verknuepfungsliste.elementAt(i);
            if (testVerk.getLeittyp().equals(leittyp)) {
                if (!testVerk.getBosNrVon().equals(bosFrom) || !testVerk.getBosNrNach().equals(bosTo)) continue;
                retval = testVerk.getBaustandAnfang();
                continue;
            }
            retval = 0;
        }
        return retval;
    }

    public static void update(String path, String[] regionCodes, GKICache ksdCacheDirectives) throws GKIException {
        bosVerknuepfungen.clear();
        BOSVerknuepfungReader2.einlesenTabelle(path, regionCodes, ksdCacheDirectives);
    }

    public static void reset() {
        bosVerknuepfungen = new Hashtable();
    }
}

