/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.logging.GKILogManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;

public class ExtendedAttributeTranslator {
    private static final Log log = GKILogManager.getInstance().getLogger(ExtendedAttributeTranslator.class);
    private static final String RESOURCE_FILE = "extAttMessages";
    private static Map<Locale, ExtendedAttributeTranslation> translations;
    private static String ksdPath;
    private static String preProductionPath;
    private ResourceBundle resourceBundle;

    public ExtendedAttributeTranslator(Locale locale) {
        ExtendedAttributeTranslation translation = ExtendedAttributeTranslation.getTranslation(locale);
        this.resourceBundle = translation.getResourceBundle();
    }

    private String getString(String key, ResourceBundle bundle) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                log.trace((Object)e.getMessage());
            }
        }
        return null;
    }

    public String findDisplayValue(String extAttrValue) {
        return this.getString(extAttrValue, this.resourceBundle);
    }

    public static void setKsdPath(String ksd) {
        ksdPath = ksd;
    }

    public static void setPreProductionPath(String preProdPath) {
        preProductionPath = preProdPath;
    }

    public static synchronized void reset() {
        translations = null;
    }

    private static class ExtendedAttributeTranslation {
        private ResourceBundle bundle;

        public static synchronized ExtendedAttributeTranslation getTranslation(Locale locale) {
            ExtendedAttributeTranslation translation;
            if (translations == null) {
                translations = new HashMap();
            }
            if ((translation = (ExtendedAttributeTranslation)translations.get(locale)) == null) {
                translation = new ExtendedAttributeTranslation(locale);
                translations.put(locale, translation);
            }
            return translation;
        }

        private ExtendedAttributeTranslation(Locale locale) {
            this.bundle = this.getResourceBundle(locale);
            if (this.bundle == null) {
                String message = "Translation of extended attributes for locale " + locale + " does not exist (bundle " + ExtendedAttributeTranslator.RESOURCE_FILE + ")";
                if (PreProdHolder.getIsPreProd()) {
                    message = PreProdLogMessages.getParameterString("CODE_EXT_ATTRIB_NOT_FOUND", new Object[]{locale});
                    PreProdLogEntry entry = new PreProdLogEntry("INFO", "CODE_EXT_ATTRIB_NOT_FOUND", message);
                    PreProdHolder.addLogEntry(entry);
                }
                log.info((Object)message);
            }
        }

        public ResourceBundle getResourceBundle() {
            return this.bundle;
        }

        private ResourceBundle getResourceBundle(Locale locale) {
            if (locale == null) {
                log.info((Object)"translation of extended attributes - locale not set");
            }
            ClassLoader propertyLoader = null;
            try {
                propertyLoader = this.getClassLoader();
            }
            catch (Exception e) {
                log.info((Object)"Path for translation of extended attributes not valid");
                propertyLoader = this.getClass().getClassLoader();
            }
            try {
                ResourceBundle result = ResourceBundle.getBundle(ExtendedAttributeTranslator.RESOURCE_FILE, locale, propertyLoader);
                if (result == null) {
                    result = ResourceBundle.getBundle(ExtendedAttributeTranslator.RESOURCE_FILE, null, propertyLoader);
                }
                return result;
            }
            catch (MissingResourceException e) {
                log.trace((Object)e.getMessage());
            }
            catch (Exception e) {
                log.info((Object)"Exception loading translation of extended attributes", (Throwable)e);
            }
            return null;
        }

        private ClassLoader getClassLoader() throws KSDAccessException {
            try {
                File file;
                ArrayList<URL> urls = new ArrayList<URL>();
                if (KSDCache.getInstance().isPreProduction()) {
                    log.trace((Object)("Path to PreProduction is: " + preProductionPath));
                    if (preProductionPath == null) {
                        String message = "Translation of extended attributes - preProductionPath not set: " + preProductionPath;
                        KSDAccessException ex = new KSDAccessException(message);
                        log.info((Object)message);
                        throw ex;
                    }
                    file = new File(preProductionPath);
                    if (!file.exists()) {
                        String message = "Translation of extended attributes - invalid preProductionPath: " + preProductionPath;
                        KSDAccessException ex = new KSDAccessException(message);
                        log.info((Object)message);
                        throw ex;
                    }
                    urls.add(file.toURI().toURL());
                }
                log.trace((Object)("Path to KSD is: " + ksdPath));
                if (ksdPath == null) {
                    String message = "Translation of extended attributes - ksdPath not set: " + ksdPath;
                    KSDAccessException ex = new KSDAccessException(message);
                    log.info((Object)message);
                    throw ex;
                }
                file = new File(ksdPath);
                if (!file.exists()) {
                    String message = "Translation of extended attributes - invalid ksdPath: " + ksdPath;
                    KSDAccessException ex = new KSDAccessException(message);
                    log.info((Object)message);
                    throw ex;
                }
                urls.add(file.toURI().toURL());
                KSDCache.SwitchClassLoader loader = new KSDCache.SwitchClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
                return loader;
            }
            catch (MalformedURLException e) {
                String message = "Translation of extended attributes MalformedURLException, ksdPath: " + ksdPath + ", preProductionPath: " + preProductionPath;
                KSDAccessException ex = new KSDAccessException(message);
                log.info((Object)message);
                throw ex;
            }
        }
    }
}

