/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.ILevelESeriesDerivateNotFoundException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelData;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelKeyData;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class ILevelReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(ILevelReader.class);
    private static final String MAPPING_PROPERTIES_FILE_NAME = "ereihe2istufentabelle.properties";
    private static ILevelReader instance = null;
    private Properties mappingtable;
    private Hashtable<String, String> newestDistributed = new Hashtable();
    private Hashtable<String, Hashtable<Object, String>> allILevels = new Hashtable();

    private ILevelReader() {
    }

    public void readInTable(String path, boolean reset) throws KSDAccessException {
        block9: {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File directory, String name) {
                    return name != null && name.toLowerCase().endsWith("_istufe.properties");
                }
            };
            try {
                File dir = new File(path);
                File[] propFiles = dir.listFiles(filter);
                if (propFiles == null) break block9;
                for (int i = 0; i < propFiles.length; ++i) {
                    File propFile = propFiles[i];
                    Properties props = this.loadProperties(propFile);
                    Hashtable<Object, String> code2ILevelHt = new Hashtable<Object, String>();
                    String eSeriesDerivate = "";
                    int lineNr = 1;
                    Enumeration<Object> en = props.keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        String value = props.getProperty(key);
                        try {
                            String eSeriesDerivateToken = this.extractAndSortILevels(key, value, code2ILevelHt);
                            if (propFile.getName().startsWith(eSeriesDerivateToken)) {
                                eSeriesDerivate = eSeriesDerivateToken;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (PreProdHolder.getIsPreProd()) {
                                String message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{propFile.getCanonicalPath(), "" + lineNr, "not a number"});
                                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_READING_REF_FILES_NOT_VALID", message));
                            }
                            log.warn((Object)("funny entry in " + propFile.getCanonicalPath()), (Throwable)nfe);
                        }
                        ++lineNr;
                    }
                    this.allILevels.put(eSeriesDerivate, code2ILevelHt);
                }
            }
            catch (IOException ex) {
                String message = "ILevel Reader IOException path: " + path;
                KSDAccessException exk = new KSDAccessException(message);
                log.info((Object)message);
                throw exk;
            }
            catch (Exception ex) {
                String message = "iLevelReader  uknown read in table: " + path;
                KSDAccessException exk = new KSDAccessException(message);
                log.info((Object)message);
                throw exk;
            }
        }
        this.readinMapping(path, reset);
        log.debug((Object)("allILevels: " + this.allILevels));
        log.info((Object)("newestDistributed: " + this.newestDistributed));
        log.info((Object)("mappingtable: " + this.mappingtable));
    }

    private String extractAndSortILevels(String szKey, String iLevelFull, Hashtable<Object, String> code2ILevelHt) {
        Object code = null;
        try {
            code = Integer.decode("0x" + szKey);
        }
        catch (NumberFormatException e) {
            code = szKey;
        }
        StringTokenizer tk = new StringTokenizer(iLevelFull, "-");
        String eSeriesDerivate = tk.nextToken();
        tk = new StringTokenizer(iLevelFull, ";");
        String iLevelCut = tk.nextToken();
        boolean isDistributed = false;
        if (tk.hasMoreTokens()) {
            String tokenStringTrim;
            String tokenString = tk.nextToken();
            if (!tokenString.equals(tokenStringTrim = tokenString.trim())) {
                log.warn((Object)("I-Level =\"" + iLevelFull + "\": contains spaces"));
            }
            if ("D".equalsIgnoreCase(tokenStringTrim)) {
                isDistributed = true;
            }
        }
        if (isDistributed) {
            if (this.newestDistributed.containsKey(eSeriesDerivate)) {
                String existingLevel = this.newestDistributed.get(eSeriesDerivate);
                if (this.isHigher(existingLevel, iLevelCut)) {
                    this.newestDistributed.put(eSeriesDerivate, iLevelCut);
                }
            } else {
                this.newestDistributed.put(eSeriesDerivate, iLevelCut);
            }
        }
        code2ILevelHt.put(code, iLevelCut);
        return eSeriesDerivate;
    }

    private void readinMapping(String path, boolean reset) throws KSDAccessException {
        File dir = new File(path);
        File file = new File(dir, MAPPING_PROPERTIES_FILE_NAME);
        try {
            this.mappingtable = this.loadDerivate(file, reset);
        }
        catch (IOException e) {
            String message;
            if (PreProdHolder.getIsPreProd()) {
                message = PreProdLogMessages.getParameterString("CODE_READING_REF_FILES_NOT_VALID", new Object[]{file, "-", e.getMessage()});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_READING_REF_FILES_NOT_VALID", message));
            }
            message = "ILevel Reader invalid path: " + file;
            KSDAccessException ex = new KSDAccessException(message);
            log.info((Object)message);
            throw ex;
        }
    }

    public ILevelData find(ILevelKeyData codes, String eseries) throws KSDDataException {
        if (codes == null || eseries == null) {
            return null;
        }
        String eSeriesDerivate = this.mappingtable.getProperty(eseries.trim());
        if (eSeriesDerivate == null) {
            String message;
            if (PreProdHolder.getIsPreProd()) {
                message = PreProdLogMessages.getParameterString("CODE_E_SERIES_DERIVATE_NOT_FOUND", new Object[]{eseries});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_E_SERIES_DERIVATE_NOT_FOUND", message));
            }
            message = "ILevelReader no eseries found: " + eseries;
            ILevelESeriesDerivateNotFoundException iex = new ILevelESeriesDerivateNotFoundException(message);
            log.info((Object)message);
            throw iex;
        }
        Hashtable<Object, String> code2ILevelHt = this.allILevels.get(eSeriesDerivate);
        if (code2ILevelHt == null) {
            if (PreProdHolder.getIsPreProd()) {
                String message = PreProdLogMessages.getParameterString("CODE_I_LEVEL_FOUND", new Object[]{eseries});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_I_LEVEL_FOUND", message));
            }
            throw new ILevelESeriesDerivateNotFoundException("No ILevel for eseries found");
        }
        ILevelData result = new ILevelData();
        result.setIlevelPlant(ILevelReader.getILevelPlant(codes, eSeriesDerivate, code2ILevelHt));
        result.setILevelHO(ILevelReader.getILevelHO(codes, eSeriesDerivate, code2ILevelHt));
        result.setILevelBackup(ILevelReader.getILevelBackup(codes, eSeriesDerivate, code2ILevelHt));
        String iLevelInstalled = result.getILevelHO();
        if (iLevelInstalled == null || iLevelInstalled.equals("0")) {
            iLevelInstalled = result.getIlevelPlant();
        }
        if (iLevelInstalled == null || iLevelInstalled.equals("0")) {
            throw new ILevelESeriesDerivateNotFoundException("No ILevel found");
        }
        String iLevelNewestDistributed = this.newestDistributed.get(eSeriesDerivate);
        if (iLevelNewestDistributed != null) {
            result.setNewiLevelHOAvailable(this.isHigher(iLevelInstalled, iLevelNewestDistributed));
        }
        return result;
    }

    private static String getILevelBackup(ILevelKeyData codes, String eSeriesDerivate, Hashtable<?, ?> code2ILevelHt) {
        return ILevelReader.getILevel(codes.getIlevelBackupCode(), codes.getIlevelBackup(), eSeriesDerivate, code2ILevelHt);
    }

    private static String getILevelHO(ILevelKeyData codes, String eSeriesDerivate, Hashtable<?, ?> code2ILevelHt) {
        return ILevelReader.getILevel(codes.getIlevelHOCode(), codes.getIlevelHO(), eSeriesDerivate, code2ILevelHt);
    }

    private static String getILevelPlant(ILevelKeyData codes, String eSeriesDerivate, Hashtable<?, ?> code2ILevelHt) {
        return ILevelReader.getILevel(codes.getIlevelPlantCode(), codes.getIlevelPlant(), eSeriesDerivate, code2ILevelHt);
    }

    private static String getILevel(Integer numberCode, String textCode, String eSeriesDerivate, Hashtable<?, ?> code2ILevelHt) {
        String result;
        if (textCode != null && (result = (String)code2ILevelHt.get(textCode)) != null) {
            return result;
        }
        if (numberCode != null) {
            result = (String)code2ILevelHt.get(numberCode);
            if (result != null) {
                return result;
            }
            int code = numberCode;
            if (ILevelReader.isCalculationILevelCode(eSeriesDerivate, code) && (result = ILevelReader.calculateILevelFromCode(eSeriesDerivate, code)) != null) {
                return result;
            }
        }
        return textCode;
    }

    private static boolean isCalculationILevelCode(String eSeriesDerivate, int code) {
        int month = (code & 0xF00) >>> 8;
        if (month == 0 || month > 12) {
            return false;
        }
        if ("E070".equalsIgnoreCase(eSeriesDerivate)) {
            return true;
        }
        if ("E89X".equalsIgnoreCase(eSeriesDerivate)) {
            return true;
        }
        return "R056".equalsIgnoreCase(eSeriesDerivate);
    }

    private static String calculateILevelFromCode(String eSeriesDerivate, int code) {
        int yearOffset = 7;
        int monthOffset = 0;
        int ilevelOffset = 300;
        int year = ((code & 0xF000) >>> 12) + yearOffset;
        int month = ((code & 0xF00) >>> 8) + monthOffset;
        int ilevel = (code & 0xFF) + ilevelOffset;
        String result = eSeriesDerivate.toUpperCase() + "-" + Utilities.toString(year, 2, '0') + "-" + Utilities.toString(month, 2, '0') + "-" + ilevel;
        return result;
    }

    private boolean isHigher(String existingILevel, String newestIlevel) {
        if (newestIlevel == null) {
            return false;
        }
        if (existingILevel == null) {
            return true;
        }
        return newestIlevel.toUpperCase().compareTo(existingILevel.toUpperCase()) > 0;
    }

    public static ILevelReader getInstance() {
        if (instance == null) {
            instance = new ILevelReader();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDerivate(File file, boolean reset) throws IOException {
        Properties props = null;
        props = reset || this.mappingtable == null ? new Properties() : this.mappingtable;
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file));
            String line = null;
            log.info((Object)"Read eSeriesDerivate: ");
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                StringTokenizer tokens;
                if (line.startsWith("#") || (tokens = new StringTokenizer(line, ";")).countTokens() != 2) continue;
                String eSeries = tokens.nextToken();
                String derivat = tokens.nextToken();
                props.put(eSeries, derivat);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            props.load(in);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
        return props;
    }

    public static void reset() {
        instance = null;
    }

    public static void main(String[] args) {
        int code = 5732;
        String result = ILevelReader.calculateILevelFromCode("R056", code);
        System.out.println(result);
    }
}

