/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.Messages;
import com.bmw.gki.ka.exception.PreProductionAccessException;
import com.bmw.gki.ka.util.ExtendedAttributesHandler;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.klib.api.exception.JarLoadException;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.api.exception.KSDVersionException;
import com.bmw.gki.klib.config.GKICache;
import com.bmw.gki.klib.config.GKICacheObject;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.external.BatteryStateRetrieverIF;
import com.bmw.gki.klib.external.KSDDataRetrieverIF;
import com.bmw.gki.klib.external.cache.BOSAWNummerReader;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.BOSVerknuepfungReader;
import com.bmw.gki.klib.external.cache.BOSVorziehwertReader;
import com.bmw.gki.klib.external.cache.CCMessageReader;
import com.bmw.gki.klib.external.cache.ExtendedAttributeTranslator;
import com.bmw.gki.klib.external.cache.FgnrPraefixReader;
import com.bmw.gki.klib.external.cache.ILevelReader;
import com.bmw.gki.klib.external.cache.KSDConfiguration;
import com.bmw.gki.klib.external.cache.LeadTypeReader;
import com.bmw.gki.klib.external.cache.MModelReader;
import com.bmw.gki.klib.external.cache.NaviDVDReader;
import com.bmw.gki.klib.external.cache.PreProductionConfiguration;
import com.bmw.gki.klib.external.cache.RegionReader;
import com.bmw.gki.klib.external.cache.SSIInformationReader;
import com.bmw.gki.klib.external.cache.SchluesselFilterReader;
import com.bmw.gki.klib.external.cache.SchluesselVarianteReader;
import com.bmw.gki.klib.external.cache.ServicePaketKSD;
import com.bmw.gki.klib.util.Translator;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;

public class KSDCache {
    private static final int TIME_LENGTH = 10;
    private String ksdVersion = null;
    private String ksdTimeValue = null;
    private boolean isKsdVersionValid = false;
    private boolean checkKSDVersion = true;
    private GKISettings GKIsettings = null;
    private static Log log = GKILogManager.getInstance().getLogger(KSDCache.class);
    private Class<?> keyAnalyserClass;
    private KSDDataRetrieverIF serviceKSD;
    private BatteryStateRetrieverIF batteryStateRetriever;
    private static KSDCache instance = null;
    private KSDConfiguration ksdproperties = KSDConfiguration.getInstance();
    private PreProductionConfiguration preProductionProperties = PreProductionConfiguration.getInstance();
    private boolean availableKSD = false;
    private boolean isPreProduction = false;
    private boolean withJarUpdate = false;

    private void loadVersionIni(String path, String alternativPath) throws KSDPropertyFormatException {
        String message;
        if (!new File(path).exists()) {
            if (!new File(alternativPath).exists()) {
                String message2 = "KSDCache - file version.ini" + path + "and ksd2.ini " + alternativPath + " not found ";
                KSDPropertyFormatException fe = new KSDPropertyFormatException(message2);
                log.info((Object)("exception code: " + fe.getErrorCode() + " message: " + message2));
                throw fe;
            }
            path = alternativPath;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            Properties props = new Properties();
            props.load(in);
            this.ksdTimeValue = props.getProperty("Key");
            this.ksdVersion = props.getProperty("Ausgabedatum");
        }
        catch (IOException e) {
            String message3 = "KSDCache - KSD version.ini file - IOException: " + path;
            KSDPropertyFormatException fe = new KSDPropertyFormatException(message3);
            log.info((Object)("exception code: " + fe.getErrorCode() + " message: " + message3));
            throw fe;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
        if (this.ksdTimeValue == null) {
            message = "KSDCache - Version key in version.ini file not found: " + path;
            KSDPropertyFormatException fe = new KSDPropertyFormatException(message);
            log.info((Object)("exception code: " + fe.getErrorCode() + " message: " + message));
            throw fe;
        }
        if (this.ksdTimeValue.length() < 10) {
            message = "KSDCache - Version key 'time' to short: " + path;
            KSDPropertyFormatException fe = new KSDPropertyFormatException(message);
            log.info((Object)("exception code: " + fe.getErrorCode() + " message: " + message));
            throw fe;
        }
        String timeValStr = this.ksdTimeValue.substring(0, 10);
        if (!Pattern.matches("\\d*", timeValStr)) {
            String message4 = "KSDCache - Version key not a number: " + path;
            KSDPropertyFormatException fe = new KSDPropertyFormatException(message4);
            log.info((Object)("exception code: " + fe.getErrorCode() + " message: " + message4));
            throw fe;
        }
    }

    private static void printClassLocation(Class<?> clazz) {
        try {
            CodeSource codeSource;
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                URL location = codeSource.getLocation();
                System.out.println("********************************************************************************************\nlocation of " + clazz + " -> " + location + "\n********************************************************************************************");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected KSDCache() {
        KSDCache.printClassLocation(KSDCache.class);
    }

    public String getKSDVersion() {
        return this.ksdVersion;
    }

    public Class<?> getKeyAnalyserClass() {
        return this.keyAnalyserClass;
    }

    public void setKSD(String path, boolean withJarUpdate, GKISettings settings, boolean checkKSDVersion) throws KSDVersionException, JarLoadException, KSDAccessException {
        this.GKIsettings = settings;
        this.ksdproperties.setKSDPath(path);
        this.checkPathValid(path);
        this.availableKSD = true;
        this.loadVersionIni(path + KSDConfiguration.getInstance().getVersionIni(), path + KSDConfiguration.getInstance().getKsd2Ini());
        GKICache ksdCacheConfig = this.ksdproperties.getCacheConfig();
        ksdCacheConfig.addValueToCacheObject("CACHE_BOSVALUECACHE", this.getKSDVersionKey());
        this.initializeKSD(path);
        this.setCheckKSDVersion(checkKSDVersion);
        if (withJarUpdate) {
            this.updateKeyAnalyser(path + "/SAM/Lib/" + this.ksdproperties.getKeyAnalyserJar());
            this.updateServiceKSD(new String[]{path + "/SAM/Lib/" + this.ksdproperties.getServiceKSDJar(), path + "/SAM/Lib/" + this.ksdproperties.getKsdAdapterJar()}, settings);
            this.updateBatteryStateRetriever(new String[]{path + "/SAM/Lib/" + this.ksdproperties.getBatteryStateRetrieverJar()});
        }
        if (checkKSDVersion && !this.isKSDVersionValid(path)) {
            log.info((Object)("KSD version probably outdated. KSD path: " + path));
        }
    }

    public void prepareKSD(String path, boolean withJarUpdate, GKISettings settings, boolean checkKSDVersion) throws JarLoadException, KSDAccessException {
        this.GKIsettings = settings;
        this.ksdproperties.setKSDPath(path);
        this.checkPathValid(path);
        this.availableKSD = true;
        this.withJarUpdate = withJarUpdate;
        this.loadVersionIni(path + KSDConfiguration.getInstance().getVersionIni(), path + KSDConfiguration.getInstance().getKsd2Ini());
    }

    public void initialize() throws JarLoadException, KSDAccessException {
        GKICache ksdCacheConfig = this.ksdproperties.getCacheConfig();
        ksdCacheConfig.addValueToCacheObject("CACHE_BOSVALUECACHE", this.getKSDVersionKey());
        String path = this.ksdproperties.getKSDPath();
        this.initializeKSD(path);
        this.setCheckKSDVersion(this.checkKSDVersion);
        if (this.withJarUpdate) {
            this.updateKeyAnalyser(path + "/SAM/Lib/" + this.ksdproperties.getKeyAnalyserJar());
            this.updateServiceKSD(new String[]{path + "/SAM/Lib/" + this.ksdproperties.getServiceKSDJar(), path + "/SAM/Lib/" + this.ksdproperties.getKsdAdapterJar()}, this.GKIsettings);
            this.updateBatteryStateRetriever(new String[]{path + "/SAM/Lib/" + this.ksdproperties.getBatteryStateRetrieverJar()});
        }
        if (this.checkKSDVersion && !this.isKSDVersionValid(path)) {
            log.info((Object)("KSD version probably outdated. KSD path: " + path));
        }
    }

    public void setCacheConfig(GKICacheObject cacheObject) {
        if (cacheObject != null) {
            this.ksdproperties.getCacheConfig().addCacheObject(cacheObject.getCacheObjectName(), cacheObject);
        }
    }

    public void setConfigPropertyOverride(String key, String value) {
        if (key != null && key == "ksdAdapterJar") {
            this.ksdproperties.setKsdAdapterJar(value);
        }
    }

    public String getKSDVersionKey() {
        return this.ksdTimeValue;
    }

    public boolean isCheckKSDVersion() {
        return this.checkKSDVersion;
    }

    public void setCheckKSDVersion(boolean checkKSDVersion) {
        this.checkKSDVersion = checkKSDVersion;
    }

    private void loadJarForPreProd() throws JarLoadException {
        log.info((Object)"Load pre production jars if exists");
        this.updateKeyAnalyser(this.ksdproperties.getKSDPath() + "/SAM/Lib/" + this.ksdproperties.getKeyAnalyserJar());
        this.updateServiceKSD(new String[]{this.preProductionProperties.getPreProductionPath(), this.preProductionProperties.getPreProductionPath() + "/" + this.ksdproperties.getKsdAdapterJar(), this.ksdproperties.getKSDPath() + "/SAM/Lib/" + this.ksdproperties.getServiceKSDJar(), this.ksdproperties.getKSDPath() + "/SAM/Lib/" + this.ksdproperties.getKsdAdapterJar()}, this.GKIsettings);
        this.updateBatteryStateRetriever(new String[]{this.preProductionProperties.getPreProductionPath(), this.ksdproperties.getKSDPath() + "/SAM/Lib/" + this.ksdproperties.getBatteryStateRetrieverJar()});
    }

    public void setPreProduction(String path) throws PreProductionAccessException {
        String message;
        this.initPreProd();
        this.isPreProduction = true;
        this.preProductionProperties.setPreProductionPath(path);
        try {
            this.loadJarForPreProd();
        }
        catch (JarLoadException e) {
            message = "Exception load jars for pre production returns errors";
            log.info((Object)message, (Throwable)e);
        }
        PreProdHolder.setIsPreProd(true);
        this.initializePreProduction(path);
        try {
            this.checkMakeArchiv(path);
        }
        catch (IOException e) {
            message = "Check reference directory and copy archive files returns error";
            log.info((Object)message);
            throw new PreProductionAccessException(message, e);
        }
        finally {
            this.releasePreProd();
        }
        if (!this.availableKSD) {
            String message2 = "KSD DVD not available, only 'pre-production' data loaded";
            throw new PreProductionAccessException(message2);
        }
    }

    private File getFile(String path, String fileName, int index) {
        return new File(path + this.preProductionProperties.getArchivDir(), "V_" + index + "_" + fileName);
    }

    private synchronized void checkMakeArchiv(String path) throws IOException {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"GKI check archiv and make archiv files....start");
        File[] children = Utilities.getFiles(path + this.preProductionProperties.getReferenceDir());
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                File archivFile = this.getFile(path, child.getName(), 0);
                if (archivFile.exists()) {
                    log.trace((Object)(" check file exists: " + archivFile.getName()));
                    log.debug((Object)("last modfied reference file:" + child.lastModified()));
                    log.debug((Object)("last modfied archiv file:" + archivFile.lastModified()));
                    if (child.lastModified() > archivFile.lastModified()) {
                        log.trace((Object)"refrence file last modified date > than archiv file");
                        this.makeVersion(path, child.getName(), archivFile, 0);
                        PreProdHolder.setHasMakeArchive(true);
                    }
                }
                log.trace((Object)(" copy file " + child.getName() + " to: " + archivFile));
                Utilities.copyFile(child, archivFile);
            }
        }
        log.debug((Object)"GKI check archiv and make archiv files....end");
        long endTime = System.currentTimeMillis();
        log.info((Object)("GKI check and build preProduction archive files: " + (endTime - startTime) + " ms"));
    }

    public synchronized void makeVersion(String path, String fileName, File file, int index) throws IOException {
        log.trace((Object)("path is: " + path + " fileName is: " + fileName + " idex is: " + index));
        File target = this.getFile(path, fileName, index + 1);
        if (target.exists()) {
            this.makeVersion(path, fileName, target, index + 1);
        }
        File srcFile = this.getFile(path, fileName, index);
        log.trace((Object)(" Rename file with name: " + srcFile.getName() + " to: " + target.getName()));
        srcFile.renameTo(target);
    }

    private void checkPathValid(String path) throws KSDAccessException {
        log.debug((Object)("Path is: " + path));
        if (path == null || !new File(path).exists()) {
            String message = "The path: " + path + " is not valid";
            throw new KSDAccessException(message);
        }
    }

    private void updateServiceKSD(String[] paths, GKISettings settings) throws JarLoadException {
        try {
            String className = this.ksdproperties.getServiceKSDClassName();
            Class<?> newServiceKSDClass = null;
            newServiceKSDClass = this.switchClassLoader(paths).loadClass(className);
            this.serviceKSD = (KSDDataRetrieverIF)newServiceKSDClass.newInstance();
            this.serviceKSD.setSettings(settings);
            this.serviceKSD.setKSDPath(this.ksdproperties.getKSDPath());
        }
        catch (ClassNotFoundException e) {
            throw new JarLoadException("ServiceKSD Class not found", e);
        }
        catch (InstantiationException e) {
            throw new JarLoadException("KSDCache.invalidUrl", e);
        }
        catch (IllegalAccessException e) {
            throw new JarLoadException("KSDCache.invalidUrl", e);
        }
    }

    private void updateBatteryStateRetriever(String[] paths) throws JarLoadException {
        try {
            try {
                String className = this.ksdproperties.getBatteryStateRetrieverClassName();
                Class<?> loadedClass = this.switchClassLoader(paths).loadClass(className);
                this.batteryStateRetriever = (BatteryStateRetrieverIF)loadedClass.newInstance();
                String path = this.ksdproperties.getKSDPath() + this.ksdproperties.getKeyReferencePath();
                this.batteryStateRetriever.initialize(path);
            }
            catch (ClassNotFoundException e) {
                throw new JarLoadException("Battery State Retriever Class not found", e);
            }
            catch (InstantiationException e) {
                throw new JarLoadException("KSDCache.invalidUrl", e);
            }
            catch (IllegalAccessException e) {
                throw new JarLoadException("KSDCache.invalidUrl", e);
            }
            catch (KSDPropertyFormatException e) {
                throw new JarLoadException("Problems initializing Battery State Retriever", e);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Exception initializing BatteryStateRetriever", (Throwable)e);
        }
    }

    public void updateKeyAnalyser(String path) throws JarLoadException {
        try {
            Class<?> newKeyAnalyzerClass = null;
            String className = this.ksdproperties.getKeyAnalyzerClassName();
            if (this.isPreProduction && this.preProductionProperties.getPreProductionPath() != null) {
                log.info((Object)"updateKeyAnalyser for pre production");
                newKeyAnalyzerClass = this.switchClassLoader(new String[]{this.preProductionProperties.getPreProductionPath() + "/reference", this.preProductionProperties.getPreProductionPath() + "/" + this.ksdproperties.getKeyAnalyserJar(), path}).loadClass(className);
                log.info((Object)"updateKeyAnalyser for pre production done");
            } else {
                String[] pathes = path.split(";");
                newKeyAnalyzerClass = this.switchClassLoader(pathes).loadClass(className);
            }
            this.keyAnalyserClass = newKeyAnalyzerClass;
        }
        catch (ClassNotFoundException e) {
            throw new JarLoadException("Key Analyser Class not found", e);
        }
    }

    private ClassLoader switchClassLoader(String[] paths) throws JarLoadException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < paths.length; ++i) {
                log.debug((Object)("path " + paths[i]));
                File file = new File(paths[i]);
                if (!file.exists() && i == paths.length - 1) {
                    throw new JarLoadException("KSD Cache invalid path " + file, new String[]{paths[i]});
                }
                urls.add(file.toURI().toURL());
            }
            return new SwitchClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new JarLoadException("Invalid classpath url", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KSDCache getInstance() {
        if (instance != null) return instance;
        Class<KSDCache> clazz = KSDCache.class;
        synchronized (KSDCache.class) {
            if (instance != null) return instance;
            log.debug((Object)"****Get new instance from KSD Cache ********");
            instance = new KSDCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean isKSDVersionValid(String path) throws KSDPropertyFormatException {
        Date today = new Date(System.currentTimeMillis());
        log.debug((Object)("today:" + today + ",millis:" + today.getTime()));
        Date expireDate = new Date(Long.parseLong(this.ksdTimeValue) * 1000L);
        log.debug((Object)("expires at:" + expireDate + ",millis:" + expireDate.getTime()));
        this.isKsdVersionValid = new Date().before(expireDate);
        return this.isKsdVersionValid;
    }

    public void initializeKSD(String path) throws KSDAccessException {
        log.info((Object)"------------------------------------------------------------------");
        log.info((Object)("initializeKSD('" + path + "')"));
        log.info((Object)"------------------------------------------------------------------");
        RegionReader.readInTable(path + this.ksdproperties.getRegionVariantPath());
        String vehiclePrefixFilePath = null;
        try {
            vehiclePrefixFilePath = path + this.ksdproperties.getVehicleNumberPrefixPath();
            FgnrPraefixReader.einlesenTabelle(vehiclePrefixFilePath);
            vehiclePrefixFilePath = path + this.ksdproperties.getVehicleNumberPrefixPathGKI();
            FgnrPraefixReader.einlesenTabelle(vehiclePrefixFilePath);
            vehiclePrefixFilePath = path + this.ksdproperties.getVehicleNumberPrefixPathWithProductTypeGKI();
            FgnrPraefixReader.einlesenTabelle(vehiclePrefixFilePath);
        }
        catch (Exception e) {
            log.info((Object)("KSD/GKI Refrence Data: FgnrPraefixReader ERROR - file: " + vehiclePrefixFilePath + "\n"), (Throwable)e);
        }
        try {
            BOSNummerReader.einlesenTabelle(path + this.ksdproperties.getKeyReferencePath(), KSDConfiguration.getSupportedLocales());
            BOSAWNummerReader.einlesenTabelle(path + this.ksdproperties.getKeyReferencePath());
            BOSVerknuepfungReader.einlesenTabelle(path + this.ksdproperties.getKeyReferencePath(), RegionReader.getRegions(), this.ksdproperties.getCacheConfig());
            BOSVorziehwertReader.einlesenTabelle(path + this.ksdproperties.getKeyReferencePath(), RegionReader.getRegions());
            SchluesselVarianteReader.einlesenTabelle(path + this.ksdproperties.getKeyVariantPath());
            SchluesselFilterReader.einlesenTabelle(path + this.ksdproperties.getKeyFormatPath(), path + this.ksdproperties.getKeyFilterPath());
            ServicePaketKSD.einlesenTabelle(path + this.ksdproperties.getSIConnectionsPath(), path);
            ILevelReader.getInstance().readInTable(path + this.ksdproperties.getKeyReferencePath(), true);
            NaviDVDReader.getInstance().readInTable(path + this.ksdproperties.getKeyReferencePath());
            Messages.getInstance().readInExceptionMessagesFromKSD(path + this.ksdproperties.getGKIKeyReferencePath(), KSDConfiguration.getSupportedLocales());
            Translator.loadMessagesFromKSD(path + this.ksdproperties.getGKIKeyReferencePath(), KSDConfiguration.getSupportedLocales());
            log.info((Object)("Set Extended AttributesPath:" + this.ksdproperties.getGKIKeyReferencePath()));
            ExtendedAttributesHandler.setKsdPath(path + this.ksdproperties.getGKIKeyReferencePath());
            ExtendedAttributeTranslator.setKsdPath(path + this.ksdproperties.getGKIKeyReferencePath());
        }
        catch (KSDAccessException e) {
            log.info((Object)"------------------------------------------------------------------");
            log.info((Object)("ERROR: initializeKSD('" + path + "')"), (Throwable)e);
            log.info((Object)"------------------------------------------------------------------");
            throw e;
        }
        try {
            SSIInformationReader.einlesenTabelle(path + this.ksdproperties.getGKIKeyReferencePath());
        }
        catch (Exception e) {
            log.info((Object)"SSIInformationReader: returns errors\n", (Throwable)e);
        }
        try {
            MModelReader.readInProperties(path + this.ksdproperties.getGKIKeyReferencePath());
        }
        catch (Exception e) {
            log.info((Object)"MModelReader: returns errors\n", (Throwable)e);
        }
    }

    public void initializePreProduction(String path) {
        try {
            log.info((Object)"------------------------------------------------------------------");
            log.info((Object)("initializePreProduction('" + path + "')"));
            log.info((Object)"------------------------------------------------------------------");
            File dir = new File(path);
            new File(dir, this.preProductionProperties.getArchivDir()).mkdirs();
            new File(dir, this.preProductionProperties.getErrorDir()).mkdirs();
            new File(dir, this.preProductionProperties.getReferenceDir()).mkdirs();
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: can not create preProdDir 'archive', 'error', 'reference'");
        }
        try {
            RegionReader.readInTable(path + this.preProductionProperties.getRegionVariantPath());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: RegionReader returns errors\n", (Throwable)e);
        }
        try {
            FgnrPraefixReader.einlesenTabelle(path + this.preProductionProperties.getVehicleNumberPrefixPath());
            FgnrPraefixReader.einlesenTabelle(path + this.ksdproperties.getVehicleNumberPrefixPathWithProductTypeGKI());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: FgnrPraefixReader returns errors\n", (Throwable)e);
        }
        try {
            BOSNummerReader.einlesenTabelle(path + this.preProductionProperties.getReferenceDir(), KSDConfiguration.getSupportedLocales());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: BOSNummerReader returns errors\n", (Throwable)e);
        }
        try {
            BOSAWNummerReader.einlesenTabelle(path + this.preProductionProperties.getReferenceDir());
            BOSVerknuepfungReader.einlesenTabelle(path + this.preProductionProperties.getReferenceDir(), RegionReader.getRegions(), null);
            BOSVorziehwertReader.einlesenTabelle(path + this.preProductionProperties.getReferenceDir(), RegionReader.getRegions());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: BOSAWNummerReader,BOSVerknuepfungReader,BOSVorziehwertReader return errors\n", (Throwable)e);
        }
        try {
            SchluesselVarianteReader.einlesenTabelle(path + this.preProductionProperties.getKeyVariantPath());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: SchluesselVarianteReader returns errors\n", (Throwable)e);
        }
        try {
            ILevelReader.getInstance().readInTable(path + this.preProductionProperties.getReferenceDir(), false);
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: ILevelReader returns errors\n", (Throwable)e);
        }
        try {
            LeadTypeReader.readInTable(path + this.preProductionProperties.getLeadTypePath());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: LeadTypeReader returns errors\n", (Throwable)e);
        }
        try {
            CCMessageReader.readInTable(path + this.preProductionProperties.getCCMessagePath());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: CCMessageReader returns errors\n", (Throwable)e);
        }
        try {
            ExtendedAttributesHandler.setPreProductionPath(path + this.preProductionProperties.getReferenceDir());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: ExtendedAttributesHandler returns errors\n", (Throwable)e);
        }
        try {
            ExtendedAttributeTranslator.setPreProductionPath(path + this.preProductionProperties.getReferenceDir());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: ExtendedAttributeTranslator returns errors\n", (Throwable)e);
        }
        try {
            MModelReader.readInProperties(path + this.preProductionProperties.getReferenceDir());
        }
        catch (Exception e) {
            log.info((Object)"PRE PRODUCTION: MModelReader returns errors\n", (Throwable)e);
        }
    }

    public boolean isAvailableKSD() {
        return this.availableKSD;
    }

    public boolean isKSDVersionValid() {
        return this.isKsdVersionValid;
    }

    public boolean isPreProduction() {
        return this.isPreProduction;
    }

    public String getPreProductionErrorPath() {
        return this.preProductionProperties.getPreProductionPath() + this.preProductionProperties.getErrorDir();
    }

    public KSDDataRetrieverIF getServiceKSD() {
        return this.serviceKSD;
    }

    public BatteryStateRetrieverIF getBatteryStateRetriever() {
        return this.batteryStateRetriever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        log.info((Object)"Call reset KSD Cache...");
        if (instance != null) {
            KSDCache kSDCache = instance;
            synchronized (kSDCache) {
                KSDConfiguration.getInstance().reset();
                PreProductionConfiguration.getInstance().reset();
                KSDCache.resetAllReaders();
                PreProdHolder.reset();
                instance = null;
                log.info((Object)"reset KSD Cache done, instance was not null... ");
                return;
            }
        }
        log.info((Object)"reset KSD Cache, instance was null... ");
    }

    public void setKSDDataSource(DataSource ds) {
        this.serviceKSD.setKSDDataSource(ds);
    }

    private void releasePreProd() {
        List<PreProdLogEntry> entries;
        log.trace((Object)"****release Pre Prod KSD Cache");
        if (KSDCache.getInstance().isPreProduction() && (entries = PreProdHolder.getLogEntries()) != null && entries.size() > 0) {
            try {
                if (PreProdHolder.getHasMakeArchiv()) {
                    Utilities.writeLogFile(null, PreProdHolder.getAllFormattedLogEntries(), KSDCache.getInstance().getPreProductionErrorPath());
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't release pre prod values", (Throwable)e);
            }
        }
    }

    private void initPreProd() {
        PreProdHolder.reset();
    }

    private static void resetAllReaders() {
        BOSAWNummerReader.reset();
        BOSNummerReader.reset();
        BOSVerknuepfungReader.reset();
        BOSVorziehwertReader.reset();
        FgnrPraefixReader.reset();
        ILevelReader.reset();
        LeadTypeReader.reset();
        NaviDVDReader.reset();
        RegionReader.reset();
        SchluesselFilterReader.reset();
        SchluesselVarianteReader.reset();
        ServicePaketKSD.reset();
        CCMessageReader.reset();
        Messages.reset();
        Translator.reset();
        ExtendedAttributesHandler.reset();
        ExtendedAttributeTranslator.reset();
        SSIInformationReader.reset();
        MModelReader.reset();
    }

    public static class SwitchClassLoader
    extends URLClassLoader {
        private static Log log = GKILogManager.getInstance().getLogger(SwitchClassLoader.class);
        public static boolean loadClassFromURLS = false;

        public SwitchClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (loadClassFromURLS) {
                try {
                    clazz = this.findLoadedClass(name);
                    if (clazz == null) {
                        clazz = this.findClass(name);
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = super.loadClass(name);
            }
            if (clazz != null && log.isDebugEnabled()) {
                try {
                    CodeSource codeSource;
                    ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                    if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                        URL location = codeSource.getLocation();
                        log.debug((Object)("load class '" + name + "': '" + location + "'"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return clazz;
        }

        @Override
        public URL getResource(String name) {
            URL url = null;
            try {
                url = this.findResource(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (url == null) {
                url = super.getResource(name);
            }
            if (url != null && log.isDebugEnabled()) {
                log.debug((Object)("load resource '" + url + "'"));
            }
            return url;
        }
    }
}

