/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.exception.PreProductionAccessException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.data.ksd.FgnrKreisInfo;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class LeadTypeReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(LeadTypeReader.class);
    private static Properties leadtypes = new Properties();
    private static final String DEFAULT = "leadtype.properties";
    private static final String TYP_SCHLUESSEL = "typschluessel";
    private static final String LEAD_TYPE = "leadtype";
    private static final String MODEL_DESIG = "modeldesignation";
    private static final String EBAUREIHE = "ebaureihe";
    private static final String BAUSTAND = "baustand";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readInTable(String path) throws KSDPropertyFormatException {
        block15: {
            InputStream in = null;
            try {
                if (path != null && path.length() > 0) {
                    in = new FileInputStream(path);
                    leadtypes.load(in);
                    break block15;
                }
                if (PreProdHolder.getIsPreProd()) {
                    String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_FOUND", new Object[]{"" + path});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_FOUND", message));
                    break block15;
                }
                String message = "LeadType Reader path not set: " + path;
                KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                log.info((Object)message);
                throw pex;
            }
            catch (Exception e) {
                if (PreProdHolder.getIsPreProd()) {
                    String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_FOUND", new Object[]{"" + path});
                    PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_FOUND", message));
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static FgnrKreisInfo getFgnrKreisInfo(String vin) throws PreProductionAccessException {
        log.trace((Object)("get preproduction fgnrInfo for vin: " + vin));
        FgnrKreisInfo fzgInfo = null;
        if (vin == null || vin.length() < 17) {
            String message = "PreProduction: leadtype.properties contains invalid vin (<17)";
            throw new PreProductionAccessException(message);
        }
        String typSchluessel = vin.substring(3, 7);
        log.trace((Object)("Typschluessel is: " + typSchluessel));
        if (leadtypes != null) {
            fzgInfo = new FgnrKreisInfo();
            if (LeadTypeReader.removeWhitspace(leadtypes.getProperty(typSchluessel + "." + TYP_SCHLUESSEL)) == null) {
                String message = "PreProduction: leadtype.properties contains no typ";
                throw new PreProductionAccessException(message);
            }
            fzgInfo.setTypschluessel(LeadTypeReader.removeWhitspace(leadtypes.getProperty(typSchluessel + "." + TYP_SCHLUESSEL)));
            fzgInfo.setLeittyp(LeadTypeReader.removeWhitspace(leadtypes.getProperty(typSchluessel + "." + LEAD_TYPE)));
            fzgInfo.setModelBezeichnung(LeadTypeReader.removeWhitspace(leadtypes.getProperty(typSchluessel + "." + MODEL_DESIG)));
            fzgInfo.setEngineeringSeries(LeadTypeReader.removeWhitspace(leadtypes.getProperty(typSchluessel + "." + EBAUREIHE)));
            try {
                String baustandStr = leadtypes.getProperty(typSchluessel + "." + BAUSTAND);
                if (baustandStr == null) {
                    log.info((Object)"Set Default value ");
                    baustandStr = "200709";
                }
                int baustand = Integer.parseInt(LeadTypeReader.removeWhitspace(baustandStr));
                fzgInfo.setBaustand(baustand);
            }
            catch (NumberFormatException e) {
                String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_VALID", new Object[]{DEFAULT, "BAUSTAND"});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_VALID", message));
                throw new PreProductionAccessException("logic.LeittypBaustandException");
            }
            fzgInfo.setLeittypEingabeArt(0);
            fzgInfo.setTypschluesselEingabeArt(0);
            if (fzgInfo.getTypschluessel() == null || fzgInfo.getLeittyp() == null && fzgInfo.getModelBezeichnung() == null || fzgInfo.getEngineeringSeries() == null) {
                String message = PreProdLogMessages.getParameterString("CODE_FILE_NOT_VALID", new Object[]{DEFAULT, "EMPTY VALUES"});
                PreProdHolder.addLogEntry(new PreProdLogEntry("INFO", "CODE_FILE_NOT_VALID", message));
                throw new PreProductionAccessException("logic.LeittypBaustandException");
            }
        }
        return fzgInfo;
    }

    private static String removeWhitspace(String string) {
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public static void reset() {
        leadtypes = new Properties();
    }
}

