/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.logging.GKILogManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;

public class ObjectCache {
    private static Log log = GKILogManager.getInstance().getLogger(ObjectCache.class);

    private ObjectCache() {
    }

    public static boolean checkCacheExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean cleanCache(String filePath) {
        File file = new File(filePath);
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCache(String filePath, Object objectToWrite) {
        if (objectToWrite != null) {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(filePath);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(objectToWrite);
                objectOutputStream.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Object readCache(String filePath) throws KSDAccessException {
        Object obj = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream, 8000));
            obj = objectInputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new KSDAccessException("Class not found", e);
        }
        catch (FileNotFoundException e) {
            throw new KSDAccessException("File not found", e);
        }
        catch (IOException e) {
            throw new KSDAccessException("IO problems", e);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hashFile(String filePath) {
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        String sha256hex = null;
        try {
            File file = new File(filePath);
            fileInputStream = new FileInputStream(filePath);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 8000);
            byte[] array = new byte[(int)file.length()];
            bufferedInputStream.read(array, 0, array.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return sha256hex;
    }
}

