/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.external.cache;

import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDPropertyFormatException;
import com.bmw.gki.klib.external.cache.KSDReaderIF;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

public class RegionReader
implements KSDReaderIF {
    private static Log log = GKILogManager.getInstance().getLogger(RegionReader.class);
    private static Properties regionmapping = new Properties();
    private static final String DEFAULT = "ECE";
    private static String[] regions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readInTable(String path) throws KSDPropertyFormatException, KSDAccessException {
        if (path == null || path.length() == 0) {
            String message = "RegionReader Reader path not set: " + path;
            KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
            log.info((Object)message);
            throw pex;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            regionmapping.load(in);
            regions = RegionReader.createRegionList();
        }
        catch (FileNotFoundException fnf) {
            if (!PreProdHolder.getIsPreProd()) {
                String message = "Region Reader file not found found: " + path;
                KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                log.info((Object)message);
                throw pex;
            }
        }
        catch (IOException ioe) {
            if (!PreProdHolder.getIsPreProd()) {
                String message = "Region Reader IOException: " + path;
                KSDPropertyFormatException pex = new KSDPropertyFormatException(message);
                log.info((Object)message);
                throw pex;
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static String[] createRegionList() {
        Iterator<Map.Entry<Object, Object>> elemCollection = regionmapping.entrySet().iterator();
        TreeMap map = new TreeMap();
        while (elemCollection.hasNext()) {
            Map.Entry<Object, Object> elem = elemCollection.next();
            map.put(elem.getValue(), null);
        }
        return map.keySet().toArray(new String[0]);
    }

    public static String[] getRegions() {
        return regions;
    }

    public static String find(Locale locale) {
        return regionmapping.getProperty(locale.getCountry(), DEFAULT);
    }

    public static void reset() {
        regionmapping = new Properties();
        regions = new String[0];
    }
}

