/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.logic;

import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.exception.GKIExceptionIF;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.ka.util.PreProdLogMessages;
import com.bmw.gki.klib.api.AuftragsbasisGrunddatenIF;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api.Schluesseldaten;
import com.bmw.gki.klib.api.exception.BosNotFoundException;
import com.bmw.gki.klib.api.exception.CBSDataCorrectionFlagException;
import com.bmw.gki.klib.api.exception.GKIWarning;
import com.bmw.gki.klib.api.exception.HydrogenWarning;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.klib.api.exception.KSDVersionException;
import com.bmw.gki.klib.api.exception.KeineArbeitswerteException;
import com.bmw.gki.klib.api.exception.KeyDataLengthException;
import com.bmw.gki.klib.api.exception.LocaleHolder;
import com.bmw.gki.klib.api.exception.NotFoundException;
import com.bmw.gki.klib.api.exception.PredeliveryException;
import com.bmw.gki.klib.api.exception.ServiceCounterZeroConnectedWarning;
import com.bmw.gki.klib.api.exception.ServiceCounterZeroWarning;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api.exception.ToManyActiveBasicSIPackagesException;
import com.bmw.gki.klib.api_V00_01_00.TypeError;
import com.bmw.gki.klib.api_current.ExtendedAttributeBaseType;
import com.bmw.gki.klib.api_current.KeyBaseType;
import com.bmw.gki.klib.api_current.KeyDataAnalysedType;
import com.bmw.gki.klib.api_current.KeyDataBinType;
import com.bmw.gki.klib.config.EngineOilProperties;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apiparams.KeyDataAnalysed;
import com.bmw.gki.klib.data.apiparams.OrderbaseUpdateData;
import com.bmw.gki.klib.data.apitransformation.TypeErrorAdapter;
import com.bmw.gki.klib.data.ksd.ExtAttribute;
import com.bmw.gki.klib.data.ksd.FgnrKreisInfo;
import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.data.ksd.cbs.BOSAWNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cc.CCMessage;
import com.bmw.gki.klib.data.ksd.cc.CheckControlRetrievalException;
import com.bmw.gki.klib.data.ksd.engineoil.EngineOil;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelData;
import com.bmw.gki.klib.data.ksd.navi.NaviDVDData;
import com.bmw.gki.klib.data.ksd.navi.NaviPartData;
import com.bmw.gki.klib.data.orderbase.AuftragsbasisGrunddaten;
import com.bmw.gki.klib.data.orderbase.BOSAWPosition;
import com.bmw.gki.klib.data.orderbase.ExtendedKeyData;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenCBS2;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenCBS4;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE60;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenE65;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenF01;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenVariante72;
import com.bmw.gki.klib.data.orderbase.SchluesseldatenVorE65;
import com.bmw.gki.klib.external.BatteryStateRetrieverIF;
import com.bmw.gki.klib.external.KSDDataRetrieverFactory;
import com.bmw.gki.klib.external.KSDDataRetrieverIF;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.klib.external.cache.NaviDVDReader;
import com.bmw.gki.klib.logic.BOSVerarbeitungsLogik;
import com.bmw.gki.klib.util.StatusMeasureReader;
import com.bmw.gki.klib.util.Utilities;
import com.bmw.gki.logging.GKILogManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

public class GKILogic {
    private static Log log = GKILogManager.getInstance().getLogger(GKILogic.class);
    private boolean useSI = true;
    private List<BSIServicePaket> siData;
    private List<TypeErrorAdapter> warnings;
    private GKISettings settings;
    private KeyDataBinType keyDataBin;
    private String saOptionCode = null;
    private String ssiCountry = null;
    private boolean isSSInterpretation = false;

    public AuftragsbasisGrunddatenIF createOrderbase(KeyDataAnalysedType analysedKey, GKISettings settings) throws GKIException {
        this.settings = settings;
        String vin = analysedKey.getVehicle().getVin();
        KSDDataRetrieverIF retriever = this.getKSDDataRetriever(settings);
        if (retriever == null) {
            throw new KSDAccessException("KSD not set");
        }
        try {
            log.debug((Object)("GKILogic: requested VIN: " + vin));
            FgnrKreisInfo fgnrInfo = retriever.retrieveLeadtypeBuilddate(vin);
            return this.createOrderbase(analysedKey, vin, fgnrInfo);
        }
        catch (NotFoundException e) {
            log.fatal((Object)"Not found exception from ksd", (Throwable)e);
            throw new GKIException(e.getFormatedMessage());
        }
        catch (NullPointerException npe) {
            if (analysedKey instanceof KeyDataAnalysed && ((KeyDataAnalysed)analysedKey).getAnalysedField().isKeyTruncated()) {
                throw new KeyDataLengthException();
            }
            throw new SystemException(npe.getMessage(), npe);
        }
        catch (GKIException e) {
            log.debug((Object)("GKILogic.createOrderbase:" + e.getClass().getName() + ":"), (Throwable)e);
            throw e;
        }
    }

    public void updateOrderbase(OrderbaseUpdateData data, Locale locale) throws GKIException {
        this.settings = new GKISettings(locale, false);
        BOSVerarbeitungsLogik bosLogic = new BOSVerarbeitungsLogik();
        bosLogic.aktualisierenCBSWerte(this.settings.getRegionCode(), data, locale, this.warnings);
    }

    private AuftragsbasisGrunddatenIF createOrderbase(KeyDataAnalysedType keydata, String vin, FgnrKreisInfo fgnrInfo) throws GKIException {
        GKIException e;
        Schluesseldaten schluesseldaten = this.createKey(keydata, fgnrInfo);
        this.checkStatusMeasureFlag(keydata);
        AuftragsbasisGrunddaten auftragsbasisGrunddaten = new AuftragsbasisGrunddaten(schluesseldaten, fgnrInfo);
        if (KSDCache.getInstance().isCheckKSDVersion() && !KSDCache.getInstance().isKSDVersionValid()) {
            e = new KSDVersionException("KSD Version not valid", new String[]{KSDCache.getInstance().getKSDVersion()});
            GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
        }
        if (fgnrInfo != null && Utilities.isNullOrEmptyString(fgnrInfo.getEngineeringSeries()) && Utilities.isNullOrEmptyString(fgnrInfo.getModelBezeichnung())) {
            e = new PredeliveryException("Model designation and engeeniering series from KSD is not set");
            GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
        }
        try {
            if (schluesseldaten.isE65upward() && schluesseldaten instanceof SchluesseldatenE65) {
                this.retrieveCCMessages(auftragsbasisGrunddaten, (SchluesseldatenE65)schluesseldaten);
            }
        }
        catch (GKIWarning e2) {
            GKILogic.addToWarningsListOnlyOnce(e2, this.warnings);
        }
        if (!auftragsbasisGrunddaten.isUebergabedurchsicht() && this.useSI) {
            try {
                this.checkSI(auftragsbasisGrunddaten);
            }
            catch (ToManyActiveBasicSIPackagesException e3) {
                GKILogic.addToWarningsListOnlyOnce(e3, this.warnings);
            }
            catch (BSIDatensatzfehlerhaftException e4) {
                GKILogic.addToWarningsListOnlyOnce(e4, this.warnings);
            }
        }
        if (schluesseldaten.isE65upward()) {
            try {
                this.prepareOrderbaseData(auftragsbasisGrunddaten);
            }
            catch (GKIWarning e5) {
                GKILogic.addToWarningsListOnlyOnce(e5, this.warnings);
            }
            catch (GKIException e6) {
                log.fatal((Object)e6.getFormatedMessage(), (Throwable)e6);
                throw e6;
            }
            if (schluesseldaten.isLargeKey()) {
                this.retrieveExtendedKeyData(auftragsbasisGrunddaten, fgnrInfo);
            }
        }
        try {
            this.retrieveExtendedAttributes(auftragsbasisGrunddaten, fgnrInfo);
        }
        catch (GKIWarning e7) {
            GKILogic.addToWarningsListOnlyOnce(e7, this.warnings);
        }
        return auftragsbasisGrunddaten;
    }

    private void checkStatusMeasureFlag(KeyDataAnalysedType keydata) {
        KeyDataAnalysedType.CbsBaseData cbsBaseData = keydata.getCbsBaseData();
        if (cbsBaseData != null) {
            List<KeyDataAnalysedType.CbsBaseData.ConditionBasedService> cbs = cbsBaseData.getConditionBasedService();
            for (KeyDataAnalysedType.CbsBaseData.ConditionBasedService conditionBasedService : cbs) {
                Integer statusMeasureFlag;
                if (conditionBasedService == null || (statusMeasureFlag = conditionBasedService.getStatusMeasure()) == null || !StatusMeasureReader.getInstance().hasFlag("statusReplacementValue", statusMeasureFlag)) continue;
                String cbsName = "" + conditionBasedService.getCbsId();
                try {
                    BOSNummer bosNummer = BOSNummerReader.find((int)conditionBasedService.getCbsId().longValue());
                    cbsName = bosNummer.getBezeichnung(LocaleHolder.getLocale());
                }
                catch (GKIException e) {
                    log.warn((Object)("could not find BOSNummer for " + conditionBasedService.getCbsId()), (Throwable)e);
                }
                String message = "The CBS item " + cbsName + " with the warning symbol contains a substitution value due to a malfunction";
                CBSDataCorrectionFlagException correctionDataException = new CBSDataCorrectionFlagException(message, new String[]{cbsName});
                GKILogic.addToWarningsListOnlyOnce(correctionDataException, this.warnings);
            }
        }
    }

    private void expandExtAttributes(Locale locale, String name, String value, List<ExtAttribute> newExtendedAttributes, KSDDataRetrieverIF ksdRetriever) {
        try {
            ExtAttribute extAttr = ksdRetriever.retrieveExtendedAttribute(locale, name, value);
            if (extAttr != null) {
                if (extAttr.getName() == null) {
                    extAttr.setName(name);
                }
                if (extAttr.getValue() == null) {
                    extAttr.setValue(value);
                }
                newExtendedAttributes.add(extAttr);
            }
        }
        catch (AbstractMethodError ame) {
            log.warn((Object)"Try to read extended attributes from old ka_impl.jar");
        }
        catch (GKIException e) {
            GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
        }
    }

    private void retrieveExtendedAttributes(AuftragsbasisGrunddatenIF auftragsbasis, FgnrKreisInfo fgnrInfo) throws GKIWarning, GKIException {
        List<ExtendedAttributeBaseType> extendedAttributeList;
        Schluesseldaten schluesseldaten = auftragsbasis.getSchluesseldaten();
        KeyDataAnalysedType keyData = schluesseldaten.getData();
        KeyDataAnalysedType.ExtendedAttributes extendedAttributes = keyData.getExtendedAttributes();
        if (extendedAttributes != null && (extendedAttributeList = extendedAttributes.getExtendedAttribute()) != null && !extendedAttributeList.isEmpty()) {
            KSDDataRetrieverIF ksdRetriever = this.getKSDDataRetriever(this.settings);
            Locale locale = this.settings.getLocale();
            ArrayList<ExtAttribute> newExtendedAttributes = new ArrayList<ExtAttribute>();
            for (ExtendedAttributeBaseType extendedAttribute : extendedAttributeList) {
                String name = extendedAttribute.getName();
                String value = extendedAttribute.getValue();
                log.debug((Object)("Extended Attribute name: " + name + ", value: " + value));
                this.expandExtAttributes(locale, name, value, newExtendedAttributes, ksdRetriever);
            }
            String saOptionCodeValue = this.getSAOptionCode();
            if (saOptionCodeValue != null) {
                String saOptionCodeName = "badFuelEquipmentCode";
                this.expandExtAttributes(locale, "badFuelEquipmentCode", saOptionCodeValue, newExtendedAttributes, ksdRetriever);
            }
            if (this.ssiCountry != null) {
                this.expandExtAttributes(locale, "usedShortenedServiceInterval", this.isSSInterpretation ? "1" : "0", newExtendedAttributes, ksdRetriever);
            }
            schluesseldaten.setExtAttributes(newExtendedAttributes);
            this.retrieveBatteryData(auftragsbasis, fgnrInfo, ksdRetriever);
        }
    }

    private void retrieveCCMessages(AuftragsbasisGrunddatenIF auftragsbasis, SchluesseldatenE65 schluesseldaten) throws GKIWarning {
        KSDDataRetrieverIF ksdRetriever = this.getKSDDataRetriever(this.settings);
        TreeSet<String> ccIds = new TreeSet<String>();
        List<CCMessage> ccObjects = schluesseldaten.getCheckControlIds();
        for (CCMessage element : ccObjects) {
            ccIds.add(element.getId());
        }
        Map<?, ?> map = ksdRetriever.retrieveCheckControlMessages(auftragsbasis.getFgnrKreisInfo().getEngineeringSeries(), this.settings.getLocale(), ccIds);
        log.debug((Object)("retrieved " + map.size() + " from ksd"));
        try {
            for (Object key : map.keySet()) {
                if (map.get(key) != null) continue;
                String message = "CC Map has no data for:" + key;
                CheckControlRetrievalException ccEx = new CheckControlRetrievalException(message);
                throw ccEx;
            }
        }
        catch (CheckControlRetrievalException e) {
            GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
        }
        schluesseldaten.setCheckControlMessageTexts(map);
    }

    public BSIBerechnungsbasis retrieveCalculationBase(String vertragstyp) throws GKIException, BSIDatensatzfehlerhaftException {
        KSDDataRetrieverIF ksdRetriever = this.getKSDDataRetriever(this.settings);
        return ksdRetriever.retrieveCalculationBase(vertragstyp);
    }

    private void prepareOrderbaseData(AuftragsbasisGrunddatenIF auftragsbasis) throws GKIException {
        BOSVerarbeitungsLogik bosLogic = new BOSVerarbeitungsLogik();
        bosLogic.setSAOptionCode(this.saOptionCode);
        bosLogic.setSSICountry(this.ssiCountry);
        List<BOSAWPosition> bosAWPositions = bosLogic.erzeugeBOSAWPositions(auftragsbasis, this.settings, this.warnings);
        this.isSSInterpretation = bosLogic.isSSInterpretation();
        auftragsbasis.setBosAwPositions(bosAWPositions);
        if (!bosAWPositions.isEmpty()) {
            boolean selectionFlag = bosAWPositions.get(0).getSelectionFlag();
            bosLogic.pruefenSelektionsKriterien(bosAWPositions, selectionFlag, null);
        }
        this.checkServiceCounterZero(bosAWPositions);
    }

    private void checkServiceCounterZero(List<BOSAWPosition> bosAWPositions) {
        for (BOSAWPosition bosAWpos : bosAWPositions) {
            if (bosAWpos.getServiceZaehler() != 0 || bosAWpos.getBosNr().getBosNr() == 99999 || bosAWpos.getBosNr().getBosNr() == 33 || bosAWpos.getBosNr().getBosNr() == 32 || bosAWpos.hasZuVerknuepfendeBosPosition()) continue;
            String cbsName = "" + bosAWpos.getBosNr().getBosNr();
            try {
                BOSNummer bosNummer = BOSNummerReader.find(bosAWpos.getBosNr().getBosNr());
                cbsName = bosNummer.getBezeichnung(LocaleHolder.getLocale());
            }
            catch (GKIException e) {
                log.warn((Object)("could not find BOSNummer for " + bosAWpos.getBosNr().getBosNr()), (Throwable)e);
            }
            GKIWarning warning = new ServiceCounterZeroWarning(null, new String[]{cbsName});
            GKILogic.addToWarningsListOnlyOnce(warning, this.warnings);
            if (!bosAWpos.getSelectionFlag().booleanValue() || bosAWpos.getVerknuepfungsliste() == null || bosAWpos.getVerknuepfungsliste().size() <= 0) continue;
            warning = new ServiceCounterZeroConnectedWarning(null, new String[]{cbsName});
            GKILogic.addToWarningsListOnlyOnce(warning, this.warnings);
        }
    }

    private void retrieveExtendedKeyData(AuftragsbasisGrunddatenIF orderbase, FgnrKreisInfo fgnrInfo) throws GKIException {
        if (orderbase.getSchluesseldaten().isLargeKey() && orderbase.getSchluesseldaten() instanceof SchluesseldatenE65) {
            ExtendedKeyData extendedKeyData;
            KSDDataRetrieverIF ksdRetriever = this.getKSDDataRetriever(this.settings);
            SchluesseldatenE65 schluesselE65 = (SchluesseldatenE65)orderbase.getSchluesseldaten();
            if (this.keyDataBin.getContent().length <= 256) {
                schluesselE65.setExtendedKeyData(null);
            }
            if ((extendedKeyData = schluesselE65.getExtendedKeyData()) != null) {
                this.retrieveNaviDVDData(extendedKeyData, schluesselE65.getMarke(), ksdRetriever);
                this.retrieveILevel(extendedKeyData, fgnrInfo, ksdRetriever);
                SchluesselVariante keyVariant = schluesselE65.getSchluesselVariante();
                this.retrieveTopUpInformationEngineOil(extendedKeyData, fgnrInfo, keyVariant);
            }
        }
    }

    private void retrieveBatteryData(AuftragsbasisGrunddatenIF orderBase, FgnrKreisInfo fgnrInfo, KSDDataRetrieverIF ksdRetriever) throws GKIException {
        BatteryStateRetrieverIF batteryStateRetriever = KSDCache.getInstance().getBatteryStateRetriever();
        if (batteryStateRetriever != null) {
            batteryStateRetriever.retrieveBatteryState(orderBase, fgnrInfo, ksdRetriever, this.settings.getLocale());
        }
    }

    private void retrieveILevel(ExtendedKeyData extendedKeyData, FgnrKreisInfo fgnrInfo, KSDDataRetrieverIF ksdRetriever) {
        try {
            String engineeringSeries = fgnrInfo.getEngineeringSeries();
            ILevelData iLevelData = ksdRetriever.retrieveILevel(extendedKeyData.getIlevelKeyData(), engineeringSeries);
            if (iLevelData != null) {
                extendedKeyData.setILevelData(iLevelData);
            }
        }
        catch (KSDDataException e) {
            GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
        }
    }

    private void retrieveTopUpInformationEngineOil(ExtendedKeyData extendedKeyData, FgnrKreisInfo fgnrInfo, SchluesselVariante keyVariant) throws NumberFormatException, GKIException {
        EngineOil engineOil = this.retrieveTopUpInformationEngineOil(Integer.valueOf(extendedKeyData.getTopUpInformationEngineOil().getCode()), this.settings.getLocale(), fgnrInfo, keyVariant);
        extendedKeyData.setTopUpInformationEngineOil(engineOil);
    }

    private void retrieveNaviDVDData(ExtendedKeyData extendedKeyData, String brand, KSDDataRetrieverIF ksdRetriever) {
        NaviDVDData naviData = NaviDVDReader.getInstance().find(brand, extendedKeyData.getNaviDVDCode());
        if (naviData != null && naviData.getDescription() != null) {
            naviData = this.getCopyOfNaviDVDData(naviData);
            naviData.setNewFeatures(false);
            naviData.setSoftwareUpdateNecessary(false);
            NaviDVDData latestDVD = this.getLatestNaviDvd(naviData, brand);
            if (latestDVD != null && !latestDVD.equals(naviData)) {
                naviData.setSoftwareUpdateNecessary(latestDVD.isSoftwareUpdateNecessary());
                naviData.setNewFeatures(latestDVD.isNewFeatures());
            } else if ((naviData = this.getCopyOfNaviDVDData(naviData)) != null) {
                naviData.setSoftwareUpdateNecessary(false);
                naviData.setNewFeatures(false);
            }
            extendedKeyData.setNaviData(naviData);
        }
    }

    private NaviDVDData getLatestNaviDvd(NaviDVDData naviData, String brand) {
        NaviDVDData successorDVD;
        NaviPartData partData;
        log.debug((Object)naviData);
        if (naviData != null && (partData = naviData.getPartData()) != null && partData.hasSuccessor() && (successorDVD = this.getCopyOfNaviDVDData(partData.getSuccessorDVD())) != null) {
            boolean softwareUpdateNecessary = naviData.isSoftwareUpdateNecessary();
            boolean newFeatures = naviData.isNewFeatures();
            log.info((Object)("\nSWUpdate: act navi=" + softwareUpdateNecessary + ", successor Navi: " + successorDVD.isSoftwareUpdateNecessary()));
            log.info((Object)("\nFeature: act navi=" + newFeatures + ", successor Navi: " + successorDVD.isNewFeatures()));
            if (softwareUpdateNecessary) {
                successorDVD.setSoftwareUpdateNecessary(true);
                successorDVD.setNewFeatures(true);
            } else if (newFeatures) {
                successorDVD.setNewFeatures(true);
            }
            return this.getLatestNaviDvd(successorDVD, brand);
        }
        return naviData;
    }

    private NaviDVDData getCopyOfNaviDVDData(NaviDVDData naviData) {
        if (naviData != null) {
            try {
                return (NaviDVDData)naviData.clone();
            }
            catch (CloneNotSupportedException e) {
                log.warn((Object)"GKILogic.getCopyOfNaviDVDData: error cloning NaviDVDData", (Throwable)e);
            }
        }
        return null;
    }

    private EngineOil retrieveTopUpInformationEngineOil(Integer topUpEngineOil, Locale locale, FgnrKreisInfo fgnrInfo, SchluesselVariante keyVariant) throws GKIException {
        EngineOil result = new EngineOil();
        result.setCode("" + topUpEngineOil);
        EngineOilProperties oilProps = EngineOilProperties.getInstance(keyVariant);
        int cbsId = oilProps.get(topUpEngineOil);
        result.setId(cbsId);
        KSDDataRetrieverIF ksdRetriever = KSDDataRetrieverFactory.getKSDDataRetriever(this.settings);
        BOSNummer bosNumber = ksdRetriever.findCBSNumber(cbsId);
        result.setDescription(bosNumber.getBezeichnung(locale));
        if (cbsId != 99901 && cbsId != 99905 && cbsId != 99904 && cbsId != 99910) {
            try {
                BOSAWNummer bosAwNumber = ksdRetriever.findCBSFlatRateNumber(fgnrInfo.getLeittyp(), bosNumber, fgnrInfo.getBaustand());
                result.setFlatRateNumber(this.isSSInterpretation ? bosAwNumber.getSsiAwNrHaupt() : bosAwNumber.getAwNrHaupt());
            }
            catch (KeineArbeitswerteException nfe) {
                log.info((Object)("No flat rate number found for cbsIdentifier " + bosNumber.getBosNr()));
                GKILogic.addToWarningsListOnlyOnce(nfe, this.warnings);
            }
        }
        return result;
    }

    private void checkSI(AuftragsbasisGrunddatenIF orderbase) throws GKIException {
        Date readInDate = orderbase.getSchluesseldaten().getEinleseDatum();
        Date erstzulassung = null;
        int kmStand = (int)Math.round(orderbase.getSchluesseldaten().getKmStand());
        if (orderbase.getSchluesseldaten().isE65upward() && orderbase.getSchluesseldaten() instanceof SchluesseldatenE65) {
            ArrayList<BSIServicePaket> bsiServicePackages = new ArrayList<BSIServicePaket>();
            SchluesseldatenE65 schluesselE65 = (SchluesseldatenE65)orderbase.getSchluesseldaten();
            erstzulassung = schluesselE65.getErstzulassung();
            if (this.siData != null) {
                for (BSIServicePaket siPackage : this.siData) {
                    siPackage.pruefeGueltigkeit(kmStand, readInDate, erstzulassung);
                    bsiServicePackages.add(siPackage);
                }
            }
            orderbase.setServicePackages(bsiServicePackages);
        }
    }

    public void setSiData(List<BSIServicePaket> siData) {
        this.siData = siData;
    }

    private Schluesseldaten createKey(KeyDataAnalysedType analysed, FgnrKreisInfo fgnrKreisInfo) throws GKIException {
        KeyBaseType keyBaseData = analysed.getKeyBaseData();
        SchluesselVariante sv = this.retrieveKeyVariant(keyBaseData.getKeyVariant(), fgnrKreisInfo.getBaustand(), this.settings);
        int variante = sv.getSchluesselVariante();
        int subvariante = keyBaseData.getKeySubVariant();
        Schluesseldaten schluesseldaten = null;
        switch (variante) {
            case 3: 
            case 4: {
                schluesseldaten = new SchluesseldatenVorE65(analysed, sv);
                break;
            }
            case 5: {
                schluesseldaten = new SchluesseldatenVorE65(analysed, sv);
                break;
            }
            case 6: {
                if (subvariante == 1) {
                    schluesseldaten = new SchluesseldatenCBS2(analysed, this.settings, sv);
                    break;
                }
                schluesseldaten = new SchluesseldatenE65(analysed, this.settings, sv);
                break;
            }
            case 7: {
                if (subvariante == 1) {
                    schluesseldaten = new SchluesseldatenE60(analysed, this.settings, sv);
                    break;
                }
                schluesseldaten = new SchluesseldatenVariante72(analysed, this.settings, sv);
                break;
            }
            case 8: {
                schluesseldaten = new SchluesseldatenCBS4(analysed, this.settings, sv);
                break;
            }
            case 9: {
                schluesseldaten = new SchluesseldatenF01(analysed, this.settings, sv);
                break;
            }
            default: {
                String message = PreProdLogMessages.getParameterString("CODE_KEY_VARIANT_NOT_IMPL", new Object[]{"" + sv.getSchluesselVariante()});
                PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_KEY_VARIANT_NOT_IMPL", message));
                throw new GKIException("schluesselVariante.ungueltig");
            }
        }
        if (schluesseldaten instanceof SchluesseldatenE65) {
            try {
                ((SchluesseldatenE65)schluesseldaten).erzeugeBosDaten();
            }
            catch (BosNotFoundException e) {
                GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
            }
            catch (GKIException e) {
                GKILogic.addToWarningsListOnlyOnce(new BosNotFoundException(e.getMessage(), e), this.warnings);
            }
        }
        if (schluesseldaten instanceof SchluesseldatenE60) {
            try {
                ((SchluesseldatenE60)schluesseldaten).checkDataConsistence(keyBaseData.getDataConsistence3());
            }
            catch (GKIException e) {
                GKILogic.addToWarningsListOnlyOnce(e, this.warnings);
            }
        }
        if ("GX81".equals(fgnrKreisInfo.getTypschluessel())) {
            HydrogenWarning hw = new HydrogenWarning();
            log.info((Object)("error code: " + hw.getErrorCode() + " - typ is 'GX81'"));
            GKILogic.addToWarningsListOnlyOnce(hw, this.warnings);
        }
        if (schluesseldaten != null) {
            if (this.keyDataBin != null) {
                if (schluesseldaten.getSchluesselVariante() != null) {
                    schluesseldaten.getSchluesselVariante().setSubvariante(subvariante);
                }
                if (this.keyDataBin.getReadInDate() != null) {
                    schluesseldaten.setEinleseDatum(this.keyDataBin.getReadInDate().toGregorianCalendar().getTime());
                }
                if (this.keyDataBin.getOrigin() != null) {
                    schluesseldaten.setHerkunft(this.keyDataBin.getOrigin().value().charAt(0));
                }
            }
            if (fgnrKreisInfo.getTypschluessel() != null) {
                schluesseldaten.setTypschluessel(fgnrKreisInfo.getTypschluessel());
            }
        }
        return schluesseldaten;
    }

    private SchluesselVariante retrieveKeyVariant(int var, int builddate, GKISettings setting) throws GKIException {
        KSDDataRetrieverIF ksdRetriever = this.getKSDDataRetriever(setting);
        SchluesselVariante variante = ksdRetriever.findKeyVariant(var);
        if (variante.getSchluesselVariante() != 5) {
            variante = ksdRetriever.filterKeyVariant(variante, builddate);
        }
        return variante;
    }

    public void setUseSI(boolean useSI) {
        this.useSI = useSI;
    }

    public KeyDataBinType getKeyDataBin() {
        return this.keyDataBin;
    }

    public void setKeyDataBin(KeyDataBinType keyDataBin) {
        this.keyDataBin = keyDataBin;
    }

    public void setWarnings(List<TypeErrorAdapter> warnings) {
        this.warnings = warnings;
    }

    public KSDDataRetrieverIF getKSDDataRetriever(GKISettings setting) {
        return KSDDataRetrieverFactory.getKSDDataRetriever(setting);
    }

    public static void addToWarningsListOnlyOnce(GKIExceptionIF exception, List<TypeErrorAdapter> warnings) {
        if (warnings == null) {
            return;
        }
        String errorCode = Utilities.nvl(exception.getErrorCode());
        String errorDescription = Utilities.nvl(exception.getFormatedMessage());
        for (TypeErrorAdapter obj : warnings) {
            Object typeError;
            String code = null;
            String description = null;
            if (obj instanceof TypeErrorAdapter) {
                typeError = obj;
                code = ((TypeErrorAdapter)typeError).getErrorCode();
                description = ((TypeErrorAdapter)typeError).getErrorDescription();
            } else if (obj instanceof com.bmw.gki.klib.api_current.TypeError) {
                typeError = obj;
                code = typeError.getErrorCode();
                description = typeError.getErrorDescription();
            } else if (obj instanceof com.bmw.gki.klib.api_V03_00_00.TypeError) {
                typeError = obj;
                code = typeError.getErrorCode();
                description = typeError.getErrorDescription();
            } else if (obj instanceof com.bmw.gki.klib.api_V02_00_00.TypeError) {
                typeError = obj;
                code = typeError.getErrorCode();
                description = typeError.getErrorDescription();
            } else if (obj instanceof TypeError) {
                typeError = obj;
                code = typeError.getErrorCode();
                description = typeError.getErrorDescription();
            }
            if (!errorCode.equals(Utilities.nvl(code)) || !errorDescription.equals(Utilities.nvl(description))) continue;
            return;
        }
        warnings.add(new TypeErrorAdapter(exception));
    }

    public void setSAOptionCode(String code) {
        this.saOptionCode = code;
    }

    public String getSAOptionCode() {
        return this.saOptionCode;
    }

    public void setSSICountry(String country) {
        this.ssiCountry = country;
    }
}

