/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.klib.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class TranslationChecker {
    private List<String> translated = new Vector<String>();
    private Properties allResources = new Properties();
    private Map<String, Properties> localeResources = new HashMap<String, Properties>();
    private static final String RESOURCE_BASE_NAME = "ExceptionMessages";
    private static final String[] localeStrings = new String[]{"de", "el", "en", "en_US", "es", "fr", "in", "it", "ja", "ko", "nl", "pt", "ru", "sv", "th", "zh", "zh_TW"};

    public static void main(String[] args) {
        TranslationChecker instance = new TranslationChecker();
        instance.loadAllResources();
        instance.checkTranslations();
    }

    private void checkTranslations() {
        Set<Object> keySet = this.allResources.keySet();
        ArrayList<Object> keyList = new ArrayList<Object>(keySet.size());
        keyList.addAll(keySet);
        Collections.sort(keyList);
        for (String string : keyList) {
            boolean isTranslated = true;
            for (int i = 0; i < localeStrings.length; ++i) {
                Properties localeResource = this.localeResources.get(localeStrings[i]);
                if (localeResource.containsKey(string)) continue;
                if (isTranslated) {
                    isTranslated = false;
                    System.out.print("\n" + string + "\t");
                }
                System.out.print(localeStrings[i] + " ");
            }
            if (!isTranslated) continue;
            this.translated.add(string);
        }
        System.out.println("\n\nTranslated:");
        for (String string : this.translated) {
            System.out.println(string);
        }
    }

    private void loadAllResources() {
        for (int i = 0; i < localeStrings.length; ++i) {
            this.loadResource(RESOURCE_BASE_NAME, localeStrings[i]);
        }
    }

    private void loadResource(String baseName, String locale) {
        String resourceName = baseName + "_" + locale + ".properties";
        if (locale == null) {
            resourceName = baseName + ".properties";
        }
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        try {
            if (inStream == null) {
                System.out.println(locale + " notFound");
                return;
            }
            this.allResources.load(inStream);
            inStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            Properties localeResource = new Properties();
            localeResource.load(inStream);
            this.localeResources.put(locale, localeResource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

