/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.etk.client.adapter.rest;

import com.bmw.etk.client.ProxySettings;
import com.bmw.etk.client.adapter.rest.AddAsapAuthenticationToHeaderFilter;
import com.bmw.etk.client.adapter.rest.ClientException;
import com.bmw.etk.client.adapter.rest.CockiePreservingFilter;
import com.bmw.etk.client.adapter.rest.ConnectionFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterface;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import exceptions.StatusType;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Transferable;

public class ETKRestApiClient {
    private static final Logger log = Logger.getLogger(ETKRestApiClient.class);
    private WebResource mWebResource;
    private static final Class NO_CLASS = null;

    public ETKRestApiClient(String pServerUrl, boolean pEnableCockieHandling, boolean pAddAsapAuthenticationToHeader, ProxySettings pProxySettings) {
        Client client;
        log.debug((Object)("Initializing REST Client with url: " + pServerUrl));
        if (!pProxySettings.isUseProxy()) {
            client = new Client();
        } else {
            ConnectionFactory httpURLConnectionFactory = new ConnectionFactory(pProxySettings);
            URLConnectionClientHandler ch = new URLConnectionClientHandler((HttpURLConnectionFactory)httpURLConnectionFactory);
            client = new Client((ClientHandler)ch);
        }
        if (pEnableCockieHandling) {
            client.addFilter((ClientFilter)new CockiePreservingFilter());
        }
        if (pAddAsapAuthenticationToHeader) {
            client.addFilter((ClientFilter)new AddAsapAuthenticationToHeaderFilter());
        }
        client.addFilter((ClientFilter)new GZIPContentEncodingFilter(true));
        this.mWebResource = client.resource(pServerUrl);
    }

    public Transferable executeService(Transferable pTransferable, String pRootPath) throws ClientException, CommunicationException {
        WebResource uniformInterface = this.mWebResource.path(pRootPath).path("/do_transfer");
        return (Transferable)this.post((UniformInterface)uniformInterface, pTransferable.getClass(), pTransferable);
    }

    private <T> T post(UniformInterface pWebResource, Class<T> pClassReturnValue, Object pObjectToPost) throws ClientException, CommunicationException {
        try {
            if (pClassReturnValue == NO_CLASS) {
                pWebResource.post(pObjectToPost);
                return null;
            }
            return (T)pWebResource.post(pClassReturnValue, pObjectToPost);
        }
        catch (UniformInterfaceException e) {
            return this.handleExceptionWithGenericClientException(e);
        }
        catch (ClientHandlerException e) {
            throw new CommunicationException(e);
        }
    }

    private <T> T handleExceptionWithGenericClientException(UniformInterfaceException pExcp) throws ClientException {
        log.error((Object)pExcp);
        try {
            StatusType statusType = (StatusType)pExcp.getResponse().getEntity(StatusType.class);
            StringBuilder sb = new StringBuilder("Exception: ").append((Object)pExcp).append('\n');
            if (statusType == null) {
                sb.append("no status type");
            } else {
                sb.append("\ncaused by: ").append(statusType.getExceptionClass()).append(' ').append(statusType.getMessage() != null ? "\n message: " + statusType.getMessage() : "");
            }
            throw new ClientException(sb.toString());
        }
        catch (ClientHandlerException e) {
            throw new ClientException(pExcp.getMessage());
        }
        catch (Throwable e) {
            throw new ClientException(e.getMessage());
        }
    }
}

