/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TextFieldPatternFormatter;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.RequiredFieldChecker;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JRequiredLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.MaskFormatter;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class AngebotSaveDialog
extends AbstractDialog {
    public static final String LISTENELEMENT_ANGEBOTDIALOG = "AngebotSaveListenElement";
    private static final String PATTERN_BINDEFRIST = "[0-9]{0,3}";
    private JTextField mAngebotNr;
    private JTextField mAngebotsName;
    private JTextField mAngebotsdatum;
    private JFormattedTextField mBindeFrist;
    private JTextField mBemerkung;
    private JTextField mProduktBenennung;
    private JTextField mErsteller;
    private JTextField mKundenNummer;
    private JTextField mKundenName;
    private JTextField mKundenVorname;
    private JTextField mStrasse;
    private JTextField mHausNummer;
    private JTextField mPlz;
    private JTextField mStadt;
    private JTextField mPostFach;
    private JTextField mTelefon;
    private JTextField mFax;
    private JTextField mMobil;
    private JTextField mEmail;
    private JTextField mLand;
    private JLabel mAngebotsNrText;
    private JLabel mAngebotsNameText;
    private JLabel mBindeFristText;
    private JLabel mProduktBenennungText;
    private JLabel mAngebotsDatumText;
    private JLabel mBemerkungText;
    private JLabel mErstellerText;
    private JLabel mKundenNummerText;
    private JRequiredLabel mKundenNameText;
    private JRequiredLabel mKundenVornameText;
    private JLabel mStrasseText;
    private JLabel mHausNummerText;
    private JLabel mLandText;
    private JLabel mPlzText;
    private JLabel mStadtText;
    private JLabel mPostFachText;
    private JLabel mTelefonText;
    private JLabel mMobilText;
    private JLabel mFaxText;
    private JLabel mEmailText;
    private JLabel labPflichtfeld;
    private JLabel angebotSuche;
    private JPanel contentPanel;
    private JPanel errorPanel;
    private JLabel mDetails;
    private JPanel kundenPanel;
    private ArrayList<JLabel> mLabKunde;
    private SimpleDateFormat dateFormatter;
    private int distTop = 10;
    private int distBottom = 8;
    private int distLeft = 8;
    private int distRight = 8;
    public static final int HEIGHT_LISTE = 200;
    public static final int HEIGHT_MASKE = 200;
    private Kunde mKunde;
    private static final Color COLOR_PFLICHTFELD = Color.RED;
    private RequiredFieldChecker checker;
    private String DETAILS = "Kundendaten";
    boolean detailsGeklappt = false;
    private JPanel kundenEingabePanel;
    private boolean suchenEnabled = true;
    private static Logger log = Logger.getLogger(AngebotSaveDialog.class);

    public AngebotSaveDialog(JFrame owner, String title, MarkenLayout markenLayout, Dimension dialogSize) {
        super(owner, title, markenLayout, dialogSize);
        this.mDialog.setDefaultCloseOperation(2);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
        this.mDialog.setModal(true);
        this.mDialog.setResizable(false);
        this.checker = new RequiredFieldChecker(Resource.getInstance().getErrormessageFelder());
        this.createLabels();
        this.setDialogLocation();
        this.initLayout();
        this.setLayout();
        this.mDialog.validate();
    }

    private void initLayout() {
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(this.distTop, this.distLeft, 0, this.distRight));
        this.mDialog.getContentPane().add((Component)this.createErrorPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 18, new Insets(this.distTop, this.distLeft, 0, this.distRight));
        this.mDialog.getContentPane().add((Component)this.createUpperContentPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, 18, new Insets(this.distTop, this.distLeft, 0, this.distRight));
        this.mDialog.getContentPane().add((Component)this.kundenPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mDialog.getContentPane().add((Component)this.setButtonsPanel(Resource.getInstance().getSpeichern(), Resource.getInstance().getAbbrechen(), true, 15, 200), gbc);
    }

    private JPanel createErrorPanel() {
        if (this.errorPanel == null) {
            this.errorPanel = new JPanel();
            this.errorPanel.setLayout(new GridBagLayout());
        }
        this.errorPanel.removeAll();
        this.errorPanel.setVisible(false);
        return this.errorPanel;
    }

    public void clearErrors() {
        this.errorPanel.removeAll();
        this.errorPanel.validate();
        this.errorPanel.setVisible(false);
        this.mDialog.validate();
    }

    public void setError(String message) {
        this.errorPanel.setVisible(true);
        String[] labels = message.split("\n");
        int row = 0;
        for (String str : labels) {
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, row, 1, 1, 1.0, 0.0, 1, 10, new Insets(0, 0, 0, 0));
            JLabel label = new JLabel(str, 0);
            label.setBoldFont();
            label.setForeground(COLOR_PFLICHTFELD);
            label.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.errorPanel.add((Component)label, gbc);
            ++row;
        }
        this.errorPanel.validate();
        this.errorPanel.repaint();
        if (this.mKunde != null && this.detailsGeklappt) {
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200 + 60));
        }
        this.setDialogLocation();
        this.mDialog.validate();
    }

    private void createLabels() {
        this.kundenPanel = new JPanel(new GridBagLayout());
        this.mAngebotsNrText = new JLabel(Resource.getInstance().getAngebotsnummer() + ":", 4);
        this.mAngebotsNameText = new JLabel(Resource.getInstance().getAngebotsname() + ":", 4);
        this.mAngebotsDatumText = new JLabel(Resource.getInstance().getAngebotsdatum() + ":", 4);
        this.mBindeFristText = new JLabel(Resource.getInstance().getBindefristInTagen() + ":", 4);
        this.mBemerkungText = new JLabel(Resource.getInstance().getBemerkung() + ":", 4);
        this.mProduktBenennungText = new JLabel(Resource.getInstance().getProduktbenennung() + ":", 4);
        this.mErstellerText = new JLabel(Resource.getInstance().getErsteller() + ":", 4);
        this.kundenEingabePanel = new JPanel(new GridBagLayout());
        this.mAngebotNr = new JTextField("", 20);
        this.mAngebotNr.setEnabled(false);
        this.mAngebotsNrText.setLabelFor(this.mAngebotNr);
        this.mAngebotsName = new JTextField(20);
        this.mAngebotsName.setText("");
        this.mAngebotsNameText.setLabelFor(this.mAngebotsName);
        this.mAngebotsdatum = new JTextField("", 20);
        this.mAngebotsdatum.setEnabled(false);
        this.mAngebotsDatumText.setLabelFor(this.mAngebotsdatum);
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("###");
            formatter.setPlaceholderCharacter('0');
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Pattern pBindefrist = Pattern.compile(PATTERN_BINDEFRIST);
        TextFieldPatternFormatter formatBindefrist = new TextFieldPatternFormatter(pBindefrist);
        formatBindefrist.setAllowsInvalid(false);
        this.mBindeFrist = new JFormattedTextField(formatBindefrist);
        this.mBindeFristText.setLabelFor(this.mBindeFrist);
        this.mBemerkung = new JTextField("", 20, 56);
        this.mBemerkungText.setLabelFor(this.mBemerkung);
        this.mProduktBenennung = new JTextField("", 20);
        this.mProduktBenennung.setEnabled(false);
        this.mProduktBenennungText.setLabelFor(this.mProduktBenennung);
        this.mErsteller = new JTextField("", 20);
        this.mErsteller.setEnabled(false);
        this.mErstellerText.setLabelFor(this.mErsteller);
        this.angebotSuche = new JLabel();
        this.angebotSuche.setName("suchen");
        this.angebotSuche.setCursor(Cursor.getPredefinedCursor(12));
        this.mKundenNummerText = new JLabel(Resource.getInstance().getKundennummer() + ":", 4);
        this.mKundenNameText = new JRequiredLabel(Resource.getInstance().getKundenname() + ":", 4);
        this.mKundenVornameText = new JRequiredLabel(Resource.getInstance().getVorname() + ":", 4);
        this.mKundenNummer = new JTextField("", 20, 7);
        this.mKundenNummerText.setLabelFor(this.mKundenNummer);
        this.mKundenName = new JTextField("", 20, 40);
        this.mKundenVorname = new JTextField("", 20, 40);
        this.mStrasseText = new JLabel(Resource.getInstance().getStrasse() + ":", 4);
        this.mStrasse = new JTextField("", 30, 40);
        this.mStrasseText.setLabelFor(this.mStrasse);
        this.mHausNummerText = new JLabel(Resource.getInstance().getHausnummer() + ":", 4);
        this.mHausNummer = new JTextField("", 10, 40);
        this.mHausNummerText.setLabelFor(this.mHausNummer);
        this.mLandText = new JLabel(Resource.getInstance().getLand() + ":", 4);
        this.mPlzText = new JLabel(Resource.getInstance().getPlz() + ":", 4);
        this.mStadtText = new JLabel(Resource.getInstance().getOrt() + ":", 4);
        this.mPostFachText = new JLabel(Resource.getInstance().getPostfach() + ":", 4);
        this.mTelefonText = new JLabel(Resource.getInstance().getTelefon() + ":", 4);
        this.mFaxText = new JLabel(Resource.getInstance().getFax() + ":", 4);
        this.mEmailText = new JLabel(Resource.getInstance().getEmail() + ":", 4);
        this.mMobilText = new JLabel(Resource.getInstance().getMobil() + ":", 4);
        this.mPlz = new JTextField("", 10, 10);
        this.mPlzText.setLabelFor(this.mPlz);
        this.mStadt = new JTextField("", 30, 40);
        this.mStadtText.setLabelFor(this.mStadt);
        this.mPostFach = new JTextField("", 30, 10);
        this.mPostFachText.setLabelFor(this.mPostFach);
        this.mTelefon = new JTextField("", 30, 25);
        this.mTelefonText.setLabelFor(this.mTelefon);
        this.mFax = new JTextField("", 30, 25);
        this.mFaxText.setLabelFor(this.mFax);
        this.mEmail = new JTextField("", 30, 40);
        this.mEmailText.setLabelFor(this.mEmail);
        this.mLand = new JTextField("", 30, 40);
        this.mLandText.setLabelFor(this.mLand);
        this.mMobil = new JTextField("", 30, 25);
        this.mDetails = new JLabel();
        this.mDetails.setName(this.DETAILS);
        this.mDetails.setBorder(BorderFactory.createRaisedBevelBorder());
        this.labPflichtfeld = new JLabel("* " + Resource.getInstance().getPflichtfeld());
        this.labPflichtfeld.setForeground(COLOR_PFLICHTFELD);
    }

    private JPanel createUpperContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new GridBagLayout());
        } else {
            this.contentPanel.removeAll();
        }
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, this.distLeft, 0, 5));
        this.contentPanel.add((Component)this.getRequiredLabelPanel(this.mAngebotsNrText), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mAngebotNr, gbc);
        this.checker.addRequiredField(this.mAngebotNr, this.mAngebotsNrText);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.getRequiredLabelPanel(this.mAngebotsNameText), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mAngebotsName, gbc);
        this.checker.addRequiredField(this.mAngebotsName, this.mAngebotsNameText);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, this.distLeft, 0, 5));
        this.contentPanel.add((Component)this.mProduktBenennungText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mProduktBenennung, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, this.distLeft, 0, 5));
        this.contentPanel.add((Component)this.getRequiredLabelPanel(this.mAngebotsDatumText), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mAngebotsdatum, gbc);
        this.checker.addRequiredField(this.mAngebotsdatum, this.mAngebotsDatumText);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.getRequiredLabelPanel(this.mBindeFristText), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, 0, 0, 5));
        gbc.ipadx = 50;
        this.contentPanel.add((Component)this.mBindeFrist, gbc);
        this.checker.addRequiredField(this.mBindeFrist, this.mBindeFristText);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mErstellerText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mErsteller, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mBemerkungText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 5, 4, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mBemerkung, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 6, 5, 1, 1.0, 0.0, 2, 12, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 0, 12, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mKundenNummerText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 7, 4, 1, 1.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.contentPanel.add((Component)this.mKundenNummer, gbc);
        JPanel suchPanel = new JPanel();
        suchPanel.setLayout(new GridBagLayout());
        suchPanel.setOpaque(false);
        GridBagConstraints kgbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        suchPanel.add((Component)this.mKundenVornameText, kgbc);
        this.checker.addRequiredField(this.mKundenVorname, this.mKundenVornameText.getLabel());
        kgbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        suchPanel.add((Component)this.mKundenVorname, kgbc);
        kgbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 10));
        suchPanel.add((Component)new JLabel("   "), kgbc);
        kgbc = this.mMarkenLayout.setGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 10));
        suchPanel.add((Component)this.mKundenNameText, kgbc);
        kgbc = this.mMarkenLayout.setGridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 10));
        suchPanel.add((Component)this.mKundenName, kgbc);
        this.checker.addRequiredField(this.mKundenName, this.mKundenNameText.getLabel());
        kgbc = this.mMarkenLayout.setGridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 10));
        suchPanel.add((Component)this.angebotSuche, kgbc);
        kgbc = this.mMarkenLayout.setGridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 10));
        suchPanel.add((Component)new JLabel("    "), kgbc);
        kgbc = this.mMarkenLayout.setGridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 10));
        suchPanel.add((Component)this.mDetails, kgbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 8, 5, 1, 0.0, 0.0, 0, 18, new Insets(0, 50, 0, 0));
        this.contentPanel.add((Component)suchPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 9, 5, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        this.contentPanel.add((Component)this.labPflichtfeld, gbc);
        this.contentPanel.validate();
        return this.contentPanel;
    }

    private JPanel getRequiredLabelPanel(Component component) {
        JPanel labelPanel = new JPanel();
        labelPanel.setOpaque(false);
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        JLabel labStern1 = new JLabel("*");
        labStern1.setForeground(COLOR_PFLICHTFELD);
        labelPanel.add(component);
        labelPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        labelPanel.add(labStern1);
        return labelPanel;
    }

    private void setLayout() {
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.getContentPane().setForeground(this.mMarkenLayout.getPrimaryForeground());
        if (this.isSuchenEnabled()) {
            this.angebotSuche.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_aktiv.gif"));
        } else {
            this.angebotSuche.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_inaktiv.gif"));
        }
        this.mDetails.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "aufklappen.gif"));
        this.contentPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.contentPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getAngebotsinformationen(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
        this.kundenPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mAngebotsNrText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mAngebotsNameText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mBindeFristText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mProduktBenennungText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mAngebotsDatumText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mBemerkungText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mErstellerText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mKundenNummerText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mKundenNameText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mKundenVornameText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mStrasseText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mHausNummerText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mLandText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPlzText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mStadtText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPostFachText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mTelefonText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mMobilText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mFaxText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mEmailText.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.labPflichtfeld.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mAngebotsNrText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mAngebotsNameText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mBindeFristText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mProduktBenennungText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mAngebotsDatumText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mBemerkungText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mErstellerText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mKundenNummerText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mKundenNameText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mKundenVornameText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mStrasseText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHausNummerText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mLandText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mPlzText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mStadtText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mPostFachText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mTelefonText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mMobilText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mFaxText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mEmailText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.errorPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.kundenEingabePanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.setButtonLayout();
    }

    public void showKundenListe(ArrayList<Kunde> kundeListe) {
        if (this.kundenPanel != null) {
            this.kundenPanel.removeAll();
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(this.distTop, this.distLeft, this.distBottom, this.distRight));
            int treffer = kundeListe.size();
            int addHeight = (this.errorPanel.isVisible() ? 50 : 0) + 200;
            if (treffer > 1 && treffer <= 50) {
                this.kundenPanel.add((Component)this.getKundenListe(kundeListe), gbc);
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + addHeight));
                this.detailsGeklappt = false;
                this.mDetails.setBorder(BorderFactory.createRaisedBevelBorder());
                this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
            } else if (treffer == 0) {
                this.kundenPanel.add((Component)this.getInfotext(Resource.getInstance().getInfotextKeinTreffer()), gbc);
                this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + addHeight));
                this.detailsGeklappt = false;
                this.mDetails.setBorder(BorderFactory.createRaisedBevelBorder());
            } else if (treffer > 50) {
                String text = StringUtils.substituteStringStraight(Resource.getInstance().getInfotextZuVieleTreffer(), "{0}", Integer.toString(treffer));
                this.kundenPanel.add((Component)this.getInfotext(text), gbc);
                this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + addHeight));
                this.detailsGeklappt = false;
                this.mDetails.setBorder(BorderFactory.createRaisedBevelBorder());
            } else {
                this.showKundenEingabePanel();
            }
            this.kundenPanel.validate();
            this.kundenPanel.updateUI();
            this.setDialogLocation();
            this.mDialog.validate();
        }
    }

    public void showKundenEingabePanel() {
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(this.distTop, this.distLeft, this.distBottom, this.distRight));
        int addHeight = this.errorPanel.isVisible() ? 50 : 0;
        this.detailsGeklappt = !this.detailsGeklappt;
        this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + addHeight + (this.detailsGeklappt ? 200 : 0)));
        if (this.detailsGeklappt) {
            this.mDetails.setBorder(BorderFactory.createLoweredBevelBorder());
            this.kundenPanel.add((Component)this.getKundenEingabePanel(), gbc);
            this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundendaten(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
        } else {
            this.hideKundenDialog();
        }
        this.kundenPanel.validate();
        this.kundenPanel.updateUI();
        this.setDialogLocation();
        this.mDialog.validate();
    }

    private JPanel getKundenEingabePanel() {
        this.kundenEingabePanel.removeAll();
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mStrasseText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mStrasse, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mHausNummerText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mHausNummer, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mLandText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mLand, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mPlzText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mPlz, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mStadtText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mStadt, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mPostFachText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mPostFach, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mTelefonText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mTelefon, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mMobilText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, 0, 5));
        this.kundenEingabePanel.add((Component)this.mMobil, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        this.kundenEingabePanel.add((Component)this.mFaxText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        this.kundenEingabePanel.add((Component)this.mFax, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        this.kundenEingabePanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 0, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        this.kundenEingabePanel.add((Component)this.mEmailText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        this.kundenEingabePanel.add((Component)this.mEmail, gbc);
        return this.kundenEingabePanel;
    }

    private JPanel getInfotext(String infoText) {
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel lab = new JLabel("<html>" + infoText + "</html>", 0);
        lab.setForeground(this.mMarkenLayout.getPrimaryForeground());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 0, 18, new Insets(this.distTop, 0, this.distBottom, 5));
        panel.add((Component)lab, gbc);
        return panel;
    }

    private JScrollPane getKundenListe(ArrayList<Kunde> kundenListe) {
        JPanel panel = new JPanel();
        JScrollPane panelScroll = new JScrollPane(panel, 20, 31);
        panelScroll.setPreferredSize(new Dimension(this.mDialogSize.width - 30, 170));
        panelScroll.setBorder(BorderFactory.createEmptyBorder());
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        this.mLabKunde = new ArrayList();
        for (int ii = 0; ii < kundenListe.size(); ++ii) {
            JLabel temp = new JLabel("   " + kundenListe.get(ii).toString(), 2);
            temp.setName(LISTENELEMENT_ANGEBOTDIALOG + ii);
            temp.setForeground(this.mMarkenLayout.getPrimaryForeground());
            temp.setCursor(Cursor.getPredefinedCursor(12));
            this.mLabKunde.add(ii, temp);
            panel.add(temp);
        }
        this.setChanged();
        this.notifyObservers(this.mLabKunde);
        return panelScroll;
    }

    @Override
    public void hideDialog() {
        if (this.mDialog.isVisible()) {
            this.mDialog.setVisible(false);
        }
    }

    private void init() {
        Angebot angebot = ClientKonfiguration.getClientKonfiguration().getAngebot();
        if (angebot != null) {
            this.mAngebotNr.setText(Integer.toString(angebot.getAngebotsnummer()));
            if (angebot.getAnlageDatum() != null) {
                this.mAngebotsdatum.setText(this.dateFormatter.format(angebot.getAnlageDatum()));
            }
            this.mAngebotsName.setText(angebot.getAngebotsName());
            this.mBindeFrist.setText(String.valueOf(angebot.getBindeFrist()));
            if (angebot.getBemerkung() != null) {
                this.mBemerkung.setText(angebot.getBemerkung());
            } else {
                this.mBemerkung.setText("");
            }
        } else {
            this.mAngebotsdatum.setText(this.dateFormatter.format(new Date()));
            this.mErsteller.setText(GlobalObjects.getInstance().getSessionInfo().getLogin());
        }
        this.mProduktBenennung.setText(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getProduktName());
        this.setLayout();
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.mMarkenLayout = markenLayout;
        this.mDialog.getContentPane().validate();
        this.setDialogLocation();
        this.errorPanel.setVisible(false);
        this.hideKundenDialog();
        this.init();
        this.mDialog.setVisible(true);
        this.mDialog.validate();
    }

    public void hideKundenDialog() {
        this.kundenPanel.removeAll();
        this.kundenPanel.setBorder(BorderFactory.createEmptyBorder());
        this.kundenPanel.updateUI();
        this.mDetails.setBorder(BorderFactory.createRaisedBevelBorder());
        this.mDialog.setSize(this.mDialogSize);
        this.mDialog.validate();
    }

    public JLabel getAnfrageSuche() {
        return this.angebotSuche;
    }

    public String getBemerkung() {
        return this.mBemerkung.getText();
    }

    public Integer getAngebotNr() {
        if (this.mAngebotNr.getText().length() == 0 || this.mAngebotNr.getText().trim().length() == 0) {
            return null;
        }
        return new Integer(this.mAngebotNr.getText());
    }

    public Date getAngebotsdatum() {
        if (this.mAngebotsdatum.getText().length() == 0) {
            return null;
        }
        try {
            Date datum = this.dateFormatter.parse(this.mAngebotsdatum.getText());
            return datum;
        }
        catch (ParseException e) {
            log.warn((Object)("Unable to parse Date:" + this.mAngebotsdatum.getText()));
            return null;
        }
    }

    public String getAngebotsName() {
        return this.mAngebotsName.getText();
    }

    public Integer getBindeFrist() {
        if (this.mBindeFrist.getText().length() == 0 || this.mBindeFrist.getText().trim().length() == 0) {
            return null;
        }
        return new Integer(this.mBindeFrist.getText());
    }

    public String getErsteller() {
        return this.mErsteller.getText();
    }

    public String getProduktBenennung() {
        return this.mProduktBenennung.getText();
    }

    public String getKundenName() {
        return this.mKundenName.getText();
    }

    public String getKundenNummer() {
        return this.mKundenNummer.getText();
    }

    public String getKundenVorname() {
        return this.mKundenVorname.getText();
    }

    public JTextField getMKundenName() {
        return this.mKundenName;
    }

    public void setMKundenName(JTextField kundenName) {
        this.mKundenName = kundenName;
    }

    public JTextField getMKundenNummer() {
        return this.mKundenNummer;
    }

    public void setMKundenNummer(JTextField kundenNummer) {
        this.mKundenNummer = kundenNummer;
    }

    public JTextField getMKundenVorname() {
        return this.mKundenVorname;
    }

    public void setMKundenVorname(JTextField kundenVorname) {
        this.mKundenVorname = kundenVorname;
    }

    public JTextField getMProduktBenennung() {
        return this.mProduktBenennung;
    }

    public void setKunde(Kunde kunde) {
        this.mKunde = kunde;
        if (kunde != null) {
            this.setFieldInfo(kunde.getVorname(), this.mKundenVorname);
            this.setFieldInfo(kunde.getName(), this.mKundenName);
            this.setFieldInfo(kunde.getStrasse(), this.mStrasse);
            this.setFieldInfo(kunde.getHausnr(), this.mHausNummer);
            this.setFieldInfo(kunde.getLand(), this.mLand);
            this.setFieldInfo(kunde.getPlz(), this.mPlz);
            this.setFieldInfo(kunde.getStadt(), this.mStadt);
            this.setFieldInfo(kunde.getKundennummer(), this.mKundenNummer);
            this.setFieldInfo(kunde.getMobilnummer(), this.mMobil);
            this.setFieldInfo(kunde.getTelefonnummer(), this.mTelefon);
            this.setFieldInfo(kunde.getFaxnummer(), this.mFax);
        } else {
            this.setFieldInfo(null, this.mKundenVorname);
            this.setFieldInfo(null, this.mKundenName);
            this.setFieldInfo(null, this.mStrasse);
            this.setFieldInfo(null, this.mHausNummer);
            this.setFieldInfo(null, this.mLand);
            this.setFieldInfo(null, this.mPlz);
            this.setFieldInfo(null, this.mStadt);
            this.setFieldInfo(null, this.mKundenNummer);
            this.setFieldInfo(null, this.mMobil);
            this.setFieldInfo(null, this.mTelefon);
            this.setFieldInfo(null, this.mFax);
        }
        if (this.mKundenName.getText() != null && this.mKundenName.getText() != "" && !this.mKundenName.isEnabled()) {
            this.suchenEnabled = false;
            this.angebotSuche.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_inaktiv.gif"));
        } else {
            this.suchenEnabled = true;
            this.angebotSuche.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_aktiv.gif"));
        }
    }

    private void setFieldInfo(String value, JTextField field) {
        if (value != null && value.length() > 0) {
            field.setText(value);
            field.setEnabled(false);
        } else {
            field.setText("");
            field.setEnabled(true);
        }
    }

    public Kunde estimateKunde() {
        Kunde kunde = new Kunde();
        if (this.mKunde != null && this.mKunde.getKundenId() != 0) {
            kunde.setKundenId(this.mKunde.getKundenId());
            if (this.mKunde.getAnrede() != null) {
                kunde.setAnrede(this.mKunde.getAnrede());
            }
        }
        kunde.setKundennummer(this.mKundenNummer.getText());
        kunde.setName(this.mKundenName.getText());
        kunde.setVorname(this.mKundenVorname.getText());
        kunde.setStrasse(this.mStrasse.getText());
        kunde.setHausnr(this.mHausNummer.getText());
        kunde.setLand(this.mLand.getText());
        kunde.setPlz(this.mPlz.getText());
        kunde.setStadt(this.mStadt.getText());
        kunde.setPostfachnr(this.mPostFach.getText());
        kunde.setTelefonnummer(this.mTelefon.getText());
        kunde.setMobilnummer(this.mMobil.getText());
        kunde.setFaxnummer(this.mFax.getText());
        kunde.setEmail(this.mEmail.getText());
        return kunde;
    }

    public Kunde getKunde() {
        return this.mKunde;
    }

    public RequiredFieldChecker getChecker() {
        return this.checker;
    }

    public void setChecker(RequiredFieldChecker checker) {
        this.checker = checker;
    }

    public JLabel getMDetails() {
        return this.mDetails;
    }

    public void reset() {
        this.mAngebotNr.setText(null);
        this.mAngebotsName.setText(null);
        this.mAngebotsdatum.setText(null);
        this.mBindeFrist.setText(null);
        this.mBemerkung.setText(null);
        this.mProduktBenennung.setText(null);
        this.mErsteller.setText(null);
        this.mKundenNummer.setText(null);
        this.mKundenName.setText(null);
        this.mKundenVorname.setText(null);
        this.mStrasse.setText(null);
        this.mHausNummer.setText(null);
        this.mPlz.setText(null);
        this.mStadt.setText(null);
        this.mPostFach.setText(null);
        this.mTelefon.setText(null);
        this.mFax.setText(null);
        this.mMobil.setText(null);
        this.mEmail.setText(null);
        this.mLand.setText(null);
        this.detailsGeklappt = false;
    }

    public JFormattedTextField getMBindeFrist() {
        return this.mBindeFrist;
    }

    public JTextField getMAngebotNr() {
        return this.mAngebotNr;
    }

    public JLabel getAngebotSuche() {
        return this.angebotSuche;
    }

    public boolean isSuchenEnabled() {
        return this.suchenEnabled;
    }
}

