/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageSaveDialog;
import de.esg.zub.common.CommonDataLoader;
import de.esg.zub.common.ControllerDialogKunde;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import webetk.DuplicateValueException;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;

public class ControllerAnfrageSave
implements Observer,
ActionListener {
    private static Logger log = Logger.getLogger(ControllerAnfrageSave.class);
    private static final long serialVersionUID = 1L;
    private static final String ANFRAGE_SPEICHERN = Resource.getInstance().getAnfrageSpeichern();
    private static final String FEHLER_BEIM_SPEICHERN = Resource.getInstance().getFehlerBeimSpeichern();
    public static final int LENGTH_KUNDENNUMMER = 7;
    public static final int MAX_LENGTH_KUNDENNAME = 40;
    private AnfrageSaveDialog mAnfrageSaveDialog;
    private ArrayList<Kunde> mKundenListe;
    private Kunde mKunde;
    private SaveDialogMouseListener sdml;
    private static ControllerAnfrageSave mInstance = null;

    private ControllerAnfrageSave() {
    }

    public static ControllerAnfrageSave getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerAnfrageSave();
            mInstance.init();
        }
        return mInstance;
    }

    public void init() {
        log.debug((Object)"init");
        this.mAnfrageSaveDialog = new AnfrageSaveDialog(MainController.getInstance().getMainFrame(), Resource.getInstance().getSpeichernUnverbindlicheAnfrage(), WorkflowController.getInstance().getMarkenLayout(), new Dimension(620, 240));
        this.sdml = new SaveDialogMouseListener();
        this.mAnfrageSaveDialog.getActionButton().addMouseListener(this.sdml);
        this.mAnfrageSaveDialog.getCancelButton().addMouseListener(this.sdml);
        this.mAnfrageSaveDialog.getAnfrageSuche().addMouseListener(this.sdml);
        this.mAnfrageSaveDialog.addObserver(this);
        this.mAnfrageSaveDialog.getTfNachname().getDocument().addDocumentListener(new ItemDocumentListener());
        this.mAnfrageSaveDialog.getTfVorname().getDocument().addDocumentListener(new ItemDocumentListener());
        this.mAnfrageSaveDialog.getTfNachname().addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String txtKundenname;
        if (e.getSource() == this.mAnfrageSaveDialog.getTfNachname() && (txtKundenname = this.mAnfrageSaveDialog.getTfNachname().getText()) != null && txtKundenname.length() > 0) {
            if (txtKundenname.length() > 40) {
                txtKundenname = txtKundenname.substring(0, 40);
            }
            Cursor oldCursor = this.mAnfrageSaveDialog.getTfNachname().getCursor();
            try {
                this.mAnfrageSaveDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mAnfrageSaveDialog.getTfNachname().setCursor(Cursor.getPredefinedCursor(3));
                this.sucheNachKundenname(txtKundenname);
            }
            finally {
                this.mAnfrageSaveDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                MainController.getInstance().getMainFrame().setDefaultCursor();
                this.mAnfrageSaveDialog.getTfNachname().setCursor(oldCursor);
            }
        }
    }

    private void sucheNachKundenname(String kundenname) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuName(kundenname);
        if (this.mKundenListe != null && this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerAnfrageSave.this.mAnfrageSaveDialog.setNachname(ControllerAnfrageSave.this.mKunde.getName());
                    ControllerAnfrageSave.this.mAnfrageSaveDialog.setVorname(ControllerAnfrageSave.this.mKunde.getVorname());
                    ControllerAnfrageSave.this.mAnfrageSaveDialog.setKundenId(ControllerAnfrageSave.this.mKunde.getKundenId());
                }
            });
        } else {
            this.mKunde = null;
        }
        this.mAnfrageSaveDialog.showKundenListe(this.mKundenListe);
    }

    public AnfrageSaveDialog getAnfrageSavedialog() {
        return this.mAnfrageSaveDialog;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg.getClass().equals(ArrayList.class)) {
            ArrayList list = (ArrayList)arg;
            for (int i = 0; i < list.size(); ++i) {
                ((JLabel)list.get(i)).addMouseListener(this.sdml);
            }
        }
        if (arg.getClass().equals(String.class) && arg.equals("Buttons")) {
            this.mAnfrageSaveDialog.getActionButton().addMouseListener(this.sdml);
            this.mAnfrageSaveDialog.getCancelButton().addMouseListener(this.sdml);
        }
    }

    private void handleSaveEvent() throws Exception {
        Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
        if (this.mAnfrageSaveDialog.getBemerkung() != null && !this.mAnfrageSaveDialog.getBemerkung().equals("")) {
            anfrage.setBemerkung(this.mAnfrageSaveDialog.getBemerkung());
        }
        Kunde kunde = null;
        if (this.mAnfrageSaveDialog.getTfNachname() != null && !this.mAnfrageSaveDialog.getKundenNachname().equals("")) {
            kunde = new Kunde();
            kunde.setName(this.mAnfrageSaveDialog.getKundenNachname());
        }
        if (this.mAnfrageSaveDialog.getTfVorname() != null && !this.mAnfrageSaveDialog.getKundenVorname().equals("")) {
            if (kunde == null) {
                kunde = new Kunde();
            }
            kunde.setVorname(this.mAnfrageSaveDialog.getKundenVorname());
        }
        if (this.mAnfrageSaveDialog.getKundenId() != null) {
            if (kunde == null) {
                kunde = new Kunde();
            }
            kunde.setKundenId(this.mAnfrageSaveDialog.getKundenId());
        }
        if (!(kunde == null || this.mAnfrageSaveDialog.getKundenId() == null || anfrage.getKunde() != null && this.mAnfrageSaveDialog.getKundenId().equals(anfrage.getKunde().getKundenId()))) {
            anfrage.setKunde(kunde);
        } else if (!(kunde == null || this.mAnfrageSaveDialog.getTfNachname().getText().equals(anfrage.getKunde().getName()) && this.mAnfrageSaveDialog.getTfVorname().getText().equals(anfrage.getKunde().getVorname()) || !this.mAnfrageSaveDialog.getKundenId().equals(anfrage.getKunde().getKundenId()))) {
            kunde.setKundenId(0);
            anfrage.setKunde(kunde);
        }
        String login = GlobalObjects.getInstance().getSessionInfo().getLogin();
        if (anfrage.getAnfrageId() != 0) {
            anfrage.setAenderungsNutzerId(login);
            anfrage.setAenderungsDatum(new Date());
        } else {
            anfrage.setAnlageDatum(new Date());
            anfrage.setAnlageNutzerId(login);
        }
        if (GlobalObjects.getInstance().getIpacData().isSpeicherKunde() && this.istKundeEingegeben()) {
            this.mKunde = this.speichereKunde(anfrage.getKunde());
            anfrage.setKunde(this.mKunde);
        }
        AnfragenDataLoader.speichereAnfrage(anfrage);
        if (ControllerKalkulationPanel.getInstance().getModel() != null) {
            if (this.mKunde != null && this.mAnfrageSaveDialog.getKundenId().intValue() == this.mKunde.getKundenId()) {
                anfrage.setKunde(this.mKunde);
            }
            ControllerKalkulationPanel.getInstance().getModel().setAnfrage(anfrage);
            if (ControllerKalkulationPanel.getInstance().getKalkulationView() != null) {
                ControllerKalkulationPanel.getInstance().getKalkulationView().update(ControllerKalkulationPanel.getInstance(), null);
            }
        }
        anfrage.setExplizitGespeichert(true);
        ClientKonfiguration.getClientKonfiguration().getKalkulationModel().setAnfrage(anfrage);
        ControllerMenuBar.getInstance().setSpeichern();
    }

    private boolean istKundeEingegeben() {
        return this.mAnfrageSaveDialog.getTfNachname() != null && !this.mAnfrageSaveDialog.getKundenNachname().equals("");
    }

    private Kunde speichereKunde(Kunde kunde) {
        Kunde k = null;
        try {
            k = CommonDataLoader.speichereKunde(kunde);
        }
        catch (DuplicateValueException e) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getErrorMsgKundennummer(), Resource.getInstance().getSpeicherfehler(), 0);
            Logger.getLogger(ControllerDialogKunde.class).error((Object)"Fehler beim Speichern eines Kunden. ", (Throwable)e);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getFehlerBeimAnlegenAendernDesNutzers(), Resource.getInstance().getSpeicherfehler(), 0);
            Logger.getLogger(ControllerDialogKunde.class).error((Object)"Fehler beim Speichern eines Kunden. ", (Throwable)e);
        }
        return k;
    }

    private void handleKundenAuswahl(String listenElement) {
        String txtIndex = listenElement.substring("AnfrageSaveListenElement".length());
        int index = Integer.parseInt(txtIndex);
        this.mKunde = this.mKundenListe.get(index);
        this.mAnfrageSaveDialog.setNachname(this.mKunde.getName());
        this.mAnfrageSaveDialog.setVorname(this.mKunde.getVorname());
        this.mAnfrageSaveDialog.setKundenId(this.mKunde.getKundenId());
    }

    public SaveDialogMouseListener getSdml() {
        return this.sdml;
    }

    private class SaveDialogMouseListener
    extends MouseAdapter {
        private SaveDialogMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            block19: {
                try {
                    ((ControllerAnfrageSave)ControllerAnfrageSave.this).mAnfrageSaveDialog.mDialog.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    if (e.getComponent().getName().equals("saveCancel") && ControllerAnfrageSave.this.mAnfrageSaveDialog.getCancelButton().isEnabled()) {
                        try {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                            ControllerAnfrageSave.this.mAnfrageSaveDialog.hideDialog();
                            break block19;
                        }
                        finally {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        }
                    }
                    if (e.getComponent().getName().equals("saveAction") && ControllerAnfrageSave.this.mAnfrageSaveDialog.getActionButton().isEnabled()) {
                        try {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                            ControllerAnfrageSave.this.handleSaveEvent();
                            ControllerAnfrageSave.this.mAnfrageSaveDialog.hideDialog();
                            break block19;
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ANFRAGE_SPEICHERN + ex.getMessage(), FEHLER_BEIM_SPEICHERN, 0);
                            ex.printStackTrace();
                            break block19;
                        }
                        finally {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        }
                    }
                    if (e.getComponent().getName().equals("suchen")) {
                        String kundenNachname = ControllerAnfrageSave.this.mAnfrageSaveDialog.getKundenNachname();
                        try {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                            if (kundenNachname != null && kundenNachname != "") {
                                ControllerAnfrageSave.this.sucheNachKundenname(kundenNachname);
                            }
                            break block19;
                        }
                        finally {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        }
                    }
                    if (e.getComponent().getName().startsWith("AnfrageSaveListenElement")) {
                        ControllerAnfrageSave.this.handleKundenAuswahl(e.getComponent().getName());
                    }
                }
                finally {
                    ((ControllerAnfrageSave)ControllerAnfrageSave.this).mAnfrageSaveDialog.mDialog.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                }
            }
        }
    }

    private class ItemDocumentListener
    implements DocumentListener {
        private ItemDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setKundenNrNull();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setKundenNrNull();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setKundenNrNull();
        }

        private void setKundenNrNull() {
            ControllerAnfrageSave.this.mAnfrageSaveDialog.setKundenId(0);
        }
    }
}

