/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.zub.common.CommonDataLoader;
import de.esg.zub.common.DialogKunde;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.MaskeKundendaten;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import webetk.DuplicateValueException;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;

public class ControllerDialogKunde
implements ActionListener,
MouseListener,
CaretListener {
    private static Logger log = Logger.getLogger(ControllerDialogKunde.class);
    public static final int LENGTH_KUNDENNUMMER = 7;
    public static final int MAX_LENGTH_KUNDENNAME = 40;
    private DialogKunde mDialog = null;
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();
    private static ControllerDialogKunde mInstance;
    private int mState;
    private static final int STATE_SUCHE = 1;
    private static final int STATE_EDIT = 2;
    private ArrayList<Kunde> mKundenListe;
    private Kunde mKunde;
    private int selectionStartKundennummer = 0;

    private ControllerDialogKunde() {
        this.mDialog = new DialogKunde(MainController.getInstance().getMainFrame(), Resource.getInstance().getKundeSuchen(), this.mLayout, new Dimension(600, 250));
        this.mDialog.getAbstractDialog().setResizable(false);
        this.addListeners();
        this.mDialog.getActionButton().addMouseListener(this);
        this.mDialog.getCancelButton().addMouseListener(this);
    }

    public static ControllerDialogKunde getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerDialogKunde();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String txtKundenname;
        if (e.getSource() == this.mDialog.getTfKundennummer()) {
            String txtKundennummer = this.mDialog.getTfKundennummer().getText();
            if (txtKundennummer != null && txtKundennummer.length() > 0) {
                Cursor oldCursor = this.mDialog.getTfKundennummer().getCursor();
                try {
                    this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    this.mDialog.getTfKundennummer().setCursor(Cursor.getPredefinedCursor(3));
                    this.sucheNachKundennummer(txtKundennummer);
                }
                finally {
                    this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                    this.mDialog.getTfKundennummer().setCursor(oldCursor);
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                }
            }
        } else if (e.getSource() == this.mDialog.getTfKundenname() && (txtKundenname = this.mDialog.getTfKundenname().getText()) != null && txtKundenname.length() > 0) {
            if (txtKundenname.length() > 40) {
                txtKundenname = txtKundenname.substring(0, 40);
            }
            Cursor oldCursor = this.mDialog.getTfKundenname().getCursor();
            try {
                this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mDialog.getTfKundenname().setCursor(Cursor.getPredefinedCursor(3));
                this.sucheNachKundenname(txtKundenname);
            }
            finally {
                this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                MainController.getInstance().getMainFrame().setDefaultCursor();
                this.mDialog.getTfKundenname().setCursor(oldCursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        Cursor oldCursor;
        javax.swing.JLabel label;
        if (e.getComponent() instanceof JLabelButton) {
            label = (JLabelButton)e.getComponent();
            if (label.getName().equals("saveCancel")) {
                oldCursor = label.getCursor();
                try {
                    this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                    label.setCursor(Cursor.getPredefinedCursor(3));
                    this.handleAbbrechen(e);
                }
                finally {
                    this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                    label.setCursor(oldCursor);
                }
            } else if (label.getName().equals("saveAction")) {
                oldCursor = label.getCursor();
                try {
                    this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                    label.setCursor(Cursor.getPredefinedCursor(3));
                    this.handleUebernehmen(e);
                }
                finally {
                    this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                    label.setCursor(oldCursor);
                }
            } else if (label.getName().equals("NewKunde") && ((JLabelButton)label).isEnabled()) {
                this.handleNeuerKunde();
            } else if (label.getName().equals("BearbeiteKunde") && ((JLabelButton)label).isEnabled() && this.mKunde != null) {
                this.handleBearbeiteKunde();
            }
        }
        if (e.getComponent() instanceof JLabel) {
            label = (JLabel)e.getComponent();
            oldCursor = label.getCursor();
            try {
                this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                label.setCursor(Cursor.getPredefinedCursor(3));
                if (label.getName().equals("Suchen")) {
                    this.handleSucheKunde(e);
                } else if (label.getName().length() > "DialogKundeListenElement".length() && label.getName().startsWith("DialogKundeListenElement")) {
                    this.handleKundenAuswahl(label.getName());
                }
            }
            finally {
                this.mDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                label.setCursor(oldCursor);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JLabel label;
        if (e.getComponent() instanceof JLabel && (label = (JLabel)e.getComponent()).getName().equals("Suchen")) {
            label.setIcon(ImageCache.getInstance().getIcon(this.mLayout.getIconPath() + "suchen_mouseOver.gif"));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JLabel label;
        if (e.getComponent() instanceof JLabel && (label = (JLabel)e.getComponent()).getName().equals("Suchen")) {
            label.setIcon(ImageCache.getInstance().getIcon(this.mLayout.getIconPath() + "suchen_aktiv.gif"));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.mDialog.getMaskeKundendaten() != null && (e.getSource() == this.mDialog.getMaskeKundendaten().getTfKundennummer() || e.getSource() == this.mDialog.getMaskeKundendaten().getTfName())) {
            boolean valid = this.isKundennummerComplete(this.mDialog.getMaskeKundendaten().getTfKundennummer().getText()) && this.isKundennameValid(this.mDialog.getMaskeKundendaten().getTfName().getText());
            this.mDialog.setActionButtonEnabled(valid);
        }
    }

    public Kunde getKunde(String kundennummer, String kundenname) {
        this.mState = 1;
        this.mKunde = null;
        this.setSuchenEnabled(true);
        this.mDialog.getTfKundennummer().setText(kundennummer);
        this.mDialog.getTfKundenname().setText(kundenname);
        if (kundennummer != null && !kundennummer.equals("")) {
            this.sucheNachKundennummer(kundennummer);
        } else if (kundenname != null && !kundenname.equals("")) {
            this.sucheNachKundenname(kundenname);
        }
        this.updatePanel();
        this.mDialog.showDialog(this.mLayout);
        if (this.mDialog.getDialogResult() == 1) {
            this.mDialog.hideDialog();
            return this.mKunde;
        }
        this.mDialog.hideDialog();
        return null;
    }

    private void handleSucheKunde(MouseEvent e) {
        String txtKdNummer = this.mDialog.getTfKundennummer().getText();
        String txtKdName = this.mDialog.getTfKundenname().getText();
        if (this.isKundennummerValid(txtKdNummer)) {
            this.sucheNachKundennummer(txtKdNummer);
        } else if (this.isKundennameValid(txtKdName)) {
            this.sucheNachKundenname(txtKdName);
        }
    }

    private void handleNeuerKunde() {
        this.mState = 2;
        this.setSuchenEnabled(false);
        this.mDialog.showMaskeKundendaten(null);
        boolean valid = this.isKundennummerComplete(this.mDialog.getMaskeKundendaten().getTfKundennummer().getText()) && this.isKundennameValid(this.mDialog.getMaskeKundendaten().getTfName().getText());
        this.mDialog.setActionButtonEnabled(valid);
    }

    private void handleBearbeiteKunde() {
        this.mState = 2;
        this.setSuchenEnabled(false);
        this.mDialog.showMaskeKundendaten(this.mKunde);
        boolean valid = this.isKundennummerComplete(this.mDialog.getMaskeKundendaten().getTfKundennummer().getText()) && this.isKundennameValid(this.mDialog.getMaskeKundendaten().getTfName().getText());
        this.mDialog.setActionButtonEnabled(valid);
    }

    private void handleAbbrechen(MouseEvent e) {
        if (this.mState == 2) {
            if (this.mKunde == null) {
                this.mDialog.getTfKundennummer().setText("");
                this.mDialog.getTfKundenname().setText("");
            } else {
                this.mDialog.getTfKundennummer().setText(this.mKunde.getKundennummer());
                this.mDialog.getTfKundenname().setText(this.mKunde.getName());
            }
            this.setSuchenEnabled(true);
            this.mDialog.hideZusatzPanel();
            this.mState = 1;
        } else {
            this.mDialog.setDialogResult(-1);
            this.mDialog.getAbstractDialog().dispose();
        }
    }

    private void setSuchenEnabled(boolean enabled) {
        this.removeListeners();
        if (enabled) {
            this.addListeners();
        }
        this.mDialog.getTfKundennummer().setEditable(enabled);
        this.mDialog.getTfKundenname().setEditable(enabled);
        this.mDialog.changeButtonsLayout(enabled, this.mKunde != null);
    }

    private void addListeners() {
        log.debug((Object)"addListeners");
        this.mDialog.getButNeuerKunde().addMouseListener(this);
        this.mDialog.getButBearbeiteKunde().addMouseListener(this);
        this.mDialog.getButSuchen().addMouseListener(this);
        this.mDialog.getTfKundennummer().addActionListener(this);
        this.mDialog.getTfKundenname().addActionListener(this);
    }

    public void addMaskeCaretListener(MaskeKundendaten kundenDaten) {
        if (this.mDialog != null && kundenDaten != null) {
            kundenDaten.getTfKundennummer().addCaretListener(this);
            kundenDaten.getTfName().addCaretListener(this);
        }
    }

    private void removeListeners() {
        this.mDialog.getButNeuerKunde().removeMouseListener(this);
        this.mDialog.getButBearbeiteKunde().removeMouseListener(this);
        this.mDialog.getButSuchen().removeMouseListener(this);
        this.mDialog.getTfKundennummer().removeActionListener(this);
        this.mDialog.getTfKundenname().removeActionListener(this);
    }

    private void handleUebernehmen(MouseEvent e) {
        if (this.mDialog.isActionButtonEnabled()) {
            if (this.mState == 1) {
                this.mDialog.setDialogResult(1);
                this.mDialog.getAbstractDialog().dispose();
                ControllerKalkulationPanel.getInstance().getKalkulationView().getPanFirma().getTfKundenNr().setText(this.mKunde.getKundennummer());
            } else if (this.mState == 2) {
                this.mKunde = this.speichereKunde();
                this.mDialog.setDialogResult(1);
                if (this.mKunde != null) {
                    this.mDialog.getAbstractDialog().dispose();
                }
                if (this.mKunde != null) {
                    ControllerKalkulationPanel.getInstance().getKalkulationView().getPanFirma().getTfKundenNr().setText(this.mKunde.getKundennummer());
                }
            }
        }
    }

    private void handleKundenAuswahl(String listenElement) {
        String txtIndex = listenElement.substring("DialogKundeListenElement".length());
        int index = Integer.parseInt(txtIndex);
        this.mKunde = this.mKundenListe.get(index);
        this.mDialog.getTfKundennummer().setText(this.mKunde.getKundennummer());
        this.mDialog.getTfKundenname().setText(this.mKunde.getName());
        this.mDialog.setActionButtonEnabled(true);
        this.updatePanel();
    }

    private boolean isKundennummerValid(String kdnummer) {
        if (kdnummer.length() > 0 && kdnummer.length() <= 7) {
            try {
                Integer.parseInt(kdnummer);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isKundennummerComplete(String kdnummer) {
        if (kdnummer.length() <= 7 && kdnummer.length() > 0) {
            try {
                Integer.parseInt(kdnummer);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isKundennameValid(String kdname) {
        return kdname.length() > 0 && kdname.length() <= 40;
    }

    public Kunde sucheNachKundennummer(String kundennummer) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuNummer(kundennummer);
        if (this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            this.mDialog.setActionButtonEnabled(true);
            this.selectionStartKundennummer = this.mDialog.getTfKundennummer().getText().length();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKunde.this.mDialog.getTfKundennummer().setText(ControllerDialogKunde.this.mKunde.getKundennummer());
                    ControllerDialogKunde.this.mDialog.getTfKundenname().setText(ControllerDialogKunde.this.mKunde.getName());
                    ControllerDialogKunde.this.mDialog.getTfKundennummer().select(ControllerDialogKunde.this.selectionStartKundennummer, 7);
                }
            });
        } else {
            this.mKunde = null;
            this.mDialog.setActionButtonEnabled(false);
            this.selectionStartKundennummer = 0;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKunde.this.mDialog.getTfKundenname().setText("");
                }
            });
        }
        this.mDialog.showKundenListe(this.mKundenListe);
        return this.mKunde;
    }

    private Kunde sucheNachKundenname(String kundenname) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuName(kundenname);
        if (this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            this.mDialog.setActionButtonEnabled(true);
            this.selectionStartKundennummer = this.mDialog.getTfKundenname().getText().length();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKunde.this.mDialog.getTfKundennummer().setText(ControllerDialogKunde.this.mKunde.getKundennummer());
                    ControllerDialogKunde.this.mDialog.getTfKundenname().setText(ControllerDialogKunde.this.mKunde.getName());
                    ControllerDialogKunde.this.mDialog.getTfKundenname().select(ControllerDialogKunde.this.selectionStartKundennummer, ControllerDialogKunde.this.mDialog.getTfKundenname().getText().length());
                }
            });
        } else {
            this.mKunde = null;
            this.mDialog.setActionButtonEnabled(false);
            this.selectionStartKundennummer = 0;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKunde.this.mDialog.getTfKundennummer().setText("");
                }
            });
        }
        this.mDialog.showKundenListe(this.mKundenListe);
        return this.mKunde;
    }

    private Kunde speichereKunde() {
        Kunde k = null;
        try {
            k = CommonDataLoader.speichereKunde(this.mDialog.getMaskeKundendaten().getKunde());
        }
        catch (DuplicateValueException e) {
            JOptionPane.showMessageDialog((Component)this.mDialog.getAbstractDialog().getContentPane(), Resource.getInstance().getErrorMsgKundennummer(), Resource.getInstance().getSpeicherfehler(), 0);
            Logger.getLogger(ControllerDialogKunde.class).error((Object)"Fehler beim Speichern eines Kunden. ", (Throwable)e);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getFehlerBeimAnlegenAendernDesNutzers(), Resource.getInstance().getSpeicherfehler(), 0);
            Logger.getLogger(ControllerDialogKunde.class).error((Object)"Fehler beim Speichern eines Kunden. ", (Throwable)e);
        }
        return k;
    }

    public void updatePanel() {
        this.mDialog.changeButtonsLayout(this.mState == 1, this.mKunde != null);
    }
}

