/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GkiZugriffException;
import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.DialogKundeKeyReader;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Kunde;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class ControllerDialogKundeKeyReader
implements KeyListener,
MouseListener {
    static Logger log = Logger.getLogger(ControllerDialogKundeKeyReader.class);
    public static final int LENGTH_KUNDENNUMMER = 7;
    public static final int MAX_LENGTH_KUNDENNAME = 40;
    private DialogKundeKeyReader mDialogKunde = null;
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();
    private static ControllerDialogKundeKeyReader mInstance;
    private ArrayList<Kunde> mKundenListe;
    private Kunde mKunde;
    private int selectionStartKundennummer = 0;

    private ControllerDialogKundeKeyReader() {
        this.mDialogKunde = new DialogKundeKeyReader(MainController.getInstance().getMainFrame(), Resource.getInstance().getKundeSuchen(), this.mLayout, new Dimension(520, 240));
        this.mDialogKunde.getAbstractDialog().setResizable(false);
        this.addListeners();
        this.mDialogKunde.getActionButton().addMouseListener(this);
        this.mDialogKunde.getCancelButton().addMouseListener(this);
        this.mDialogKunde.getTfKundenname().addKeyListener(this);
        this.mDialogKunde.getTfKundennummer().addKeyListener(this);
    }

    public static ControllerDialogKundeKeyReader getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerDialogKundeKeyReader();
        }
        return mInstance;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JLabel label;
        if (e.getComponent() instanceof JLabel && (label = (JLabel)e.getComponent()).getName().equals("Suchen")) {
            label.setIcon(ImageCache.getInstance().getIcon(this.mLayout.getIconPath() + "suchen_mouseOver.gif"));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JLabel label;
        if (e.getComponent() instanceof JLabel && (label = (JLabel)e.getComponent()).getName().equals("Suchen")) {
            label.setIcon(ImageCache.getInstance().getIcon(this.mLayout.getIconPath() + "suchen_aktiv.gif"));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        javax.swing.JLabel label;
        if (e.getButton() == 3) {
            return;
        }
        if (e.getComponent() instanceof JLabel) {
            label = (JLabel)e.getComponent();
            if (e.getClickCount() == 1) {
                int i;
                int index;
                String txtIndex;
                if (label.getName().startsWith("ListenelementDialogkunde") && label.getName().length() > "ListenelementDialogkunde".length()) {
                    txtIndex = label.getName().substring("ListenelementDialogkunde".length());
                    index = Integer.parseInt(txtIndex);
                    for (i = 0; i < this.mDialogKunde.getAktuellKundenListe().size(); ++i) {
                        this.mDialogKunde.getKundenPanels().get(i).setBackground(this.mLayout.getPrimaryBackground());
                        this.mDialogKunde.getAktuellKundenListe().get(i).setForeground(this.mLayout.getPrimaryForeground());
                    }
                    this.handleKundenAuswahl(index);
                    this.mDialogKunde.getKundenPanels().get(index).setBackground(this.mLayout.getSelectedReiterBackground());
                    label.setForeground(this.mLayout.getSelectedReiterForeground());
                }
                if (label.getName().startsWith("ListenelementFahrzeugdaten") && label.getName().length() > "ListenelementFahrzeugdaten".length()) {
                    if (this.mDialogKunde.getModus().equals("Fahrzeugsicht")) {
                        txtIndex = label.getName().substring("ListenelementFahrzeugdaten".length());
                        index = Integer.parseInt(txtIndex);
                        for (i = 0; i < this.mDialogKunde.getFahrzeugPanels().size(); ++i) {
                            this.mDialogKunde.getFahrzeugPanels().get(i).setBackground(this.mLayout.getPrimaryBackground());
                            this.mDialogKunde.getAktuellFahrzeugListe().get(i).setForeground(this.mLayout.getPrimaryForeground());
                        }
                        this.mDialogKunde.getFahrzeugPanels().get(index).setBackground(this.mLayout.getSelectedReiterBackground());
                        label.setForeground(this.mLayout.getSelectedReiterForeground());
                    } else {
                        txtIndex = label.getName().substring("ListenelementFahrzeugdaten".length());
                        index = Integer.parseInt(txtIndex);
                        this.fahrzeugeAnzeigen((JLabel)label, index);
                    }
                } else if (e.getSource() == this.mDialogKunde.getKeyReaderLabel()) {
                    if (GlobalObjects.getInstance().isKeyReaderAktiv() && GlobalObjects.getInstance().existiertKeyreaderFile()) {
                        this.einlesenKeyReaderDatei();
                    } else {
                        JOptionPane.showMessageDialog((Component)MainView.getInstance(), Resource.getInstance().getKeinKeyreader(), Resource.getInstance().getFehlerKeyreader(), 0);
                    }
                } else if (label.getName().equals("Suchen")) {
                    Cursor oldCursor = label.getCursor();
                    try {
                        this.mDialogKunde.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                        label.setCursor(Cursor.getPredefinedCursor(3));
                        MainController.getInstance().getMainFrame().setBusiCursor();
                        this.handleSucheKunde();
                    }
                    finally {
                        this.mDialogKunde.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                        label.setCursor(oldCursor);
                        MainController.getInstance().getMainFrame().setDefaultCursor();
                    }
                }
            } else if (e.getSource() != this.mDialogKunde.getSuchenButton() && !this.mDialogKunde.getModus().equals("Fahrzeugsicht")) {
                String txtIndex = label.getName().substring("ListenelementDialogkunde".length());
                int index = Integer.parseInt(txtIndex);
                this.fahrzeugeAnzeigen((JLabel)label, index);
            }
        }
        if (e.getComponent() instanceof JLabelButton) {
            label = (JLabelButton)e.getComponent();
            if (label.getName().equals("saveCancel")) {
                this.handleAbbrechen(e);
            } else if (label.getName().equals("saveAction")) {
                this.handleUebernehmen(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && (e.getSource() == this.mDialogKunde.getTfKundenname() || e.getSource() == this.mDialogKunde.getTfKundennummer())) {
            Cursor oldCursor;
            if (e.getSource() == this.mDialogKunde.getTfKundenname()) {
                oldCursor = ((JTextField)e.getSource()).getCursor();
                try {
                    this.mDialogKunde.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                    this.mDialogKunde.getTfKundenname().setCursor(Cursor.getPredefinedCursor(3));
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    if (this.isKundennameValid(this.mDialogKunde.getTfKundenname().getText())) {
                        this.sucheNachKundenname(this.mDialogKunde.getTfKundenname().getText());
                    }
                }
                finally {
                    this.mDialogKunde.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                    this.mDialogKunde.getTfKundenname().setCursor(oldCursor);
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                }
            }
            if (e.getSource() == this.mDialogKunde.getTfKundennummer()) {
                oldCursor = ((JFormattedTextField)e.getSource()).getCursor();
                try {
                    this.mDialogKunde.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                    this.mDialogKunde.getTfKundennummer().setCursor(Cursor.getPredefinedCursor(3));
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    if (this.isKundennummerValid(this.mDialogKunde.getTfKundennummer().getText())) {
                        this.sucheNachKundennummer(this.mDialogKunde.getTfKundennummer().getText());
                    }
                }
                finally {
                    this.mDialogKunde.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                    this.mDialogKunde.getTfKundennummer().setCursor(oldCursor);
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                }
            }
        }
    }

    public void fahrzeugeAnzeigen(JLabel label, int index) {
        for (int i = 0; i < this.mDialogKunde.getAktuellKundenListe().size(); ++i) {
            this.mDialogKunde.getAktuellKundenListe().get(i).setBackground(this.mLayout.getPrimaryBackground());
            this.mDialogKunde.getAktuellKundenListe().get(i).setForeground(this.mLayout.getPrimaryForeground());
        }
        this.handleKundenAuswahl(index);
        this.handleFahrzeugAuswahl(index);
        label.setBackground(this.mLayout.getSelectedReiterBackground());
        label.setForeground(this.mLayout.getSelectedReiterForeground());
    }

    public Kunde getKunde(String kundennummer, String kundenname) {
        this.mKunde = null;
        this.setSuchenEnabled(true);
        this.mDialogKunde.getTfKundennummer().setText(kundennummer);
        this.mDialogKunde.getTfKundenname().setText(kundenname);
        if (kundennummer != null && !kundennummer.equals("")) {
            this.sucheNachKundennummer(kundennummer);
        } else if (kundenname != null && !kundenname.equals("")) {
            this.sucheNachKundenname(kundenname);
        }
        this.mDialogKunde.showDialog(this.mLayout);
        if (this.mDialogKunde.getDialogResult() == 1) {
            this.mDialogKunde.hideDialog();
            return this.mKunde;
        }
        this.mDialogKunde.hideDialog();
        return null;
    }

    private void handleSucheKunde() {
        String txtKdNummer = this.mDialogKunde.getTfKundennummer().getText();
        String txtKdName = this.mDialogKunde.getTfKundenname().getText();
        if (this.isKundennummerValid(txtKdNummer)) {
            this.sucheNachKundennummer(txtKdNummer);
        } else if (this.isKundennameValid(txtKdName)) {
            this.sucheNachKundenname(txtKdName);
        }
    }

    private void handleAbbrechen(MouseEvent e) {
        this.mDialogKunde.setDialogResult(-1);
        this.mDialogKunde.getAbstractDialog().dispose();
    }

    private void setSuchenEnabled(boolean enabled) {
        this.removeListeners();
        if (enabled) {
            this.addListeners();
        }
        this.mDialogKunde.getTfKundennummer().setEditable(enabled);
        this.mDialogKunde.getTfKundenname().setEditable(enabled);
        this.mDialogKunde.getSuchenButton().setIcon(ImageCache.getInstance().getIcon(this.mLayout.getIconPath() + "suchen_aktiv.gif"));
    }

    private void addListeners() {
        HilfeMouseListener hilfeListener = new HilfeMouseListener("i50017");
        this.mDialogKunde.getButSuchen().addMouseListener(this);
        this.mDialogKunde.getButSuchen().addMouseListener(hilfeListener);
        if (GlobalObjects.getInstance().isKeyReaderAktiv() && GlobalObjects.getInstance().existiertKeyreaderFile()) {
            this.mDialogKunde.getKeyReaderLabel().addMouseListener(this);
        }
        this.mDialogKunde.getKeyReaderLabel().addMouseListener(hilfeListener);
        this.mDialogKunde.getTfKundennummer().addMouseListener(hilfeListener);
        this.mDialogKunde.getTfKundenname().addMouseListener(hilfeListener);
        this.mDialogKunde.getAbstractDialog().addMouseListener(hilfeListener);
    }

    private void removeListeners() {
        this.mDialogKunde.getButSuchen().removeMouseListener(this);
    }

    private void handleUebernehmen(MouseEvent e) {
        if (this.mDialogKunde.isActionButtonEnabled()) {
            if (this.mDialogKunde.getModus().equals("Kundensicht")) {
                int index = -1;
                for (int ii = 0; ii < this.mDialogKunde.getKundenPanels().size(); ++ii) {
                    if (!this.mDialogKunde.getKundenPanels().get(ii).getBackground().toString().equals(this.mLayout.getSelectedReiterBackground().toString())) continue;
                    index = ii;
                }
                if (index != -1) {
                    GlobalObjects.getInstance().getIpacData().setKunde(this.mKundenListe.get(index));
                }
                this.mDialogKunde.setDialogResult(1);
                this.mDialogKunde.getAbstractDialog().dispose();
            } else if (this.mDialogKunde.getModus().equals("Fahrzeugsicht")) {
                int index = -1;
                if (this.mDialogKunde.getFahrzeugPanels() != null) {
                    for (int ii = 0; ii < this.mDialogKunde.getFahrzeugPanels().size(); ++ii) {
                        if (!this.mDialogKunde.getFahrzeugPanels().get(ii).getBackground().toString().equals(this.mLayout.getSelectedReiterBackground().toString())) continue;
                        index = ii;
                    }
                }
                GlobalObjects.getInstance().getIpacData().setKunde(this.mKunde);
                if (index != -1) {
                    this.mDialogKunde.setVin(this.mDialogKunde.getMarkenFahrzeuge().get(index).getFahrgestellnummer());
                }
                this.mDialogKunde.setDialogResult(1);
                this.mDialogKunde.getAbstractDialog().dispose();
            }
        }
    }

    private void handleKundenAuswahl(int index) {
        this.mDialogKunde.setModus("Kundensicht");
        this.mKunde = this.mKundenListe.get(index);
        this.mDialogKunde.getTfKundennummer().setText(this.mKunde.getKundennummer());
        this.mDialogKunde.getTfKundenname().setText(this.mKunde.getName());
        this.mDialogKunde.setActionButtonEnabled(true);
        this.updatePanel();
    }

    private void handleFahrzeugAuswahl(int index) {
        this.mKunde = this.mKundenListe.get(index);
        this.mDialogKunde.showFahrzeugListe(this.mKunde);
        this.mDialogKunde.setActionButtonEnabled(true);
        this.updatePanel();
    }

    private boolean isKundennummerValid(String kdnummer) {
        if (kdnummer.length() > 0 && kdnummer.length() <= 7) {
            try {
                Integer.parseInt(kdnummer);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isKundennameValid(String kdname) {
        return kdname.length() > 0 && kdname.length() <= 40;
    }

    private void sucheNachKundennummer(String kundennummer) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuNummer(kundennummer);
        if (this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            this.mDialogKunde.setActionButtonEnabled(true);
            this.selectionStartKundennummer = this.mDialogKunde.getTfKundennummer().getText().length();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundennummer().setText(ControllerDialogKundeKeyReader.this.mKunde.getKundennummer());
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundenname().setText(ControllerDialogKundeKeyReader.this.mKunde.getName());
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundennummer().select(ControllerDialogKundeKeyReader.this.selectionStartKundennummer, 7);
                }
            });
        } else {
            this.mKunde = null;
            this.mDialogKunde.setActionButtonEnabled(false);
            this.selectionStartKundennummer = 0;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundenname().setText("");
                }
            });
        }
        this.mDialogKunde.showKundenListe(this.mKundenListe);
        this.updatePanel();
    }

    private void sucheNachKundenname(String kundenname) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuName(kundenname);
        if (this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            this.mDialogKunde.setActionButtonEnabled(true);
            this.selectionStartKundennummer = this.mDialogKunde.getTfKundenname().getText().length();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundennummer().setText(ControllerDialogKundeKeyReader.this.mKunde.getKundennummer());
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundenname().setText(ControllerDialogKundeKeyReader.this.mKunde.getName());
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundenname().select(ControllerDialogKundeKeyReader.this.selectionStartKundennummer, ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundenname().getText().length());
                }
            });
        } else {
            this.mKunde = null;
            this.mDialogKunde.setActionButtonEnabled(false);
            this.selectionStartKundennummer = 0;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerDialogKundeKeyReader.this.mDialogKunde.getTfKundennummer().setText("");
                }
            });
        }
        if (this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
        }
        this.mDialogKunde.showKundenListe(this.mKundenListe);
        this.updatePanel();
    }

    private void einlesenKeyReaderDatei() {
        String vin = null;
        try {
            vin = GlobalObjects.getInstance().retrieveVinFromKeyReader(null, null);
        }
        catch (GkiZugriffException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            JOptionPane.showMessageDialog((Component)MainView.getInstance(), Resource.getInstance().getGetFahrgestellnummerKeyreaderFailed() + "\r\n" + ex.getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
        }
        this.mDialogKunde.setVin(vin);
        this.mDialogKunde.hideDialog();
        this.mDialogKunde.setDialogResult(1);
    }

    public void updatePanel() {
        this.mDialogKunde.setLayout();
    }

    public DialogKundeKeyReader getDialogKunde() {
        return this.mDialogKunde;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

