/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.Login;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.ExitEventListener;
import de.esg.commonclient.dialog.extras.login.DlgLoginController;
import de.esg.zub.common.LoginView;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MainFrame;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubMisc;

public class ControllerLoginView {
    private static Logger log = Logger.getLogger(ControllerLoginView.class);

    private void setzeServerSessionInfo() {
        TrfZubMisc misc = new TrfZubMisc(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.ANPASSEN_SESSIONINFO_IPAC);
        }
        catch (CommunicationException ex) {
            log.error((Object)"Kommunikationsfehler beim Anpassen der Sessioninfo am Server!", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), ex.getMessage());
        }
        if (misc.getError() != null) {
            log.error((Object)"Sonstiger Fehler beim Anpassen der Sessioninfo am Server", (Throwable)misc.getError());
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), misc.getError().getMessage());
        }
    }

    public void entry(String nutzer, MainFrame mainFrame) {
        log.debug((Object)"Login");
        DlgLoginController loginController = new DlgLoginController();
        loginController.addExitEventListener((ExitEventListener)new LoginDlgExitEventListener());
        LoginView loginView = new LoginView();
        loginController.init((DialogView)loginView, nutzer, (JFrame)mainFrame);
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (loginInfo.getLogin() == null) {
            log.debug((Object)"Login-Panel anzeigen");
            mainFrame.addPanel((JPanel)((Object)loginView));
            loginView.setFocus();
        } else {
            log.debug((Object)"Welcome-Panel anzeigen");
            if (!WorkflowController.getInstance().getActiveState().getName().equals("WELCOME") && !WorkflowController.getInstance().getActiveState().getName().equals("CONFIG")) {
                WorkflowController.getInstance().changeState("WELCOME");
            }
        }
    }

    private class LoginDlgExitEventListener
    implements ExitEventListener {
        private LoginDlgExitEventListener() {
        }

        public void exitDialog() {
            log.debug((Object)"Leaving login dialog");
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            Login.writeLoginName((String)"ZUB", (String)oLoginInfo.getLogin());
            ControllerLoginView.this.setzeServerSessionInfo();
            WorkflowController.getInstance().changeState("WELCOME");
        }
    }
}

