/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.ControllerDialogKunde;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.MaskeKundendaten;
import de.esg.zub.common.TextFieldPatternFormatter;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DialogKunde
extends AbstractDialog {
    private static Logger log = Logger.getLogger(DialogKunde.class);
    public static final String SUCHEN = "Suchen";
    public static final String NEW_KUNDE = "NewKunde";
    public static final String BEARBEITE_KUNDE = "BearbeiteKunde";
    public static final String LISTENELEMENT_DIALOGKUNDE = "DialogKundeListenElement";
    public static final int HEIGHT_LISTE = 200;
    public static final int HEIGHT_MASKE = 300;
    public static final int DIALOG_OK = 1;
    public static final int DIALOG_ABBRECHEN = -1;
    private int mDialogResult = -1;
    private JPanel mPanUeber;
    private JPanel mPanButtons;
    private JPanel mPanZusatz;
    private MaskeKundendaten mMaskeKundendaten;
    private JLabel mLabKundennummer;
    private JFormattedTextField mTfKundennummer;
    private JLabel mLabKundenname;
    private JTextField mTfKundenname;
    private JLabel mLabSuchenButton;
    private JLabelButton mButNeuerKunde;
    private JLabelButton mButBearbeiteKunde;
    private JLabel[] mLabKunde;

    public DialogKunde(JFrame owner, String title, MarkenLayout markenLayout, Dimension dialogSize) {
        super(owner, title, markenLayout, dialogSize);
        this.mDialog.setDefaultCloseOperation(2);
        this.createContentPane();
    }

    private void createContentPane() {
        log.debug((Object)"creating layout");
        this.mDialog.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.mPanUeber = this.getPanUeber();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(5, 5, 5, 5));
        this.mDialog.add((Component)this.mPanUeber, gbc);
        this.mPanButtons = this.getPanButtons();
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 3, 18, new Insets(5, 5, 5, 5));
        this.mDialog.add((Component)this.mPanButtons, gbc);
        this.mPanZusatz = new JPanel();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 1, 18, new Insets(0, 5, 0, 5));
        this.mDialog.add((Component)this.mPanZusatz, gbc);
        this.mButtonPanel = this.setButtonsPanel(Resource.getInstance().getUebernehmen(), Resource.getInstance().getAbbrechen(), false, 10);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 2, 10, new Insets(5, 5, 5, 5));
        this.mDialog.add((Component)this.mButtonPanel, gbc);
    }

    private JPanel getPanUeber() {
        if (this.mPanUeber == null) {
            this.mPanUeber = new JPanel();
            this.mPanUeber.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.mLabKundennummer = new JLabel(Resource.getInstance().getKundennummer() + ":");
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(15, 8, 0, 0));
            this.mPanUeber.add((Component)this.mLabKundennummer, gbc);
            this.mLabKundenname = new JLabel(Resource.getInstance().getKundenname() + ":");
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(15, 8, 0, 0));
            this.mPanUeber.add((Component)this.mLabKundenname, gbc);
            Pattern pKundennummer = Pattern.compile("[0-9]{0,7}");
            TextFieldPatternFormatter format = new TextFieldPatternFormatter(pKundennummer);
            format.setAllowsInvalid(false);
            this.mTfKundennummer = new JFormattedTextField(format);
            this.mTfKundennummer.setPreferredSize(new Dimension(100, 19));
            this.mTfKundennummer.setMinimumSize(new Dimension(100, 19));
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 0, 18, new Insets(14, 5, 0, 15));
            this.mPanUeber.add((Component)this.mTfKundennummer, gbc);
            this.mTfKundenname = new JTextField(15);
            this.mTfKundenname.setMaxCharacters(40);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(14, 5, 0, 15));
            this.mPanUeber.add((Component)this.mTfKundenname, gbc);
            this.mLabSuchenButton = new JLabel();
            this.mLabSuchenButton.setName(SUCHEN);
            this.mLabSuchenButton.setCursor(Cursor.getPredefinedCursor(12));
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 0, 14, new Insets(15, 0, 15, 15));
            this.mPanUeber.add((Component)this.mLabSuchenButton, gbc);
        }
        return this.mPanUeber;
    }

    private JPanel getPanButtons() {
        if (this.mPanButtons == null) {
            this.mPanButtons = new JPanel();
            this.mPanButtons.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.mButNeuerKunde = new JLabelButton(Resource.getInstance().getNeuerKunde(), NEW_KUNDE, true, this.mMarkenLayout);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 10, 10, 10));
            this.mPanButtons.add((Component)this.mButNeuerKunde, gbc);
            this.mButBearbeiteKunde = new JLabelButton(Resource.getInstance().getKundeBearbeiten(), BEARBEITE_KUNDE, false, this.mMarkenLayout);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 10, 10, 10));
            this.mPanButtons.add((Component)this.mButBearbeiteKunde, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 0, 14, new Insets(0, 0, 0, 0));
            this.mPanButtons.add(Box.createVerticalGlue(), gbc);
        }
        return this.mPanButtons;
    }

    @Override
    public void hideDialog() {
        if (this.isVisible) {
            this.isVisible = false;
            this.mDialog.setVisible(this.isVisible);
        }
    }

    public void init() {
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.mMarkenLayout = markenLayout;
        this.setLayout();
        this.mDialog.setModal(true);
        this.mDialog.getContentPane().validate();
        this.hideZusatzPanel();
        this.mDialog.validate();
        this.mButNeuerKunde.setEnabled(true, this.mMarkenLayout);
        this.setDialogLocation();
        this.isVisible = true;
        this.mDialog.setVisible(this.isVisible);
        this.mDialog.validate();
    }

    @Override
    protected void setDialogLocation() {
        int xOwner = this.mOwner.getX();
        int yOwner = this.mOwner.getY();
        int wOwner = this.mOwner.getWidth();
        int hOwner = this.mOwner.getHeight();
        this.mDialog.setLocation(xOwner + wOwner / 2 - (this.mDialog.getWidth() / 2 - 100), yOwner + hOwner / 2 - (this.mDialog.getHeight() - 50));
    }

    public void showKundenListe(ArrayList<Kunde> kundeListe) {
        this.mPanZusatz.removeAll();
        this.mPanZusatz.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
        this.mPanZusatz.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
        int treffer = kundeListe.size();
        if (treffer > 1 && treffer <= 50) {
            this.mPanZusatz.add(this.getKundenListe(kundeListe));
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else if (treffer == 0) {
            this.mPanZusatz.add(this.getInfotext(Resource.getInstance().getKeineDatenGefunden()));
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else if (treffer > 50) {
            String text = StringUtils.substituteStringStraight(Resource.getInstance().getInfotextZuVieleTreffer(), "{0}", Integer.toString(treffer));
            this.mPanZusatz.add(this.getInfotext(text));
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else {
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height));
            this.hideZusatzPanel();
            this.changeButtonsLayout(true, true);
        }
        this.mPanZusatz.updateUI();
        this.mDialog.validate();
    }

    public void showMaskeKundendaten(Kunde kunde) {
        String frameHeader;
        if (kunde == null) {
            frameHeader = Resource.getInstance().getNeuerKunde();
            kunde = new Kunde();
        } else {
            frameHeader = Resource.getInstance().getKundeBearbeiten();
        }
        this.mPanZusatz.removeAll();
        this.mPanZusatz.setBorder(BorderFactory.createEmptyBorder());
        this.mPanZusatz.add(this.getMaske(frameHeader));
        this.fillMaske(kunde);
        this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 300));
        this.mPanZusatz.updateUI();
        this.mDialog.validate();
        this.mMaskeKundendaten.getTfKundennummer().requestFocusInWindow();
        this.mButNeuerKunde.setEnabled(false, this.mMarkenLayout);
    }

    public void hideZusatzPanel() {
        this.mButNeuerKunde.setEnabled(true, this.mMarkenLayout);
        this.mPanZusatz.setBorder(BorderFactory.createEmptyBorder());
        this.mPanZusatz.removeAll();
        this.mPanZusatz.updateUI();
        this.mDialog.setSize(this.mDialogSize);
        this.mDialog.validate();
    }

    private JScrollPane getKundenListe(ArrayList<Kunde> kundenListe) {
        JPanel panel = new JPanel();
        JScrollPane panelScroll = new JScrollPane(panel, 20, 31);
        panelScroll.setPreferredSize(new Dimension(this.mDialogSize.width - 30, 170));
        panelScroll.setBorder(BorderFactory.createEmptyBorder());
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        this.mLabKunde = new JLabel[kundenListe.size()];
        for (int ii = 0; ii < kundenListe.size(); ++ii) {
            this.mLabKunde[ii] = new JLabel("   " + kundenListe.get(ii).toString(), 2);
            this.mLabKunde[ii].setName(LISTENELEMENT_DIALOGKUNDE + ii);
            this.mLabKunde[ii].setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mLabKunde[ii].addMouseListener(ControllerDialogKunde.getInstance());
            this.mLabKunde[ii].setCursor(Cursor.getPredefinedCursor(12));
            panel.add(this.mLabKunde[ii]);
        }
        return panelScroll;
    }

    private JPanel getInfotext(String infoText) {
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel lab = new JLabel("<html>" + infoText + "</html>", 0);
        lab.setForeground(this.mMarkenLayout.getPrimaryForeground());
        panel.add(lab);
        return panel;
    }

    private JPanel getMaske(String frameHeader) {
        this.mMaskeKundendaten = new MaskeKundendaten();
        this.mMaskeKundendaten.setLayout(this.mMarkenLayout);
        this.mMaskeKundendaten.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 300));
        this.mMaskeKundendaten.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), frameHeader, 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
        return this.mMaskeKundendaten;
    }

    private void fillMaske(Kunde kunde) {
        this.mMaskeKundendaten.fill(kunde);
    }

    public void setLayout() {
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.getContentPane().setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mPanUeber.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getSuchenUeber(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
        this.mPanUeber.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mLabKundennummer.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mLabKundenname.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mButNeuerKunde.setLayout(this.mMarkenLayout);
        this.mButBearbeiteKunde.setLayout(this.mMarkenLayout);
        this.setButtonLayout();
        this.mPanZusatz.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getAktionen(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
        this.mPanButtons.setBackground(this.mMarkenLayout.getPrimaryBackground());
    }

    public void changeButtonsLayout(boolean aktiv, boolean kundeIdentified) {
        if (aktiv) {
            this.mLabSuchenButton.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_aktiv.gif"));
            this.mButNeuerKunde.setLayout(this.mMarkenLayout);
            this.mButBearbeiteKunde.setEnabled(kundeIdentified, this.mMarkenLayout);
            this.actionButton.setEnabled(kundeIdentified, this.mMarkenLayout);
        } else {
            this.mLabSuchenButton.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_inaktiv.gif"));
            this.mButNeuerKunde.setEnabled(false, this.mMarkenLayout);
            this.mButBearbeiteKunde.setEnabled(false, this.mMarkenLayout);
        }
    }

    public int getDialogResult() {
        return this.mDialogResult;
    }

    public void setDialogResult(int result) {
        this.mDialogResult = result;
    }

    public JLabelButton getButNeuerKunde() {
        return this.mButNeuerKunde;
    }

    public JLabelButton getButBearbeiteKunde() {
        return this.mButBearbeiteKunde;
    }

    public JLabel getButSuchen() {
        return this.mLabSuchenButton;
    }

    public JTextField getTfKundenname() {
        return this.mTfKundenname;
    }

    public JFormattedTextField getTfKundennummer() {
        return this.mTfKundennummer;
    }

    public MaskeKundendaten getMaskeKundendaten() {
        return this.mMaskeKundendaten;
    }
}

