/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.extras.login.DlgLoginController;
import de.esg.commonclient.dialog.extras.login.DlgLoginModel;
import de.esg.zub.common.Constants;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class LoginView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(LoginView.class);
    private DlgLoginModel model = null;
    private DlgLoginController controller = null;
    private JPanel contentPanel;
    private JPanel entryPane = new JPanel();
    private JLabel labelFiliale = new JLabel();
    private JLabel labelUsername = new JLabel();
    private JTextField textUsername = new JTextField(20);
    private JLabel labelPwd = new JLabel();
    private JPasswordField textPassword = new JPasswordField(20);
    private JTextField textFiliale = new JTextField(20);
    private JButtonEx buttonFiliale = new JButtonEx();
    private JButtonEx buttonLogin = new JButtonEx();
    private String msNutzer = null;

    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgContoller) {
        log.debug((Object)"init");
        this.model = (DlgLoginModel)oDlgModel;
        this.controller = (DlgLoginController)oDlgContoller;
        log.debug((Object)"loadFilialen");
        this.controller.loadFilialen(GlobalObjects.getInstance().getFirmaId());
        log.debug((Object)"Init components");
        this.initComponents();
        try {
            this.setupListeners();
        }
        catch (ClassCastException e) {
            log.error((Object)"Illegal initialization!", (Throwable)e);
            throw new IllegalComponentStateException("View called with wrong controller!");
        }
        if (GlobalObjects.getInstance().getIstStandalone() && this.controller.existiertEineFirmaFilialeNutzer() || this.model.getUserId() != null) {
            log.debug((Object)"Standalone single user");
            if (this.model.getUserId() != null) {
                this.textUsername.setText(this.model.getUserId());
            } else {
                this.textUsername.setText("admin");
            }
            this.loadFilialePasswort();
            this.textPassword.setText(this.model.getPasswort());
            this.buttonLogin.doClick();
        }
        this.textUsername.requestFocus();
    }

    public void update() throws IllegalStateException {
    }

    protected void setupListeners() {
        this.textPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginView.this.doLogin();
            }
        });
        this.buttonLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginView.this.doLogin();
            }
        });
        this.buttonFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bNutzerDarfFilialeAendern = LoginView.this.controller.doLoginFilialeAendern(LoginView.this.textUsername.getText());
                if (bNutzerDarfFilialeAendern) {
                    LoginView.this.textFiliale.setText(LoginView.this.model.getFilialeBezeichnung());
                    LoginView.this.buttonLogin.requestFocus();
                }
            }
        });
        this.textUsername.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LoginView.this.msNutzer = LoginView.this.textUsername.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (LoginView.this.textUsername.getText().equals("score")) {
                    String sMeldung = Resource.getInstance().getLoginScoreNotAllowed();
                    JOptionPane.showMessageDialog((Component)LoginView.this.controller.getMainView(), sMeldung, Resource.getInstance().getLogin(), 1);
                    LoginView.this.textUsername.setText("");
                    LoginView.this.textUsername.requestFocus();
                    return;
                }
                LoginView.this.loadFilialePasswort();
            }
        });
        this.textFiliale.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LoginView.this.buttonLogin.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public void initMenus() {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.labelFiliale.setBigEtkFont();
        this.labelFiliale.setText(Resource.getInstance().getAnmeldenAnFiliale() + ":");
        this.textFiliale.setPreferredSize(new Dimension(250, 21));
        this.textFiliale.setEditable(false);
        this.labelUsername.setBigEtkFont();
        this.labelUsername.setText(Resource.getInstance().getNutzerId() + ":");
        this.textUsername.setPreferredSize(new Dimension(250, 21));
        EnhancedTextDocument ehDocUser = new EnhancedTextDocument(20, 0);
        this.textUsername.setDocument((Document)ehDocUser);
        this.labelPwd.setBigEtkFont();
        this.labelPwd.setText(Resource.getInstance().getPasswort() + ":");
        this.textPassword.setPreferredSize(new Dimension(250, 21));
        EnhancedTextDocument ehDocPasswort = new EnhancedTextDocument(20, 0);
        this.textPassword.setDocument((Document)ehDocPasswort);
        this.buttonFiliale.setFont(Constants.Layout.getZubBigEtkFont());
        this.buttonFiliale.setText(Resource.getInstance().getAndereFiliale() + "...");
        this.buttonFiliale.setEnabled(false);
        this.buttonLogin.setFont(Constants.Layout.getZubBigEtkFont());
        this.buttonLogin.setText(Resource.getInstance().getLogin());
        int nAnzahlFilialen = this.model.getAnzahlFilialen();
        if (nAnzahlFilialen <= 1) {
            this.buttonFiliale.setVisible(false);
        }
        this.createLayout();
    }

    private void createLayout() {
        int[] w = new int[]{20, 0, 5, 0, 5, 0, 20};
        int[] h = new int[]{30, 0, 5, 0, 5, 0, 8, 0, 30};
        HIGLayout entryLayout = new HIGLayout(w, h);
        entryLayout.setColumnWeight(1, 1);
        entryLayout.setColumnWeight(7, 1);
        entryLayout.setRowWeight(1, 1);
        entryLayout.setRowWeight(9, 1);
        this.entryPane.setLayout((LayoutManager)entryLayout);
        HIGConstraints hc = new HIGConstraints();
        this.entryPane.add((Component)this.labelUsername, hc.rc(2, 2, "r"));
        this.entryPane.add((Component)this.textUsername, hc.rc(2, 4, "l"));
        this.entryPane.add((Component)this.labelPwd, hc.rc(4, 2, "r"));
        this.entryPane.add((Component)this.textPassword, hc.rc(4, 4, "l"));
        this.entryPane.add((Component)this.labelFiliale, hc.rc(6, 2, "r"));
        this.entryPane.add((Component)this.textFiliale, hc.rc(6, 4, "l"));
        this.entryPane.add((Component)this.buttonFiliale, hc.rc(6, 6, "l"));
        this.entryPane.add((Component)this.buttonLogin, hc.rc(8, 4, "tl"));
        this.add(this.contentPanel, "Center");
        this.contentPanel.add((Component)this.entryPane, "Center");
    }

    private void loadFilialePasswort() {
        String sFirmaId = GlobalObjects.getInstance().getFirmaId();
        String sNutzerId = this.textUsername.getText();
        if (!this.textUsername.getText().equals(this.msNutzer) && sNutzerId.trim().length() != 0) {
            if (this.controller.existiertNutzerId(sFirmaId, sNutzerId)) {
                this.controller.loadDefaultFilialePasswort(sFirmaId, sNutzerId);
                this.textFiliale.setText(this.model.getFilialeBezeichnung());
                this.textUsername.setText(this.model.getUserId());
                this.textPassword.requestFocus();
                this.buttonFiliale.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog((Component)this.controller.getMainView(), Resource.getInstance().getNutzerNichtVorhanden(), Resource.getInstance().getAnmeldung(), 1);
                this.textFiliale.setText("");
                this.textUsername.setText("");
                this.textUsername.requestFocus();
                this.buttonFiliale.setEnabled(false);
            }
        }
    }

    private boolean checkEingaben() {
        String sUserId = this.textUsername.getText();
        String sPassword = new String(this.textPassword.getPassword());
        if (sUserId == null || sUserId.length() == 0) {
            log.debug((Object)"No username entered.");
            JOptionPane.showMessageDialog((Component)this.controller.getMainView(), Resource.getInstance().getNutzernameAngeben(), Resource.getInstance().getInformation(), 1);
            this.textUsername.requestFocus();
            return false;
        }
        if (sPassword == null || sPassword.length() == 0) {
            log.debug((Object)"No password entered.");
            JOptionPane.showMessageDialog((Component)this.controller.getMainView(), Resource.getInstance().getPasswortAngeben(), Resource.getInstance().getInformation(), 1);
            this.textPassword.requestFocus();
            return false;
        }
        if (!sPassword.toUpperCase().equals(this.model.getPasswort().toUpperCase())) {
            log.debug((Object)"Wrong password entered.");
            JOptionPane.showMessageDialog((Component)this.controller.getMainView(), Resource.getInstance().getPasswortNichtKorrekt(), Resource.getInstance().getInformation(), 1);
            this.textPassword.requestFocus();
            return false;
        }
        return true;
    }

    public void setFocus() {
        this.textUsername.requestFocus();
    }

    public void doLogin() {
        if (!this.checkEingaben()) {
            return;
        }
        String sFirmaId = GlobalObjects.getInstance().getFirmaId();
        String sFilialId = this.model.getFiliale();
        String sUserId = this.textUsername.getText();
        GlobalObjects.getInstance().getIpacData().setFilialName(this.model.getFilialeBezeichnung());
        this.controller.performLogin(sFirmaId, sFilialId, sUserId, this.model.getPasswort());
    }
}

