/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.IMainController;
import de.esg.commonclient.InitLogging;
import de.esg.commonclient.Login;
import de.esg.commonclient.SplashScreen;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.extras.login.DlgLoginController;
import de.esg.tools.win32.registry.WindowsRegistry;
import de.esg.zub.common.ControllerAgbDialog;
import de.esg.zub.common.MainFrame;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.welcome.ControllerWelcomePanel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.apache.log4j.Logger;
import webetk.ObjectLockedException;
import webetk.app.settings.EinstellungenBasis;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.CommController;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfString;
import webetk.communication.transferables.TrfZubSuche;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenController;
import webetk.javaclient.dialog.extras.login.DlgLoginView;
import webetk.javaclient.framework.WarumUpJAIImageLoader;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.utils.ExternalCommand;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.Marken;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class MainController
implements IMainController {
    private static Logger log;
    private MainFrame mMainFrame;
    private static MainController mControllerInstance;

    public static void main(String[] args) {
        int nThreadId = 0;
        String sNutzer = null;
        String sPort = null;
        String sProp = null;
        int nArg = 0;
        while (nArg + 1 <= args.length) {
            String sArg = args[nArg];
            if (sArg != null) {
                System.out.println("Aufrufargument: " + sArg);
                if (sArg.indexOf("threadid=") > -1) {
                    String sThreadId = sArg.substring(9);
                    if (sThreadId != null) {
                        System.out.println("ThreadId: " + sThreadId);
                        nThreadId = Integer.parseInt(sThreadId);
                    }
                } else if (sArg.indexOf("userid=") > -1) {
                    sNutzer = sArg.substring(7);
                    if (sNutzer != null) {
                        System.out.println("Nutzer: " + sNutzer);
                    }
                } else if (sArg.indexOf("serverport=") > -1) {
                    sPort = sArg.substring(11);
                    if (sPort != null) {
                        System.out.println("Port: " + sPort);
                    }
                } else if (sArg.indexOf("prop=") > -1 && (sProp = sArg.substring(5)) != null) {
                    System.out.println("Prop: " + sProp);
                    GlobalObjects.resetInstance();
                    GlobalObjects.setPropFileName((String)sProp);
                }
            }
            ++nArg;
        }
        GlobalObjects.setIpac((boolean)true);
        MetalLookAndFeel.setCurrentTheme((MetalTheme)new WebETKTheme());
        MainController.getInstance().init(sNutzer, nThreadId, sPort, sProp);
    }

    public void init(MainFrame pMainFrame) {
        this.mMainFrame = pMainFrame;
    }

    public void init(String nutzer, int threadID, String port, String sProp) {
        System.setProperty("sun.java2d.ddscale", "true");
        if (sProp != null) {
            InitLogging.initLogging((String)sProp, (boolean)true);
        } else {
            InitLogging.initLogging((String)GlobalObjects.getPropFileName(), (boolean)true);
        }
        log = Logger.getLogger(MainController.class);
        String language = GlobalObjects.getInstance().getLanguage();
        if (language != null) {
            Resource.setLanguage((String)language);
        } else {
            log.info((Object)"No language property found!");
        }
        log.debug((Object)"Hauptfenster anlegen");
        this.mMainFrame = new MainFrame();
        this.mMainFrame.addWindowListener(new MainFrameWindowListener());
        this.initCommController(port);
        this.mMainFrame.createAndShowGUI();
        log.debug((Object)"The GUI was started!");
        SplashScreen.hide((int)threadID);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        if (!this.isClientAktuell()) {
            System.exit(-2);
        }
        log.debug((Object)"starting login");
        if (nutzer == null || nutzer.length() < 1) {
            nutzer = Login.readLoginName((String)"ZUB");
        }
        WorkflowController.getInstance().changeToLoginState(nutzer, this.mMainFrame);
    }

    public void initFromETK(WindowListener etkListener, String btenr) {
        if (mControllerInstance != null && mControllerInstance.getMainFrame() != null) {
            mControllerInstance.getMainFrame().requestFocus();
            this.mMainFrame.setVisible(true);
            this.mMainFrame.validate();
            this.mMainFrame.setBusiCursor();
        } else {
            mControllerInstance = this;
            System.setProperty("sun.java2d.ddscale", "true");
            InitLogging.initLogging((String)GlobalObjects.getInstance().getPropertyFile(), (boolean)true);
            log = Logger.getLogger(MainController.class);
            log.debug((Object)"Hauptfenster anlegen");
            this.mMainFrame = new MainFrame();
            this.mMainFrame.addWindowListener(new MainFrameWindowListener());
            this.mMainFrame.addWindowListener(etkListener);
            this.mMainFrame.setDefaultCloseOperation(2);
            this.mMainFrame.setSize(this.mMainFrame.getFrameSize());
        }
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        ZubCustomizable.setMarktUndSprache(loginInfo.getSettings().getMarktKuerzel(), GlobalObjects.getInstance().getLanguage());
        boolean bFzg = MainController.setzeFahrzeug();
        WorkflowController.getInstance().setMarkenLayout(null, null);
        WorkflowController.getInstance().getMarkenLayout().setPossibleMarks(loginInfo.getUserMarken());
        WorkflowController.getInstance().getMarkenLayout().setPossibleProdukte(loginInfo.getUserProdukte());
        this.mMainFrame.setVisible(true);
        this.mMainFrame.validate();
        log.debug((Object)"The GUI was started!");
        boolean isUs = GlobalObjects.getInstance().getIpacData().isUs();
        if (!bFzg) {
            if (btenr != null) {
                if (GlobalObjects.getInstance().getEtkData().getAssSucheInfo() != null) {
                    String sMarke = GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getMarke();
                    String sProdukt = GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getProduktart();
                    ControllerWelcomePanel.setMarkeProduktartGlobal(sMarke, sProdukt);
                    ControllerMainPanel.getInstance();
                    ControllerMenuBar.getInstance();
                    ControllerStatusBar.getInstance();
                    ControllerSubCategoryPanel.getInstance();
                    ControllerProduktListPanel.getInstance();
                    ControllerInfoPanel.getInstance();
                    ControllerAgbDialog.getInstance().checkAgbBestaetigt();
                    this.initWithBtenr(btenr);
                } else {
                    log.error((Object)"Marke nicht gesetzt!");
                }
            } else {
                if (isUs) {
                    ControllerWelcomePanel.setMarkeProduktartGlobal(Marken.getInstance().getMarke("BMW").getBerechtigung(), Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
                }
                WorkflowController.getInstance().changeState("WELCOME");
            }
        } else {
            String sMarke = GlobalObjects.getInstance().getIpacData().getFahrzeug().getMarke();
            String sProdukt = GlobalObjects.getInstance().getIpacData().getFahrzeug().getProduktart();
            ControllerWelcomePanel.setMarkeProduktartGlobal(sMarke, sProdukt);
            ControllerMainPanel.getInstance();
            ControllerMenuBar.getInstance();
            ControllerStatusBar.getInstance();
            ControllerSubCategoryPanel.getInstance();
            ControllerProduktListPanel.getInstance();
            ControllerInfoPanel.getInstance();
            ControllerAgbDialog.getInstance().checkAgbBestaetigt();
            if (btenr != null) {
                if (this.pruefeBerechtigung(sMarke, sProdukt)) {
                    this.initWithBtenr(btenr);
                } else {
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(null);
                    WorkflowController.getInstance().changeState("WELCOME");
                }
            } else if (this.pruefeBerechtigung(sMarke, sProdukt)) {
                WorkflowController.getInstance().changeState("CONFIG");
            } else {
                GlobalObjects.getInstance().getIpacData().setFahrzeug(null);
                WorkflowController.getInstance().changeState("WELCOME");
            }
        }
    }

    private boolean pruefeBerechtigung(String marke, String produkt) {
        ArrayList<String> possibleMarkenUser = WorkflowController.getInstance().getMarkenLayout().getPossibleMarks();
        ArrayList<String> possibleProdukteUser = WorkflowController.getInstance().getMarkenLayout().getPossibleProdukte();
        Collection<String> possibleProdukteMarkt = GlobalObjects.getInstance().getSessionInfo().getSettings().getIPACMarkt() != null ? GlobalObjects.getInstance().getSessionInfo().getSettings().getIPACMarkt().getProdukte() : null;
        ArrayList<MarkeProdukt> lMarkenProdukte = MarkenProdukte.getInstance(2).getBerechtigteMarkenProdukte(possibleMarkenUser, possibleProdukteUser, possibleProdukteMarkt, null);
        for (MarkeProdukt oMarkeProdukt : lMarkenProdukte) {
            if (!marke.equals(oMarkeProdukt.getMarke()) || !produkt.equals(oMarkeProdukt.getProdukt())) continue;
            return true;
        }
        return false;
    }

    private void initWithBtenr(String btenr) {
        this.mMainFrame.addConfiguratorPanel(ControllerMainPanel.getInstance().getMainPanel(), WorkflowController.getInstance().getMarkenLayout());
        GlobalObjects.getInstance().getIpacData().setSelectedBte(btenr);
        GlobalObjects.getInstance().getIpacData().setSelectedBnb(null);
        WorkflowController.getInstance().changeState("CONFIG");
        StringBuffer hkBuf = new StringBuffer();
        HitListenUnterkategorie uk = NavigationPanelDataLoader.getHkUkZuProdukt(btenr, hkBuf);
        Integer hkId = new Integer(hkBuf.toString());
        HauptKategorie hk = ControllerNavigationPanel.getInstance().getNavigationPanel().getHauptKategorieZuId(hkId);
        WorkflowController.getInstance().setHauptKategorie(hk);
        WorkflowController.getInstance().setUnterkategorie(uk);
        ControllerNavigationPanel.getInstance().getNavigationPanel().getCategoryComboBox().setSelectedItem(hk.getName());
        int selectedIndex = ControllerNavigationPanel.getInstance().getNavigationPanel().getCategoryComboBox().getSelectedIndex();
        ControllerNavigationPanel.getInstance().handleCategoryItemStateChangedEvent(selectedIndex);
        ControllerNavigationPanel.getInstance().showUnterkategorienListe();
        ControllerNavigationPanel.getInstance().getNavigationPanel().getSubCategoryComboBox().setSelectedItem(uk);
        ControllerNavigationPanel.getInstance().handleSubCategoryItemStateChangedEvent();
        ControllerProduktListPanel.getInstance().showProduktListe();
        ArrayList<ProduktListenElement> produkte = ControllerProduktListPanel.getInstance().getProduktListPanel().getProduktList();
        if (produkte != null) {
            for (int i = 0; i < produkte.size(); ++i) {
                if (!produkte.get(i).getBteNr().equals(btenr)) continue;
                GlobalObjects.getInstance().getIpacData().setSelectedProdukt(produkte.get(i));
            }
            WorkflowController.getInstance().setNewKonfiguration(true);
            WorkflowController.getInstance().setAddKonfiguration(false);
            WorkflowController.getInstance().setAddKonfigurationDataSet(true);
            WorkflowController.getInstance().changeState("MARKETING");
        }
        this.mMainFrame.setDefaultCursor();
    }

    public void initFromISPA(String nutzerID, String passwort, String filialID, String sprache, String vin, String kundennummer, Integer angebotsnummer) {
        if (mControllerInstance != null && mControllerInstance.getMainFrame() != null) {
            mControllerInstance.getMainFrame().requestFocus();
            return;
        }
        mControllerInstance = this;
        MetalLookAndFeel.setCurrentTheme((MetalTheme)new WebETKTheme());
        WarumUpJAIImageLoader.warmUp();
        String key = "HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\EtkLauncher";
        String propFileName = WindowsRegistry.getValueAsString((String)key, (String)"instPath");
        if (propFileName != null) {
            propFileName = propFileName + "properties\\javaclient.properties";
            System.out.println("Property File aus Launcher Registry (key: " + key + ": " + propFileName);
            GlobalObjects.setPropFileName((String)propFileName);
        }
        InitLogging.initLogging((String)propFileName);
        GlobalObjects.getInstance();
        GlobalObjects.getInstance().getIpacData().setStartedFromISPA(true);
        GlobalObjects.getInstance().getIpacData().setVINfromISPA(vin);
        String language = GlobalObjects.getInstance().getLanguage();
        if (language != null) {
            Resource.setLanguage((String)language);
            WebETKTheme.changeFont((String)language.substring(0, 2));
        } else {
            log.info((Object)"No language property found!");
        }
        System.setProperty("sun.java2d.ddscale", "true");
        InitLogging.initLogging((String)GlobalObjects.getInstance().getPropertyFile(), (boolean)true);
        log = Logger.getLogger(MainController.class);
        log.debug((Object)"Hauptfenster anlegen");
        this.mMainFrame = new MainFrame();
        this.mMainFrame.addWindowListener(new MainFrameWindowListener());
        this.initCommController(null);
        this.mMainFrame.createAndShowGUI();
        log.debug((Object)"The GUI was created!");
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        String firmaID = GlobalObjects.getInstance().getFirmaId();
        DlgLoginController loginController = new DlgLoginController();
        loginController.init((DialogView)new DlgLoginView(), nutzerID, (JFrame)this.getMainFrame());
        if (!loginController.performLogin(firmaID, filialID, nutzerID, passwort)) {
            return;
        }
        MainController.setLanguage(sprache);
        this.mMainFrame.setDefaultCloseOperation(2);
        this.mMainFrame.setSize(this.mMainFrame.getFrameSize());
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        ZubCustomizable.setMarktUndSprache(loginInfo.getSettings().getMarktKuerzel(), GlobalObjects.getInstance().getLanguage());
    }

    protected static void setLanguage(String sprache) {
        log.debug((Object)("Sprache setzen: " + sprache));
        String etkSprache = MainController.changeScoreSpracheToEtkSprache(sprache);
        Resource.setLanguage((String)etkSprache);
        WebETKTheme.changeFont((String)etkSprache.substring(0, 2));
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        EinstellungenBasis settings = oLoginInfo.getSettings();
        settings.setSprache(etkSprache.substring(0, 2));
        if (etkSprache.length() == 4) {
            settings.setSpracheRegion(etkSprache.substring(2, 4));
        } else {
            settings.setSpracheRegion("  ");
        }
        DlgEinstellungenController.setEinstellungenInServerSessionInfo((EinstellungenBasis)settings);
    }

    protected static String changeScoreSpracheToEtkSprache(String scoreSprache) {
        log.debug((Object)("scoreSprache: " + scoreSprache));
        if (scoreSprache.indexOf("_") > -1) {
            scoreSprache = scoreSprache.substring(0, 2) + scoreSprache.substring(3, 5);
        }
        if (scoreSprache.indexOf("-") > -1) {
            scoreSprache = scoreSprache.substring(0, 2) + scoreSprache.substring(3, 5);
        }
        if (Resource.canSetLanguage((String)scoreSprache)) {
            return scoreSprache;
        }
        if (Resource.canSetLanguage((String)(scoreSprache = scoreSprache.substring(0, 2)))) {
            return scoreSprache;
        }
        scoreSprache = "en";
        log.debug((Object)("umgewandelt in: " + scoreSprache));
        return scoreSprache;
    }

    private static boolean setzeFahrzeug() {
        if (GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null) {
            GlobalObjects.getInstance().getIpacData().setFahrzeug(MainController.getFahrzeugFromJavaFzgSucheInfo(GlobalObjects.getInstance().getEtkData().getFzgSucheInfo(), GlobalObjects.getInstance().getFzgIdInfo()));
            return true;
        }
        return false;
    }

    private static Fahrzeug getFahrzeugFromJavaFzgSucheInfo(JavaFzgSucheInfo fzgSucheInfo, JavaFzgIdInfo fzgIdInfo) {
        TrfZubSuche trfSucheMap;
        Fahrzeug fahrzeug = null;
        if (fzgIdInfo != null && fzgIdInfo.getFahrgestellNr() != null && !fzgIdInfo.getFahrgestellNr().equals("")) {
            String sFgstNr = fzgIdInfo.getFahrgestellNr().equals(fzgSucheInfo.getFahrgestellnummer()) ? fzgIdInfo.getFahrgestellNr() : fzgSucheInfo.getFahrgestellnummer();
            trfSucheMap = new TrfZubSuche(null);
            trfSucheMap.setValue("vin", sFgstNr);
            trfSucheMap.setValue("produktart", fzgIdInfo.getProduktart());
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfSucheMap, Command.ERMITTLE_FAHRZEUGDATEN);
            }
            catch (CommunicationException e) {
                log.error((Object)"Fehler beim Laden eines Fahrzeugs: ", (Throwable)e);
            }
            fahrzeug = (Fahrzeug)trfSucheMap.getValue("fahrzeug");
        }
        if (fahrzeug == null) {
            String produktart = fzgIdInfo == null ? (fzgSucheInfo == null ? "" : fzgSucheInfo.getProduktart()) : fzgIdInfo.getProduktart();
            trfSucheMap = new TrfZubSuche(null);
            trfSucheMap.setValue("modellspaltenid", fzgSucheInfo.getModellspalte());
            trfSucheMap.setValue("produktart", produktart);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfSucheMap, Command.ERMITTLE_FAHRZEUGDATEN);
            }
            catch (CommunicationException e) {
                log.error((Object)"Fehler beim Laden eines Fahrzeugs: ", (Throwable)e);
            }
            fahrzeug = (Fahrzeug)trfSucheMap.getValue("fahrzeug");
        }
        if (fahrzeug != null) {
            fahrzeug.setBedingungsMenge(fzgSucheInfo.getBedingungsMenge());
            fahrzeug.setAusstattung(fzgSucheInfo.getAusstattung());
            fahrzeug.setGraphicSearch(fzgSucheInfo.getGraphicSearch());
            fahrzeug.setIGDOMFehler(fzgSucheInfo.getIGDOMFehler());
            fahrzeug.setSOWUFehler(fzgSucheInfo.getSOWUFehler());
            fahrzeug.setVINSpecFehler(fzgSucheInfo.getVINSpecFehler());
            fahrzeug.setTypmenge(fzgSucheInfo.getTypmenge());
            fahrzeug.setBedingungsMenge(fzgSucheInfo.getBedingungsMenge());
            fahrzeug.setBedingungsMenge_BTE(fzgSucheInfo.getBedingungsMenge_BTE());
            fahrzeug.setFzgIdString(fzgSucheInfo.getFzgIdString());
            fahrzeug.setBaujahr(fzgSucheInfo.getBaujahr());
            fahrzeug.setProduktionsdatum(fzgSucheInfo.getProduktionsdatum());
        }
        return fahrzeug;
    }

    private void initCommController(String port) {
        try {
            GlobalObjects globs = GlobalObjects.getInstance();
            String serverUrl = globs.getServerUrl();
            CommController.getInstance().init(serverUrl);
            log.info((Object)("init CommController with " + serverUrl));
            CommController commController = CommController.getInstance();
            if (port != null && port.length() > 0) {
                int nStart = serverUrl.lastIndexOf(":") + 1;
                int nEnde = serverUrl.indexOf("/", nStart) - 1;
                serverUrl = serverUrl.substring(0, nStart) + port + serverUrl.substring(nEnde + 1, serverUrl.length());
                log.debug((Object)("serverUrl " + serverUrl));
            }
            commController.init(serverUrl);
            int nConnectionTimeout = globs.getTimeoutConnection();
            int nSocketTimeout = globs.getTimeoutSocket();
            int nHttpConnectionFactoryTimeout = globs.getTimeoutConnection();
            commController.setTimeouts(nConnectionTimeout, nSocketTimeout, nHttpConnectionFactoryTimeout);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mMainFrame, ex.toString(), "Could not connect to ETK-Server", 0);
            log.fatal((Object)"Could not intialize the communication controller!", (Throwable)ex);
            this.exit(-2);
        }
    }

    public MainFrame getMainFrame() {
        return this.mMainFrame;
    }

    public static IMainController getIMainControllerInstance() {
        return MainController.getInstance();
    }

    public static MainController getInstance() {
        if (mControllerInstance == null) {
            mControllerInstance = new MainController();
        }
        return mControllerInstance;
    }

    public void exit(int exitCode) {
        this.onExit();
        if (GlobalObjects.isIpac()) {
            System.exit(0);
        } else {
            ControllerMainPanel.reset();
            ControllerMenuBar.reset();
            ControllerStatusBar.reset();
            WorkflowController.reset();
            ControllerInfoPanel.reset();
            ControllerWelcomePanel.reset();
            mControllerInstance = null;
            this.mMainFrame.dispose();
            this.mMainFrame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExit() {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            if (GlobalObjects.isIpac() && !WorkflowController.getInstance().getActiveState().getName().equals("LOGIN") && !WorkflowController.getInstance().getActiveState().getName().equals("WELCOME")) {
                WorkflowController.getInstance().changeState("WELCOME");
            }
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (loginInfo != null) {
            Login.deleteLoginName((String)"ZUB", (String)loginInfo.getLogin());
        }
        MainController.getInstance().getMainFrame().setHidden(true);
    }

    private boolean isClientAktuell() {
        String szClientVersion = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream("version.txt")));
            if (in != null) {
                String szLine = in.readLine();
                while (szLine != null) {
                    if (szLine.indexOf("Version.Programme=") == 0) {
                        szClientVersion = szLine.substring(18);
                        break;
                    }
                    szLine = in.readLine();
                }
                in.close();
            }
        }
        catch (IOException ex) {
            return true;
        }
        TrfString trf = new TrfString(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_PROGRAMM_VERSION);
        }
        catch (CommunicationException ex) {
            JOptionPane.showMessageDialog(this.mMainFrame, Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return false;
        }
        if (trf.getError() != null) {
            JOptionPane.showMessageDialog(this.mMainFrame, Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return false;
        }
        String szServerVersion = trf.getString();
        if (!szClientVersion.equals(szServerVersion)) {
            JOptionPane.showMessageDialog(this.mMainFrame, Resource.getInstance().getMsgClientVeraltet(), Resource.getInstance().getSonstigerFehler(), 0);
            String sSetupPath = GlobalObjects.getInstance().getSetupPath();
            String[] aCmds = new String[]{sSetupPath};
            ExternalCommand cmd = new ExternalCommand(aCmds, null, null);
            cmd.start();
            System.exit(0);
            return false;
        }
        return true;
    }

    static {
        mControllerInstance = null;
    }

    private class MainFrameWindowListener
    extends WindowAdapter {
        private MainFrameWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            log.debug((Object)"windowClosing");
            if (GlobalObjects.getInstance().getIpacData().getAnfrage() != null) {
                try {
                    AnfragenDataLoader.entsperreAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
                }
                catch (ObjectLockedException e1) {
                    log.error((Object)e1);
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
            MainController.this.exit(0);
        }
    }
}

