/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.ControllerAgbDialog;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.MainPanel;
import de.esg.zub.configurator.content.anfrage.AnfrageSucheBean;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.angebot.AngebotDataLoader;
import de.esg.zub.configurator.content.angebot.AngebotsSucheBean;
import de.esg.zub.configurator.content.angebot.ControllerAngebotsPanel;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.content.technisch.ArbeitHinzufuegenDialog;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.InfoPanel;
import de.esg.zub.configurator.navigation.miniatur.MiniaturKalkulationsPanel;
import de.esg.zub.configurator.navigation.miniatur.MiniaturMarketingPanel;
import de.esg.zub.configurator.navigation.miniatur.MiniaturTechnikPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.PrototypeMenuBar;
import de.esg.zub.configurator.workflow.StatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.ControllerWelcomePanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.verwaltung.AngebotsSuche;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(MainFrame.class);
    private Dimension mFrameSize;
    private Dimension mScreenSize;
    private Dimension mLeftDim;
    private Dimension mRightDim;
    private JPanel mConfiguratorPanel;
    private JPanel mActuellPanel;
    private JPanel mContainerKalkMiniatur;
    private JPanel mContainerTechMiniatur;
    private JPanel mContainerMarkMiniatur;
    private JPanel mContainerInfoMiniatur;
    private JPanel mContainerMiniaturansichten;
    private InfoPanel mInfoPanel;
    private MainPanel mMainPanel;
    private PrototypeMenuBar mMenuBar;
    private StatusBar mStatusBar;
    private MiniaturTechnikPanel dummyTech;
    private MiniaturMarketingPanel dummyMark;
    private GridBagConstraints gbc;
    private ArbeitHinzufuegenDialog arbeitHinzufuegen;
    protected boolean mHidden = false;

    public MainFrame() {
        this.setTitle(Resource.getInstance().getIpacTitel());
        Image img = ImageCache.getInstance().getImage("Icons/ai_etk.jpg");
        this.setIconImage(img);
        this.mScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mFrameSize = new Dimension(1024, 738);
        this.setSize(this.mFrameSize);
        this.setResizable(false);
        this.mLeftDim = new Dimension(208, 653);
        this.mRightDim = new Dimension(808, 653);
        this.mConfiguratorPanel = new JPanel(new GridBagLayout());
        this.mContainerInfoMiniatur = new JPanel(new CardLayout(0, 0));
        this.mContainerInfoMiniatur.setPreferredSize(this.mLeftDim);
        this.mContainerInfoMiniatur.setMinimumSize(this.mLeftDim);
        this.mContainerInfoMiniatur.setMaximumSize(this.mLeftDim);
        this.mContainerInfoMiniatur.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 4, new Color(212, 208, 200)));
    }

    public void createAndShowGUI() {
        log.debug((Object)"Showing MainFrame");
        this.setSize(this.mFrameSize);
        this.getContentPane().setBackground(WorkflowController.getInstance().getMarkenLayout().getSecondaryBackground());
        if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            this.mHidden = false;
        }
        this.validate();
    }

    public void addConfiguratorPanel(MainPanel mPanel, MarkenLayout mLayout) {
        log.debug((Object)"Showing ConfiguratorPanel");
        if (this.mActuellPanel != null) {
            this.remove(this.mActuellPanel);
        }
        if (this.mInfoPanel == null) {
            this.mInfoPanel = ControllerInfoPanel.getInstance().getInfoPanel();
            this.mInfoPanel.setName("INFOPANEL");
            this.mContainerInfoMiniatur.add((Component)this.mInfoPanel, "INFOPANEL");
        }
        this.mInfoPanel.setInitialLook();
        if (this.mMainPanel == null) {
            this.mMainPanel = mPanel;
            this.mMainPanel.setPreferredSize(this.mRightDim);
            this.mMainPanel.setMinimumSize(this.mRightDim);
            this.mMainPanel.setMaximumSize(this.mRightDim);
            this.gbc = new GridBagConstraints();
            this.gbc = mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(0, 0, 0, 0));
            this.mConfiguratorPanel.add((Component)this.mMainPanel, this.gbc);
        }
        this.gbc = mLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.mConfiguratorPanel.add((Component)this.mContainerInfoMiniatur, this.gbc);
        this.changeContainerInfoMiniatur("INFOPANEL");
        this.add(this.mConfiguratorPanel);
        this.mActuellPanel = this.mConfiguratorPanel;
        this.changeContainerInfoMiniatur("INFOPANEL");
        this.showMenuBar();
        this.showStatusBar();
        this.mConfiguratorPanel.validate();
        this.mConfiguratorPanel.updateUI();
        this.validate();
    }

    public void addMenuBar(PrototypeMenuBar pMenuBar) {
        this.mMenuBar = pMenuBar;
        this.setJMenuBar(this.mMenuBar.getMenuBar());
        this.validate();
    }

    public void showMenuBar() {
        this.mMenuBar.getMenuBar().setVisible(true);
        this.mMenuBar.setStyle(WorkflowController.getInstance().getMarkenLayout());
        this.validate();
    }

    public void removeMenuBar() {
        this.mMenuBar.getMenuBar().setVisible(false);
        this.validate();
    }

    public void addStatusBar(StatusBar statusBar, MarkenLayout mLayout) {
        this.mStatusBar = statusBar;
        this.mStatusBar.getStatusBar().setMinimumSize(new Dimension(30, 35));
        GridBagConstraints gbc = mLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 1, 15, new Insets(0, 0, 0, 0));
        this.mConfiguratorPanel.add((Component)this.mStatusBar.getStatusBar(), gbc);
        this.mConfiguratorPanel.validate();
    }

    public void showStatusBar() {
        if (this.mStatusBar == null) {
            this.mStatusBar = new StatusBar(WorkflowController.getInstance().getMarkenLayout());
            this.mStatusBar.addObserver(ControllerStatusBar.getInstance());
        }
        this.mStatusBar.getStatusBar().setVisible(true);
        this.mStatusBar.setStyle(WorkflowController.getInstance().getMarkenLayout());
        int gap = (this.mStatusBar.getStatusBar().getHeight() - 19) / 2;
        FlowLayout flow = new FlowLayout(0);
        flow.setVgap(gap);
        this.mStatusBar.getStatusBar().setLayout(flow);
        this.validate();
    }

    public void removeStatusBar() {
        this.mStatusBar.getStatusBar().setVisible(false);
        this.validate();
    }

    public void addPanel(JPanel newPanel) {
        log.debug((Object)"Showing new Panel");
        if (this.mActuellPanel != null) {
            this.remove(this.mActuellPanel);
        }
        this.add(newPanel);
        this.mActuellPanel = newPanel;
        this.validate();
        this.repaint();
    }

    public void changeContainerInfoMiniatur(String contentName) {
        int count = this.mContainerInfoMiniatur.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!this.mContainerInfoMiniatur.getComponent(i).isVisible() || this.mContainerInfoMiniatur.getComponent(i).getName().equals(contentName)) continue;
            ((CardLayout)this.mContainerInfoMiniatur.getLayout()).show(this.mContainerInfoMiniatur, contentName);
        }
    }

    public void setMiniaturansichten(MiniaturMarketingPanel mark, MiniaturTechnikPanel tech, MiniaturKalkulationsPanel kalk) {
        Dimension topComp = new Dimension(208, 660);
        Dimension topComp2 = new Dimension(208, 222);
        if (this.mContainerMiniaturansichten == null) {
            this.mContainerMiniaturansichten = new JPanel(new GridBagLayout());
            this.mContainerMiniaturansichten.setMinimumSize(topComp);
            this.mContainerMiniaturansichten.setMaximumSize(topComp);
            this.mContainerMiniaturansichten.setPreferredSize(topComp);
            this.mContainerMiniaturansichten.setName("MINIATURANSICHTEN");
            this.mContainerMarkMiniatur = new JPanel(new GridBagLayout());
            this.mContainerMarkMiniatur.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, new Color(212, 208, 200)));
            this.mContainerTechMiniatur = new JPanel(new GridBagLayout());
            this.mContainerTechMiniatur.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, new Color(212, 208, 200)));
            this.mContainerKalkMiniatur = new JPanel(new GridBagLayout());
            this.mContainerKalkMiniatur.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, new Color(212, 208, 200)));
            this.mContainerInfoMiniatur.add((Component)this.mContainerMiniaturansichten, "MINIATURANSICHTEN");
        }
        this.mContainerMiniaturansichten.setBackground(WorkflowController.getInstance().getMarkenLayout().getPrimaryBackground());
        mark.getPanel().setMinimumSize(topComp2);
        mark.getPanel().setMaximumSize(topComp2);
        mark.getPanel().setPreferredSize(topComp2);
        tech.getPanel().setMinimumSize(topComp2);
        tech.getPanel().setMaximumSize(topComp2);
        tech.getPanel().setPreferredSize(topComp2);
        kalk.getPanel().setMinimumSize(topComp2);
        kalk.getPanel().setMaximumSize(topComp2);
        kalk.getPanel().setPreferredSize(topComp2);
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 11, new Insets(0, 0, 0, 0));
        this.mContainerMarkMiniatur.removeAll();
        this.mContainerMarkMiniatur.add((Component)mark.getPanel(), this.gbc);
        this.mContainerMiniaturansichten.add((Component)this.mContainerMarkMiniatur, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
        this.mContainerTechMiniatur.removeAll();
        this.mContainerTechMiniatur.add((Component)tech.getPanel(), this.gbc);
        this.mContainerMiniaturansichten.add((Component)this.mContainerTechMiniatur, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 2, 1, 1, 1.0, 100.0, 1, 11, new Insets(0, 0, 0, 0));
        this.mContainerKalkMiniatur.removeAll();
        this.mContainerKalkMiniatur.add((Component)kalk.getPanel(), this.gbc);
        this.mContainerMiniaturansichten.add((Component)this.mContainerKalkMiniatur, this.gbc);
        this.changeContainerInfoMiniatur("MINIATURANSICHTEN");
        this.mContainerInfoMiniatur.validate();
        this.mContainerInfoMiniatur.updateUI();
        this.validate();
    }

    public void setBusiCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public PrototypeMenuBar getPrototypeMenuBar() {
        return this.mMenuBar;
    }

    public StatusBar getStatusBar() {
        return this.mStatusBar;
    }

    public InfoPanel getInfoPanel() {
        return ControllerInfoPanel.getInstance().getInfoPanel();
    }

    public MainPanel getMainPanel() {
        return this.mMainPanel;
    }

    public Dimension getFrameSize() {
        return this.mFrameSize;
    }

    public Dimension getScreenSize() {
        return this.mScreenSize;
    }

    public MiniaturTechnikPanel getDummyTech() {
        return this.dummyTech;
    }

    public MiniaturMarketingPanel getDummyMark() {
        return this.dummyMark;
    }

    public ArbeitHinzufuegenDialog getArbeitHinzufuegen() {
        return this.arbeitHinzufuegen;
    }

    public JPanel getContainerMiniaturansichten() {
        return this.mContainerMiniaturansichten;
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    public void setHidden(boolean flag) {
        this.mHidden = flag;
    }

    private GridBagConstraints setGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, int anchor, Insets insets) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.fill = fill;
        c.insets = insets;
        c.anchor = anchor;
        return c;
    }

    public void showErrorMessage(String errorMsg) {
        JOptionPane.showMessageDialog((Component)this, errorMsg, Resource.getInstance().getInformation(), 1);
    }

    public boolean showConfirmMessage(String errorMsg) {
        int result = JOptionPane.showConfirmDialog((Component)this, errorMsg, Resource.getInstance().getInformation(), 0, 1);
        return result == 0;
    }

    public int showConfirmCancelMessage(String errorMsg) {
        int result = JOptionPane.showConfirmDialog((Component)this, errorMsg, Resource.getInstance().getInformation(), 1, 1);
        return result;
    }

    public void initFromISPA(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, Integer angebotsnummer) {
        if (this.calculateISPAParameter(vin, vbg) == -1) {
            ArrayList<String> marken = new ArrayList<String>();
            marken.add(Marken.getInstance().getMarke("BMW").getBerechtigung());
            WorkflowController.getInstance().getMarkenLayout().setPossibleMarks(marken);
            ArrayList<String> produkte = new ArrayList<String>();
            produkte.add(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
            WorkflowController.getInstance().getMarkenLayout().setPossibleProdukte(produkte);
            WorkflowController.getInstance().changeState("WELCOME");
            log.error((Object)("Ung\u00fcltiges Fahrgestellnummernformat!\nEs m\u00fcssen die letzten 7 Zeichen der VIN \u00fcbergeben werden!\n\n\u00dcbergebene Fahrgestellnummer war '" + vin + "'"));
            GlobalObjects.getInstance().getIpacData().setIspaAngebotsNr(0);
            return;
        }
        log.debug((Object)"ISPA-PARAMETER berechnet !");
        WorkflowController.getInstance().setMarkenLayout(null, null);
        ArrayList<String> marken = new ArrayList<String>();
        marken.add(GlobalObjects.getInstance().getIpacData().getFahrzeug().getMarke());
        WorkflowController.getInstance().getMarkenLayout().setPossibleMarks(marken);
        char produktart = GlobalObjects.getInstance().getIpacData().getFahrzeug().getProduktArt();
        ArrayList<String> produkte = new ArrayList<String>();
        produkte.add(Character.toString(produktart));
        WorkflowController.getInstance().getMarkenLayout().setPossibleProdukte(produkte);
        GlobalObjects.getInstance().getSessionInfo().setUserMarken(marken);
        GlobalObjects.getInstance().getIpacData().setIspaAngebotsNr(0);
        GlobalObjects.getInstance().getIpacData().setIspaKundenNr(kundennummer);
        if (angebotsnummer != null && angebotsnummer != 0) {
            GlobalObjects.getInstance().getIpacData().setIspaAngebotsNr(angebotsnummer.intValue());
            int konfigId = this.calculateKonfigId(angebotsnummer);
            WorkflowController.getInstance().changeState("WELCOME");
            if (konfigId == -1) {
                GlobalObjects.getInstance().getIpacData().setIspaErrorMessage(Resource.getInstance().getErrormessageAngebotsnr());
                System.out.println("Ung\u00fcltige Angebotsnummer! ! ! ! ! ! !");
                GlobalObjects.getInstance().getIpacData().setIspaAngebotsNr(0);
                return;
            }
            ControllerAngebotsPanel.getInstance().aendereAngebot(konfigId);
        } else if (!GlobalObjects.getInstance().getIpacData().hasAnfrageAngebotWithVIN()) {
            String sMarke = GlobalObjects.getInstance().getIpacData().getFahrzeug().getMarke();
            String sProdukt = GlobalObjects.getInstance().getIpacData().getFahrzeug().getProduktart();
            ControllerWelcomePanel.setMarkeProduktartGlobal(sMarke, sProdukt);
            ControllerMainPanel.getInstance();
            ControllerMenuBar.getInstance();
            ControllerStatusBar.getInstance();
            ControllerSubCategoryPanel.getInstance();
            ControllerProduktListPanel.getInstance();
            ControllerInfoPanel.getInstance();
            ControllerAgbDialog.getInstance().checkAgbBestaetigt();
            if (MainController.getInstance().getMainFrame().getMainPanel() == null) {
                MainController.getInstance().getMainFrame().addConfiguratorPanel(ControllerMainPanel.getInstance().getMainPanel(), WorkflowController.getInstance().getMarkenLayout());
            }
            WorkflowController.getInstance().changeState("CONFIG");
        } else {
            WorkflowController.getInstance().changeState("WELCOME");
        }
        this.validate();
    }

    private int calculateISPAParameter(String vin, EtkScoreVerbauung[] vbg) {
        AnfrageSucheBean beanAnfrage = new AnfrageSucheBean();
        beanAnfrage.setVin(vin);
        try {
            GlobalObjects.getInstance().getIpacData().setAnzahlAnfragen(((ArrayList)AnfragenDataLoader.sucheAnfrage(beanAnfrage)).size());
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        AngebotsSucheBean beanAngebot = new AngebotsSucheBean();
        beanAngebot.setVin(vin);
        try {
            GlobalObjects.getInstance().getIpacData().setAnzahlAngebote(((ArrayList)AngebotDataLoader.sucheAngebote(beanAngebot)).size());
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        if (GlobalObjects.getInstance().getIpacData().getAnzahlAnfragen() == 0 && GlobalObjects.getInstance().getIpacData().getAnzahlAngebote() == 0) {
            GlobalObjects.getInstance().getIpacData().setAnfrageAngebotWithVIN(false);
        } else {
            GlobalObjects.getInstance().getIpacData().setAnfrageAngebotWithVIN(true);
        }
        return this.calculateFahrzeug(vin, vbg);
    }

    private int calculateFahrzeug(String vin, EtkScoreVerbauung[] vbg) {
        GlobalObjects.getInstance().getIpacData().setIspaAusstattungen(vbg);
        log.debug((Object)"Performing FI by Fahrgestellnummer ");
        if (vbg != null) {
            for (EtkScoreVerbauung verbauung : vbg) {
                log.debug((Object)("art: " + verbauung.getArt() + " code: " + verbauung.getCode()));
            }
        }
        if (vin == null || vin.length() != 7) {
            GlobalObjects.getInstance().getIpacData().setIspaErrorMessage(Resource.getInstance().getIspaVinError());
            return -1;
        }
        Fahrzeug fahrzeugdaten = NavigationPanelDataLoader.loadFahrzeugdatenVin(GlobalObjects.getInstance().getIpacData().getVINfromISPA());
        FzgSucheInfo oFzgSucheInfo = null;
        oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug() == null || !GlobalObjects.getInstance().getIpacData().getFahrzeug().getFahrgestellnummer().equals(GlobalObjects.getInstance().getIpacData().getVINfromISPA()) ? FBIDataloader.getFIByFahrgesellnummer(GlobalObjects.getInstance().getIpacData().getVINfromISPA()) : GlobalObjects.getInstance().getIpacData().getFahrzeug();
        fahrzeugdaten.setFzgSucheInfo(oFzgSucheInfo);
        GlobalObjects.getInstance().getIpacData().setFahrzeug(fahrzeugdaten);
        return 0;
    }

    private int calculateKonfigId(int angebotsnummer) {
        AngebotsSucheBean bean = new AngebotsSucheBean();
        bean.setAngebotsNummer(Integer.toString(angebotsnummer));
        ArrayList angebote = new ArrayList();
        try {
            System.out.println("Angebotsnummer  " + angebotsnummer);
            angebote = (ArrayList)AngebotDataLoader.sucheAngebote(bean);
        }
        catch (Exception e) {
            log.debug((Object)"Es konnte kein Angebot zu der \u00fcbergebenen Angebotsnummer gefunden werden");
            e.printStackTrace();
        }
        if (angebote.size() > 0) {
            System.out.println("KonfigId  =  " + ((AngebotsSuche)angebote.get(0)).getKonfigId());
            return ((AngebotsSuche)angebote.get(0)).getKonfigId();
        }
        return -1;
    }
}

