/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.resources.Resource;

public class Version {
    private static Logger log = Logger.getLogger(Version.class);
    private static Version instance = null;
    private JDialog dlg = new JDialog((Frame)MainController.getInstance().getMainFrame(), false);
    private JPanel panVersion;
    private JLabel labCDVersion;
    private JLabel labCDVersionAnz;
    private JLabel labWebETKVersion;
    private JLabel labWebETKVersionAnz;
    private JLabel labDBVersion;
    private JLabel labDBVersionAnz;
    private JLabel labDatenVom;
    private JLabel labDatenVomAnz;
    private JLabel labServer;
    private JLabel labServerAnz;
    private TrfHashMap oAnzeigedaten = null;

    public Version() {
        this.dlg.setTitle(Resource.getInstance().getVersion());
        if (GlobalObjects.getInstance().getIstStandalone()) {
            this.dlg.setSize(380, 240);
        } else {
            this.dlg.setSize(380, 260);
        }
        this.dlg.setLocation(100, 100);
        this.initComponents();
        this.loadVersionsinformation();
        this.update();
    }

    private void initComponents() {
        this.panVersion = new JPanel();
        this.labCDVersion = new JLabel(Resource.getInstance().getCdVersion() + ":");
        this.labWebETKVersion = new JLabel(Resource.getInstance().getEtkVersion() + ":");
        this.labDBVersion = new JLabel(Resource.getInstance().getDatenbankVersion());
        this.labDatenVom = new JLabel(Resource.getInstance().getDatenVom());
        this.labCDVersionAnz = new JLabel();
        this.labWebETKVersionAnz = new JLabel();
        this.labDBVersionAnz = new JLabel();
        this.labDatenVomAnz = new JLabel();
        if (!GlobalObjects.getInstance().getIstStandalone()) {
            this.labServer = new JLabel(Resource.getInstance().getServer() + ":");
            this.labServerAnz = new JLabel();
        }
        this.layoutAll();
    }

    protected void layoutAll() {
        Container paneContent = this.dlg.getContentPane();
        JPanel content = this.createVersionPanel();
        paneContent.add(content);
        paneContent.setBackground(WorkflowController.getInstance().getMarkenLayout().getSecondaryBackground());
        paneContent.validate();
    }

    private JPanel createVersionPanel() {
        this.panVersion.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 15, 5);
        this.panVersion.add((Component)this.labCDVersion, gbc);
        gbc.gridx = 1;
        this.panVersion.add((Component)this.labCDVersionAnz, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.panVersion.add((Component)this.labWebETKVersion, gbc);
        gbc.gridx = 1;
        this.panVersion.add((Component)this.labWebETKVersionAnz, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.panVersion.add((Component)this.labDBVersion, gbc);
        gbc.gridx = 1;
        this.panVersion.add((Component)this.labDBVersionAnz, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.panVersion.add((Component)this.labDatenVom, gbc);
        gbc.gridx = 1;
        this.panVersion.add((Component)this.labDatenVomAnz, gbc);
        if (!GlobalObjects.getInstance().getIstStandalone()) {
            gbc.gridx = 0;
            gbc.gridy = 4;
            this.panVersion.add((Component)this.labServer, gbc);
            gbc.gridx = 1;
            this.panVersion.add((Component)this.labServerAnz, gbc);
        }
        return this.panVersion;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    private void update() {
        String sCDVersion = (String)this.oAnzeigedaten.getValue("cdversion");
        String sWebETKVersion = (String)this.oAnzeigedaten.getValue("webetkversion");
        String sDBVersion = (String)this.oAnzeigedaten.getValue("dbversion");
        String sDatenVom = (String)this.oAnzeigedaten.getValue("datenvom");
        this.labCDVersionAnz.setText(sCDVersion);
        this.labWebETKVersionAnz.setText(sWebETKVersion);
        this.labDBVersionAnz.setText(sDBVersion);
        this.labDatenVomAnz.setText(sDatenVom);
        if (!GlobalObjects.getInstance().getIstStandalone()) {
            int nInd = GlobalObjects.getInstance().getServerUrl().indexOf("/javaserver");
            String sUrlAnfang = GlobalObjects.getInstance().getServerUrl().substring(0, nInd);
            this.labServerAnz.setText(sUrlAnfang);
        }
    }

    private void loadVersionsinformation() {
        log.debug((Object)"Performing Load Versioninfo");
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfVersionsinfo = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfVersionsinfo, Command.LOAD_VERSIONSINFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)"Version: ", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfVersionsinfo.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfVersionsinfo.getError());
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), trfVersionsinfo.getError().getMessage(), Resource.getInstance().getVersion(), 0);
            return;
        }
        this.oAnzeigedaten = trfVersionsinfo;
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
    }
}

