/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.IIpacData;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.content.marketing.Bestandteil;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import de.esg.zub.configurator.content.marketing.MarketingDataloader;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.TechnikDataloader;
import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.configurator.navigation.miniatur.IMiniaturPanel;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.common.PreisZeile;
import webetk.app.zub.common.Preise;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Kunde;

public class ClientKonfiguration
extends Konfiguration
implements Observer {
    private static Logger log = Logger.getLogger(ClientKonfiguration.class);
    MarketingModel mMarketingModel;
    TechnikModel mTechnikModel;
    KalkulationModel mKalkulationModel;
    List<IMiniaturPanel> mMiniPanels;
    static ClientKonfiguration konfig;
    List<KonfigurationsPosition> addKonfigurationList = new ArrayList<KonfigurationsPosition>();
    List<KonfigurationsPosition> deleteKonfigurationList = new ArrayList<KonfigurationsPosition>();
    List<KonfigurationsPosition> updateKonfigurationList = new ArrayList<KonfigurationsPosition>();
    boolean konfigUpdateKunde = false;
    boolean konfigUpdateAngebot = false;
    boolean konfigUpdateAbschlag = false;
    private List<Bauteil> bauteileToUpdate = new ArrayList<Bauteil>();
    private List<Arbeit> arbeitToUpdate = new ArrayList<Arbeit>();
    public static final String KERNPRODUKT = "KERNPRODUKT";
    private boolean mKalkulationSet = false;
    private boolean saved = false;
    private static final long serialVersionUID = 1L;
    private int posNr = 0;
    private double mwSteuerSatzHoch = 0.0;
    private double mwSteuerSatzNiedrig = 0.0;
    private double mwSteuerSatzAltteile = 0.0;
    private double mwSteuerSatz3 = 0.0;
    private double mwSteuerSatz4 = 0.0;

    public static ClientKonfiguration getClientKonfiguration() {
        if (konfig == null) {
            konfig = ClientKonfiguration.newClientKonfiguration();
        }
        return konfig;
    }

    public static ClientKonfiguration newClientKonfiguration() {
        ArrayList<IMiniaturPanel> miniAnsichten = new ArrayList();
        if (konfig != null) {
            miniAnsichten = konfig.getMiniPanels();
        }
        konfig = new ClientKonfiguration();
        konfig.setMarketingModel(ControllerMarketingPanel.getInstance().getModel());
        konfig.ladeDefaultMwSteuerSaetze();
        konfig.setTechnikModel(ControllerTechnikPanel.getInstance().getModel(), null);
        ControllerTechnikPanel.getInstance().addObserver(konfig);
        ControllerKalkulationPanel.getInstance().addObserver(konfig);
        konfig.setMiniPanels(miniAnsichten);
        return konfig;
    }

    private void ladeDefaultMwSteuerSaetze() {
        this.mwSteuerSatzHoch = ClientKonfiguration.parseDoubleSafely(GlobalObjects.getInstance().getConfig().getMWStSatzHoch());
        this.mwSteuerSatzNiedrig = ClientKonfiguration.parseDoubleSafely(GlobalObjects.getInstance().getConfig().getMWStSatzNiedrig());
        this.mwSteuerSatzAltteile = ClientKonfiguration.parseDoubleSafely(GlobalObjects.getInstance().getConfig().getMWStSatzAltteile());
        this.mwSteuerSatz3 = ClientKonfiguration.parseDoubleSafely(GlobalObjects.getInstance().getConfig().getMWStSatz3());
        this.mwSteuerSatz4 = ClientKonfiguration.parseDoubleSafely(GlobalObjects.getInstance().getConfig().getMWStSatz4());
    }

    public static double parseDoubleSafely(String str) {
        double result = 0.0;
        try {
            result = Double.parseDouble(str);
        }
        catch (NullPointerException npe) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public double getMwStSatzZuCode(String code) {
        double mwst = 0.0;
        mwst = code != null ? (code.equals("2") ? this.mwSteuerSatzHoch : (code.equals("3") ? this.mwSteuerSatzAltteile : (code.equals("4") ? this.mwSteuerSatz3 : (code.equals("5") ? this.mwSteuerSatz4 : this.mwSteuerSatzNiedrig)))) : this.mwSteuerSatzHoch;
        return mwst;
    }

    public void reset() {
        this.mMarketingModel = null;
        this.mTechnikModel = null;
        this.mKalkulationModel = null;
        this.addKonfigurationList.clear();
        this.updateKonfigurationList.clear();
        this.deleteKonfigurationList.clear();
        this.setSaved(false);
        this.setKalkulationSet(false);
        this.setAngebot(null);
        this.setAufabschlag(0.0);
    }

    private ClientKonfiguration() {
        this.mMiniPanels = new ArrayList<IMiniaturPanel>();
    }

    public KalkulationModel getKalkulationModel() {
        return this.mKalkulationModel;
    }

    public boolean setKalkulationModel(KalkulationModel kalkulationModel, boolean loadPreise) throws CloneNotSupportedException {
        this.mKalkulationModel = kalkulationModel;
        boolean failureAlt = false;
        boolean failureAltVar = false;
        boolean failureBesttVar = false;
        boolean failure = false;
        if (kalkulationModel != null) {
            this.setAufabschlag(kalkulationModel.getAufAbschlag());
            this.mTechnikModel = new TechnikModel();
            Fahrzeug fahrzeug = kalkulationModel.getVorgang().getFahrzeug();
            MarketingProdukt marketingProdukt = null;
            try {
                marketingProdukt = MarketingDataloader.getMarketingProdukt(kalkulationModel.getVorgang().getBtNummer(), kalkulationModel.getVorgang().getBildPos(), null, kalkulationModel.getVorgang().getUnterKategorie().isLifestyle());
                marketingProdukt.setUnterkategorie(kalkulationModel.getVorgang().getUnterKategorie());
            }
            catch (Exception ex) {
                log.error((Object)"Konnte Marketingprodukt nicht laden", (Throwable)ex);
                return true;
            }
            this.mMarketingModel = new MarketingModel();
            this.mMarketingModel.setMarketingProduct(marketingProdukt, false);
            marketingProdukt.setSelectedBnbsMitVarianten(this.selectedBnbsMitVarianten);
            for (int i = 0; i < marketingProdukt.getAlleVarianten().size(); ++i) {
                Variante var = marketingProdukt.getAlleVarianten().get(i);
                for (int k = 0; k < marketingProdukt.getSelectedBnbsMitVarianten().size(); ++k) {
                    Bnb selBnb = marketingProdukt.getSelectedBnbsMitVarianten().get(k);
                    if (selBnb.getSelectedVariante() == null || var.getVarianteId() != selBnb.getSelectedVariante().getVarianteId()) continue;
                    selBnb.setSelectedVariante((Variante)var.clone());
                }
            }
            block8: for (Bnb bnb : this.selectedBnbsMitVarianten) {
                int j;
                String elementart = bnb.getElementArt();
                Variante selVar = bnb.getSelectedVariante();
                String bildpos = bnb.getBildPos();
                if (elementart.equals("OPTIONAL")) {
                    for (j = 0; j < marketingProdukt.getZusatzProdukte().size(); ++j) {
                        ProduktListenElement zusatzPr = (ProduktListenElement)marketingProdukt.getZusatzProdukte().get(j);
                        int zusatzPrVariantenId = 0;
                        if (zusatzPr.getVariante() != null) {
                            zusatzPrVariantenId = zusatzPr.getVariante().getVarianteId();
                        }
                        if (!zusatzPr.getBildPosNr().equals(bildpos) || selVar == null || selVar.getVarianteId() != zusatzPrVariantenId) continue;
                        bnb.setBnbName(zusatzPr.getProduktName());
                        bnb.setBteNr(zusatzPr.getBteNr());
                        this.mMarketingModel.getIndexSelectedZusatzprodukte().add(new Integer(j));
                    }
                    continue;
                }
                if (elementart.equals("HP_EINZELTEIL")) {
                    for (j = 0; j < marketingProdukt.getEinzelteile().size(); ++j) {
                        failureAlt = true;
                        Bnb einzelteil = marketingProdukt.getEinzelteile().get(j);
                        if (!einzelteil.getBildPos().equals(bildpos)) continue;
                        if (selVar != null) {
                            einzelteil.setSelectedVariante(selVar);
                            failureAltVar = false;
                        }
                        this.mMarketingModel.addSelectedEinzelteil(einzelteil);
                    }
                    continue;
                }
                if (elementart.equals("HP_ALTERNATIV")) {
                    for (j = 0; j < marketingProdukt.getAlternativen().size(); ++j) {
                        failureAlt = true;
                        Bnb alternative = marketingProdukt.getAlternativen().get(j);
                        if (!alternative.getBildPos().equals(bildpos)) continue;
                        this.mMarketingModel.setSelectedAlternative(alternative);
                        bnb.setBnbName(alternative.getBnbName());
                        bnb.setBteNr(alternative.getBteNr());
                        if (selVar != null) {
                            this.mMarketingModel.setSelectedVariante(selVar);
                            failureAltVar = false;
                        }
                        failureAlt = false;
                        failure = failure || failureAlt || failureAltVar;
                        continue block8;
                    }
                    continue;
                }
                if (!elementart.equals("HP_PAKET") && !elementart.equals("HP_OBLIGAT")) continue;
                for (j = 0; j < marketingProdukt.getBestandTeile().size(); ++j) {
                    Bnb besttBnb = marketingProdukt.getBestandTeile().get(j);
                    if (!besttBnb.getBildPos().equals(bildpos)) continue;
                    Bestandteil besttModel = this.mMarketingModel.getBestandteile().get(j);
                    bnb.setBnbName(besttBnb.getBnbName());
                    bnb.setBteNr(besttBnb.getBteNr());
                    if (selVar != null) {
                        this.mMarketingModel.getBestandteile().get(j).setSelectedVariante(selVar);
                        failureAltVar = false;
                    }
                    failure = failure || failureBesttVar;
                    continue block8;
                }
            }
            try {
                if (fahrzeug != null) {
                    if (fahrzeug.getModellspalte() == 0L) {
                        try {
                            if (fahrzeug.getFahrgestellnummer() == null || fahrzeug.getFahrgestellnummer().length() == 0) {
                                FBIDataloader.ermittleFahrzeugId(fahrzeug);
                            } else {
                                FzgSucheInfo info = FBIDataloader.getFIByFahrgesellnummer(fahrzeug.getFahrgestellnummer());
                                fahrzeug.setFzgSucheInfo(info);
                                if (info.getBaureiheBezeichnung() != null && info.getBaureiheBezeichnung().length() > 0) {
                                    fahrzeug.setBaureiheBezeichnung(info.getBaureiheBezeichnung());
                                }
                                if (info.getKarosserieBezeichnung() != null && info.getKarosserieBezeichnung().length() > 0) {
                                    fahrzeug.setKarosserieBezeichnung(info.getKarosserieBezeichnung());
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Fehler", (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                    KalkulationDataLoader.ermittleAktiveBedingungen(fahrzeug, marketingProdukt);
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getFahrzeug());
                }
                ArrayList<PreisZeile> hinzugefuegteTeile = null;
                String preiseLaden = null;
                if (loadPreise) {
                    preiseLaden = "ALLES";
                    if (kalkulationModel.getAnfrage() != null) {
                        hinzugefuegteTeile = new ArrayList<PreisZeile>();
                        List positionen = kalkulationModel.getAnfrage().getVorgang().getKonfiguration().getPositionen();
                        for (KonfigurationsPosition pos : positionen) {
                            if (!pos.getStatus().equals("INSERT") || pos.getArt() != 'T') continue;
                            PreisZeile preis = new PreisZeile();
                            preis.setSachNr(pos.getArtikelNummer().replace(" ", ""));
                            hinzugefuegteTeile.add(preis);
                        }
                    }
                } else {
                    preiseLaden = "NICHTS";
                }
                TechnischesProdukt tProdukt = TechnikDataloader.getTechnikProdukt(marketingProdukt, GlobalObjects.getInstance().getIpacData().getFahrzeug(), preiseLaden, hinzugefuegteTeile);
                Preise preise = GlobalObjects.getInstance().getIpacData().getPreise();
                if (preise != null) {
                    marketingProdukt.ermittlePreiseZusatzprodukte(preise);
                }
                this.mMarketingModel.setVerbaubareVarianten(tProdukt.getVerbaubareVarianten());
                this.mMarketingModel.setVerbaubareAlternativen(tProdukt.getVerbaubareAlternativen());
                this.mMarketingModel.setVerbaubareZusatzprodukte(tProdukt.getVerbaubareZubehoerProdukte());
                ControllerMarketingPanel.getInstance().setModel(this.mMarketingModel);
                TechnikModel tModell = new TechnikModel();
                tModell.setAufwaende(AdminDataLoader.ladeAufwandKonfiguration(GlobalObjects.getInstance().getSessionInfo().getFilialeId(), GlobalObjects.getInstance().getSessionInfo().getMarke(), GlobalObjects.getInstance().getSessionInfo().getProdukart()));
                tModell.setTechnikProdukt(tProdukt);
                if (this.getPositionen() != null) {
                    this.clearifyModel(this, tModell, tProdukt);
                }
                this.mTechnikModel = tModell;
                this.mTechnikModel.berechnePreiseUndGesamtMenge();
                this.mTechnikModel.getEinbauCalculator().calculate();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return failure;
    }

    private void clearifyModel(Konfiguration konfiguration, TechnikModel tModell, TechnischesProdukt produkt) {
        Preise preise = produkt.getPreise();
        for (KonfigurationsPosition pos : konfiguration.getPositionen()) {
            if (pos.getStatus().equals("DELETE")) {
                if (pos.getArt() == 'T') {
                    if (pos.getGruppe().equals(KERNPRODUKT)) {
                        this.loescheBauteil(pos, tModell.getKernProduktBnbs());
                    }
                    if (pos.getGruppe().equals("OPTIONAL")) {
                        this.loescheBauteil(pos, tModell.getZusatzProduktBnbs());
                    }
                    if (!pos.getGruppe().equals("HUB")) continue;
                    this.loescheBauteil(pos, tModell.getHilfBnbs());
                    continue;
                }
                if (pos.getArt() != 'A') continue;
                if (pos.getGruppe().equals(KERNPRODUKT)) {
                    this.loescheArbeit(pos, tModell.getArbeitKernprodukt());
                }
                if (pos.getGruppe().equals("OPTIONAL")) {
                    this.loescheArbeit(pos, tModell.getArbeitZusatzprodukt());
                }
                if (!pos.getGruppe().equals("HUB")) continue;
                this.loescheArbeit(pos, tModell.getArbeitHilf());
                continue;
            }
            if (pos.getStatus().equals("INSERT")) {
                if (pos.getArt() == 'T') {
                    this.insertBauteil(pos, tModell.getHilfBnbs(), tModell, preise, this.mwSteuerSatzHoch);
                    continue;
                }
                if (pos.getArt() != 'A') continue;
                this.insertArbeit(pos, tModell.getArbeitHilf(), tModell, this.mwSteuerSatzHoch);
                continue;
            }
            if (pos.getGruppe().equals(KERNPRODUKT)) {
                if (pos.getArt() == 'T') {
                    this.abgleichBauteil(pos, tModell.getKernProduktBnbs(), preise);
                    continue;
                }
                if (pos.getArt() != 'A') continue;
                this.abgleichArbeit(pos, tModell.getArbeitKernprodukt(), tModell, this.mwSteuerSatzHoch);
                continue;
            }
            if (pos.getGruppe().equals("OPTIONAL")) {
                if (pos.getArt() == 'T') {
                    this.abgleichBauteil(pos, tModell.getZusatzProduktBnbs(), preise);
                    continue;
                }
                if (pos.getArt() != 'A') continue;
                this.abgleichArbeit(pos, tModell.getArbeitZusatzprodukt(), tModell, this.mwSteuerSatzHoch);
                continue;
            }
            if (!pos.getGruppe().equals("HUB")) continue;
            if (pos.getArt() == 'T') {
                this.abgleichBauteil(pos, tModell.getHilfBnbs(), preise);
                continue;
            }
            if (pos.getArt() != 'A') continue;
            this.abgleichArbeit(pos, tModell.getArbeitHilf(), tModell, this.mwSteuerSatzHoch);
        }
    }

    private void abgleichArbeit(KonfigurationsPosition pos, ArrayList<Arbeit> arbeitsListe, TechnikModel model, double mwSteuerSatz) {
        Arbeit refArbeit = new Arbeit(pos.getArtikelNummer(), pos.getArtikelBenennung(), pos.getElementArt(), 0, pos.getBemerkung(), 0.0, 0.0, 0.0, 0.0, false);
        if (this.isRefaArbeit(pos.getArtikelNummer())) {
            refArbeit.setRefaArbeit(true);
        }
        for (Arbeit arbeit : arbeitsListe) {
            if (!arbeit.equals(refArbeit)) continue;
            arbeit.setPosIntern(pos.getPos());
            if (arbeit.getMenge() != pos.getMenge()) {
                int awAlt = arbeit.getMenge();
                arbeit.setMenge(pos.getMenge());
                model.setAnzahlArbeit(model.getAnzahlArbeit() - awAlt + pos.getMenge());
                model.changeMengeArbeit(pos.getGruppe(), arbeit.getBenennung(), arbeit.getAwnummer(), pos.getMenge(), awAlt);
            }
            if (this.getAngebot() != null) {
                arbeit.setEinzelPreisNetto((float)pos.getPreis());
                arbeit.setGesamtPreisNetto((float)((double)pos.getMenge() * pos.getPreis()));
            } else {
                arbeit.setEinzelPreisNetto(model.getEinbauCalculator().berechnePreisFuerAwNr(arbeit.getAwnummer(), 1.0f, true));
                arbeit.setEinzelPreisBrutto(model.getEinbauCalculator().berechnePreisFuerAwNr(arbeit.getAwnummer(), 1.0f, false));
                arbeit.setGesamtPreisNetto(arbeit.getEinzelPreisNettoNumeric() * (double)arbeit.getMenge());
                arbeit.setGesamtPreisBrutto(model.getEinbauCalculator().berechnePreisFuerAwNr(arbeit.getAwnummer(), arbeit.getMenge(), false));
                pos.setPreis(arbeit.getEinzelPreisNettoNumeric());
                pos.setMwstSatz(mwSteuerSatz);
                pos.setMwStBetrag(Math.floor(pos.getGesamtPreis() * pos.getMwstSatz() + 0.5) / 100.0);
            }
            return;
        }
    }

    private void abgleichBauteil(KonfigurationsPosition pos, ArrayList<TechnischerBnb> bnbListe, Preise preise) {
        Bauteil ref = new Bauteil(pos.getArtikelNummer());
        for (TechnischerBnb bnb : bnbListe) {
            for (Bauteil bauteil : bnb.getBauteile()) {
                if (!bauteil.equals(ref)) continue;
                bauteil.setPosIntern(pos.getPos());
                bauteil.setMenge(pos.getMenge());
                if (this.getAngebot() != null) {
                    bauteil.setEinzelPreis(pos.getPreis());
                } else {
                    PreisZeile zeile = preise.findPreisZeileZuSachnummer(bauteil.getTeilenummer());
                    if (zeile != null && zeile.getPreis() != null) {
                        double dMwStBetrag = Math.floor(zeile.getMwSt() * (double)bauteil.getMenge() * zeile.getPreis() + 0.5) / 100.0;
                        bauteil.setEinzelPreis(zeile.getGesamtPreis(1, this.mTechnikModel.isAbPreiseMitSteuer()));
                        bauteil.setMwStSatz((float)zeile.getMwSt());
                        pos.setPreis(zeile.getPreis());
                        pos.setMwstSatz(zeile.getMwSt());
                        pos.setMwStBetrag(dMwStBetrag);
                    }
                }
                return;
            }
        }
    }

    private void insertArbeit(KonfigurationsPosition pos, ArrayList<Arbeit> arbeitHilf, TechnikModel tModel, double mwSteuerSatz) {
        Arbeit arbeit = new Arbeit(pos.getArtikelNummer(), pos.getArtikelBenennung(), pos.getElementArt(), pos.getMenge(), pos.getBemerkung(), (float)pos.getPreis(), (float)pos.getGesamtPreis(), (double)((float)pos.getPreis()) + pos.getMwStBetrag(), (double)((float)pos.getGesamtPreis()) + pos.getMwStBetrag() * (double)pos.getMenge(), false);
        if (this.isRefaArbeit(pos.getArtikelNummer())) {
            arbeit.setRefaArbeit(true);
        }
        arbeit.setHinzugefuegt(true);
        if (this.getAngebot() == null) {
            arbeit.setEinzelPreisBrutto(tModel.getEinbauCalculator().berechnePreisFuerAwNr(arbeit.getAwnummer(), 1.0f, false));
            arbeit.setGesamtPreisBrutto(tModel.getEinbauCalculator().berechnePreisFuerAwNr(arbeit.getAwnummer(), arbeit.getMenge(), false));
            pos.setMwstSatz(mwSteuerSatz);
            pos.setMwStBetrag(Math.floor(pos.getMwstSatz() * pos.getGesamtPreis() + 0.5) / 100.0);
        }
        arbeit.setPosIntern(pos.getPos());
        tModel.arbeitHinzuf\u00fcgen(arbeit);
        arbeitHilf.add(arbeit);
    }

    private boolean isRefaArbeit(String awnummer) {
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug().getProduktArt() == 'M') {
            return !awnummer.equals("");
        }
        return false;
    }

    private void insertBauteil(KonfigurationsPosition pos, ArrayList<TechnischerBnb> bnbListe, TechnikModel tModel, Preise preise, double stdMwSteuerSatz) {
        Bauteil bauteil = new Bauteil(pos.getArtikelNummer());
        bauteil.setBenennung(pos.getArtikelBenennung());
        bauteil.setAktiv(true);
        bauteil.setMenge(pos.getMenge());
        bauteil.setEinzelPreis(pos.getPreis());
        bauteil.setBTEBauteil(false);
        bauteil.setPosIntern(pos.getPos());
        bauteil.setElementArt(pos.getElementArt());
        bauteil.setBemerkung(pos.getBemerkung());
        for (TechnischerBnb bnb : bnbListe) {
            if (!bnb.isHinzugefuegt()) continue;
            if (bnb.getBauteile() == null) {
                bnb.setBauteile(new ArrayList<Bauteil>());
            }
            bnb.getBauteile().add(bauteil);
            tModel.setAnzahlTeile(tModel.getAnzahlTeile() + pos.getMenge());
            return;
        }
        TechnischerBnb bnb = new TechnischerBnb();
        bnb.setHinzugefuegt(true);
        bnb.setElementArt(pos.getElementArt());
        if (bnb.getBauteile() == null) {
            bnb.setBauteile(new ArrayList<Bauteil>());
        }
        bnb.getBauteile().add(bauteil);
        tModel.setAnzahlTeile(tModel.getAnzahlTeile() + pos.getMenge());
        if (this.getAngebot() == null) {
            PreisZeile zeile = preise.findPreisZeileZuSachnummer(bauteil.getTeilenummer().replace(" ", ""));
            if (zeile != null) {
                pos.setMwstSatz(zeile.getMwSt());
                bauteil.setMwStSatz((float)zeile.getMwSt());
            } else {
                pos.setMwstSatz(stdMwSteuerSatz);
                bauteil.setMwStSatz((float)stdMwSteuerSatz);
            }
        }
        bnbListe.add(bnb);
    }

    private void loescheArbeit(KonfigurationsPosition pos, ArrayList<Arbeit> arbeiten) {
        Arbeit refArbeit = new Arbeit(pos.getArtikelNummer(), pos.getArtikelBenennung(), pos.getElementArt(), pos.getMenge(), pos.getBemerkung(), (float)pos.getPreis(), (float)pos.getGesamtPreis(), (double)((float)pos.getPreis()) + pos.getMwStBetrag(), (double)((float)pos.getGesamtPreis()) + pos.getMwStBetrag() * (double)pos.getMenge(), false);
        Iterator<Arbeit> it = arbeiten.iterator();
        while (it.hasNext()) {
            Arbeit arbeit = it.next();
            if (!arbeit.equals(refArbeit)) continue;
            it.remove();
        }
    }

    private void loescheBauteil(KonfigurationsPosition pos, ArrayList<TechnischerBnb> technischeBnbs) {
        Bauteil ref = new Bauteil(pos.getArtikelNummer());
        for (TechnischerBnb bnb : technischeBnbs) {
            for (Bauteil bauteil : bnb.getBauteile()) {
                if (!bauteil.equals(ref)) continue;
                bauteil.setAktiv(false);
                bauteil.setPosIntern(pos.getPos());
            }
        }
    }

    public MarketingModel getMarketingModel() {
        return this.mMarketingModel;
    }

    public void setMarketingModel(MarketingModel marketingModel) {
        this.mMarketingModel = marketingModel;
    }

    public TechnikModel getTechnikModel() {
        return this.mTechnikModel;
    }

    public void setTechnikModel(TechnikModel technikModel, Anfrage anfrage) {
        this.mTechnikModel = technikModel;
    }

    public void speichereKonfiguration(String letzteSicht) throws Exception {
        Anfrage anfrage;
        if (letzteSicht.equals("KALKULATION")) {
            ControllerKalkulationPanel.getInstance().updateKalkulationModel();
        }
        if ((anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage()) == null) {
            if (ControllerMarketingPanel.getInstance().getModel() != null && ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt() != null) {
                AnfrageHandler.getInstance().createAnfrage(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt(), this.mMarketingModel.getMarketingProdukt().isFahrzeugUngebunden() ? null : ControllerFBI.getInstance().getFbiModel().getFahrzeug(), this.mTechnikModel.getTechnikProdukt());
            } else {
                AnfrageHandler.getInstance().createAnfrage(this.mMarketingModel.getMarketingProdukt(), this.mMarketingModel.getMarketingProdukt().isFahrzeugUngebunden() ? null : ControllerFBI.getInstance().getFbiModel().getFahrzeug(), this.mTechnikModel.getTechnikProdukt());
            }
        }
        if ((anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage()).getVorgang() == null) {
            anfrage.setVorgang(AnfrageHandler.getInstance().createVorgang(this.mMarketingModel.getMarketingProdukt(), ControllerFBI.getInstance().getFbiModel().getFahrzeug(), anfrage));
        }
        if (anfrage.getAnfrageId() != 0) {
            anfrage.setAenderungsDatum(new Date());
            anfrage.setAenderungsNutzerId(GlobalObjects.getInstance().getSessionInfo().getLogin());
        }
        this.setLetzteSicht(letzteSicht);
        anfrage.getVorgang().setKonfiguration(this.getKonfiguration());
        if (anfrage.getVorgang() != null && anfrage.getVorgang().getFahrzeug() != null && (anfrage.getVorgang().getFahrzeug().getProduktArt() == '\u0000' || anfrage.getVorgang().getFahrzeug().getProduktArt() == ' ')) {
            anfrage.getVorgang().getFahrzeug().setProduktArt(GlobalObjects.getInstance().getSessionInfo().getProdukart().charAt(0));
        }
        int konfigId = this.getKonfigurationsId();
        int vorgangsId = anfrage.getVorgang().getVorgangsId();
        if (this.konfigUpdateKunde || konfigId == 0 && (anfrage.getKunde() != null || this.getAngebot() != null && this.getAngebot().getKunde() != null)) {
            int kundenId = 0;
            Kunde kundeToSave = null;
            if (this.getAngebot() != null && this.getAngebot().getKunde() != null) {
                kundenId = this.getAngebot().getKunde().getKundenId();
                kundeToSave = this.getAngebot().getKunde();
                this.konfigUpdateKunde = true;
            } else if (anfrage.getKunde() != null) {
                kundenId = anfrage.getKunde().getKundenId();
                kundeToSave = anfrage.getKunde();
                this.konfigUpdateKunde = true;
            }
            if (anfrage.getVorgang().getFahrzeug() != null && anfrage.getVorgang().getFahrzeug().getFahrgestellnummer() != null && kundeToSave != null) {
                if (kundeToSave.getFahrzeuge() == null) {
                    kundeToSave.setFahrzeuge(new ArrayList<Fahrzeug>());
                }
                kundeToSave.getFahrzeuge().add(anfrage.getVorgang().getFahrzeug());
            }
            if (kundeToSave != null && kundeToSave.getName() != null && GlobalObjects.getInstance().getIpacData().isSpeicherKunde()) {
                Kunde kunde = KalkulationDataLoader.speichereKunde(kundeToSave);
                if (kundenId == 0) {
                    if (this.getAngebot() != null) {
                        this.getAngebot().setKunde(kunde);
                    } else {
                        if (this.mKalkulationModel != null) {
                            this.mKalkulationModel.setAnfrage(anfrage);
                        }
                        anfrage.setKunde(kunde);
                    }
                }
            }
        }
        if (this.getPositionen() == null) {
            this.estimateKalkulationModelFromTechnik(anfrage, true);
        }
        anfrage = KalkulationDataLoader.speichereKonfiguration(anfrage, this.konfigUpdateAbschlag, this.addKonfigurationList, this.updateKonfigurationList, this.deleteKonfigurationList);
        if (this.konfigUpdateAngebot || konfigId == 0 && this.getAngebot() != null) {
            KalkulationDataLoader.speichereAngebot(this.getAngebot());
        } else if (this.konfigUpdateKunde && anfrage.getKunde() != null) {
            KalkulationDataLoader.speichereKundenZuordnung(anfrage);
        }
        int newKonfigId = 0;
        try {
            newKonfigId = anfrage.getVorgang().getKonfiguration().getKonfigurationsId();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (vorgangsId == 0 && anfrage.getVorgang().getVorgangsId() != 0) {
            ControllerMenuBar.getInstance().updateNewVorgang(anfrage.getVorgang());
        }
        if (konfigId == 0 && newKonfigId != 0) {
            MainController.getInstance().getMainFrame().getMainPanel().getConfigPanel().updateNewKonfiguration(newKonfigId);
        }
        GlobalObjects.getInstance().getIpacData().setAnfrage(anfrage);
        this.setKonfiguration(anfrage.getVorgang().getKonfiguration());
        this.addKonfigurationList.clear();
        this.updateKonfigurationList.clear();
        this.deleteKonfigurationList.clear();
        this.bauteileToUpdate.clear();
        this.arbeitToUpdate.clear();
        this.konfigUpdateAbschlag = false;
        this.konfigUpdateAngebot = false;
        this.konfigUpdateKunde = false;
    }

    public Konfiguration getKonfiguration() {
        Konfiguration konfig = new Konfiguration();
        konfig.setAlternativeBildPos(this.getAlternativeBildPos());
        konfig.setSelectedBnbsMitVarianten(this.getSelectedBnbsMitVarianten());
        konfig.setAnfrageId(this.getAnfrageId());
        konfig.setAngebot(this.getAngebot());
        konfig.setAufabschlag(this.getAufabschlag());
        konfig.setKonfigurationsId(this.getKonfigurationsId());
        konfig.setKonfigurationsIdVorlage(this.getKonfigurationsIdVorlage());
        konfig.setKonfigurationsName(this.getKonfigurationsName());
        konfig.setLetzteSicht(this.getLetzteSicht());
        konfig.setOptionaleProdukte(this.getOptionaleProdukte());
        konfig.setPositionen(this.getPositionen());
        konfig.setVorgangsId(this.getVorgangsId());
        return konfig;
    }

    public void synchronizeKonfigurationsPositionen(List<KonfigurationsPosition> positionen, boolean syncFromTModel) {
        List targetPos = this.getPositionen();
        for (KonfigurationsPosition position : positionen) {
            if (!targetPos.contains(position)) {
                targetPos.add(position);
                this.addKonfigurationList.add(position);
                continue;
            }
            KonfigurationsPosition tPos = (KonfigurationsPosition)this.getPositionen().get(this.getPositionen().indexOf(position));
            tPos.setArtikelBenennung(position.getArtikelBenennung());
            tPos.setElementArt(position.getElementArt());
            tPos.setGruppe(position.getGruppe());
            tPos.setMenge(position.getMenge());
            tPos.setPreis(position.getPreis());
            if (this.getAngebot() != null) {
                tPos.setMwstSatz(position.getMwstSatz());
                tPos.setMwStBetrag(position.getMwStBetrag());
            }
            tPos.setStatus(position.getStatus());
            tPos.setUpdated(position.isUpdated());
            if (!syncFromTModel) {
                tPos.setRabatt(position.getRabatt());
            }
            if (position.isUpdated() && !this.updateKonfigurationList.contains(tPos)) {
                this.updateKonfigurationList.add(tPos);
                continue;
            }
            if (!position.isUpdated()) continue;
            this.updateKonfigurationList.set(this.updateKonfigurationList.indexOf(tPos), tPos);
        }
        Iterator it = targetPos.iterator();
        while (it.hasNext()) {
            KonfigurationsPosition position;
            position = (KonfigurationsPosition)it.next();
            if (positionen.contains(position)) continue;
            boolean temporaryCreated = false;
            if (this.addKonfigurationList.contains(position)) {
                this.addKonfigurationList.remove(position);
                temporaryCreated = true;
            }
            if (this.updateKonfigurationList.contains(position)) {
                this.updateKonfigurationList.remove(position);
                temporaryCreated = true;
            }
            if (!temporaryCreated && this.konfigurationsId != 0) {
                this.deleteKonfigurationList.add(position);
            }
            it.remove();
        }
    }

    private List<KonfigurationsPosition> ermittlePositionenArbeit(List<Arbeit> marketingArbeit, List<Arbeit> technischeArbeit, String gruppe, String elementArt, Preise preise, double mwSteuer) {
        KonfigurationsPosition pos;
        ArrayList<KonfigurationsPosition> positionen = new ArrayList<KonfigurationsPosition>();
        for (Arbeit arbeit : technischeArbeit) {
            if (!marketingArbeit.contains(arbeit) || arbeit.isHinzugefuegt()) {
                pos = new KonfigurationsPosition(gruppe, elementArt, "INSERT", 'A', arbeit.getAwnummer(), arbeit.getBenennung(), arbeit.getMenge(), ControllerTechnikPanel.getInstance().getModel().getEinbauCalculator().berechnePreisFuerAwNr(arbeit.getAwnummer(), 1.0f, true), 0.0, arbeit.getBemerkung());
                if (arbeit.getPosIntern() == 0) {
                    ++this.posNr;
                    arbeit.setPosIntern(this.posNr);
                }
                if (this.getAngebot() == null) {
                    pos.setMwstSatz(mwSteuer);
                    pos.setMwStBetrag(Math.floor(mwSteuer * pos.getGesamtPreis() + 0.5) / 100.0);
                }
                pos.setPos(arbeit.getPosIntern());
                if (this.arbeitToUpdate.contains(arbeit)) {
                    pos.setUpdated(true);
                }
                positionen.add(pos);
                continue;
            }
            pos = new KonfigurationsPosition(gruppe, elementArt, "PUB", 'A', arbeit.getAwnummer(), arbeit.getBenennung(), arbeit.getMenge(), arbeit.getEinzelPreisNettoNumeric(), 0.0, arbeit.getBemerkung());
            if (arbeit.getPosIntern() == 0) {
                ++this.posNr;
                arbeit.setPosIntern(this.posNr);
            }
            pos.setPos(arbeit.getPosIntern());
            if (this.getAngebot() == null) {
                pos.setMwstSatz(mwSteuer);
                pos.setMwStBetrag(Math.floor(mwSteuer * pos.getGesamtPreis() + 0.5) / 100.0);
            }
            if (this.arbeitToUpdate.contains(arbeit)) {
                pos.setUpdated(true);
            }
            positionen.add(pos);
        }
        for (Arbeit arbeit : marketingArbeit) {
            if (technischeArbeit.contains(arbeit)) continue;
            pos = new KonfigurationsPosition(gruppe, elementArt, "DELETE", 'A', arbeit.getAwnummer(), arbeit.getBenennung(), arbeit.getMenge(), arbeit.getEinzelPreisNettoNumeric(), 0.0, arbeit.getBemerkung());
            if (arbeit.getPosIntern() == 0) {
                ++this.posNr;
                arbeit.setPosIntern(this.posNr);
            }
            pos.setPos(arbeit.getPosIntern());
            if (this.getAngebot() == null) {
                pos.setMwstSatz(mwSteuer);
                pos.setMwStBetrag(Math.floor(mwSteuer * pos.getGesamtPreis() + 0.5) / 100.0);
            }
            if (this.arbeitToUpdate.contains(arbeit)) {
                pos.setUpdated(true);
            }
            positionen.add(pos);
        }
        return positionen;
    }

    private List<KonfigurationsPosition> ermittlePositionen(List<TechnischerBnb> marketingBnb, List<TechnischerBnb> technischeBnb, String gruppe, Preise preise) {
        KonfigurationsPosition pos;
        ArrayList<KonfigurationsPosition> positionen = new ArrayList<KonfigurationsPosition>();
        for (TechnischerBnb bnb : technischeBnb) {
            KonfigurationsPosition pos2;
            if (!marketingBnb.contains(bnb) || bnb.isHinzugefuegt()) {
                if (bnb.getBauteile() == null) continue;
                for (Bauteil bauteil : bnb.getBauteile()) {
                    pos = new KonfigurationsPosition(gruppe, bnb.getElementArt() == null ? "HILFSSTOFFE" : bnb.getElementArt(), "INSERT", 'T', bauteil.getTeilenummer(), bauteil.getBenennung().trim().substring(0, Math.min(bauteil.getBenennung().trim().length(), 100)), bauteil.getMenge(), bauteil.getEinzelPreis(), 0.0, bauteil.getBemerkung());
                    if (bauteil.getPosIntern() == 0) {
                        ++this.posNr;
                        bauteil.setPosIntern(this.posNr);
                    }
                    pos.setPos(bauteil.getPosIntern());
                    pos.setUpdated(this.bauteileToUpdate.contains(bauteil));
                    this.setPosPreiseBauteil(preise, bnb, bauteil, pos);
                    if (!positionen.contains(bauteil)) {
                        positionen.add(pos);
                        continue;
                    }
                    positionen.set(positionen.indexOf(pos), pos);
                }
                continue;
            }
            TechnischerBnb bnbOld = marketingBnb.get(marketingBnb.indexOf(bnb));
            if (bnb.getBauteile() != null) {
                for (Bauteil bauteil : bnb.getBauteile()) {
                    if (!bnbOld.getBauteile().contains(bauteil)) {
                        pos2 = new KonfigurationsPosition(gruppe, bnb.getElementArt() == null ? "HILFSSTOFFE" : bnb.getElementArt(), "INSERT", 'T', bauteil.getTeilenummer(), bauteil.getBenennung().trim().substring(0, Math.min(bauteil.getBenennung().trim().length(), 100)), bauteil.getMenge(), bauteil.getEinzelPreis(), 0.0, bauteil.getBemerkung());
                        if (bauteil.getPosIntern() == 0) {
                            ++this.posNr;
                            bauteil.setPosIntern(this.posNr);
                        }
                        pos2.setPos(bauteil.getPosIntern());
                        pos2.setUpdated(this.bauteileToUpdate.contains(bauteil));
                        this.setPosPreiseBauteil(preise, bnb, bauteil, pos2);
                        if (!positionen.contains(pos2)) {
                            positionen.add(pos2);
                            continue;
                        }
                        positionen.set(positionen.indexOf(pos2), pos2);
                        continue;
                    }
                    if (bauteil.isAktiv()) {
                        pos2 = new KonfigurationsPosition(gruppe, bnb.getElementArt(), "PUB", 'T', bauteil.getTeilenummer(), bauteil.getBenennung().trim().substring(0, Math.min(bauteil.getBenennung().trim().length(), 100)), bauteil.getMenge(), bauteil.getEinzelPreis(), 0.0, bauteil.getBemerkung());
                        if (bauteil.getPosIntern() == 0) {
                            ++this.posNr;
                            bauteil.setPosIntern(this.posNr);
                        }
                        pos2.setPos(bauteil.getPosIntern());
                        pos2.setUpdated(this.bauteileToUpdate.contains(bauteil));
                        this.setPosPreiseBauteil(preise, bnb, bauteil, pos2);
                        if (!positionen.contains(pos2)) {
                            positionen.add(pos2);
                            continue;
                        }
                        positionen.set(positionen.indexOf(pos2), pos2);
                        continue;
                    }
                    pos2 = new KonfigurationsPosition(gruppe, bnb.getElementArt(), "DELETE", 'T', bauteil.getTeilenummer(), bauteil.getBenennung().trim().substring(0, Math.min(bauteil.getBenennung().trim().length(), 100)), bauteil.getMenge(), bauteil.getEinzelPreis(), 0.0, bauteil.getBemerkung());
                    if (bauteil.getPosIntern() == 0) {
                        ++this.posNr;
                        bauteil.setPosIntern(this.posNr);
                    }
                    pos2.setPos(bauteil.getPosIntern());
                    pos2.setUpdated(this.bauteileToUpdate.contains(bauteil));
                    this.setPosPreiseBauteil(preise, bnb, bauteil, pos2);
                    if (!positionen.contains(pos2)) {
                        positionen.add(pos2);
                        continue;
                    }
                    positionen.set(positionen.indexOf(pos2), pos2);
                }
            }
            if (bnbOld.getBauteile() == null) continue;
            for (Bauteil bauteil : bnbOld.getBauteile()) {
                if (bnb.getBauteile().contains(bauteil)) continue;
                pos2 = new KonfigurationsPosition(gruppe, bnb.getElementArt(), "DELETE", 'T', bauteil.getTeilenummer(), bauteil.getBenennung().trim().substring(0, Math.min(bauteil.getBenennung().trim().length(), 100)), bauteil.getMenge(), bauteil.getEinzelPreis(), 0.0, bauteil.getBemerkung());
                if (bauteil.getPosIntern() == 0) {
                    ++this.posNr;
                    bauteil.setPosIntern(this.posNr);
                }
                pos2.setPos(bauteil.getPosIntern());
                pos2.setUpdated(this.bauteileToUpdate.contains(bauteil));
                this.setPosPreiseBauteil(preise, bnb, bauteil, pos2);
                if (!positionen.contains(pos2)) {
                    positionen.add(pos2);
                    continue;
                }
                positionen.set(positionen.indexOf(pos2), pos2);
            }
        }
        for (TechnischerBnb bnb : marketingBnb) {
            if (technischeBnb.contains(bnb)) continue;
            for (Bauteil bauteil : bnb.getBauteile()) {
                pos = new KonfigurationsPosition(gruppe, bnb.getElementArt(), "DELETE", 'T', bauteil.getTeilenummer(), bauteil.getBenennung().trim().substring(0, Math.min(bauteil.getBenennung().trim().length(), 100)), bauteil.getMenge(), bauteil.getEinzelPreis(), 0.0, bauteil.getBemerkung());
                if (bauteil.getPosIntern() == 0) {
                    ++this.posNr;
                    bauteil.setPosIntern(this.posNr);
                }
                pos.setPos(bauteil.getPosIntern());
                pos.setUpdated(this.bauteileToUpdate.contains(bauteil));
                this.setPosPreiseBauteil(preise, bnb, bauteil, pos);
                if (!positionen.contains(pos)) {
                    positionen.add(pos);
                    continue;
                }
                positionen.set(positionen.indexOf(pos), pos);
            }
        }
        return positionen;
    }

    private void setPosPreiseBauteil(Preise preise, TechnischerBnb bnb, Bauteil bauteil, KonfigurationsPosition pos) {
        PreisZeile zeile = preise.findPreisZeileZuSachnummer(bauteil.getTeilenummer());
        if (zeile != null && !bnb.isHinzugefuegt() && this.getAngebot() == null) {
            if (zeile.getPreis() != null) {
                pos.setPreis(zeile.getPreis());
            } else {
                pos.setPreis(0.0);
            }
            pos.setMwstSatz(zeile.getMwSt());
            pos.setRabatt(zeile.getRabatt());
            pos.setMwStBetrag(Math.floor(pos.getGesamtPreis() * pos.getMwstSatz() + 0.5) / 100.0);
        } else if (this.getAngebot() == null) {
            if (bauteil.getEinzelPreis() != null) {
                pos.setPreis(bauteil.getEinzelPreis());
            } else {
                pos.setPreis(0.0);
            }
            pos.setMwstSatz(bauteil.getMwStSatz());
            pos.setMwStBetrag(Math.floor(pos.getGesamtPreis() * pos.getMwstSatz() + 0.5) / 100.0);
        }
    }

    public void addMiniaturAnsicht(IMiniaturPanel panel) {
        if (this.mMiniPanels != null) {
            if (this.mMiniPanels.contains(panel)) {
                this.mMiniPanels.remove(panel);
            }
            this.mMiniPanels.add(panel);
        }
    }

    public List<IMiniaturPanel> getMiniPanels() {
        return this.mMiniPanels;
    }

    public void setMiniPanels(List<IMiniaturPanel> miniPanels) {
        this.mMiniPanels = miniPanels;
    }

    public void synchronizeMiniPanels() {
        for (IMiniaturPanel panel : this.mMiniPanels) {
            panel.update();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!WorkflowController.getInstance().isFzBedIdentified() || GlobalObjects.getInstance().getIpacData().getAnfrage() == null) {
            return;
        }
        if (o instanceof ControllerTechnikPanel) {
            if (arg == null) {
                this.mTechnikModel = ControllerTechnikPanel.getInstance().getModel();
            }
            if (arg instanceof List) {
                this.bauteileToUpdate.addAll((List)arg);
            }
            if (arg instanceof Bauteil) {
                this.bauteileToUpdate.add((Bauteil)arg);
            }
            this.mTechnikModel = ControllerTechnikPanel.getInstance().getModel();
            if (arg instanceof Arbeit) {
                this.arbeitToUpdate.add((Arbeit)arg);
            }
            this.estimateKalkulationModelFromTechnik(GlobalObjects.getInstance().getIpacData().getAnfrage(), false);
        }
        if (o instanceof ControllerKalkulationPanel) {
            ControllerKalkulationPanel panel = (ControllerKalkulationPanel)o;
            if (arg == null) {
                return;
            }
            if (arg instanceof Kunde) {
                this.konfigUpdateKunde = true;
                if (this.getAngebot() != null) {
                    this.getAngebot().setKunde((Kunde)arg);
                } else {
                    GlobalObjects.getInstance().getIpacData().getAnfrage().setKunde((Kunde)arg);
                    this.konfigUpdateKunde = true;
                }
                return;
            }
            if (arg instanceof Angebot) {
                Angebot angebot = (Angebot)arg;
                Kunde kunde = GlobalObjects.getInstance().getIpacData().getAnfrage().getKunde();
                if (angebot.getKunde() == null && kunde != null) {
                    angebot.setKunde(kunde);
                }
                this.setAngebot(angebot);
                this.konfigUpdateAngebot = true;
            }
            if (arg instanceof String && arg.toString().equals("aufAbschlag")) {
                this.konfigUpdateAbschlag = true;
                this.setAufabschlag(panel.getModel().getAufAbschlag());
            }
            if (arg instanceof Integer) {
                int konfigPos = (Integer)arg;
                KonfigurationsPosition pos = panel.getModel().getKonfiguration().getPosition(konfigPos);
                this.getPositionen().set(konfigPos, pos);
                this.updateKonfigurationList.add(panel.getModel().getKonfiguration().getPosition(konfigPos));
            }
            this.synchronizeKonfigurationsPositionen(this.mKalkulationModel.getKonfiguration().getPositionen(), false);
            this.getKalkulationModel().getKonfiguration().setPositionen(this.getPositionen());
            if (this.mKalkulationModel.getKonfiguration().getAngebot() != null) {
                this.setAngebot(this.mKalkulationModel.getKonfiguration().getAngebot());
            }
            if (panel.getModel() != null) {
                panel.getModel().updateTableData();
            }
        }
        this.synchronizeMiniPanels();
    }

    public void setKonfiguration(Konfiguration konfig) {
        this.setSelectedBnbsMitVarianten(konfig.getSelectedBnbsMitVarianten());
        this.setAnfrageId(konfig.getAnfrageId());
        this.setAngebot(konfig.getAngebot());
        this.setAufabschlag(konfig.getAufabschlag());
        this.setKonfigurationsId(konfig.getKonfigurationsId());
        this.setKonfigurationsIdVorlage(konfig.getKonfigurationsIdVorlage());
        this.setKonfigurationsName(konfig.getKonfigurationsName());
        this.setLetzteSicht(konfig.getLetzteSicht());
        this.setPositionen(konfig.getPositionen());
        this.setVorgangsId(konfig.getVorgangsId());
    }

    public void estimateModels(Anfrage anfrage, boolean fromCreation) {
        if (fromCreation && this.getPositionen() != null) {
            this.getPositionen().clear();
        }
        this.estimateTechnikModelFromMarketing(anfrage);
        this.estimateKalkulationModelFromTechnik(anfrage, fromCreation);
    }

    public void estimateKalkulationModelFromTechnik(Anfrage anfrage, boolean fromCreation) {
        if (this.mMarketingModel != null) {
            TechnikModel model = this.mTechnikModel;
            ArrayList<KonfigurationsPosition> pos = new ArrayList<KonfigurationsPosition>();
            TechnischesProdukt produkt = ControllerTechnikPanel.getInstance().getModel().getTechnikProdukt();
            if (this.mMarketingModel == null || this.mTechnikModel == null || this.mTechnikModel.getTechnikProdukt() == null) {
                return;
            }
            this.posNr = this.ermittleMaxPosNr(this.mTechnikModel);
            pos.addAll(this.ermittlePositionen(produkt.getKernProduktBnbs(), this.mTechnikModel.getKernProduktBnbs(), KERNPRODUKT, produkt.getPreise()));
            pos.addAll(this.ermittlePositionenArbeit(model.getArbeitKernprodukt(), this.mTechnikModel.getArbeitKernprodukt(), KERNPRODUKT, "HP_OBLIGAT", produkt.getPreise(), this.mwSteuerSatzHoch));
            pos.addAll(this.ermittlePositionen(produkt.getZusatzProduktBnbs(), this.mTechnikModel.getZusatzProduktBnbs(), "OPTIONAL", produkt.getPreise()));
            pos.addAll(this.ermittlePositionenArbeit(model.getArbeitZusatzprodukt(), this.mTechnikModel.getArbeitZusatzprodukt(), "OPTIONAL", "OPTIONAL", produkt.getPreise(), this.mwSteuerSatzHoch));
            pos.addAll(this.ermittlePositionen(produkt.getHilfsStoffeBnbs(), this.mTechnikModel.getHilfBnbs(), "HUB", produkt.getPreise()));
            pos.addAll(this.ermittlePositionenArbeit(model.getArbeitHilf(), this.mTechnikModel.getArbeitHilf(), "HUB", "HILFSSTOFFE", produkt.getPreise(), this.mwSteuerSatzHoch));
            if (this.getPositionen() == null && pos != null) {
                this.setPositionen(pos);
            }
            this.synchronizeKonfigurationsPositionen(pos, !fromCreation);
            if (this.mKalkulationModel == null) {
                if (anfrage != null) {
                    anfrage.getVorgang().setKonfiguration(this);
                } else {
                    AnfrageHandler.getInstance().createAnfrage(this.mMarketingModel.getMarketingProdukt(), GlobalObjects.getInstance().getIpacData().getFahrzeug(), model.getTechnikProdukt());
                }
                KalkulationModel kalkulationModel = new KalkulationModel();
                kalkulationModel.setAnfrage(anfrage);
                this.mKalkulationModel = kalkulationModel;
            } else {
                this.mKalkulationModel.getKonfiguration().setPositionen(this.getPositionen());
            }
            this.mKalkulationModel.updateTableData();
        } else if (GlobalObjects.getInstance().getIpacData().getAnfrage() != null) {
            KalkulationModel model = new KalkulationModel();
            model.setAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage());
            this.mKalkulationModel = model;
        }
    }

    private int ermittleMaxPosNr(TechnikModel technikModel) {
        int pos = 0;
        for (TechnischerBnb bnb : technikModel.getKernProduktBnbs()) {
            for (Bauteil bauteil : bnb.getBauteile()) {
                if (bauteil.getPosIntern() <= pos) continue;
                pos = bauteil.getPosIntern();
            }
        }
        for (TechnischerBnb bnb : technikModel.getZusatzProduktBnbs()) {
            for (Bauteil bauteil : bnb.getBauteile()) {
                if (bauteil.getPosIntern() <= pos) continue;
                pos = bauteil.getPosIntern();
            }
        }
        for (TechnischerBnb bnb : technikModel.getHilfBnbs()) {
            for (Bauteil bauteil : bnb.getBauteile()) {
                if (bauteil.getPosIntern() <= pos) continue;
                pos = bauteil.getPosIntern();
            }
        }
        for (Arbeit arbeit : technikModel.getArbeitKernprodukt()) {
            if (arbeit == null || arbeit.getPosIntern() <= pos) continue;
            pos = arbeit.getPosIntern();
        }
        for (Arbeit arbeit : technikModel.getArbeitZusatzprodukt()) {
            if (arbeit == null || arbeit.getPosIntern() <= pos) continue;
            pos = arbeit.getPosIntern();
        }
        for (Arbeit arbeit : technikModel.getArbeitHilf()) {
            if (arbeit == null || arbeit.getPosIntern() <= pos) continue;
            pos = arbeit.getPosIntern();
        }
        return pos;
    }

    public void estimateTechnikModelFromMarketing(Anfrage anfrage) {
        if (this.mMarketingModel.getSelectedAlternative() != null) {
            this.setAlternativeBildPos(this.mMarketingModel.getSelectedAlternative().getBildPos());
        }
        if (this.mMarketingModel.getSelectedZusatzprodukte() != null) {
            ArrayList<String> optionaleBnbs = new ArrayList<String>();
            for (ProduktListenElement bnb : this.mMarketingModel.getSelectedZusatzprodukte()) {
                optionaleBnbs.add(bnb.getBildPosNr());
            }
            this.setOptionaleProdukte(optionaleBnbs);
        }
        this.setSelectedBnbsMitVarianten(this.mMarketingModel.getMarketingProdukt().getSelectedBnbsMitVarianten());
        if (this.mTechnikModel == null) {
            Fahrzeug info = null;
            IIpacData ipacData = GlobalObjects.getInstance().getIpacData();
            if (ipacData.getAnfrage() != null && ipacData.getAnfrage().getVorgang() != null && ipacData.getAnfrage().getVorgang().getFahrzeug() != null) {
                info = ipacData.getAnfrage().getVorgang().getFahrzeug();
            } else if (ipacData.getFahrzeug() != null) {
                info = ipacData.getFahrzeug();
            }
            if (info != null) {
                TechnikModel model = new TechnikModel();
                try {
                    model.setAufwaende(AdminDataLoader.ladeAufwandKonfiguration(GlobalObjects.getInstance().getSessionInfo().getFilialeId(), GlobalObjects.getInstance().getSessionInfo().getMarke(), GlobalObjects.getInstance().getSessionInfo().getProdukart()));
                    MarketingProdukt produkt = this.mMarketingModel.getMarketingProdukt();
                    model.setTechnikProdukt(TechnikDataloader.getTechnikProdukt(produkt, info, "ALLES", null));
                    this.setTechnikModel(model, anfrage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mTechnikModel = null;
                }
            }
        }
    }

    public int getAnzahlKonfigTeile() {
        int teil = 0;
        for (KonfigurationsPosition pos : this.positionen) {
            if (!pos.getStatus().equals("PUB") && !pos.getStatus().equals("INSERT") || pos.getArt() != 'T') continue;
            ++teil;
        }
        return teil;
    }

    public int getAnzahlKonfigArbeiten() {
        int arbeit = 0;
        for (KonfigurationsPosition pos : this.positionen) {
            if (!pos.getStatus().equals("PUB") && !pos.getStatus().equals("INSERT") || pos.getArt() != 'A') continue;
            ++arbeit;
        }
        return arbeit;
    }

    public void setKalkulationSet(boolean kalkulation) {
        this.mKalkulationSet = kalkulation;
    }

    public boolean isKalkulationSet() {
        return this.mKalkulationSet;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public double getMwSteuerSatzHoch() {
        return this.mwSteuerSatzHoch;
    }
}

