/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.VorgangKonfigView;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.resources.Resource;

public class ConfigurationPanel
extends Observable {
    private static Logger log = Logger.getLogger(ConfigurationPanel.class);
    private MarkenLayout mLayout;
    private JPanel configPanel;
    private JPanel currentConfigurationPanel = null;
    private JPanel newConfigurationPanel = null;
    private Dimension confDim;
    private JLabel configLabel;
    private JButton newConfigButton = null;
    public static final String KONFIGURATION = "KONFIGURATION";
    private int countKonfigurationen = 0;
    private Hashtable<Integer, VorgangKonfigView> konfigurationenButtonHashtable = null;
    private ArrayList<Integer> reihenfolge = null;
    private boolean isFBAVisible = false;

    public ConfigurationPanel(MarkenLayout markenLayout, Dimension dim) {
        this.mLayout = markenLayout;
        this.confDim = dim;
        this.configPanel = new JPanel(new BorderLayout());
        this.configPanel.setPreferredSize(this.confDim);
        this.configPanel.setMaximumSize(this.confDim);
        this.configPanel.setMinimumSize(this.confDim);
        this.configPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.configPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Constants.Layout.RAHMEN_COLOR));
        this.currentConfigurationPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.currentConfigurationPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.currentConfigurationPanel.setBorder(BorderFactory.createEmptyBorder());
        this.newConfigurationPanel = new JPanel(new CardLayout());
        this.newConfigurationPanel.setPreferredSize(new Dimension(50, this.confDim.height));
        this.newConfigurationPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.newConfigurationPanel.setBorder(BorderFactory.createEmptyBorder());
        this.configLabel = new JLabel(" " + Resource.getInstance().getKonfigurationen() + ":", 2);
        this.configLabel.setBoldFont();
        this.configLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.configLabel.setPreferredSize(new Dimension(115, 18));
        this.configLabel.setMinimumSize(new Dimension(115, 18));
        this.configLabel.setMaximumSize(new Dimension(115, 18));
        this.currentConfigurationPanel.add(this.configLabel);
        this.newConfigButton = new JButton(ImageCache.getInstance().getIcon(this.mLayout.getDefaultIconPath() + "neue_konfig1.gif"));
        this.newConfigButton.setName("Neu");
        this.newConfigButton.setPreferredSize(new Dimension(25, 18));
        this.newConfigButton.setBackground(this.mLayout.getPrimaryBackground());
        this.newConfigButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.newConfigurationPanel.add((Component)this.newConfigButton, "Konfiguration");
        this.configPanel.add((Component)this.currentConfigurationPanel, "Center");
        this.configPanel.add((Component)this.newConfigurationPanel, "East");
        this.currentConfigurationPanel.validate();
        this.configPanel.validate();
    }

    public void addConfigurationButton(String text, Integer konfigurationsId) {
        ++this.countKonfigurationen;
        VorgangKonfigView vorgangView = new VorgangKonfigView(konfigurationsId.toString(), text, new Dimension(95, 18), "schliessen_small_aktiv.gif", false);
        vorgangView.setName(text);
        this.currentConfigurationPanel.add(vorgangView);
        if (this.konfigurationenButtonHashtable == null) {
            this.konfigurationenButtonHashtable = new Hashtable();
        }
        if (this.reihenfolge == null) {
            this.reihenfolge = new ArrayList();
        }
        this.konfigurationenButtonHashtable.put(konfigurationsId, vorgangView);
        this.reihenfolge.add(konfigurationsId);
        this.selectButton(konfigurationsId);
        this.currentConfigurationPanel.validate();
        this.configPanel.validate();
        this.setChanged();
        this.notifyObservers(vorgangView);
    }

    public void removeAllConfigurations() {
        if (this.currentConfigurationPanel != null && this.configPanel != null) {
            this.countKonfigurationen = 0;
            this.currentConfigurationPanel.removeAll();
            if (this.reihenfolge != null) {
                this.reihenfolge.clear();
            }
            if (this.konfigurationenButtonHashtable != null) {
                this.konfigurationenButtonHashtable.clear();
            }
            this.currentConfigurationPanel.add(this.configLabel);
            this.currentConfigurationPanel.validate();
            this.configPanel.validate();
            MainController.getInstance().getMainFrame().getRootPane().updateUI();
        }
    }

    public void removeConfiguration(Integer id) {
        VorgangKonfigView vorgangView = this.konfigurationenButtonHashtable.get(id);
        this.konfigurationenButtonHashtable.remove(id);
        for (int i = 0; i < this.reihenfolge.size(); ++i) {
            if (!this.reihenfolge.get(i).equals(id)) continue;
            this.reihenfolge.remove(i);
            break;
        }
        if (vorgangView != null) {
            vorgangView.getSchliessen().removeMouseListener(ControllerMenuBar.getInstance());
            vorgangView.getBenennung().removeMouseListener(ControllerMenuBar.getInstance());
            vorgangView.removeAll();
            this.currentConfigurationPanel.remove(vorgangView);
            --this.countKonfigurationen;
            this.currentConfigurationPanel.validate();
            this.currentConfigurationPanel.updateUI();
            this.configPanel.validate();
            this.configPanel.updateUI();
        }
        if (this.countKonfigurationen == 0) {
            this.removeAllConfigurations();
        }
    }

    public void deselectAllButtons() {
        this.mLayout = WorkflowController.getInstance().getMarkenLayout();
        if (this.konfigurationenButtonHashtable != null) {
            Enumeration<VorgangKonfigView> vorgaengeLabelEnumeration = this.konfigurationenButtonHashtable.elements();
            VorgangKonfigView vorgangView = null;
            while (vorgaengeLabelEnumeration.hasMoreElements()) {
                vorgangView = vorgaengeLabelEnumeration.nextElement();
                vorgangView.setSelected(false);
                vorgangView.getSchliessen().setIcon(new ImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "schliessen_small_inaktiv.gif")));
                vorgangView.setBackground(this.mLayout.getDeselectedReiterBackground());
                vorgangView.getBenennung().setForeground(this.mLayout.getDeselectedReiterForeground());
            }
        }
    }

    public void selectButton(Integer konfigurationsId) {
        this.deselectAllButtons();
        if (konfigurationsId == null) {
            return;
        }
        if (this.konfigurationenButtonHashtable.containsKey(konfigurationsId)) {
            VorgangKonfigView vorgangView = this.konfigurationenButtonHashtable.get(konfigurationsId);
            vorgangView.setBackground(this.mLayout.getSelectedReiterBackground());
            vorgangView.setForeground(this.mLayout.getSelectedReiterForeground());
            vorgangView.setSelected(true);
            vorgangView.getBenennung().setForeground(this.mLayout.getSelectedReiterForeground());
            vorgangView.getSchliessen().setIcon(new ImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "schliessen_small_aktiv.gif")));
        } else {
            log.error((Object)("An Element with the key " + konfigurationsId + " doesn't exist in the hashtable"));
        }
    }

    public JPanel getConfiguratorPanel() {
        return this.configPanel;
    }

    public void setLayout(MarkenLayout markenLayout) {
        this.mLayout = markenLayout;
        this.configPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.configLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.configLabel.setBoldFont();
        this.newConfigButton.setBackground(this.mLayout.getPrimaryBackground());
        this.currentConfigurationPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.currentConfigurationPanel.setBorder(BorderFactory.createEmptyBorder());
        this.newConfigurationPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.newConfigurationPanel.setBorder(BorderFactory.createEmptyBorder());
    }

    public ArrayList<Integer> getReihenfolge() {
        return this.reihenfolge;
    }

    public JButton getNewConfigButton() {
        return this.newConfigButton;
    }

    public void updateNewKonfiguration(int konfigId) {
        for (Integer key : this.konfigurationenButtonHashtable.keySet()) {
            if (key != 0) continue;
            try {
                this.updateKalkulationView(key, konfigId);
            }
            catch (NoDataFoundException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            break;
        }
    }

    private void updateKalkulationView(Integer oldKey, Integer newKey) throws NoDataFoundException {
        VorgangKonfigView vorgangView = this.konfigurationenButtonHashtable.get(oldKey);
        if (vorgangView == null) {
            throw new NoDataFoundException("An Element with the key " + oldKey + " doesn't exist in the hashtable");
        }
        this.konfigurationenButtonHashtable.remove(oldKey);
        vorgangView.setId(newKey);
        this.konfigurationenButtonHashtable.put(newKey, vorgangView);
        for (int i = 0; i < this.reihenfolge.size(); ++i) {
            if (!this.reihenfolge.get(i).equals(0)) continue;
            this.reihenfolge.remove(i);
            this.reihenfolge.add(i, newKey);
            break;
        }
    }

    public int getCountKonfigurationen() {
        return this.countKonfigurationen;
    }

    public Hashtable<Integer, VorgangKonfigView> getKonfigurationenButtonHashtable() {
        return this.konfigurationenButtonHashtable;
    }

    public boolean isFBAVisible() {
        return this.isFBAVisible;
    }

    public void setFBAVisible(boolean isFBAVisible) {
        this.isFBAVisible = isFBAVisible;
    }
}

