/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ConfigurationPanel;
import de.esg.zub.configurator.content.ControllerConfigurationPanel;
import de.esg.zub.configurator.content.HeaderPanel;
import de.esg.zub.configurator.content.MainContainer;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationsPanel;
import de.esg.zub.configurator.content.marketing.ControllerFBA;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.FBA;
import de.esg.zub.configurator.content.marketing.FBI;
import de.esg.zub.configurator.content.marketing.MarketingPanel;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.content.suche.ProduktListPanel;
import de.esg.zub.configurator.content.suche.SubCategoryPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.TechnikPanel;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.MarkenProdukte;
import webetk.resources.Resource;

public class MainPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private Hashtable<String, MainContainer> cardContainers;
    private SubCategoryPanel subCategoryPanel;
    private ProduktListPanel produktListPanel;
    private MarketingPanel marketingPanel;
    private TechnikPanel technikPanel;
    private KalkulationsPanel kalkPanel;
    private JPanel startPanel;
    private FBI mFbi;
    private FBA mFba;
    private ConfigurationPanel mConfigPanel;
    private HeaderPanel mHeaderPanel;
    private JLabel mGraphikLabel = null;
    private String aktuellPanelName = "";
    private MarkenLayout mLayout;
    private boolean isConfigPanelSet = false;
    private Dimension mainPanelDim;
    public static final int MAX_HEADER_LENGTH = 60;

    public MainPanel(MarkenLayout markenLayout) {
        this.mLayout = markenLayout;
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.setLayout(new CardLayout());
        this.mainPanelDim = new Dimension(808, 660);
        this.setPreferredSize(this.mainPanelDim);
        this.mHeaderPanel = new HeaderPanel("", "");
        this.setVisible(true);
        if (WorkflowController.getInstance().getActiveState() != null) {
            this.aktuellPanelName = WorkflowController.getInstance().getActiveState().getName();
        }
        this.cardContainers = new Hashtable();
    }

    private void addPanelToCard(JPanel panel, String panelName, HeaderPanel headerPanel) {
        MainContainer mainContainer = new MainContainer(this.mainPanelDim, this.mLayout, headerPanel, panel, panelName);
        mainContainer.validate();
        this.cardContainers.put(panelName, mainContainer);
        this.aktuellPanelName = panelName;
        this.add((Component)mainContainer, panelName);
    }

    public void showInitialisierungGraphik() {
        MarkeProdukt oMrkPrd = MarkenProdukte.getInstance(2).getMarkeProdukt(this.mLayout.getMarke(), this.mLayout.getProdukt());
        ImageIcon initImageIcon = (ImageIcon)ImageCache.getInstance().getIcon(oMrkPrd.getImageStart());
        if (this.startPanel == null) {
            HeaderPanel header = new HeaderPanel("", "");
            header.addMouseListener(new HilfeMouseListener("i50033"));
            this.startPanel = new JPanel(new GridBagLayout());
            this.startPanel.setBackground(this.mLayout.getPrimaryBackground());
            this.addPanelToCard(this.startPanel, "CONFIG", header);
            this.mGraphikLabel = new JLabel();
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
            this.startPanel.add((Component)this.mGraphikLabel, gbc);
            this.startPanel.validate();
            this.startPanel.updateUI();
            this.startPanel.addMouseListener(new HilfeMouseListener("i50033"));
        }
        this.aktuellPanelName = "CONFIG";
        this.removeFBA();
        this.cardContainers.get("CONFIG").getHeaderPanel().setBackground(this.mLayout.getPrimaryBackground());
        this.startPanel.setBackground(WorkflowController.getInstance().getMarkenLayout().getPrimaryBackground());
        this.mGraphikLabel.setIcon(initImageIcon);
        this.mGraphikLabel.validate();
        ((CardLayout)this.getLayout()).show(this, "CONFIG");
        if (this.mConfigPanel == null) {
            this.mConfigPanel = ControllerConfigurationPanel.getInstance().getConfigurationPanel();
        }
        if (this.isConfigPanelSet) {
            this.addConfigPanel();
        } else {
            this.removeConfigPanel();
        }
    }

    public void showUnterkategorien(String kategorie, ArrayList<HitListenUnterkategorie> unterkategorieList) {
        if (this.subCategoryPanel == null) {
            HeaderPanel header = new HeaderPanel("", "");
            header.addMouseListener(new HilfeMouseListener("i50011"));
            this.subCategoryPanel = ControllerSubCategoryPanel.getInstance().getSubCategoryPanel();
            this.subCategoryPanel.getContainerPanel().addMouseListener(new HilfeMouseListener("i50011"));
            this.addPanelToCard(this.subCategoryPanel.getContainerPanel(), "SUBCAT", header);
        }
        this.aktuellPanelName = "SUBCAT";
        this.removeFBA();
        String tooltip = null;
        String cuttedHeader = kategorie;
        if (cuttedHeader.length() > 60) {
            tooltip = cuttedHeader;
            cuttedHeader = this.calculateHeadertext(cuttedHeader, cuttedHeader.length() - 60);
        }
        this.cardContainers.get("SUBCAT").setBackground(this.mLayout.getPrimaryBackground());
        this.subCategoryPanel.setUnterkategoriePanel(3, 3, 7, this.mLayout, unterkategorieList);
        this.cardContainers.get("SUBCAT").getHeaderPanel().changeSetting(cuttedHeader, tooltip, "", "SUBCAT", null);
        this.cardContainers.get("SUBCAT").getHeaderPanel().addMouseListener(new HilfeMouseListener("i50011"));
        ((CardLayout)this.getLayout()).show(this, "SUBCAT");
        if (this.isConfigPanelSet) {
            this.addConfigPanel();
        } else {
            this.removeConfigPanel();
        }
    }

    public void showProduktListe(HauptKategorie kategorie, HitListenUnterkategorie unterkategorie, ArrayList<ProduktListenElement> produktList) {
        if (produktList == null || produktList.isEmpty()) {
            WorkflowController.getInstance().changeState("SUBCAT");
            JOptionPane.showMessageDialog((Component)this.getSubcategory().getUnterkategorienPanel(), Resource.getInstance().getMeldungKeinTreffer(), Resource.getInstance().getInformation(), 1);
            MainController.getInstance().getMainFrame().getStatusBar().removeStatus(4);
            if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setAktuelleUnterkategorie("");
            }
            if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSubCategoryComboBox().getItemCount() > 0) {
                MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSubCategoryComboBox().setSelectedIndex(0);
            }
            return;
        }
        if (this.produktListPanel == null) {
            HeaderPanel header = new HeaderPanel("", "");
            header.addMouseListener(new HilfeMouseListener("i50019"));
            this.produktListPanel = ControllerProduktListPanel.getInstance().getProduktListPanel();
            this.produktListPanel.getContainerPanel().addMouseListener(new HilfeMouseListener("i50019"));
            this.addPanelToCard(this.produktListPanel.getContainerPanel(), "PRODUCTLIST", header);
        }
        this.aktuellPanelName = "PRODUCTLIST";
        this.removeFBA();
        String tooltip = null;
        HauptKategorie hk = kategorie == null ? produktList.get(0).getHauptkategorie() : kategorie;
        String cuttedHeader = ControllerStatusBar.createStatusHauptkat(hk.getName());
        if (cuttedHeader.length() > 60) {
            tooltip = cuttedHeader;
            cuttedHeader = this.calculateHeadertext(cuttedHeader, cuttedHeader.length() - 60);
        }
        this.cardContainers.get("PRODUCTLIST").setBackground(this.mLayout.getPrimaryBackground());
        this.produktListPanel.setProduktListPanel(1, 10, hk, unterkategorie, produktList);
        this.cardContainers.get("PRODUCTLIST").getHeaderPanel().changeSetting(cuttedHeader, tooltip, "", "PRODUCTLIST", null);
        this.cardContainers.get("PRODUCTLIST").getHeaderPanel().addMouseListener(new HilfeMouseListener("i50019"));
        ((CardLayout)this.getLayout()).show(this, "PRODUCTLIST");
        if (this.isConfigPanelSet) {
            this.addConfigPanel();
        } else {
            this.removeConfigPanel();
        }
    }

    public MainContainer getProduktListenContainer() {
        return this.cardContainers.get("PRODUCTLIST");
    }

    public void showKalkulationPanel() {
        if (this.kalkPanel == null) {
            HeaderPanel header = new HeaderPanel("", "");
            header.addMouseListener(new HilfeMouseListener("i50086"));
            this.kalkPanel = ControllerKalkulationPanel.getInstance().getKalkulationView();
            this.kalkPanel.getKalkulationPanel().addMouseListener(new HilfeMouseListener("i50086"));
            this.addPanelToCard(this.kalkPanel.getKalkulationPanel(), "KALKULATION", header);
        }
        this.aktuellPanelName = "KALKULATION";
        this.removeFBA();
        String tooltip = null;
        String cuttedHeader = ControllerMarketingPanel.getInstance().getModel().getProductNamePlain() + " - " + Resource.getInstance().getKalkulationssicht();
        if (cuttedHeader.length() > 60) {
            tooltip = cuttedHeader;
            cuttedHeader = this.calculateHeadertext(ControllerMarketingPanel.getInstance().getModel().getProductNamePlain(), cuttedHeader.length() - 60);
        } else {
            cuttedHeader = ControllerMarketingPanel.getInstance().getModel().getProductNamePlain();
        }
        this.cardContainers.get("KALKULATION").getHeaderPanel().changeSetting(cuttedHeader + " - " + Resource.getInstance().getKalkulationssicht(), tooltip, "", "MARKETING", null);
        ((CardLayout)this.getLayout()).show(this, "KALKULATION");
        if (this.isConfigPanelSet) {
            this.addConfigPanel();
        } else {
            this.removeConfigPanel();
        }
        this.updateUI();
        this.validate();
    }

    public void addMarketingPanel() {
        if (this.marketingPanel == null) {
            HeaderPanel header = new HeaderPanel("", "");
            header.addMouseListener(new HilfeMouseListener("i500511"));
            this.marketingPanel = ControllerMarketingPanel.getInstance().getMarketingView();
            this.marketingPanel.getMarketingPanel().addMouseListener(new HilfeMouseListener("i500511"));
            this.addPanelToCard(this.marketingPanel.getMarketingPanel(), "MARKETING", header);
        }
        this.aktuellPanelName = "MARKETING";
        this.removeFBA();
        String tooltip = null;
        String cuttedHeader = ControllerMarketingPanel.getInstance().getModel().getProductNamePlain() + " - " + Resource.getInstance().getMarketingsicht();
        if (cuttedHeader.length() > 60) {
            tooltip = cuttedHeader;
            cuttedHeader = this.calculateHeadertext(ControllerMarketingPanel.getInstance().getModel().getProductNamePlain(), cuttedHeader.length() - 60);
        } else {
            cuttedHeader = ControllerMarketingPanel.getInstance().getModel().getProductNamePlain();
        }
        this.cardContainers.get("MARKETING").getHeaderPanel().changeSetting(cuttedHeader + " - " + Resource.getInstance().getMarketingsicht(), tooltip, "", "MARKETING", null);
        ((CardLayout)this.getLayout()).show(this, "MARKETING");
        if (this.isConfigPanelSet) {
            this.addConfigPanel();
        } else {
            this.removeConfigPanel();
        }
        this.updateUI();
        this.validate();
    }

    public void addTechnikPanel() {
        if (this.technikPanel == null) {
            HeaderPanel header = new HeaderPanel("", "");
            header.addMouseListener(new HilfeMouseListener("i50074"));
            this.technikPanel = ControllerTechnikPanel.getTechnikView();
            this.technikPanel.getTechnikPanel().addMouseListener(new HilfeMouseListener("i50074"));
            this.addPanelToCard(this.technikPanel.getTechnikPanel(), "TECHNIK", header);
        }
        this.aktuellPanelName = "TECHNIK";
        this.removeFBA();
        String tooltip = null;
        String cuttedHeader = ControllerMarketingPanel.getInstance().getModel().getProductNamePlain() + " - " + Resource.getInstance().getKalkulationssicht();
        if (cuttedHeader.length() > 60) {
            tooltip = cuttedHeader;
            cuttedHeader = this.calculateHeadertext(ControllerMarketingPanel.getInstance().getModel().getProductNamePlain(), cuttedHeader.length() - 60);
        } else {
            cuttedHeader = ControllerMarketingPanel.getInstance().getModel().getProductNamePlain();
        }
        this.cardContainers.get("TECHNIK").getHeaderPanel().changeSetting(cuttedHeader + " - " + Resource.getInstance().getTechnischeSicht(), tooltip, "", "MARKETING", null);
        ((CardLayout)this.getLayout()).show(this, "TECHNIK");
        if (this.isConfigPanelSet) {
            this.addConfigPanel();
        } else {
            this.removeConfigPanel();
        }
        this.updateUI();
        this.validate();
    }

    private String calculateHeadertext(String headertext, int cut) {
        String newHeaderText = null;
        newHeaderText = headertext.subSequence(0, headertext.length() - cut - 3) + "...";
        return newHeaderText;
    }

    public void addFBI(FBI fbi) {
        this.marketingPanel.compactView();
        if (this.mFbi == null) {
            this.mFbi = fbi;
        }
        this.cardContainers.get("MARKETING").showFBBox(fbi);
        this.updateUI();
        this.validate();
    }

    public void addFBA() {
        if (this.mFba == null) {
            this.mFba = ControllerFBA.getFba();
        }
        this.mFba.changeFBABox(this.mLayout, GlobalObjects.getInstance().getIpacData().getFahrzeug());
        if (this.aktuellPanelName.equals("MARKETING")) {
            this.marketingPanel.compactView();
            this.marketingPanel.setFBAVisible(true);
        }
        if (this.aktuellPanelName.equals("TECHNIK")) {
            this.technikPanel.compactView();
            this.technikPanel.setFBAVisible(true);
        }
        if (this.aktuellPanelName.equals("KALKULATION")) {
            this.kalkPanel.compactView();
            this.kalkPanel.setFBAVisible(true);
        }
        if (this.aktuellPanelName.equals("SUBCAT")) {
            this.subCategoryPanel.setFBAVisible(true);
        }
        if (this.aktuellPanelName.equals("PRODUCTLIST")) {
            this.produktListPanel.setFBAVisible(true);
        }
        if (this.aktuellPanelName.equals("CONFIG")) {
            this.mConfigPanel.setFBAVisible(true);
        }
        this.cardContainers.get(this.aktuellPanelName).showFBBox(this.mFba);
        this.updateUI();
        this.validate();
    }

    public void removeFBA() {
        if (this.aktuellPanelName.equals("MARKETING") && this.marketingPanel != null && this.marketingPanel.isFBAVisible()) {
            this.cardContainers.get(this.aktuellPanelName).hideFBBox(this.mFba);
            this.marketingPanel.normalizeView();
            this.marketingPanel.setFBAVisible(false);
        }
        if (this.aktuellPanelName.equals("TECHNIK") && this.technikPanel != null && this.technikPanel.isFBAVisible()) {
            this.cardContainers.get(this.aktuellPanelName).hideFBBox(this.mFba);
            this.technikPanel.normalizeView();
            this.technikPanel.setFBAVisible(false);
        }
        if (this.aktuellPanelName.equals("KALKULATION") && this.kalkPanel != null && this.kalkPanel.isFBAVisible()) {
            this.cardContainers.get(this.aktuellPanelName).hideFBBox(this.mFba);
            this.kalkPanel.normalizeView();
            this.kalkPanel.setFBAVisible(false);
        }
        if (this.aktuellPanelName.equals("SUBCAT") && this.subCategoryPanel != null && this.subCategoryPanel.isFBAVisible()) {
            this.cardContainers.get(this.aktuellPanelName).hideFBBox(this.mFba);
            this.subCategoryPanel.setFBAVisible(false);
        }
        if (this.aktuellPanelName.equals("PRODUCTLIST") && this.produktListPanel != null && this.produktListPanel.isFBAVisible()) {
            this.cardContainers.get(this.aktuellPanelName).hideFBBox(this.mFba);
            this.produktListPanel.setFBAVisible(false);
        }
        if (this.aktuellPanelName.equals("CONFIG") && this.mConfigPanel != null && this.mConfigPanel.isFBAVisible()) {
            this.cardContainers.get(this.aktuellPanelName).hideFBBox(this.mFba);
            this.mConfigPanel.setFBAVisible(false);
        }
        this.updateUI();
        this.validate();
    }

    public void addConfigPanel() {
        if (this.mConfigPanel == null) {
            this.mConfigPanel = ControllerConfigurationPanel.getInstance().getConfigurationPanel();
        }
        this.mConfigPanel.setLayout(this.mLayout);
        this.cardContainers.get(this.aktuellPanelName).showConfigPanel(this.mConfigPanel.getConfiguratorPanel());
        this.isConfigPanelSet = true;
        this.validate();
        this.updateUI();
    }

    public void removeConfigPanel() {
        if (this.mConfigPanel != null && this.isConfigPanelSet) {
            this.isConfigPanelSet = false;
            this.cardContainers.get(this.aktuellPanelName).hideConfigPanel(this.mConfigPanel.getConfiguratorPanel());
        }
    }

    public void removeFBI() {
        this.cardContainers.get("MARKETING").hideFBBox(this.mFbi);
        this.marketingPanel.normalizeView();
        this.marketingPanel.getMarketingPanel().updateUI();
        this.updateUI();
        this.validate();
    }

    public ProduktListPanel getProduktListPanel() {
        return this.produktListPanel;
    }

    public SubCategoryPanel getSubcategory() {
        return this.subCategoryPanel;
    }

    public HeaderPanel getHeaderPanel() {
        return this.mHeaderPanel;
    }

    public MarketingPanel getMarketingPanel() {
        return this.marketingPanel;
    }

    public TechnikPanel getTechnikPanel() {
        return this.technikPanel;
    }

    public String getAktuellPanelName() {
        return this.aktuellPanelName;
    }

    public Dimension getMainPanelDim() {
        return this.mainPanelDim;
    }

    public ConfigurationPanel getConfigPanel() {
        return this.mConfigPanel;
    }

    public FBI getFbi() {
        return this.mFbi;
    }

    public boolean isFbaVisible() {
        if (this.aktuellPanelName.equals("MARKETING")) {
            return this.marketingPanel.isFBAVisible();
        }
        if (this.aktuellPanelName.equals("TECHNIK")) {
            return this.technikPanel.isFBAVisible();
        }
        if (this.aktuellPanelName.equals("KALKULATION")) {
            return this.kalkPanel.isFBAVisible();
        }
        if (this.aktuellPanelName.equals("CONFIG")) {
            return this.mConfigPanel.isFBAVisible();
        }
        if (this.aktuellPanelName.equals("SUBCAT")) {
            return this.subCategoryPanel.isFBAVisible();
        }
        if (this.aktuellPanelName.equals("PRODUCTLIST")) {
            return this.produktListPanel.isFBAVisible();
        }
        return false;
    }

    public void showErrorMessage(String errorMsg) {
        JOptionPane.showMessageDialog((Component)this, errorMsg, Resource.getInstance().getInformation(), 1);
    }

    public boolean isConfigPanelSet() {
        return this.isConfigPanelSet;
    }
}

