/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.admin;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TextFieldPatternFormatter;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import webetk.app.MarktIpac;
import webetk.app.admintool.Sprache;
import webetk.resources.Resource;

public class AbstractAdminComponent {
    protected MarkenLayout mMarkenLayout;
    private Dimension defaultSize = new Dimension(130, 20);
    private Dimension defaultBlankLine = new Dimension(750, 10);

    public AbstractAdminComponent(MarkenLayout mLayout) {
        this.mMarkenLayout = mLayout;
    }

    protected JLabel getLabel(String text, int width, int height) {
        JLabel label = new JLabel();
        label.setText(text);
        label.setPreferredSize(new Dimension(width, height));
        label.setMaximumSize(new Dimension(width, height));
        label.setMinimumSize(new Dimension(width, height));
        this.setComponentBackground(label);
        return label;
    }

    protected JLabel getLabel(String bundleText) {
        return this.getLabel(bundleText, (int)this.defaultSize.getWidth(), (int)this.defaultSize.getHeight());
    }

    protected JTextField getTextField(String text, int width, int height) {
        JTextField field = new JTextField(text);
        field.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(field);
        return field;
    }

    protected JTextField getTextField(int width, int height) {
        JTextField field = new JTextField();
        field.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(field);
        return field;
    }

    protected TextFieldPatternFormatter getTextFieldPatternFormatter(String pat) {
        Pattern pattern = Pattern.compile(pat);
        TextFieldPatternFormatter textPatFormatter = new TextFieldPatternFormatter(pattern);
        textPatFormatter.setAllowsInvalid(false);
        return textPatFormatter;
    }

    protected JFormattedTextField getFormattedTextField(String pat, int width, int height) {
        JFormattedTextField field = new JFormattedTextField(this.getTextFieldPatternFormatter(pat));
        field.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(field);
        return field;
    }

    protected JFormattedTextField getFormattedTextField(String pat) {
        JFormattedTextField field = new JFormattedTextField(this.getTextFieldPatternFormatter(pat));
        this.setComponentBackground(field);
        return field;
    }

    protected JComboBox getCombo(int width, int height) {
        JComboBox combo = new JComboBox();
        combo.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(combo);
        return combo;
    }

    protected JComboBox getCombo(DefaultComboBoxModel model, int width, int height) {
        JComboBox combo = new JComboBox((ComboBoxModel)model);
        combo.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(combo);
        return combo;
    }

    protected JComboBox getCombo(MarktIpac[] data, int width, int height) {
        JComboBox combo = new JComboBox(data);
        combo.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(combo);
        return combo;
    }

    protected JComboBox getCombo(Sprache[] data, int width, int height) {
        JComboBox combo = new JComboBox(data);
        combo.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(combo);
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                javax.swing.JLabel label = (javax.swing.JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Sprache sprache = (Sprache)value;
                    label.setText(sprache.getBenennung());
                    label.setFont(Constants.Layout.getZubSprachCbFont());
                }
                return label;
            }
        });
        return combo;
    }

    protected JComboBox getCombo(String[] data, int width, int height) {
        JComboBox combo = new JComboBox(data);
        combo.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(combo);
        return combo;
    }

    protected JLabel getSizer(int width, int height) {
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(label);
        return label;
    }

    protected JLabel getBlankLine() {
        JLabel label = new JLabel();
        label.setPreferredSize(this.defaultBlankLine);
        return label;
    }

    protected JLabel getBlankLine(int width, int height) {
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(width, height));
        return label;
    }

    protected JPanel getPanel(int width, int height) {
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setPreferredSize(new Dimension(width, height));
        return panel;
    }

    protected JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        return panel;
    }

    protected JCheckBox getCheckbox(int width, int height) {
        JCheckBox checkbox = new JCheckBox();
        checkbox.setBackground(this.mMarkenLayout.getPrimaryBackground());
        checkbox.setPreferredSize(new Dimension(width, height));
        return checkbox;
    }

    protected void setComponentBackground(Component comp) {
        comp.setBackground(this.mMarkenLayout.getPrimaryBackground());
        comp.setForeground(this.mMarkenLayout.getPrimaryForeground());
    }

    protected JTabbedPane getTabedPane(String[] bezeichnungen, Component[] content, int width, int height) {
        int i;
        JTabbedPane pane = new JTabbedPane();
        for (i = 0; i < Math.max(bezeichnungen.length, content.length); ++i) {
            String bezeichnung = i >= bezeichnungen.length ? "" : bezeichnungen[i];
            Component comp = i >= content.length ? new JPanel() : content[i];
            pane.setFont(Constants.Layout.getZubBigFont());
            pane.addTab(bezeichnung, comp);
        }
        pane.setPreferredSize(new Dimension(width, height));
        for (i = 0; i < pane.getTabCount(); ++i) {
            pane.setBackgroundAt(i, i == pane.getSelectedIndex() ? this.mMarkenLayout.getPrimaryBackground() : this.mMarkenLayout.getDeselectedReiterBackground());
            pane.setForegroundAt(i, i == pane.getSelectedIndex() ? this.mMarkenLayout.getPrimaryForeground() : this.mMarkenLayout.getDeselectedReiterForeground());
        }
        pane.setBackground(this.mMarkenLayout.getPrimaryBackground());
        pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                for (int i = 0; i < pane.getTabCount(); ++i) {
                    pane.setBackgroundAt(i, AbstractAdminComponent.this.mMarkenLayout.getDeselectedReiterBackground());
                    pane.setForegroundAt(i, AbstractAdminComponent.this.mMarkenLayout.getDeselectedReiterForeground());
                }
                pane.setBackgroundAt(pane.getSelectedIndex(), AbstractAdminComponent.this.mMarkenLayout.getPrimaryBackground());
                pane.setForegroundAt(pane.getSelectedIndex(), AbstractAdminComponent.this.mMarkenLayout.getPrimaryForeground());
            }
        });
        return pane;
    }

    protected JTabbedPane getTabedPaneUnterReiter(String[] bezeichnungen, Component[] content, int width, int height) {
        int i;
        JTabbedPane pane = new JTabbedPane();
        for (i = 0; i < Math.max(bezeichnungen.length, content.length); ++i) {
            String bezeichnung = i >= bezeichnungen.length ? "" : bezeichnungen[i];
            Component comp = i >= content.length ? new JPanel() : content[i];
            pane.setFont(Constants.Layout.getZubBigFont());
            pane.addTab(bezeichnung, comp);
        }
        pane.setPreferredSize(new Dimension(width, height));
        for (i = 0; i < pane.getTabCount(); ++i) {
            pane.setBackgroundAt(i, i == pane.getSelectedIndex() ? this.mMarkenLayout.getSelectedReiterBackground() : this.mMarkenLayout.getDeselectedReiterBackground());
            pane.setForegroundAt(i, i == pane.getSelectedIndex() ? this.mMarkenLayout.getSelectedReiterForeground() : this.mMarkenLayout.getDeselectedReiterForeground());
            ((JPanel)pane.getComponent(i)).setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mMarkenLayout.getSelectedReiterBackground()));
        }
        pane.setBackground(this.mMarkenLayout.getSelectedReiterBackground());
        pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                for (int i = 0; i < pane.getTabCount(); ++i) {
                    pane.setBackgroundAt(i, AbstractAdminComponent.this.mMarkenLayout.getDeselectedReiterBackground());
                    pane.setForegroundAt(i, AbstractAdminComponent.this.mMarkenLayout.getDeselectedReiterForeground());
                }
                pane.setBackgroundAt(pane.getSelectedIndex(), AbstractAdminComponent.this.mMarkenLayout.getSelectedReiterBackground());
                pane.setForegroundAt(pane.getSelectedIndex(), AbstractAdminComponent.this.mMarkenLayout.getSelectedReiterForeground());
            }
        });
        return pane;
    }

    protected JLabelButton getButtonSpeichern(String name, boolean isEnabled) {
        return this.getButton(Resource.getInstance().getSpeichern(), name, isEnabled);
    }

    protected JLabelButton getButtonZur\u00fccksetzen(String name, boolean isEnabled) {
        return this.getButton(Resource.getInstance().getZuruecksetzen(), name, isEnabled);
    }

    protected JPanel getButtonPanel(JLabelButton first, JLabelButton second) {
        JPanel buttonPanel = this.getPanel(800, 50);
        FlowLayout fLayout = new FlowLayout();
        fLayout.setAlignment(1);
        buttonPanel.setLayout(fLayout);
        buttonPanel.add(this.getBlankLine());
        buttonPanel.add(first);
        buttonPanel.add(this.getSizer(20, 20));
        buttonPanel.add(second);
        return buttonPanel;
    }

    protected JLabelButton getButton(String text, String name, boolean isEnabled) {
        JLabelButton button = new JLabelButton(text, name, true, this.mMarkenLayout);
        button.setLayout(this.mMarkenLayout);
        button.setDefaultFont();
        return button;
    }
}

