/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.admin;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.customizable.ZubCustomizable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.MarktIpac;
import webetk.app.admintool.Sprache;
import webetk.app.konfiguration.Nutzer;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;

public class AdminModel {
    static Logger log = Logger.getLogger(AdminModel.class);
    private ArrayList<Nutzer> mNutzerList;
    private ArrayList<FilialeZub> mFilialenList;
    private FilialeZub[] mFilialArray;
    private String[] mStringFilialList;
    private FilialeZub mSelectedFiliale;
    private MarktIpac mSelectedFilialMarkt;
    private int mIndexSelectedFiliale;
    private String[] mStringNutzerList;
    private NutzerZub mSelectedUser;
    private Sprache mStringSelectedUserSprache;
    private String mStringSelectedUserMarkt;
    private ArrayList<AufwandsKonfiguration> mAufwaendeList = new ArrayList();
    private ArrayList<MarktIpac> mMarktList;
    private MarktIpac[] mMaerkteArray;
    private ArrayList<Sprache> mSprachenList;
    private Sprache[] mSprachenArray;
    private ArrayList<MarkeProdukt> mMarkeProduktartList;
    public static final DecimalFormat nfWaehrung = new DecimalFormat("#0.00");

    public ArrayList<Nutzer> getNutzerlist() {
        return this.mNutzerList;
    }

    public void setNutzerlist(ArrayList<Nutzer> nutzerlist) {
        this.mNutzerList = nutzerlist;
    }

    public String[] getStringNutzerList() {
        if (this.mStringNutzerList == null) {
            if (this.mNutzerList != null) {
                if (!GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                    this.mStringNutzerList = new String[this.mNutzerList.size()];
                    for (int i = 0; i < this.mNutzerList.size(); ++i) {
                        this.mStringNutzerList[i] = this.mNutzerList.get(i).getUserId() + " - " + this.mNutzerList.get(i).getUserName();
                    }
                } else {
                    this.mStringNutzerList = new String[this.mNutzerList.size() + 1];
                    this.mStringNutzerList[0] = "";
                    for (int i = 0; i < this.mNutzerList.size(); ++i) {
                        this.mStringNutzerList[i + 1] = this.mNutzerList.get(i).getUserId() + " - " + this.mNutzerList.get(i).getUserName();
                    }
                }
            } else {
                this.mStringNutzerList = new String[1];
            }
        }
        return this.mStringNutzerList;
    }

    public NutzerZub getSelectedUser() {
        return this.mSelectedUser;
    }

    public void setSelectedUser(NutzerZub nutzer) {
        this.mSelectedUser = nutzer;
        if (nutzer != null) {
            if (this.mSelectedUser.getMarktId() != null) {
                this.calculateMarkt(this.mSelectedUser.getMarktId());
            } else {
                this.calculateMarkt(-1);
            }
        }
    }

    public FilialeZub[] getFilialArray() {
        if (this.mFilialenList != null) {
            this.mFilialArray = new FilialeZub[this.mFilialenList.size()];
            for (int i = 0; i < this.mFilialenList.size(); ++i) {
                this.mFilialArray[i] = this.mFilialenList.get(i);
            }
        } else {
            this.mFilialArray = new FilialeZub[1];
        }
        return this.mFilialArray;
    }

    public void setFilialenList(ArrayList<FilialeZub> filialenList) {
        this.mFilialenList = filialenList;
    }

    public String[] getStringFilialList() {
        if (this.mStringFilialList == null) {
            if (this.mFilialenList != null) {
                this.mStringFilialList = new String[this.mFilialenList.size()];
                for (int i = 0; i < this.mFilialenList.size(); ++i) {
                    this.mStringFilialList[i] = this.mFilialenList.get(i).getBezeichnung();
                }
            } else {
                this.mStringFilialList = new String[1];
            }
        }
        return this.mStringFilialList;
    }

    public FilialeZub getSelectedFiliale() {
        return this.mSelectedFiliale;
    }

    public void setSelectedFiliale(int index) {
        this.mSelectedFiliale = this.mFilialenList.get(index);
        this.mIndexSelectedFiliale = index;
        this.mSelectedFilialMarkt = this.mSelectedFiliale.getMarktId() != null ? this.calculateMarkt(this.mSelectedFiliale.getMarktId()) : this.calculateMarkt(-1);
    }

    public String getFilialId(int index) {
        return this.mFilialenList.get(index).getId();
    }

    private MarktIpac calculateMarkt(int marktId) {
        if (this.mMarktList != null && marktId != -1) {
            for (int i = 0; i < this.mMarktList.size(); ++i) {
                if (marktId != this.mMarktList.get(i).getMarktId()) continue;
                return this.mMarktList.get(i);
            }
        }
        return this.mMarktList.get(0);
    }

    public AufwandsKonfiguration getAufwaendeFuerMarkeProdukt(String psMarke, String psProdukt) {
        for (AufwandsKonfiguration oAufwKonf : this.mAufwaendeList) {
            if (!oAufwKonf.getMarke().equalsIgnoreCase(psMarke) || !oAufwKonf.getProdukt().equalsIgnoreCase(psProdukt)) continue;
            return oAufwKonf;
        }
        return null;
    }

    public void setAufwaendeFuerMarkeProdukt(AufwandsKonfiguration pAufwaende) {
        boolean bGefunden = false;
        for (AufwandsKonfiguration oAufwKonf : this.mAufwaendeList) {
            if (!oAufwKonf.getMarke().equalsIgnoreCase(pAufwaende.getMarke()) || !oAufwKonf.getProdukt().equalsIgnoreCase(pAufwaende.getProdukt())) continue;
            oAufwKonf = pAufwaende;
            bGefunden = true;
        }
        if (!bGefunden) {
            this.mAufwaendeList.add(pAufwaende);
        }
    }

    public Object[][] getDataAufwaende(String sMarke, String sProdukt, AufwandsKonfiguration oAufwandsKonfig) {
        if (sProdukt.equalsIgnoreCase(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            Object[][] dummy = new Object[][]{{Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.arbeitsnummern.mechanisch", ""), ZubCustomizable.getInstance().getBenennungMechanischeArbeit(), this.checkBenennung(ZubCustomizable.getInstance().getBenennungMechanischeArbeit(), oAufwandsKonfig.getMechanischeArbeit().getBezeichnung()), WebetkUtils.getPriceString(oAufwandsKonfig.getMechanischeArbeit().getAwMin()), WebetkUtils.getPriceString(oAufwandsKonfig.getMechanischeArbeit().getPreis())}, {Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.arbeitsnummern.elektrisch", ""), ZubCustomizable.getInstance().getBenennungElektrischeArbeit(), this.checkBenennung(ZubCustomizable.getInstance().getBenennungElektrischeArbeit(), oAufwandsKonfig.getElektrischeArbeit().getBezeichnung()), WebetkUtils.getPriceString(oAufwandsKonfig.getElektrischeArbeit().getAwMin()), WebetkUtils.getPriceString(oAufwandsKonfig.getElektrischeArbeit().getPreis())}, {Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.arbeitsnummern.programm", ""), ZubCustomizable.getInstance().getBenennungProgrammierArbeit(), this.checkBenennung(ZubCustomizable.getInstance().getBenennungProgrammierArbeit(), oAufwandsKonfig.getProgrammierArbeit().getBezeichnung()), WebetkUtils.getPriceString(oAufwandsKonfig.getProgrammierArbeit().getAwMin()), WebetkUtils.getPriceString(oAufwandsKonfig.getProgrammierArbeit().getPreis())}, {Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.arbeitsnummern.lack", ""), ZubCustomizable.getInstance().getBenennungLackierArbeit(), this.checkBenennung(ZubCustomizable.getInstance().getBenennungLackierArbeit(), oAufwandsKonfig.getLackierArbeit().getBezeichnung()), WebetkUtils.getPriceString(oAufwandsKonfig.getLackierArbeit().getAwMin()), WebetkUtils.getPriceString(oAufwandsKonfig.getLackierArbeit().getPreis())}, {Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.arbeitsnummern.sonstige", ""), ZubCustomizable.getInstance().getBenennungSonstigeArbeit(), this.checkBenennung(ZubCustomizable.getInstance().getBenennungSonstigeArbeit(), oAufwandsKonfig.getSonstigeArbeit().getBezeichnung()), WebetkUtils.getPriceString(oAufwandsKonfig.getSonstigeArbeit().getAwMin()), WebetkUtils.getPriceString(oAufwandsKonfig.getSonstigeArbeit().getPreis())}};
            return dummy;
        }
        Object[][] dummy = new Object[][]{{" ", ZubCustomizable.getInstance().getBenennungArbeitsaufwand(), this.checkBenennung(ZubCustomizable.getInstance().getBenennungArbeitsaufwand(), oAufwandsKonfig.getArbeitAufwand().getBezeichnung()), WebetkUtils.getPriceString(oAufwandsKonfig.getArbeitAufwand().getAwMin()), WebetkUtils.getPriceString(oAufwandsKonfig.getArbeitAufwand().getPreis())}};
        return dummy;
    }

    public Object[][] getDataAufwaendeToArray(AufwandsKonfiguration oAufwandsKonfig) {
        return this.getDataAufwaende(Marken.getInstance().getMarke("BMW").getBerechtigung(), Produkte.getInstance().getProdukt("AUTO").getBerechtigung(), oAufwandsKonfig);
    }

    public AufwandsKonfiguration setDataAufwaende(Vector<Vector<Object>> dummy, String sMarke, String sProdukt) {
        this.setDataAufwaende(dummy, this.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt));
        return this.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt);
    }

    private AufwandsKonfiguration setDataAufwaende(Vector<Vector<Object>> dataVector, AufwandsKonfiguration aufwaende) {
        if (dataVector.size() == 5) {
            aufwaende.getMechanischeArbeit().setId((String)dataVector.get(0).get(0));
            aufwaende.getMechanischeArbeit().setBezeichnung((String)dataVector.get(0).get(2));
            aufwaende.getMechanischeArbeit().setAwMin(new Double(dataVector.get(0).get(3).toString()));
            aufwaende.getMechanischeArbeit().setPreis(Double.valueOf((String)dataVector.get(0).get(4)));
            aufwaende.getElektrischeArbeit().setId((String)dataVector.get(1).get(0));
            aufwaende.getElektrischeArbeit().setBezeichnung((String)dataVector.get(1).get(2));
            aufwaende.getElektrischeArbeit().setAwMin(new Double(dataVector.get(1).get(3).toString()));
            aufwaende.getElektrischeArbeit().setPreis(Double.valueOf((String)dataVector.get(1).get(4)));
            aufwaende.getProgrammierArbeit().setId((String)dataVector.get(2).get(0));
            aufwaende.getProgrammierArbeit().setBezeichnung((String)dataVector.get(2).get(2));
            aufwaende.getProgrammierArbeit().setAwMin(new Double(dataVector.get(2).get(3).toString()));
            aufwaende.getProgrammierArbeit().setPreis(Double.valueOf((String)dataVector.get(2).get(4)));
            aufwaende.getLackierArbeit().setId((String)dataVector.get(3).get(0));
            aufwaende.getLackierArbeit().setBezeichnung((String)dataVector.get(3).get(2));
            aufwaende.getLackierArbeit().setAwMin(new Double(dataVector.get(3).get(3).toString()));
            aufwaende.getLackierArbeit().setPreis(Double.valueOf((String)dataVector.get(3).get(4)));
            aufwaende.getSonstigeArbeit().setId((String)dataVector.get(4).get(0));
            aufwaende.getSonstigeArbeit().setBezeichnung((String)dataVector.get(4).get(2));
            aufwaende.getSonstigeArbeit().setAwMin(new Double(dataVector.get(4).get(3).toString()));
            aufwaende.getSonstigeArbeit().setPreis(Double.valueOf((String)dataVector.get(4).get(4)));
        } else {
            aufwaende.getArbeitAufwand().setId((String)dataVector.get(0).get(0));
            aufwaende.getArbeitAufwand().setBezeichnung((String)dataVector.get(0).get(2));
            aufwaende.getArbeitAufwand().setAwMin(new Double(dataVector.get(0).get(3).toString()));
            aufwaende.getArbeitAufwand().setPreis(Double.valueOf((String)dataVector.get(0).get(4)));
        }
        return aufwaende;
    }

    private String checkBenennung(String orginal, String custom) {
        if (custom == null) {
            return orginal;
        }
        if (custom.equals("")) {
            return orginal;
        }
        return custom;
    }

    public ArrayList<MarktIpac> getMarktListe() {
        return this.mMarktList;
    }

    public void setMarktListe(ArrayList<MarktIpac> marktListe) {
        Collections.sort(marktListe);
        this.mMarktList = marktListe;
    }

    public MarktIpac[] getMaerkteArray() {
        if (this.mMaerkteArray == null && this.mMarktList != null) {
            this.mMaerkteArray = new MarktIpac[this.mMarktList.size()];
            for (int i = 0; i < this.mMarktList.size(); ++i) {
                this.mMaerkteArray[i] = this.mMarktList.get(i);
            }
        }
        return this.mMaerkteArray;
    }

    public MarktIpac getSelectedFilialMarkt() {
        return this.mSelectedFilialMarkt;
    }

    public void setSelectedFilialMarkt(MarktIpac selectedMarkt) {
        this.mSelectedFilialMarkt = selectedMarkt;
    }

    public void setSprachenList(ArrayList<Sprache> sprachenList) {
        this.mSprachenList = sprachenList;
    }

    public Sprache[] getSprachenArray() {
        if (this.mSprachenArray == null && this.mSprachenList != null) {
            this.mSprachenArray = new Sprache[this.mSprachenList.size() + 1];
            for (int i = 0; i < this.mSprachenList.size(); ++i) {
                this.mSprachenArray[i] = this.mSprachenList.get(i);
            }
        }
        return this.mSprachenArray;
    }

    public Sprache getStringSelectedUserSprache() {
        block3: {
            block2: {
                if (this.mSelectedUser == null) break block2;
                for (int i = 0; i < this.mSprachenList.size(); ++i) {
                    if (!this.mSelectedUser.getRegIso().equals(this.mSprachenList.get(i).getRegISO()) || !this.mSelectedUser.getIso().equals(this.mSprachenList.get(i).getISO())) continue;
                    this.mStringSelectedUserSprache = this.mSprachenList.get(i);
                }
                if (!this.mStringSelectedUserSprache.equals("")) break block3;
                this.mStringSelectedUserSprache = new Sprache(this.mSelectedUser.getIso() + "_" + this.mSelectedUser.getRegIso(), this.mSelectedUser.getIso(), this.mSelectedUser.getRegIso());
                break block3;
            }
            String iso = GlobalObjects.getInstance().getSessionInfo().getSettings().getSprache();
            for (int i = 0; i < this.mSprachenList.size(); ++i) {
                if (!iso.equals(this.mSprachenList.get(i).getISO())) continue;
                this.mStringSelectedUserSprache = this.mSprachenList.get(i);
                break;
            }
        }
        return this.mStringSelectedUserSprache;
    }

    public boolean checkFilialDatenComplete() {
        for (int i = 0; i < this.mFilialenList.size(); ++i) {
            if (this.checkFilialDatenComplete(this.mFilialenList.get(i).getId())) continue;
            return false;
        }
        return true;
    }

    public boolean checkFilialDatenComplete(String filialid) {
        FilialeZub testFiliale = null;
        for (int i = 0; i < this.mFilialenList.size(); ++i) {
            if (!this.mFilialenList.get(i).getId().equals(filialid)) continue;
            testFiliale = this.mFilialenList.get(i);
        }
        if (testFiliale.getStrasse() != null) {
            if (testFiliale.getStrasse().equals("")) {
                return false;
            }
        } else {
            return false;
        }
        if (testFiliale.getPlz() != null) {
            if (testFiliale.getPlz().equals("")) {
                return false;
            }
        } else {
            return false;
        }
        if (testFiliale.getOrt() != null) {
            return !testFiliale.getOrt().equals("");
        }
        return false;
    }

    public String getStringSelectedUserMarkt() {
        return this.mStringSelectedUserMarkt;
    }

    public ArrayList<MarkeProdukt> getMarkeProduktartList() {
        return this.mMarkeProduktartList;
    }

    public void setMarkeProduktartList(ArrayList<MarkeProdukt> markeProduktartList) {
        this.mMarkeProduktartList = markeProduktartList;
    }

    public int getIndexSelectedFiliale() {
        return this.mIndexSelectedFiliale;
    }
}

