/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.admin;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TableCellEditorDouble;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.admin.AdminModel;
import de.esg.zub.configurator.content.admin.AdminPanel;
import de.esg.zub.configurator.content.admin.TableCellEditorString;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.ControllerWelcomePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.NoDataFoundException;
import webetk.app.MarktIpac;
import webetk.app.admintool.Sprache;
import webetk.app.konfiguration.Nutzer;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.framework.MainView;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.MarkenProdukte;
import webetk.resources.Resource;

public class ControllerAdminPanel
implements MouseListener,
ActionListener,
KeyListener {
    private static final String FELDER = Resource.getInstance().getFelder();
    private static final String FELDER_TITEL = Resource.getInstance().getFelderTitel();
    private static final String ARBEITEN_ABGLEICHEN = Resource.getInstance().getArbeitenAbgleichen();
    private static final String KEINE_ARBEITSDATEN = Resource.getInstance().getKeineArbeitsdaten();
    static Logger log = Logger.getLogger(ControllerAdminPanel.class);
    private static ControllerAdminPanel mInstance = null;
    private AdminPanel mAdminPanel;
    private AdminModel mAdminModel;
    private boolean mArbeitVeraendert = false;
    private static final String STAMMDATEN = "Stammdaten";
    private static final String KONFIGURATION = "Konfiguration";
    private static final String ALLE = "Alle";
    private static final String COMBO = "Combo";
    private static final String REITER = "REITER";

    private ControllerAdminPanel() {
    }

    public static ControllerAdminPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerAdminPanel();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Dimension panelSize, MarkenLayout markenLayout) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mAdminModel = new AdminModel();
            boolean hasUngueltigeFilialen = false;
            try {
                this.mAdminModel.setSprachenList((ArrayList)AdminDataLoader.listeSprachen());
                ArrayList maerkte = (ArrayList)AdminDataLoader.ladeMarktListe();
                this.checkMarktUS(maerkte);
                for (MarktIpac markt : maerkte) {
                    this.createMarkeProdukartListe(markt);
                }
                this.mAdminModel.setMarktListe(maerkte);
                Vector nutzerList = (Vector)AdminDataLoader.ladeUserListe();
                if (!GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                    Iterator iter = nutzerList.iterator();
                    while (iter.hasNext()) {
                        if (((Nutzer)iter.next()).getUserId().equals(GlobalObjects.getInstance().getSessionInfo().getLogin())) continue;
                        iter.remove();
                    }
                }
                ArrayList<Nutzer> nutzers = new ArrayList<Nutzer>();
                nutzers.addAll(nutzerList);
                this.mAdminModel.setNutzerlist(nutzers);
                if (!GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                    this.mAdminModel.setSelectedUser(AdminDataLoader.ladeNutzerDatenZuUserId(this.mAdminModel.getNutzerlist().get(0).getUserId()));
                } else {
                    this.mAdminModel.setSelectedUser(null);
                }
                ArrayList filialen = (ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId());
                this.mAdminModel.setFilialenList(filialen);
                String aktFilialId = GlobalObjects.getInstance().getSessionInfo().getFilialeId();
                int index = 0;
                for (FilialeZub zub : filialen) {
                    if (zub.getId().equals(aktFilialId)) {
                        index = filialen.indexOf(zub);
                    }
                    if (zub.isValid()) continue;
                    hasUngueltigeFilialen = true;
                }
                this.mAdminModel.setSelectedFiliale(index);
                this.loadAufwandsDaten();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mAdminPanel = new AdminPanel(panelSize, markenLayout, this.mAdminModel);
            if (this.mAdminModel.getSelectedUser() != null) {
                this.mAdminPanel.getBenutzerPanel().setAttributes();
            } else {
                this.mAdminPanel.getBenutzerPanel().activatePanel(false);
            }
            if (this.mAdminModel.getSelectedFiliale() != null && GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                if (hasUngueltigeFilialen) {
                    this.mAdminPanel.getFirstTabbedPane().setSelectedIndex(1);
                }
                this.mAdminPanel.getFilialPanel().setAttributes();
                this.setColorSelectedFiliale(this.mAdminModel.getSelectedFiliale().getId());
                this.mAdminPanel.getFilialPanel().getFilialCombo().setSelectedItem(this.mAdminModel.getSelectedFiliale());
            }
            if (this.mAdminModel.getStringSelectedUserSprache() != null && !this.mAdminModel.getStringSelectedUserSprache().equals("")) {
                this.mAdminPanel.getBenutzerPanel().getSpracheCombo().setSelectedItem(this.mAdminModel.getStringSelectedUserSprache());
            }
            if (GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                if (!hasUngueltigeFilialen) {
                    this.validateInputFilialeDaten();
                }
                if (this.mAdminModel.getSelectedFiliale().getMarktId() != null) {
                    this.mAdminPanel.getFilialPanel().activateMarktButton();
                } else {
                    this.mAdminPanel.getFilialPanel().getMarktabgleich().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
                }
            }
            this.addListener();
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    private void createMarkeProdukartListe(MarktIpac markt) {
        Collection<String> userMarkenList = GlobalObjects.getInstance().getSessionInfo().getUserMarken();
        Collection<String> userProdukteList = GlobalObjects.getInstance().getSessionInfo().getUserProdukte();
        Collection<String> marktProdukteList = markt.getProdukte();
        ArrayList<MarkeProdukt> lMarkenProdukte = MarkenProdukte.getInstance(2).getBerechtigteMarkenProdukte(userMarkenList, userProdukteList, marktProdukteList, null);
        for (MarkeProdukt oMarkeProdukt : lMarkenProdukte) {
            oMarkeProdukt.setNameMarke(Resource.getInstance().getNameMarke(oMarkeProdukt.getMarke()));
            oMarkeProdukt.setNameProdukt(Resource.getInstance().getNameProdukt(oMarkeProdukt.getProdukt()));
        }
        markt.setMarkeProduktartList(lMarkenProdukte);
    }

    public ArrayList<MarkeProdukt> FOR_JUNIT_TEST_createMarkeProdukartListe(MarktIpac markt) {
        this.createMarkeProdukartListe(markt);
        return markt.getMarkeProduktartList();
    }

    private void checkMarktUS(ArrayList<MarktIpac> maerkte) {
        boolean isUs = GlobalObjects.getInstance().getIpacData().isUs();
        if (isUs) {
            Iterator<MarktIpac> iterMarkt = maerkte.iterator();
            while (iterMarkt.hasNext()) {
                if (iterMarkt.next().getLkz().equals("LNU")) continue;
                iterMarkt.remove();
            }
        }
    }

    private void addListener() {
        this.mAdminPanel.getBenutzerPanel().getStammdatenSpeichern().addMouseListener(mInstance);
        this.mAdminPanel.getBenutzerPanel().getStammdatenZur\u00fccksetzen().addMouseListener(mInstance);
        this.mAdminPanel.getBenutzerPanel().getNutzerCombo().addActionListener(mInstance);
        this.mAdminPanel.getFirstTabbedPane().addMouseListener(mInstance);
        if (GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
            this.mAdminPanel.getFilialPanel().getArbeitSpeichern().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getArbeitZur\u00fccksetzen().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getStammdatenSpeichern().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getStammdatenZur\u00fccksetzen().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getKonfigurationSpeichern().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getKonfigurationZur\u00fccksetzen().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getDMSabgleich().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getMarktabgleich().addMouseListener(mInstance);
            this.mAdminPanel.getFilialPanel().getFilialCombo().addActionListener(mInstance);
            this.mAdminPanel.getFilialPanel().getMarktCombo().addActionListener(mInstance);
            this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().addActionListener(mInstance);
            this.mAdminPanel.getFilialPanel().getFilialBezeichnungField().addKeyListener(mInstance);
            this.mAdminPanel.getFilialPanel().getStrasseField().addKeyListener(mInstance);
            this.mAdminPanel.getFilialPanel().getPLZField().addKeyListener(mInstance);
            this.mAdminPanel.getFilialPanel().getOrtField().addKeyListener(mInstance);
            this.mAdminPanel.getFilialPanel().getEditorDouble().addKeyListener(mInstance);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event == null || event.getComponent() == null || event.getComponent().getName() == null) {
            return;
        }
        if (event.getComponent() == this.mAdminPanel.getFirstTabbedPane() && GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
            this.stopEditingTable();
            if (this.mAdminPanel.getFirstTabbedPane().getSelectedComponent().getName().equals("Filiale")) {
                if (this.checkNutzerDatenChanged()) {
                    this.popUpSpeichernNutzer(this.mAdminModel.getSelectedUser().getUserId(), REITER);
                }
            } else if (this.mAdminPanel.getFirstTabbedPane().getSelectedComponent().getName().equals("Benutzer") && GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin") && this.checkFilialDatenChanged()) {
                this.popUpSpeichernFiliale(REITER);
            }
        }
        if (event.getComponent().getName().equals("BENUTZER")) {
            this.handleBenutzerButtonEvent(event);
        } else if (event.getComponent().getName().equals("FILIALE")) {
            this.handleFilialButtonEvent(event);
        }
    }

    public AdminPanel getAdminPanel() {
        return this.mAdminPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewNutzerDaten() {
        try {
            if (this.mAdminModel.getSelectedUser() != null) {
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mAdminPanel.getBenutzerPanel().getStammdatenSpeichern().setCursor(Cursor.getPredefinedCursor(3));
                String userId = this.mAdminModel.getSelectedUser().getUserId();
                this.mAdminModel.getSelectedUser().setRealName(this.mAdminPanel.getBenutzerPanel().getStringAngezeigterName());
                this.mAdminModel.getSelectedUser().setTelefon(this.mAdminPanel.getBenutzerPanel().getStringTelefon());
                this.mAdminModel.getSelectedUser().setEmail(this.mAdminPanel.getBenutzerPanel().getStringEmail());
                if (this.mAdminPanel.getBenutzerPanel().getSpracheCombo().getSelectedItem() != null) {
                    this.mAdminModel.getSelectedUser().setIso(((Sprache)this.mAdminPanel.getBenutzerPanel().getSpracheCombo().getSelectedItem()).getISO());
                    this.mAdminModel.getSelectedUser().setRegIso(((Sprache)this.mAdminPanel.getBenutzerPanel().getSpracheCombo().getSelectedItem()).getRegISO());
                }
                this.mAdminModel.getSelectedUser().setBearbeiterNummer(this.mAdminPanel.getBenutzerPanel().getBearbeiternr());
                NutzerZub user = this.mAdminModel.getSelectedUser();
                try {
                    AdminDataLoader.speichereNutzerDaten(user);
                    this.mAdminModel.setSelectedUser(AdminDataLoader.ladeNutzerDatenZuUserId(userId));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            this.mAdminPanel.getBenutzerPanel().getStammdatenSpeichern().setCursor(Cursor.getPredefinedCursor(12));
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkNutzerDatenChanged() {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mAdminPanel.getBenutzerPanel().getStammdatenSpeichern().setCursor(Cursor.getPredefinedCursor(3));
            if (this.mAdminModel.getSelectedUser() != null) {
                if (this.mAdminModel.getSelectedUser().getRealName() != null) {
                    if (!this.mAdminModel.getSelectedUser().getRealName().equals(this.mAdminPanel.getBenutzerPanel().getStringAngezeigterName())) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.mAdminPanel.getBenutzerPanel().getStringAngezeigterName() != null && this.mAdminPanel.getBenutzerPanel().getStringAngezeigterName().length() > 0 && !this.mAdminPanel.getBenutzerPanel().getStringAngezeigterName().equals(this.mAdminPanel.getBenutzerPanel().getOriginalAngezeigterName())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedUser().getTelefon() != null) {
                    if (!this.mAdminModel.getSelectedUser().getTelefon().equals(this.mAdminPanel.getBenutzerPanel().getStringTelefon())) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.mAdminPanel.getBenutzerPanel().getStringTelefon() != null && this.mAdminPanel.getBenutzerPanel().getStringTelefon().length() > 0) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedUser().getEmail() != null) {
                    if (!this.mAdminModel.getSelectedUser().getEmail().equals(this.mAdminPanel.getBenutzerPanel().getStringEmail())) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.mAdminPanel.getBenutzerPanel().getStringEmail() != null && this.mAdminPanel.getBenutzerPanel().getStringEmail().length() > 0) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminPanel.getBenutzerPanel().getSpracheCombo().getSelectedItem() != null && !this.mAdminModel.getStringSelectedUserSprache().equals(this.mAdminPanel.getBenutzerPanel().getSpracheCombo().getSelectedItem())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedUser().getBearbeiterNummer() != null) {
                    if (!this.mAdminModel.getSelectedUser().getBearbeiterNummer().equals(this.mAdminPanel.getBenutzerPanel().getBearbeiternr())) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (this.mAdminPanel.getBenutzerPanel().getBearbeiternr() != null && this.mAdminPanel.getBenutzerPanel().getBearbeiternr().length() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mAdminPanel.getBenutzerPanel().getStammdatenSpeichern().setCursor(Cursor.getPredefinedCursor(12));
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewFilialDaten(String category) {
        try {
            int index;
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mAdminPanel.getFilialPanel().getStammdatenSpeichern().setCursor(Cursor.getPredefinedCursor(3));
            this.mAdminPanel.getFilialPanel().getKonfigurationSpeichern().setCursor(Cursor.getPredefinedCursor(3));
            String marktkuerzel = null;
            if (category.equals(STAMMDATEN) || category.equals(ALLE)) {
                this.mAdminModel.getSelectedFiliale().setBezeichnung(this.mAdminPanel.getFilialPanel().getStringFilialBezeichnung());
                index = 0;
                if (this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedIndex() > 0) {
                    index = this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedIndex() - 1;
                }
                this.mAdminModel.getSelectedFiliale().setMarktId(this.mAdminModel.getMarktListe().get(index).getMarktId());
                marktkuerzel = this.mAdminModel.getMarktListe().get(index).getKuerzel();
                this.mAdminModel.getSelectedFiliale().setStrasse(this.mAdminPanel.getFilialPanel().getStringStrasse());
                this.mAdminModel.getSelectedFiliale().setPlz(this.mAdminPanel.getFilialPanel().getStringPLZ());
                this.mAdminModel.getSelectedFiliale().setOrt(this.mAdminPanel.getFilialPanel().getStringOrt());
                this.mAdminModel.getSelectedFiliale().setTelefon(this.mAdminPanel.getFilialPanel().getStringTelefon());
                this.mAdminModel.getSelectedFiliale().setFax(this.mAdminPanel.getFilialPanel().getStringFax());
                this.mAdminModel.getSelectedFiliale().setEmail(this.mAdminPanel.getFilialPanel().getStringEmail());
            }
            if (category.equals(KONFIGURATION) || category.equals(ALLE)) {
                index = 0;
                index = this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedIndex();
                MarktIpac markt = this.mAdminModel.getMarktListe().get(index);
                this.mAdminModel.getSelectedFiliale().setMarktId(markt.getMarktId());
                marktkuerzel = markt.getKuerzel();
                LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
                loginInfo.getSettings().setIPACMarkt(markt);
                this.mAdminModel.setSelectedFilialMarkt((MarktIpac)this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedItem());
                this.mAdminModel.getSelectedFiliale().setSpeicherKunde(this.mAdminPanel.getFilialPanel().isKundendatenSpeichern());
                this.mAdminModel.getSelectedFiliale().setPruefVerfuegbarkeit(this.mAdminPanel.getFilialPanel().isVerfuegbarkeitBerechnen());
            }
            try {
                AdminDataLoader.speichereFilialDaten(this.mAdminModel.getSelectedFiliale());
                this.mAdminModel.setFilialenList((ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId()));
                FilialeZub filiale = (FilialeZub)this.mAdminPanel.getFilialPanel().getFilialCombo().getModel().getElementAt(this.mAdminModel.getIndexSelectedFiliale());
                filiale.setBezeichnung(this.mAdminModel.getSelectedFiliale().getBezeichnung());
                ControllerWelcomePanel.getInstance().refreshWelcomePanel();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            String sprache = GlobalObjects.getInstance().getLanguage();
            ZubCustomizable.setMarktUndSprache(marktkuerzel, sprache);
        }
        finally {
            this.mAdminPanel.getFilialPanel().getKonfigurationSpeichern().setCursor(Cursor.getPredefinedCursor(12));
            this.mAdminPanel.getFilialPanel().getStammdatenSpeichern().setCursor(Cursor.getPredefinedCursor(12));
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFilialDatenChanged() {
        try {
            if (!this.mArbeitVeraendert) {
                if (!this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedItem().equals(this.mAdminModel.getSelectedFilialMarkt())) {
                    this.mArbeitVeraendert = true;
                }
                if (this.mAdminModel.getSelectedFiliale().getBezeichnung() == null && !this.mAdminPanel.getFilialPanel().getFilialBezeichnungField().getText().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getBezeichnung() != null && !this.mAdminModel.getSelectedFiliale().getBezeichnung().equals(this.mAdminPanel.getFilialPanel().getFilialBezeichnungField().getText())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getStrasse() == null && !this.mAdminPanel.getFilialPanel().getStringStrasse().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getStrasse() != null && !this.mAdminModel.getSelectedFiliale().getStrasse().equals(this.mAdminPanel.getFilialPanel().getStringStrasse())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getPlz() == null && !this.mAdminPanel.getFilialPanel().getStringPLZ().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getPlz() != null && !this.mAdminModel.getSelectedFiliale().getPlz().equals(this.mAdminPanel.getFilialPanel().getStringPLZ())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getOrt() == null && !this.mAdminPanel.getFilialPanel().getStringOrt().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getOrt() != null && !this.mAdminModel.getSelectedFiliale().getOrt().equals(this.mAdminPanel.getFilialPanel().getStringOrt())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getTelefon() == null && !this.mAdminPanel.getFilialPanel().getStringTelefon().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getTelefon() != null && !this.mAdminModel.getSelectedFiliale().getTelefon().equals(this.mAdminPanel.getFilialPanel().getStringTelefon())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getFax() == null && !this.mAdminPanel.getFilialPanel().getStringFax().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getFax() != null && !this.mAdminModel.getSelectedFiliale().getFax().equals(this.mAdminPanel.getFilialPanel().getStringFax())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getEmail() == null && !this.mAdminPanel.getFilialPanel().getStringEmail().equals("")) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().getEmail() != null && !this.mAdminModel.getSelectedFiliale().getEmail().equals(this.mAdminPanel.getFilialPanel().getStringEmail())) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().isSpeicherKunde() != this.mAdminPanel.getFilialPanel().isKundendatenSpeichern()) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mAdminModel.getSelectedFiliale().isPruefVerfuegbarkeit() != this.mAdminPanel.getFilialPanel().isVerfuegbarkeitBerechnen().booleanValue()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
        return this.mArbeitVeraendert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewAufwandDaten() {
        block8: {
            try {
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mAdminPanel.getFilialPanel().getArbeitSpeichern().setCursor(Cursor.getPredefinedCursor(3));
                String marke = this.mAdminPanel.getFilialPanel().getActivTabelModel().getMarke();
                String produktArt = this.mAdminPanel.getFilialPanel().getActivTabelModel().getProduktart();
                try {
                    if (this.mAdminPanel.getFilialPanel().isAenderungFilial() && this.mAdminPanel.getFilialPanel().isAenderungMarken()) {
                        AdminDataLoader.speichereArbeitAlles(this.mAdminModel.setDataAufwaende(this.mAdminPanel.getFilialPanel().getActivTabelModel().getDataVector(), marke, produktArt));
                        this.mAdminModel.setFilialenList((ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId()));
                        this.loadAufwandsDaten();
                        this.mAdminPanel.getFilialPanel().refreshTableModel();
                        break block8;
                    }
                    if (this.mAdminPanel.getFilialPanel().isAenderungFilial()) {
                        AdminDataLoader.speichereArbeitAlleFilialen(this.mAdminModel.setDataAufwaende(this.mAdminPanel.getFilialPanel().getActivTabelModel().getDataVector(), marke, produktArt), marke, produktArt);
                        this.mAdminModel.setFilialenList((ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId()));
                        this.loadAufwandsDaten();
                        break block8;
                    }
                    if (this.mAdminPanel.getFilialPanel().isAenderungMarken()) {
                        AdminDataLoader.speichereArbeitAlleMarken(this.mAdminModel.setDataAufwaende(this.mAdminPanel.getFilialPanel().getActivTabelModel().getDataVector(), marke, produktArt), this.mAdminModel.getSelectedFiliale());
                        this.loadAufwandsDaten();
                        break block8;
                    }
                    AdminDataLoader.speichereArbeiten(this.mAdminModel.setDataAufwaende(this.mAdminPanel.getFilialPanel().getActivTabelModel().getDataVector(), marke, produktArt), this.mAdminModel.getSelectedFiliale().getId(), marke, produktArt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.mAdminPanel.getFilialPanel().getArbeitSpeichern().setCursor(Cursor.getPredefinedCursor(12));
                MainController.getInstance().getMainFrame().setDefaultCursor();
            }
        }
    }

    public void stopEditingTable() {
        if (this.mAdminPanel.getFilialPanel().getArbeitTable().getEditorComponent() != null) {
            if (this.mAdminPanel.getFilialPanel().getArbeitTable().getEditingColumn() == 4 || this.mAdminPanel.getFilialPanel().getArbeitTable().getEditingColumn() == 3) {
                ((TableCellEditorDouble)((Object)this.mAdminPanel.getFilialPanel().getArbeitTable().getEditorComponent())).stopCellEditing();
            } else if (this.mAdminPanel.getFilialPanel().getArbeitTable().getEditingColumn() == 2) {
                ((TableCellEditorString)this.mAdminPanel.getFilialPanel().getArbeitTable().getEditorComponent()).stopCellEditing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFilialButtonEvent(MouseEvent event) {
        boolean save = false;
        this.stopEditingTable();
        if (event.getComponent() == this.mAdminPanel.getFilialPanel().getArbeitSpeichern()) {
            save = true;
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getArbeitZur\u00fccksetzen()) {
            this.mAdminPanel.getFilialPanel().arbeitZuruecksetzen();
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getStammdatenSpeichern()) {
            if (this.mAdminPanel.getFilialPanel().checkFelder()) {
                save = true;
            } else {
                JOptionPane.showMessageDialog((Component)MainView.getInstance(), FELDER, FELDER_TITEL, 0);
            }
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getStammdatenZur\u00fccksetzen()) {
            this.mAdminPanel.getFilialPanel().stammdatenZuruecksetzen();
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getKonfigurationSpeichern()) {
            save = true;
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getKonfigurationZur\u00fccksetzen()) {
            this.mAdminPanel.getFilialPanel().konfiguartionZuruecksetzen();
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getDMSabgleich()) {
            if (GlobalObjects.getInstance().isDMSAktiv()) {
                this.doDatenAbgleich();
                this.mArbeitVeraendert = true;
            }
        } else if (event.getComponent() == this.mAdminPanel.getFilialPanel().getMarktabgleich() && this.mAdminPanel.getFilialPanel().getMarktabgleich().isEnabled()) {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mAdminPanel.getFilialPanel().getMarktabgleich().setCursor(Cursor.getPredefinedCursor(3));
            try {
                int marktId = this.mAdminModel.getSelectedFiliale().getMarktId();
                if (this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedIndex() != 0 && marktId != -1 && marktId != 0) {
                    try {
                        String marke = this.mAdminPanel.getFilialPanel().getActivTabelModel().getMarke();
                        String produktart = this.mAdminPanel.getFilialPanel().getActivTabelModel().getProduktart();
                        AufwandsKonfiguration aufwand = AdminDataLoader.ladeMarktAufwandKonfiguration(marktId, marke, produktart);
                        this.mAdminPanel.getFilialPanel().setTableModel(marke, produktart, this.mAdminModel.getDataAufwaendeToArray(aufwand));
                        this.mArbeitVeraendert = true;
                        this.mAdminPanel.getFilialPanel().setArbeitTable();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                MainController.getInstance().getMainFrame().setDefaultCursor();
                this.mAdminPanel.getFilialPanel().getMarktabgleich().setCursor(Cursor.getPredefinedCursor(12));
            }
        }
        if (save) {
            this.setNewFilialDaten(ALLE);
            this.setNewAufwandDaten();
            this.setColorSelectedFiliale(((FilialeZub)this.mAdminPanel.getFilialPanel().getFilialCombo().getSelectedItem()).getId());
            this.mArbeitVeraendert = false;
            ControllerWelcomePanel.getInstance().setEnableReiter(true);
        }
    }

    private void handleBenutzerButtonEvent(MouseEvent event) {
        if (event.getComponent() == this.mAdminPanel.getBenutzerPanel().getStammdatenSpeichern()) {
            this.setNewNutzerDaten();
            ControllerWelcomePanel.getInstance().setEnableReiter(true);
        } else if (event.getComponent() == this.mAdminPanel.getBenutzerPanel().getStammdatenZur\u00fccksetzen()) {
            this.mAdminPanel.getBenutzerPanel().stammdatenZuruecksetzen();
        }
    }

    private void loadUser(String userId) {
        try {
            this.mAdminModel.setSelectedUser(AdminDataLoader.ladeNutzerDatenZuUserId(userId));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.mAdminPanel.getBenutzerPanel().setAttributes();
    }

    private void loadAufwandsDaten() {
        try {
            for (MarkeProdukt oMrkPrd : MarkenProdukte.getInstance(2).getMarkenProdukte()) {
                String sMarke = oMrkPrd.getMarke();
                String sProdukt = oMrkPrd.getProdukt();
                this.mAdminModel.setAufwaendeFuerMarkeProdukt(AdminDataLoader.ladeAufwandKonfiguration(this.mAdminModel.getSelectedFiliale().getId(), sMarke, sProdukt));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setFilialDaten() {
        this.mAdminPanel.getFilialPanel().getFilialCombo().removeActionListener(mInstance);
        this.mAdminPanel.getFilialPanel().getMarktCombo().removeActionListener(mInstance);
        this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().removeActionListener(mInstance);
        this.mAdminModel.setSelectedFiliale(this.mAdminPanel.getFilialPanel().getFilialCombo().getSelectedIndex());
        this.loadAufwandsDaten();
        this.mAdminPanel.getFilialPanel().refreshTableModel();
        this.mAdminPanel.getFilialPanel().setAttributes();
        ((JTabbedPane)this.mAdminPanel.getFilialPanel().getFilialTabbedPane()).setSelectedIndex(0);
        boolean test = this.mAdminPanel.getFilialPanel().checkFelder();
        this.mAdminPanel.getFilialPanel().aktiviereSpeichernButton(test);
        this.mArbeitVeraendert = false;
        this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().addActionListener(mInstance);
        this.mAdminPanel.getFilialPanel().getFilialCombo().addActionListener(mInstance);
        this.mAdminPanel.getFilialPanel().getMarktCombo().addActionListener(mInstance);
    }

    private void setAufwandDaten() {
        this.mArbeitVeraendert = false;
        this.mAdminPanel.getFilialPanel().setIndexMarkenComboBoxOld(this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().getSelectedIndex());
        for (MarkeProdukt oMrkPrd : this.mAdminPanel.getFilialPanel().getMarkeProduktArtList()) {
            String sMarke = oMrkPrd.getMarke();
            String sProdukt = oMrkPrd.getProdukt();
            this.mAdminPanel.getFilialPanel().setTableModel(sMarke, sProdukt, this.mAdminModel.getDataAufwaende(sMarke, sProdukt, this.mAdminModel.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt)));
        }
        this.mAdminPanel.getFilialPanel().setArbeitTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mAdminPanel.getBenutzerPanel().getNutzerCombo()) {
            String userIdOLD = null;
            if (this.mAdminModel.getSelectedUser() != null) {
                userIdOLD = this.mAdminModel.getSelectedUser().getUserId();
            }
            int selectedIndex = this.mAdminPanel.getBenutzerPanel().getNutzerCombo().getSelectedIndex();
            if (GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                --selectedIndex;
            }
            String userId = null;
            if (this.mAdminPanel.getBenutzerPanel().getNutzerCombo().getItemAt(selectedIndex) != null) {
                userId = this.mAdminModel.getNutzerlist().get(selectedIndex).getUserId();
            }
            if (userIdOLD != null && !userIdOLD.equals(userId) && this.checkNutzerDatenChanged()) {
                this.popUpSpeichernNutzer(userId, COMBO);
                return;
            }
            if (userId != null) {
                this.loadUser(userId);
                this.mAdminPanel.getBenutzerPanel().activatePanel(true);
            } else {
                this.mAdminPanel.getBenutzerPanel().clearPanel();
                this.mAdminPanel.getBenutzerPanel().activatePanel(false);
                this.mAdminModel.setSelectedUser(null);
            }
            this.mAdminPanel.getBenutzerPanel().setIndexUserComboBoxOld(this.mAdminPanel.getBenutzerPanel().getNutzerCombo().getSelectedIndex());
        } else if (e.getSource() == this.mAdminPanel.getFilialPanel().getMarktCombo()) {
            this.mAdminPanel.getFilialPanel().activateMarktButton();
            this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().removeActionListener(mInstance);
            this.mAdminPanel.getFilialPanel().setMarktProduktartCombo();
            MarktIpac marktOld = this.mAdminModel.getSelectedFilialMarkt();
            this.stopEditingTable();
            if (marktOld != this.mAdminPanel.getFilialPanel().getMarktCombo().getSelectedItem() && this.mArbeitVeraendert) {
                int result = this.popUpSpeichernAufw\u00e4nde();
                if (result == 2) {
                    this.mAdminPanel.getFilialPanel().getMarktCombo().setSelectedItem(marktOld);
                    this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().setSelectedIndex(this.mAdminPanel.getFilialPanel().getIndexMarkenComboBoxOld());
                }
                this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().addActionListener(mInstance);
                return;
            }
            this.loadAufwandsDaten();
            this.mAdminPanel.getFilialPanel().refreshTableModel();
            this.mAdminPanel.getFilialPanel().setArbeitTable();
            this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().addActionListener(mInstance);
        } else if (e.getSource() == this.mAdminPanel.getFilialPanel().getFilialCombo()) {
            this.stopEditingTable();
            int selectedIndex = this.mAdminPanel.getFilialPanel().getFilialCombo().getSelectedIndex();
            String filialIdOLD = this.mAdminModel.getSelectedFiliale().getId();
            String filialId = this.mAdminModel.getFilialId(selectedIndex);
            if (!filialIdOLD.equals(filialId) && this.checkFilialDatenChanged()) {
                this.popUpSpeichernFiliale(COMBO);
                this.setColorSelectedFiliale(filialId);
                return;
            }
            this.setFilialDaten();
            this.setColorSelectedFiliale(filialId);
            this.mAdminPanel.getFilialPanel().activateMarktButton();
        } else if (e.getSource() == this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo()) {
            this.stopEditingTable();
            if (this.mAdminPanel.getFilialPanel().getIndexMarkenComboBoxOld() != this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().getSelectedIndex() && this.mArbeitVeraendert) {
                int result = this.popUpSpeichernAufw\u00e4nde();
                if (result == 2) {
                    this.mAdminPanel.getFilialPanel().getMarkeProduktartCombo().setSelectedIndex(this.mAdminPanel.getFilialPanel().getIndexMarkenComboBoxOld());
                }
                return;
            }
            this.setAufwandDaten();
        }
    }

    private void setColorSelectedFiliale(String filialId) {
        if (!this.mAdminModel.checkFilialDatenComplete(filialId)) {
            this.mAdminPanel.getFilialPanel().getFilialCombo().setForeground(Color.RED);
        } else {
            this.mAdminPanel.getFilialPanel().getFilialCombo().setForeground(Color.BLACK);
        }
        this.mAdminPanel.getFilialPanel().refreshFilialCombo();
    }

    private void popUpSpeichernNutzer(String userId, String source) {
        int result = MainController.getInstance().getMainFrame().showConfirmCancelMessage(Resource.getInstance().getAenderungenSpeichernMeldung());
        if (result == 0 || result == 1) {
            if (result == 0) {
                this.setNewNutzerDaten();
            }
            if (userId != null) {
                this.loadUser(userId);
                this.mAdminPanel.getBenutzerPanel().activatePanel(true);
            } else {
                this.mAdminPanel.getBenutzerPanel().clearPanel();
                this.mAdminPanel.getBenutzerPanel().activatePanel(false);
                this.mAdminModel.setSelectedUser(null);
            }
            this.mAdminPanel.getBenutzerPanel().setIndexUserComboBoxOld(this.mAdminPanel.getBenutzerPanel().getNutzerCombo().getSelectedIndex());
        } else {
            if (source.equals(COMBO)) {
                this.mAdminPanel.getBenutzerPanel().getNutzerCombo().setSelectedIndex(this.mAdminPanel.getBenutzerPanel().getIndexUserComboBoxOld());
            }
            if (source.equals(REITER)) {
                this.mAdminPanel.getFirstTabbedPane().setSelectedIndex(0);
            }
        }
    }

    private void popUpSpeichernFiliale(String source) {
        int result = MainController.getInstance().getMainFrame().showConfirmCancelMessage(Resource.getInstance().getAenderungenSpeichernMeldung());
        if (result == 0 || result == 1) {
            if (result == 0) {
                this.setNewFilialDaten(ALLE);
                this.setNewAufwandDaten();
            }
            this.setFilialDaten();
        } else {
            if (source.equals(COMBO)) {
                this.mAdminPanel.getFilialPanel().getFilialCombo().setSelectedIndex(this.mAdminModel.getIndexSelectedFiliale());
            }
            if (source.equals(REITER)) {
                this.mAdminPanel.getFirstTabbedPane().setSelectedIndex(1);
            }
        }
    }

    public int popUpSpeichernGesamt() {
        int result = MainController.getInstance().getMainFrame().showConfirmCancelMessage(Resource.getInstance().getAenderungenSpeichernMeldung());
        if (result == 0 || result == 1) {
            if (result == 0) {
                this.setNewFilialDaten(ALLE);
                this.setNewAufwandDaten();
                this.setNewNutzerDaten();
            }
            this.mArbeitVeraendert = false;
        }
        return result;
    }

    private int popUpSpeichernAufw\u00e4nde() {
        int result = MainController.getInstance().getMainFrame().showConfirmCancelMessage(Resource.getInstance().getAenderungenSpeichernMeldung());
        if (result == 0 || result == 1) {
            if (result == 0) {
                this.setNewAufwandDaten();
            }
            this.loadAufwandsDaten();
            this.mAdminPanel.getFilialPanel().refreshTableModel();
            this.setAufwandDaten();
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDatenAbgleich() {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            Teileliste liste = new Teileliste(GlobalObjects.getInstance().getSessionInfo().getMarke(), GlobalObjects.getInstance().getSessionInfo().getUsername(), "Test", GlobalObjects.getInstance().getSessionInfo().getLanguage());
            try {
                Vector<Teil> dummy = new Vector<Teil>();
                for (int ii = 0; ii < this.mAdminPanel.getFilialPanel().getActivTabelModel().getAwNummern().length; ++ii) {
                    Teil teil = new Teil(this.mAdminPanel.getFilialPanel().getActivTabelModel().getAwNummern()[ii].replace(" ", ""));
                    teil.setTeileart("ARBEITSWERTNUMMER");
                    dummy.add(teil);
                }
                liste.addTeile(dummy, GlobalObjects.getInstance().getSessionInfo().getLanguage(), false, false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (DatabaseBusyException e) {
                e.printStackTrace();
            }
            catch (NoDataFoundException e) {
                e.printStackTrace();
            }
            catch (InvalidDataException e) {
                e.printStackTrace();
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            TrfTeileliste trfTL = new TrfTeileliste(null);
            trfTL.setValue("eigentuemer", liste.getNutzerID());
            trfTL.setValue("filialid", liste.getFiliale());
            trfTL.setValue("teileliste", liste);
            if (!this.mAdminPanel.getFilialPanel().getKundennummer().getText().equals("")) {
                trfTL.setValue("kundennr", this.mAdminPanel.getFilialPanel().getKundennummer().getText());
            }
            if (!this.mAdminPanel.getFilialPanel().getAuftragsnummer().getText().equals("")) {
                trfTL.setValue("auftragsnr", this.mAdminPanel.getFilialPanel().getAuftragsnummer().getText());
            }
            trfTL.setValue("datenabgleich_full", true);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LADE_ARBEITEN);
            }
            catch (CommunicationException ex) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog((Component)MainView.getInstance(), ex.getMessage(), ARBEITEN_ABGLEICHEN, 0);
            }
            if (trfTL.getError() != null) {
                Exception ex = trfTL.getError();
                if (ex instanceof DMSException) {
                    StringBuffer sMsg = new StringBuffer(Resource.getInstance().getFehlerDmsAbgleich() + ".\n");
                    DMSException exDms = (DMSException)ex;
                    Collection aTeilenummern = exDms.getTeilenummern();
                    Collection aPos = exDms.getPositionen();
                    Collection aRetcodes = exDms.getRetCodes();
                    if (aTeilenummern != null && aRetcodes != null) {
                        Iterator iTeilenummern = aTeilenummern.iterator();
                        Iterator iPos = aPos.iterator();
                        Iterator iRetcodes = aRetcodes.iterator();
                        if (iTeilenummern.hasNext() && iRetcodes.hasNext()) {
                            String sTeilenummer = (String)iTeilenummern.next();
                            String sPos = ((Integer)iPos.next()).toString();
                            int nStatus = (Integer)iRetcodes.next();
                            if (nStatus != 1800) {
                                sMsg.append(sPos + ":    " + sTeilenummer + ":    " + Resource.getInstance().getDmsFehlerText(nStatus) + "\n");
                            } else {
                                sMsg.append(KEINE_ARBEITSDATEN + "\n");
                            }
                        }
                    } else {
                        int nStatus = Integer.parseInt(ex.getMessage());
                        sMsg.append(Resource.getInstance().getDmsFehlerText(nStatus));
                    }
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog((Component)MainView.getInstance(), sMsg.toString(), ARBEITEN_ABGLEICHEN, 0);
                } else {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog((Component)MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), ARBEITEN_ABGLEICHEN, 0);
                }
            }
            liste = (Teileliste)trfTL.getValue("teileliste");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            double[] preise = new double[5];
            Iterator<Teil> iter = liste.getTeile().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Teil oTeil = iter.next();
                preise[i] = oTeil.getHaendlerpreis();
                ++i;
            }
            this.mAdminPanel.getFilialPanel().getActivTabelModel().setPreise(preise);
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    public boolean isArbeitVeraendert() {
        return this.mArbeitVeraendert;
    }

    public void setArbeitenVeraendert(boolean arbeitVeraendert) {
        this.mArbeitVeraendert = arbeitVeraendert;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.mAdminPanel.getFilialPanel().getArbeitTable().getEditorComponent() != null) {
            if (this.mAdminPanel.getFilialPanel().getArbeitTable().getEditingColumn() == 4 || this.mAdminPanel.getFilialPanel().getArbeitTable().getEditingColumn() == 3) {
                ((TableCellEditorDouble)((Object)this.mAdminPanel.getFilialPanel().getArbeitTable().getEditorComponent())).stopCellEditing();
            } else if (this.mAdminPanel.getFilialPanel().getArbeitTable().getEditingColumn() == 2) {
                ((TableCellEditorString)this.mAdminPanel.getFilialPanel().getArbeitTable().getEditorComponent()).stopCellEditing();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getComponent() == this.mAdminPanel.getFilialPanel().getFilialBezeichnungField()) {
            this.validateInputFilialeDaten();
        } else if (e.getComponent() == this.mAdminPanel.getFilialPanel().getStrasseField()) {
            this.validateInputFilialeDaten();
        } else if (e.getComponent() == this.mAdminPanel.getFilialPanel().getPLZField()) {
            this.validateInputFilialeDaten();
        } else if (e.getComponent() == this.mAdminPanel.getFilialPanel().getOrtField()) {
            this.validateInputFilialeDaten();
        }
    }

    private void validateInputFilialeDaten() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean test = ControllerAdminPanel.this.mAdminPanel.getFilialPanel().checkFelder();
                ControllerAdminPanel.this.mAdminPanel.getFilialPanel().aktiviereSpeichernButton(test);
            }
        });
    }
}

