/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.admin;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TabelCellEditorInteger;
import de.esg.zub.common.TableCellEditorDouble;
import de.esg.zub.common.TableCellRendererString;
import de.esg.zub.configurator.content.admin.AbstractAdminComponent;
import de.esg.zub.configurator.content.admin.AdminModel;
import de.esg.zub.configurator.content.admin.AdminTableCellRendererDouble;
import de.esg.zub.configurator.content.admin.AdminTableHeaderRenderer;
import de.esg.zub.configurator.content.admin.AdminTableModel;
import de.esg.zub.configurator.content.admin.TableCellEditorString;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JPatternTextField;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import webetk.app.Markt;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class FilialPanel
extends AbstractAdminComponent {
    public static final String FILIALE = "Filiale";
    static Logger log = Logger.getLogger(FilialPanel.class);
    private JPanel filialPanel;
    private JLabelButton mArbeitSpeichern;
    private JLabelButton mArbeitZur\u00fccksetzen;
    private JLabelButton mStammdatenSpeichern;
    private JLabelButton mStammdatenZur\u00fccksetzen;
    private JLabelButton mKonfigurationSpeichern;
    private JLabelButton mKonfigurationZur\u00fccksetzen;
    private JLabelButton mMarktabgleich;
    private JLabelButton mDMSabgleich;
    private static final int LENGTH_KDNR = 7;
    private static final String PATTERN_KDNR = "[0-9]{0,7}";
    private static final int LENGTH_AUFTRAGSNR = 10;
    private static final String PATTERN_AUFTRAGSNR = "[A-Za-z0-9]{0,10}";
    private static final int LENGTH_PREIS = 6;
    private static final String PATTERN_PREIS = "[0-9]{0,6}((,|\\.)[0-9]{0,2})?";
    private static final Double MIN_PREIS = new Double(0.01);
    private JTextField mFilialBezeichnungField;
    private JTextField mStrasseField;
    private JTextField mPLZField;
    private JTextField mOrtField;
    private JPatternTextField mTelefon;
    private JPatternTextField mFax;
    private JPatternTextField mEmail;
    private JPatternTextField mKundennummer;
    private JPatternTextField mAuftragsnummer;
    private JComboBox mFilialCombo;
    private JComboBox mMarktCombo;
    private JComboBox mMarkeProduktartCombo;
    private JCheckBox mKundendatenCheck;
    private JCheckBox mVerfuegbarkeitCheck;
    private JCheckBox mAenderungFilialCheck;
    private JCheckBox mAenderungFuerAlleMarkenCheck;
    private JLabel mAenderungFuerAlleMarkenText;
    private JLabel mVerf\u00fcgbarkeitsText;
    private JTable mArbeitTable;
    private ArrayList<AdminTableModel> mArbeitTableModelList = new ArrayList();
    private AdminTableModel mActiveTableModel;
    private TableCellEditorDouble mEditorDouble;
    private TabelCellEditorInteger mEditorInt;
    private TableCellEditorString mEditorString;
    private JTabbedPane mFilialTabbedPane;
    private JPanel mFilialAuswahlPanel;
    private JLabel mMeldung;
    private int mIndexMarkenComboBoxOld;
    private AdminModel mModel;

    public FilialPanel(MarkenLayout mLayout, AdminModel model) {
        super(mLayout);
        this.mModel = model;
    }

    public JPanel getFilialePanel() {
        this.filialPanel = this.getPanel();
        this.filialPanel.setName(FILIALE);
        this.filialPanel.setLayout(new BorderLayout());
        this.filialPanel.add((Component)this.getPanel(700, 20), "North");
        this.filialPanel.add((Component)this.getPanel(30, this.filialPanel.getHeight()), "East");
        this.filialPanel.add((Component)this.getPanel(30, this.filialPanel.getHeight()), "West");
        JPanel panel2 = this.getPanel();
        panel2.add(this.getFilialauswahlPanel(0));
        panel2.add(this.getFilialTabbedPane());
        this.filialPanel.add(panel2);
        return this.filialPanel;
    }

    private Component getFilialauswahlPanel(int selectedIndex) {
        this.mFilialAuswahlPanel = this.getPanel(700, 60);
        this.mFilialAuswahlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        this.mFilialAuswahlPanel.add((Component)this.getLabel(Resource.getInstance().getFilialauswahl()), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 11, new Insets(20, 0, 0, 0));
        this.mFilialCombo = this.getComboFiliale(this.mModel.getFilialArray(), 600, 20);
        this.mFilialAuswahlPanel.add((Component)this.mFilialCombo, gbc);
        this.mFilialCombo.setSelectedIndex(selectedIndex);
        this.mMeldung = new JLabel();
        this.setMeldung();
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 0, 11, new Insets(20, 110, 0, 0));
        this.mFilialAuswahlPanel.add((Component)this.getSizer(10, 20), gbc);
        this.mFilialAuswahlPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()));
        this.mFilialAuswahlPanel.updateUI();
        return this.mFilialAuswahlPanel;
    }

    private void setMeldung() {
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, 11, new Insets(0, 0, 0, 0));
        this.mFilialAuswahlPanel.remove(this.mMeldung);
        if (!this.mModel.checkFilialDatenComplete()) {
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, 11, new Insets(0, 0, 0, 0));
            this.mMeldung.setText(Resource.getInstance().getFilaleUnvollstaendig());
            this.mMeldung.setForeground(Color.RED);
        } else {
            this.mMeldung.setText("");
            this.mFilialCombo.setForeground(Color.BLACK);
        }
        this.mMeldung.updateUI();
        this.mFilialAuswahlPanel.add((Component)this.mMeldung, gbc);
        this.mFilialAuswahlPanel.updateUI();
    }

    public Component getFilialTabbedPane() {
        if (this.mFilialTabbedPane == null) {
            this.mFilialTabbedPane = this.getTabedPaneUnterReiter(new String[]{Resource.getInstance().getSchrittStammdaten(), Resource.getInstance().getSchrittMarktauswahl(), Resource.getInstance().getSchrittArbeiten()}, new Component[]{this.getStammdatenPanel(), this.getMarktauswahlPanel(), this.getArbeitenPanel()}, 700, 440);
            this.mFilialTabbedPane.setName("FilialTabbedPane");
        }
        return this.mFilialTabbedPane;
    }

    private Component getArbeitenPanel() {
        JPanel mArbeitenPanel = this.getPanel();
        mArbeitenPanel.setLayout(new BorderLayout());
        mArbeitenPanel.add(this.getWaehrungPanel(), "North");
        JPanel panel = this.getPanel();
        panel.setLayout(new GridBagLayout());
        panel.add(this.getBlankLine());
        int gesamtBreite = 700;
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        panel.add((Component)this.getLabel(Resource.getInstance().getMarke() + " :"), gbc);
        this.mMarkeProduktartCombo = this.getCombo(500, 20);
        this.setMarktProduktartCombo();
        this.mIndexMarkenComboBoxOld = 0;
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 4, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 110));
        panel.add((Component)this.mMarkeProduktartCombo, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 0, 11, new Insets(20, 105, 0, 0));
        panel.add((Component)this.getSizer(10, 20), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mAenderungFilialCheck = this.getCheckbox(500, 20);
        panel.add((Component)this.mAenderungFilialCheck, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        panel.add((Component)this.getLabel(Resource.getInstance().getAenderungfiliale(), 0, 20), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mAenderungFuerAlleMarkenCheck = this.getCheckbox(500, 20);
        panel.add((Component)this.mAenderungFuerAlleMarkenCheck, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 2, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mAenderungFuerAlleMarkenText = this.getLabel(Resource.getInstance().getAenderungmarkt(), 0, 20);
        panel.add((Component)this.mAenderungFuerAlleMarkenText, gbc);
        JScrollPane pane = new JScrollPane(this.getArbeitTable());
        pane.setPreferredSize(new Dimension(700, 104));
        pane.setMinimumSize(new Dimension(700, 104));
        this.setComponentBackground(pane.getViewport());
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 2, 11, new Insets(20, 10, 5, 10));
        panel.add((Component)pane, gbc);
        JPanel kundeAutragsnr = this.getPanel();
        kundeAutragsnr.setLayout(new GridBagLayout());
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(0, 0, 0, 2));
        JLabel kundenNrLabel = new JLabel(Resource.getInstance().getKundennummer() + ":");
        this.setComponentBackground(kundenNrLabel);
        kundeAutragsnr.add((Component)kundenNrLabel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(0, 0, 0, 5));
        this.mKundennummer = new JPatternTextField(PATTERN_KDNR);
        this.mKundennummer.setMaxCharacters(7);
        gbc.ipadx = 50;
        kundeAutragsnr.add((Component)this.mKundennummer, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(0, 0, 0, 2));
        JLabel auftragsNrLabel = new JLabel(Resource.getInstance().getAuftragsnummer() + ":");
        this.setComponentBackground(auftragsNrLabel);
        kundeAutragsnr.add((Component)auftragsNrLabel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(0, 0, 0, 10));
        gbc.ipadx = 75;
        this.mAuftragsnummer = new JPatternTextField(PATTERN_AUFTRAGSNR);
        this.mAuftragsnummer.setMaxCharacters(10);
        kundeAutragsnr.add((Component)this.mAuftragsnummer, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 5, 4, 1, 1.0, 1.0, 0, 13, new Insets(0, 0, 0, 0));
        panel.add((Component)kundeAutragsnr, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 6, 2, 1, 1.0, 1.0, 0, 17, new Insets(5, 29, 10, 60));
        this.mMarktabgleich = this.getButton(Resource.getInstance().getMarktabgleich(), "FILIALE", true);
        panel.add((Component)this.mMarktabgleich, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 6, 2, 1, 1.0, 1.0, 0, 17, new Insets(5, 177, 10, 5));
        this.mDMSabgleich = this.getButton(Resource.getInstance().getDmsabgleich(), "FILIALE", true);
        if (!GlobalObjects.getInstance().isDMSAktiv()) {
            this.mDMSabgleich.setEnabled(false, this.mMarkenLayout);
        }
        panel.add((Component)this.mDMSabgleich, gbc);
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.mMarkenLayout.getBorderColor()));
        mArbeitenPanel.add(panel);
        this.mArbeitSpeichern = this.getButtonSpeichern("FILIALE", true);
        this.mArbeitZur\u00fccksetzen = this.getButtonZur\u00fccksetzen("FILIALE", true);
        mArbeitenPanel.add((Component)this.getButtonPanel(this.mArbeitSpeichern, this.mArbeitZur\u00fccksetzen), "South");
        return mArbeitenPanel;
    }

    public void setMarktProduktartCombo() {
        this.mMarkeProduktartCombo.removeAllItems();
        ArrayList<MarkeProdukt> markeProdList = ((Markt)this.getMarktCombo().getSelectedItem()).getMarkeProduktartList();
        for (MarkeProdukt marke : markeProdList) {
            this.mMarkeProduktartCombo.addItem(marke);
        }
        this.mMarkeProduktartCombo.validate();
        this.mMarkeProduktartCombo.updateUI();
    }

    protected ArrayList<MarkeProdukt> getMarkeProduktArtList() {
        return ((Markt)this.getMarktCombo().getSelectedItem()).getMarkeProduktartList();
    }

    public JTable getArbeitTable() {
        if (this.mArbeitTable == null) {
            this.mArbeitTable = new JTable();
            this.mArbeitTable.setDefaultRenderer(String.class, new TableCellRendererString(this.mMarkenLayout));
            this.mArbeitTable.setDefaultRenderer(Double.class, new AdminTableCellRendererDouble(this.mMarkenLayout));
            this.mEditorDouble = new TableCellEditorDouble(this.mMarkenLayout, Pattern.compile(PATTERN_PREIS), MIN_PREIS);
            this.mEditorString = new TableCellEditorString(this.mMarkenLayout);
            this.mArbeitTable.setDefaultEditor(Double.class, this.mEditorDouble);
            this.mArbeitTable.setDefaultEditor(String.class, this.mEditorString);
            this.mArbeitTable.getTableHeader().setFont(Constants.Layout.getZubDefaultFont());
            this.mArbeitTable.getTableHeader().setDefaultRenderer(new AdminTableHeaderRenderer(this.mMarkenLayout));
            this.mArbeitTable.getTableHeader().setBackground(this.mMarkenLayout.getTertiaryBackground());
            this.mArbeitTable.getTableHeader().setForeground(this.mMarkenLayout.getTertiaryForeground());
            this.mArbeitTable.getTableHeader().setReorderingAllowed(false);
            for (MarkeProdukt oMrkPrd : this.getMarkeProduktArtList()) {
                String sMarke = oMrkPrd.getMarke();
                String sProdukt = oMrkPrd.getProdukt();
                this.setTableModel(sMarke, sProdukt, this.mModel.getDataAufwaende(sMarke, sProdukt, this.mModel.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt)));
            }
            this.setArbeitTable();
        }
        return this.mArbeitTable;
    }

    private Component getWaehrungPanel() {
        JPanel panel = this.getPanel(800, 50);
        panel.setLayout(new GridBagLayout());
        String waehrung = ZubCustomizable.getInstance().getWaehrungsKz();
        if (waehrung != null && waehrung.length() > 0) {
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 16, new Insets(30, 5, 0, 10));
            panel.add((Component)this.getLabel(Resource.getInstance().getAllePreise() + waehrung, 150, 20), gbc);
        }
        return panel;
    }

    private Component getMarktauswahlPanel() {
        JPanel marktAuswahlPanel = this.getPanel();
        marktAuswahlPanel.setLayout(new BorderLayout());
        marktAuswahlPanel.add((Component)this.getPanel(800, 50), "North");
        JPanel konfigPanel = this.getPanel(780, 60);
        konfigPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.mMarkenLayout.getBorderColor()));
        konfigPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        konfigPanel.add((Component)this.getLabel(Resource.getInstance().getMarkt() + ":"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 2, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mMarktCombo = this.getCombo(this.mModel.getMaerkteArray(), 500, 20);
        konfigPanel.add((Component)this.mMarktCombo, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 0, 11, new Insets(20, 110, 0, 0));
        konfigPanel.add((Component)this.getSizer(10, 22), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mKundendatenCheck = this.getCheckbox(500, 20);
        konfigPanel.add((Component)this.mKundendatenCheck, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        konfigPanel.add((Component)this.getLabel(Resource.getInstance().getKundendatenSpeichern(), 480, 20), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mVerfuegbarkeitCheck = this.getCheckbox(20, 20);
        konfigPanel.add((Component)this.mVerfuegbarkeitCheck, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 1, 1, 1.0, 100.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mVerf\u00fcgbarkeitsText = this.getLabel(Resource.getInstance().getVerfuegbarkeit(), 480, 20);
        konfigPanel.add((Component)this.mVerf\u00fcgbarkeitsText, gbc);
        marktAuswahlPanel.add(konfigPanel);
        this.mKonfigurationSpeichern = this.getButtonSpeichern("FILIALE", true);
        this.mKonfigurationZur\u00fccksetzen = this.getButtonZur\u00fccksetzen("FILIALE", true);
        marktAuswahlPanel.add((Component)this.getButtonPanel(this.mKonfigurationSpeichern, this.mKonfigurationZur\u00fccksetzen), "South");
        return marktAuswahlPanel;
    }

    private JPanel getStammdatenPanel() {
        JPanel stammdatenPanel = this.getPanel();
        stammdatenPanel.setLayout(new BorderLayout());
        JPanel ueberschriftPanel = this.getPanel(700, 50);
        ueberschriftPanel.add(this.getSizer(12, 20));
        ueberschriftPanel.add(this.getLabel(Resource.getInstance().getAngaben(), 680, 20));
        stammdatenPanel.add((Component)ueberschriftPanel, "North");
        JPanel addressPanel = this.getPanel(780, 260);
        addressPanel.setLayout(new GridBagLayout());
        addressPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.mMarkenLayout.getBorderColor()));
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getNameOhneKlammern() + "*:"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mFilialBezeichnungField = this.getTextField(500, 20);
        this.mFilialBezeichnungField.setMaxCharacters(40);
        addressPanel.add((Component)this.mFilialBezeichnungField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 110, 0, 0));
        addressPanel.add((Component)this.getSizer(10, 20), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getStrasse() + "*:"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mStrasseField = this.getTextField(500, 20);
        this.mStrasseField.setMaxCharacters(25);
        addressPanel.add((Component)this.mStrasseField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getPlz() + "/" + Resource.getInstance().getOrt() + "*:"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mPLZField = this.getTextField(200, 20);
        this.mPLZField.setMaxCharacters(10);
        addressPanel.add((Component)this.mPLZField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        addressPanel.add((Component)new JLabel(" / "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mOrtField = this.getTextField(320, 20);
        this.mOrtField.setMaxCharacters(20);
        addressPanel.add((Component)this.mOrtField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getTelefon() + ":"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 3, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mTelefon = new JPatternTextField("[+-/\u0000-9]{0,12}");
        this.mTelefon.setMaxCharacters(25);
        addressPanel.add((Component)this.mTelefon, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getFax() + ":"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 3, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mFax = new JPatternTextField("[+-/\u0000-9]{0,12}");
        this.mFax.setMaxCharacters(25);
        addressPanel.add((Component)this.mFax, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 2, 11, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getEmail() + ":"), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 5, 3, 1, 1.0, 1.0, 2, 11, new Insets(20, 5, 0, 0));
        this.mEmail = new JPatternTextField("[_a-zA-Z0-9-@\\.]*");
        this.mEmail.setMaxCharacters(50);
        addressPanel.add((Component)this.mEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 0, 17, new Insets(20, 10, 0, 20));
        addressPanel.add((Component)this.getLabel(Resource.getInstance().getPflichtfelder(), 200, 20), gbc);
        stammdatenPanel.add(addressPanel);
        this.mStammdatenSpeichern = this.getButtonSpeichern("FILIALE", true);
        this.mStammdatenZur\u00fccksetzen = this.getButtonZur\u00fccksetzen("FILIALE", true);
        stammdatenPanel.add((Component)this.getButtonPanel(this.mStammdatenSpeichern, this.mStammdatenZur\u00fccksetzen), "South");
        return stammdatenPanel;
    }

    public void setAttributes() {
        if (this.mModel.getSelectedFiliale().getBezeichnung().equals("")) {
            this.mFilialBezeichnungField.setText(this.mModel.getSelectedFiliale().getBezeichnungFirma());
        } else {
            this.mFilialBezeichnungField.setText(this.mModel.getSelectedFiliale().getBezeichnung());
        }
        this.mStrasseField.setText(this.mModel.getSelectedFiliale().getStrasse());
        this.mPLZField.setText(this.mModel.getSelectedFiliale().getPlz());
        this.mOrtField.setText(this.mModel.getSelectedFiliale().getOrt());
        this.mTelefon.setText(this.mModel.getSelectedFiliale().getTelefon());
        this.mFax.setText(this.mModel.getSelectedFiliale().getFax());
        this.mEmail.setText(this.mModel.getSelectedFiliale().getEmail());
        this.mMarktCombo.setSelectedItem(this.mModel.getSelectedFilialMarkt());
        this.mKundendatenCheck.setSelected(this.mModel.getSelectedFiliale().isSpeicherKunde());
        this.mVerfuegbarkeitCheck.setEnabled(false);
        this.mVerfuegbarkeitCheck.setSelected(false);
        this.mVerf\u00fcgbarkeitsText.setEnabled(false);
        this.setMarktProduktartCombo();
        this.mAenderungFilialCheck.setSelected(false);
        this.mAenderungFuerAlleMarkenCheck.setSelected(false);
        for (MarkeProdukt oMrkPrd : this.getMarkeProduktArtList()) {
            String sMarke = oMrkPrd.getMarke();
            String sProdukt = oMrkPrd.getProdukt();
            this.setTableModel(sMarke, sProdukt, this.mModel.getDataAufwaende(sMarke, sProdukt, this.mModel.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt)));
        }
        this.setArbeitTable();
    }

    public JLabelButton getArbeitSpeichern() {
        return this.mArbeitSpeichern;
    }

    public JLabelButton getArbeitZur\u00fccksetzen() {
        return this.mArbeitZur\u00fccksetzen;
    }

    public JLabelButton getStammdatenSpeichern() {
        return this.mStammdatenSpeichern;
    }

    public JLabelButton getStammdatenZur\u00fccksetzen() {
        return this.mStammdatenZur\u00fccksetzen;
    }

    public JLabelButton getKonfigurationSpeichern() {
        return this.mKonfigurationSpeichern;
    }

    public JLabelButton getKonfigurationZur\u00fccksetzen() {
        return this.mKonfigurationZur\u00fccksetzen;
    }

    public JLabelButton getMarktabgleich() {
        return this.mMarktabgleich;
    }

    public JLabelButton getDMSabgleich() {
        return this.mDMSabgleich;
    }

    public void stammdatenZuruecksetzen() {
        this.mFilialBezeichnungField.setText(this.mModel.getSelectedFiliale().getBezeichnung());
        this.mStrasseField.setText(this.mModel.getSelectedFiliale().getStrasse());
        this.mPLZField.setText(this.mModel.getSelectedFiliale().getPlz());
        this.mOrtField.setText(this.mModel.getSelectedFiliale().getOrt());
        this.mTelefon.setText(this.mModel.getSelectedFiliale().getTelefon());
        this.mFax.setText(this.mModel.getSelectedFiliale().getFax());
        this.mEmail.setText(this.mModel.getSelectedFiliale().getEmail());
    }

    private JComboBox getComboFiliale(FilialeZub[] data, int width, int height) {
        JComboBox combo = new JComboBox(data);
        combo.setPreferredSize(new Dimension(width, height));
        this.setComponentBackground(combo);
        combo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                javax.swing.JLabel label = (javax.swing.JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    FilialeZub filiale = (FilialeZub)value;
                    if (!FilialPanel.this.mModel.checkFilialDatenComplete(filiale.getId())) {
                        label.setForeground(Color.RED);
                    } else if (isSelected) {
                        label.setForeground(Color.WHITE);
                    } else {
                        label.setForeground(Color.BLACK);
                    }
                    label.setText(filiale.getBezeichnung());
                }
                return label;
            }
        });
        return combo;
    }

    public void refreshFilialCombo() {
        this.setMeldung();
        this.mFilialCombo.updateUI();
    }

    public void konfiguartionZuruecksetzen() {
        this.mMarktCombo.setSelectedItem(this.mModel.getSelectedFilialMarkt());
        this.mKundendatenCheck.setSelected(this.mModel.getSelectedFiliale().isSpeicherKunde());
        this.mVerfuegbarkeitCheck.setSelected(this.mModel.getSelectedFiliale().isPruefVerfuegbarkeit());
    }

    public void arbeitZuruecksetzen() {
        this.mAenderungFilialCheck.setSelected(false);
        this.mAenderungFuerAlleMarkenCheck.setSelected(false);
        for (MarkeProdukt oMrkPrd : this.getMarkeProduktArtList()) {
            String sMarke = oMrkPrd.getMarke();
            String sProdukt = oMrkPrd.getProdukt();
            this.setTableModel(sMarke, sProdukt, this.mModel.getDataAufwaende(sMarke, sProdukt, this.mModel.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt)));
        }
        this.setArbeitTable();
    }

    public JComboBox getFilialCombo() {
        return this.mFilialCombo;
    }

    public JComboBox getMarkeProduktartCombo() {
        return this.mMarkeProduktartCombo;
    }

    public void setArbeitTable() {
        if (this.mDMSabgleich != null) {
            this.mDMSabgleich.setEnabled(true);
        }
        this.mAenderungFuerAlleMarkenCheck.setEnabled(true);
        this.mAenderungFuerAlleMarkenText.setEnabled(true);
        String sMarke = ((MarkeProdukt)this.mMarkeProduktartCombo.getSelectedItem()).getMarke();
        String sProdukt = ((MarkeProdukt)this.mMarkeProduktartCombo.getSelectedItem()).getProdukt();
        AdminTableModel oAdminTableModel = this.getArbeitTableModelFuerMarkeProdukt(sMarke, sProdukt);
        this.mArbeitTable.setModel(oAdminTableModel);
        this.mActiveTableModel = oAdminTableModel;
        if (Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung().equalsIgnoreCase(sProdukt)) {
            if (this.mDMSabgleich != null) {
                this.mDMSabgleich.setEnabled(false);
            }
            this.mAenderungFuerAlleMarkenCheck.setEnabled(false);
            this.mAenderungFuerAlleMarkenText.setEnabled(false);
        }
        this.mArbeitTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.mArbeitTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.mArbeitTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.mArbeitTable.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.mArbeitTable.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.mArbeitTable.updateUI();
        this.mArbeitTable.validate();
    }

    public void setTableModel(String marke, String produkt, Object[][] data) {
        this.setArbeitTableModelFuerMarkeProdukt(new AdminTableModel(data, marke, produkt));
    }

    public void refreshTableModel() {
        for (MarkeProdukt oMrkPrd : this.getMarkeProduktArtList()) {
            String sMarke = oMrkPrd.getMarke();
            String sProdukt = oMrkPrd.getProdukt();
            this.setArbeitTableModelFuerMarkeProdukt(new AdminTableModel(this.mModel.getDataAufwaende(sMarke, sProdukt, this.mModel.getAufwaendeFuerMarkeProdukt(sMarke, sProdukt)), sMarke, sProdukt));
        }
    }

    public AdminTableModel getActivTabelModel() {
        return this.mActiveTableModel;
    }

    public JPatternTextField getKundennummer() {
        return this.mKundennummer;
    }

    public JPatternTextField getAuftragsnummer() {
        return this.mAuftragsnummer;
    }

    public String getStringFilialBezeichnung() {
        return this.mFilialBezeichnungField.getText();
    }

    public String getStringStrasse() {
        return this.mStrasseField.getText();
    }

    public String getStringPLZ() {
        return this.mPLZField.getText();
    }

    public String getStringOrt() {
        return this.mOrtField.getText();
    }

    public String getStringTelefon() {
        return this.mTelefon.getText();
    }

    public String getStringFax() {
        return this.mFax.getText();
    }

    public String getStringEmail() {
        return this.mEmail.getText();
    }

    public boolean isKundendatenSpeichern() {
        return this.mKundendatenCheck.isSelected();
    }

    public Boolean isVerfuegbarkeitBerechnen() {
        return this.mVerfuegbarkeitCheck.isSelected();
    }

    public boolean isAenderungFilial() {
        return this.mAenderungFilialCheck.isSelected();
    }

    public boolean isAenderungMarken() {
        return this.mAenderungFuerAlleMarkenCheck.isSelected();
    }

    public JComboBox getMarktCombo() {
        return this.mMarktCombo;
    }

    public int getIndexMarkenComboBoxOld() {
        return this.mIndexMarkenComboBoxOld;
    }

    public void setIndexMarkenComboBoxOld(int indexMarkenComboBoxOld) {
        this.mIndexMarkenComboBoxOld = indexMarkenComboBoxOld;
    }

    public JTextField getFilialBezeichnungField() {
        return this.mFilialBezeichnungField;
    }

    public JTextField getStrasseField() {
        return this.mStrasseField;
    }

    public JTextField getPLZField() {
        return this.mPLZField;
    }

    public JTextField getOrtField() {
        return this.mOrtField;
    }

    public boolean checkFelder() {
        boolean test = true;
        if (this.mFilialBezeichnungField.getText().equals("")) {
            return false;
        }
        if (this.mStrasseField.getText().equals("")) {
            return false;
        }
        if (this.mPLZField.getText().equals("")) {
            return false;
        }
        if (this.mOrtField.getText().equals("")) {
            return false;
        }
        return test;
    }

    public void aktiviereSpeichernButton(boolean flag) {
        this.mStammdatenSpeichern.setEnabled(flag, this.mMarkenLayout);
        this.mStammdatenSpeichern.updateUI();
    }

    public TableCellEditorDouble getEditorDouble() {
        return this.mEditorDouble;
    }

    public TabelCellEditorInteger getEditorInt() {
        return this.mEditorInt;
    }

    public void activateMarktButton() {
        if (this.mMarktCombo.getSelectedIndex() != 0) {
            this.mMarktabgleich.setEnabled(true, this.mMarkenLayout);
        } else {
            this.mMarktabgleich.setEnabled(false, this.mMarkenLayout);
        }
    }

    public AdminTableModel getArbeitTableModelFuerMarkeProdukt(String psMarke, String psProdukt) {
        for (AdminTableModel oAdmTblMdl : this.mArbeitTableModelList) {
            if (!oAdmTblMdl.getMarke().equalsIgnoreCase(psMarke) || !oAdmTblMdl.getProduktart().equalsIgnoreCase(psProdukt)) continue;
            return oAdmTblMdl;
        }
        return null;
    }

    public void setArbeitTableModelFuerMarkeProdukt(AdminTableModel pAdmTblMdl) {
        boolean bGefunden = false;
        for (AdminTableModel oAdmTblMdl : this.mArbeitTableModelList) {
            if (!oAdmTblMdl.getMarke().equalsIgnoreCase(pAdmTblMdl.getMarke()) || !oAdmTblMdl.getProduktart().equalsIgnoreCase(pAdmTblMdl.getProduktart())) continue;
            oAdmTblMdl = pAdmTblMdl;
            bGefunden = true;
        }
        if (!bGefunden) {
            this.mArbeitTableModelList.add(pAdmTblMdl);
        }
    }
}

