/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class AnfragenContainer
extends JPanel {
    private MarkenLayout mMarkenLayout;
    private GridBagConstraints gbc;
    private static int WIDTH = 152;
    private static Dimension DEFAULT_DIMENSION = new Dimension(WIDTH, 25);
    public static final String SCHLIESSEN = "schliessen";
    public static final String OEFFNEN = "oeffnen";
    private JLabel mAnfragenNameLabel;
    private JLabel mDocumentIcon;
    private JLabel mSchliessenIcon;
    private int mAnfragenId;

    public AnfragenContainer(MarkenLayout layout, String anfragenName, int anfragenId) {
        this.mMarkenLayout = layout;
        this.mAnfragenId = anfragenId;
        this.createAnfrageContainer(anfragenName);
    }

    private void createAnfrageContainer(String anfragenName) {
        this.setMaximumSize(DEFAULT_DIMENSION);
        this.setPreferredSize(DEFAULT_DIMENSION);
        this.setMinimumSize(DEFAULT_DIMENSION);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(Color.GRAY);
        this.setForeground(Color.WHITE);
        this.mDocumentIcon = new JLabel(new ImageIcon(ImageCache.getInstance().getImage("Icons/document.gif")));
        this.mDocumentIcon.setName(OEFFNEN);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(2, 2, 2, 2));
        this.add((Component)this.mDocumentIcon, this.gbc);
        this.mAnfragenNameLabel = this.mMarkenLayout.getLabel(anfragenName);
        FontMetrics fontMetrics = this.getFontMetrics(Constants.Layout.getZubDefaultFont());
        this.mAnfragenNameLabel.setText(anfragenName);
        int textBreite = fontMetrics.stringWidth(anfragenName);
        if (textBreite > WIDTH - 5) {
            this.mAnfragenNameLabel.setToolTipText(anfragenName);
        } else {
            this.mAnfragenNameLabel.setToolTipText(null);
        }
        this.mAnfragenNameLabel.setName(OEFFNEN);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, 17, new Insets(2, 2, 2, 2));
        this.add((Component)this.mAnfragenNameLabel, this.gbc);
        this.mSchliessenIcon = new JLabel(new ImageIcon(ImageCache.getInstance().getImage("Icons/Grp/schliessen.gif")));
        this.mSchliessenIcon.setName(SCHLIESSEN);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 2, 17, new Insets(2, 2, 2, 2));
        this.add((Component)this.mSchliessenIcon, this.gbc);
        this.updateUI();
    }

    public JLabel getAnfragenNameLabel() {
        return this.mAnfragenNameLabel;
    }

    public JLabel getDocumentIcon() {
        return this.mDocumentIcon;
    }

    public JLabel getSchliessenIcon() {
        return this.mSchliessenIcon;
    }

    public int getAnfragenId() {
        return this.mAnfragenId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnfragenContainer other = (AnfragenContainer)obj;
        return this.mAnfragenId == other.mAnfragenId;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.mAnfragenId;
        return result;
    }
}

