/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.anfrage.AnfragenTableCellRenderer;
import de.esg.zub.configurator.content.anfrage.AnfragenTableHeaderRenderer;
import de.esg.zub.configurator.content.anfrage.AnfragenTableModel;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import webetk.app.zub.verwaltung.AnfrageSuche;
import webetk.resources.Resource;

public class AnfragenTablePanel
extends JPanel {
    private JTable mAnfragenTable;
    private JScrollPane mAnfrageTableScrollPane;
    private JLabel mHeaderLabel;
    private MarkenLayout mMarkenLayout;
    private GridBagConstraints gbc;
    private JLabel mOpenAllIcon;
    private JLabel mCloseAllIcon;

    public AnfragenTablePanel(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setLayout(new GridBagLayout());
        this.setBackground(this.mMarkenLayout.getSecondaryBackground());
        this.createComponents();
    }

    private void createComponents() {
        this.mHeaderLabel = this.mMarkenLayout.getBoldHeaderLabel(Resource.getInstance().getAnfragen() + ":");
        this.mAnfragenTable = new JTable();
        this.mAnfragenTable.setName("ANFRAGETABLE");
        this.mAnfrageTableScrollPane = new JScrollPane(this.mAnfragenTable);
        this.mOpenAllIcon = new JLabel("++", 0);
        this.mOpenAllIcon.setBigFont();
        this.mOpenAllIcon.setMinimumSize(new Dimension(25, 15));
        this.mOpenAllIcon.setOpaque(true);
        this.mOpenAllIcon.setForeground(Color.WHITE);
        this.mOpenAllIcon.setBackground(Color.GRAY);
        this.mOpenAllIcon.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.mOpenAllIcon.setName("OPENALL");
        this.mCloseAllIcon = new JLabel("--", 0);
        this.mCloseAllIcon.setBigFont();
        this.mCloseAllIcon.setMinimumSize(new Dimension(25, 15));
        this.mCloseAllIcon.setOpaque(true);
        this.mCloseAllIcon.setBackground(Color.GRAY);
        this.mCloseAllIcon.setForeground(Color.WHITE);
        this.mCloseAllIcon.setName("CLOSEALL");
    }

    public void setTablePanel(ArrayList<AnfrageSuche> anfragen) {
        this.mHeaderLabel.setForeground(Color.GRAY);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 20, 0, 20));
        this.add((Component)this.mHeaderLabel, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 11, new Insets(2, 20, 4, 5));
        this.add((Component)this.mOpenAllIcon, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 2, 11, new Insets(2, 0, 4, 0));
        this.add((Component)this.mCloseAllIcon, this.gbc);
        AnfragenTableCellRenderer atcr = new AnfragenTableCellRenderer(this.mMarkenLayout);
        this.mAnfragenTable.setDefaultRenderer(JLabel.class, atcr);
        this.mAnfragenTable.setDefaultRenderer(ImageIcon.class, atcr);
        this.mAnfragenTable.setDefaultRenderer(String.class, atcr);
        this.mAnfragenTable.setModel(new AnfragenTableModel(anfragen));
        this.setTableHeader();
        this.mAnfragenTable.getTableHeader().setBackground(Color.GRAY);
        this.mAnfragenTable.getTableHeader().setForeground(Color.WHITE);
        this.mAnfragenTable.setShowVerticalLines(false);
        this.mAnfragenTable.setShowHorizontalLines(false);
        this.calculateTableSize();
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 1, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.mAnfrageTableScrollPane, this.gbc);
        this.updateUI();
    }

    private void setTableHeader() {
        this.mAnfragenTable.getTableHeader().setFont(Constants.Layout.getZubDefaultFont());
        this.mAnfragenTable.getTableHeader().setDefaultRenderer(new AnfragenTableHeaderRenderer(this.mMarkenLayout));
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(15);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(1).setMaxWidth(15);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(35);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(15);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(15);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(4).setMinWidth(15);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(4).setMaxWidth(15);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(5).setPreferredWidth(130);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(5).setMaxWidth(300);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(100);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(100);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(7).setMinWidth(80);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(7).setMaxWidth(80);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(8).setMinWidth(100);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(8).setMaxWidth(100);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(9).setMinWidth(100);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(9).setMaxWidth(100);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(10).setMinWidth(40);
        this.mAnfragenTable.getTableHeader().getColumnModel().getColumn(10).setMaxWidth(100);
        this.mAnfragenTable.getTableHeader().setReorderingAllowed(false);
    }

    public JTable getAnfragenTable() {
        return this.mAnfragenTable;
    }

    public int getAnfrageIdFromRow(MouseEvent event) {
        int rowIndex = this.mAnfragenTable.rowAtPoint(new Point(event.getX(), event.getY()));
        return ((AnfragenTableModel)this.mAnfragenTable.getModel()).getAnfrageIdFromRow(rowIndex);
    }

    public void handleAufZuklappen(MouseEvent event) {
        int rowIndex = this.mAnfragenTable.rowAtPoint(new Point(event.getX(), event.getY()));
        ((AnfragenTableModel)this.mAnfragenTable.getModel()).aufzuklappen(rowIndex);
        this.calculateTableSize();
    }

    public boolean isRowAnfrage(MouseEvent event) {
        int rowIndex = this.mAnfragenTable.rowAtPoint(new Point(event.getX(), event.getY()));
        return ((AnfragenTableModel)this.mAnfragenTable.getModel()).isRowAnfrage(rowIndex);
    }

    public int getVorgangsIdFromRow(MouseEvent event) {
        int rowIndex = this.mAnfragenTable.rowAtPoint(new Point(event.getX(), event.getY()));
        return ((AnfragenTableModel)this.mAnfragenTable.getModel()).getVorgangsIdFromRow(rowIndex);
    }

    public void handleRemoveRow(MouseEvent event) {
        int rowIndex = this.mAnfragenTable.rowAtPoint(new Point(event.getX(), event.getY()));
        ((AnfragenTableModel)this.mAnfragenTable.getModel()).removeRow(rowIndex);
        this.calculateTableSize();
    }

    private void calculateTableSize() {
        int anzahlZeilen = 0;
        anzahlZeilen = this.mAnfragenTable.getRowCount() < 13 ? this.mAnfragenTable.getRowCount() : 13;
        this.mAnfrageTableScrollPane.setMinimumSize(new Dimension(800, anzahlZeilen * this.mAnfragenTable.getRowHeight() + 24));
        this.mAnfrageTableScrollPane.setMaximumSize(new Dimension(800, anzahlZeilen * this.mAnfragenTable.getRowHeight() + 24));
        this.updateUI();
    }

    public JLabel getOpenAllIcon() {
        return this.mOpenAllIcon;
    }

    public JLabel getCloseAllIcon() {
        return this.mCloseAllIcon;
    }

    public void handleOpenAll() {
        ((AnfragenTableModel)this.mAnfragenTable.getModel()).alleAufKlappen();
        this.calculateTableSize();
    }

    public void handleCloseAll() {
        ((AnfragenTableModel)this.mAnfragenTable.getModel()).alleZuKlappen();
        this.calculateTableSize();
    }
}

