/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.anfrage.AnfragenContainer;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class Anfragenleiste
extends Observable {
    private JPanel mAnfrageLeistePanel = new JPanel();
    private MarkenLayout mMarkenLayout;
    private GridBagConstraints gbc;
    private ArrayList<AnfragenContainer> mAnfragenContainerList;
    private int mCountAnfragen = 0;
    private int mMaxCount = 5;

    public Anfragenleiste(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.mAnfrageLeistePanel.setBackground(this.mMarkenLayout.getSecondaryBackground());
        this.mAnfrageLeistePanel.setLayout(new GridBagLayout());
        this.mAnfrageLeistePanel.setMaximumSize(new Dimension(822, 40));
        this.mAnfrageLeistePanel.setMinimumSize(new Dimension(822, 40));
        this.gbc = this.mMarkenLayout.setGridBagConstraints(5, 0, 1, 1, 10.0, 1.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mAnfrageLeistePanel.add((Component)new JLabel(), this.gbc);
        this.mAnfragenContainerList = new ArrayList();
    }

    public void addAnfrageContainer(String anfragenName, int anfragenId) {
        if (!this.isAnfrageAdded(anfragenId, anfragenName)) {
            AnfragenContainer anfrage = new AnfragenContainer(this.mMarkenLayout, anfragenName, anfragenId);
            if (!this.mAnfragenContainerList.contains(anfrage)) {
                this.mAnfragenContainerList.add(anfrage);
            }
            ++this.mCountAnfragen;
            this.gbc = this.mMarkenLayout.setGridBagConstraints(this.mCountAnfragen, 0, 1, 1, 0.0, 1.0, 0, 17, new Insets(5, 5, 5, 5));
            this.mAnfrageLeistePanel.add((Component)anfrage, this.gbc);
            this.mAnfrageLeistePanel.updateUI();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isAnfrageAdded(int anfragenId, String anfrageName) {
        for (int ii = 0; ii < this.mAnfragenContainerList.size(); ++ii) {
            if (this.mAnfragenContainerList.get(ii).getAnfragenId() != anfragenId) continue;
            return true;
        }
        return false;
    }

    public void removeAnfrageContainer(int i) {
        this.mAnfrageLeistePanel.remove(this.mAnfragenContainerList.get(i));
        this.mAnfragenContainerList.remove(i);
        --this.mCountAnfragen;
        this.mAnfrageLeistePanel.removeAll();
        for (int j = 0; j < this.mAnfragenContainerList.size(); ++j) {
            this.gbc = this.mMarkenLayout.setGridBagConstraints(j, 0, 1, 1, 0.0, 1.0, 0, 17, new Insets(5, 5, 5, 5));
            this.mAnfrageLeistePanel.add((Component)this.mAnfragenContainerList.get(j), this.gbc);
        }
        this.gbc = this.mMarkenLayout.setGridBagConstraints(5, 0, 1, 1, 10.0, 1.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mAnfrageLeistePanel.add((Component)new JLabel(), this.gbc);
        this.mAnfrageLeistePanel.updateUI();
    }

    public int getCountAnfragen() {
        return this.mCountAnfragen;
    }

    public JPanel getAnfrageLeistePanel() {
        return this.mAnfrageLeistePanel;
    }

    public ArrayList<AnfragenContainer> getAnfragenContainerList() {
        return this.mAnfragenContainerList;
    }

    public boolean checkAnzahlContainer() {
        if (this.mAnfragenContainerList.size() + 1 > this.mMaxCount) {
            MainController.getInstance().getMainFrame().showErrorMessage(Resource.getInstance().getMaxmeldung());
            return false;
        }
        return true;
    }
}

