/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.anfrage.AnfragenContainer;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.anfrage.AnfragenPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.navigation.ControllerInfoPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.ControllerWelcomePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;
import webetk.ObjectLockedException;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class ControllerAnfragenPanel
implements MouseListener,
CellEditorListener,
Observer {
    private static Logger log = Logger.getLogger(ControllerAnfragenPanel.class);
    private static ControllerAnfragenPanel mInstance;
    private AnfragenPanel mAnfragenPanel;
    private boolean mAnfrageGeladen;
    private static final String LOESCHEN_MELDUNG_ANFRAGE;
    private static final String ANFRAGE_GESPERRT;
    private static final String ANFRGE_GESPERRT_MSG;

    private ControllerAnfragenPanel() {
    }

    public static ControllerAnfragenPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerAnfragenPanel();
        }
        return mInstance;
    }

    public void init(Dimension panelSize, MarkenLayout markenLayout) {
        this.mAnfragenPanel = new AnfragenPanel(panelSize, markenLayout);
        this.mAnfragenPanel.getAnfragenleiste().addObserver(mInstance);
        this.mAnfrageGeladen = false;
        this.addListener();
    }

    private void addListener() {
        this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().addMouseListener(mInstance);
        this.mAnfragenPanel.getSuchkriterienPanel().getSearchButton().addMouseListener(mInstance);
        this.mAnfragenPanel.getSuchkriterienPanel().getResetButton().addMouseListener(mInstance);
        this.mAnfragenPanel.getAnfragenTablePanel().getOpenAllIcon().addMouseListener(mInstance);
        this.mAnfragenPanel.getAnfragenTablePanel().getCloseAllIcon().addMouseListener(mInstance);
    }

    public AnfragenPanel getAnfragenPanel() {
        if (this.mAnfragenPanel == null) {
            this.init(ControllerWelcomePanel.getInstance().getWelcomePanel().getContentSize(), WorkflowController.getInstance().getMarkenLayout());
        }
        if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.mAnfragenPanel.getSuchkriterienPanel().resetFields();
            this.mAnfragenPanel.getAnfragenTablePanel().setVisible(false);
        }
        return this.mAnfragenPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            this.mAnfragenPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(3));
            this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().setCursor(Cursor.getPredefinedCursor(3));
            if (event.getClickCount() == 2 && event.getComponent() == this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable()) {
                int aktColumn = this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().columnAtPoint(new Point(event.getX(), event.getY()));
                if (aktColumn != 1 && aktColumn != 3 && this.mAnfragenPanel.getAnfragenleiste().checkAnzahlContainer()) {
                    this.loadAnfrage(this.mAnfragenPanel.getAnfragenTablePanel().getAnfrageIdFromRow(event));
                }
            } else if (event.getClickCount() == 2 && event.getComponent().getName().equals("oeffnen")) {
                ArrayList<AnfragenContainer> dummy = this.mAnfragenPanel.getAnfragenleiste().getAnfragenContainerList();
                for (int ii = 0; ii < dummy.size(); ++ii) {
                    if (dummy.get(ii).getAnfragenNameLabel() != event.getComponent() && dummy.get(ii).getDocumentIcon() != event.getComponent()) continue;
                    this.loadAnfrage(dummy.get(ii).getAnfragenId());
                }
            }
        }
        finally {
            this.mAnfragenPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(0));
            this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    private void loadAnfrage(int anfrageId) {
        try {
            Anfrage anfrage = AnfragenDataLoader.ladeAnfrage(anfrageId);
            this.setAnfrage(anfrage);
        }
        catch (Exception ex) {
            if (ex instanceof ObjectLockedException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog((Component)MainView.getInstance(), ANFRGE_GESPERRT_MSG, ANFRAGE_GESPERRT, 0);
            }
            ex.printStackTrace();
        }
    }

    public void setAnfrage(Anfrage anfrage) {
        this.mAnfrageGeladen = true;
        ControllerWelcomePanel.setMarkeProduktartGlobal(anfrage.getMarke(), String.valueOf(anfrage.getProduktArt()));
        String letzteSicht = "";
        try {
            letzteSicht = AnfrageHandler.getInstance().setAnfrage(anfrage);
            if (letzteSicht.equals("failure")) {
                WorkflowController.getInstance().setMarkenLayout(null, null);
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getProduktFehlerMsg(), Resource.getInstance().getInformation(), 1);
                return;
            }
            ClientKonfiguration.getClientKonfiguration().setKalkulationSet(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        WorkflowController.getInstance().setFzBedIdentified(true);
        WorkflowController.getInstance().changeState(letzteSicht);
        ControllerMenuBar.getInstance().getMenuBar().addVorgaengePanel();
        for (int i = 0; i < anfrage.getVorgangsId().size(); ++i) {
            ControllerMenuBar.getInstance().getMenuBar().addVorgang(anfrage.getVorgangsId().get(i), anfrage.getVorgangsNamen().get(i));
        }
        boolean forceReload = false;
        ControllerMenuBar.getInstance().updateViewComponents(anfrage.getVorgang().getVorgangsId(), anfrage.getVorgang(), forceReload);
        ControllerNavigationPanel.getInstance().getNavigationPanel().setStyle(WorkflowController.getInstance().getMarkenLayout());
        ControllerInfoPanel.getInstance().getInfoPanel().setStyle();
        if (ControllerInfoPanel.getInstance().getInfoPanel().getTrefferlistePanel() != null) {
            ControllerInfoPanel.getInstance().getInfoPanel().getTrefferlistePanel().setStyle();
        }
        if (ControllerInfoPanel.getInstance().getInfoPanel().getDetailPanel() != null) {
            ControllerInfoPanel.getInstance().getInfoPanel().getDetailPanel().setStyle();
        }
        ControllerMenuBar.getInstance().getMenuBar().enableMenuSpeichern(true);
        ControllerNavigationPanel.getInstance().getNavigationPanel().initBauarten();
        ControllerNavigationPanel.getInstance().getNavigationPanel().setRefreshForFZChange(true);
        this.mAnfrageGeladen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        block30: {
            try {
                this.mAnfragenPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(3));
                this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().setCursor(Cursor.getPredefinedCursor(3));
                if (event.getComponent() == this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable()) {
                    int aktColumn = this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().columnAtPoint(new Point(event.getX(), event.getY()));
                    if (aktColumn == 0) {
                        if (this.mAnfragenPanel.getAnfragenleiste().checkAnzahlContainer()) {
                            this.loadAnfrage(this.mAnfragenPanel.getAnfragenTablePanel().getAnfrageIdFromRow(event));
                        }
                    } else if (aktColumn == 1 && MainController.getInstance().getMainFrame().showConfirmMessage(LOESCHEN_MELDUNG_ANFRAGE)) {
                        try {
                            if (this.mAnfragenPanel.getAnfragenTablePanel().isRowAnfrage(event)) {
                                int anfrageId = this.mAnfragenPanel.getAnfragenTablePanel().getAnfrageIdFromRow(event);
                                this.checkInaktivAnfrageToDelete(anfrageId);
                                AnfragenDataLoader.loescheAnfrage(anfrageId);
                                if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                                    GlobalObjects.getInstance().getIpacData().setAnzahlAnfragen(GlobalObjects.getInstance().getIpacData().getAnzahlAnfragen() - 1);
                                    ControllerWelcomePanel.getInstance().getWelcomePanel().setBeschriftungBestehendeAnfragen();
                                }
                            } else {
                                try {
                                    KalkulationDataLoader.loescheVorgang(this.mAnfragenPanel.getAnfragenTablePanel().getVorgangsIdFromRow(event));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    log.error((Object)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error((Object)e);
                        }
                        this.mAnfragenPanel.getAnfragenTablePanel().handleRemoveRow(event);
                    }
                    if (aktColumn == 3) {
                        this.mAnfragenPanel.getAnfragenTablePanel().handleAufZuklappen(event);
                    }
                    break block30;
                }
                if (event.getComponent() == this.mAnfragenPanel.getSuchkriterienPanel().getSearchButton()) {
                    Cursor oldCursor = this.mAnfragenPanel.getSuchkriterienPanel().getSearchButton().getCursor();
                    try {
                        this.mAnfragenPanel.getSuchkriterienPanel().getSearchButton().setCursor(Cursor.getPredefinedCursor(3));
                        this.mAnfragenPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(3));
                        this.sucheAnfragen();
                        break block30;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error((Object)e);
                        break block30;
                    }
                    finally {
                        this.mAnfragenPanel.getSuchkriterienPanel().getSearchButton().setCursor(oldCursor);
                        this.mAnfragenPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (event.getComponent() == this.mAnfragenPanel.getSuchkriterienPanel().getResetButton()) {
                    this.mAnfragenPanel.getSuchkriterienPanel().resetFields();
                    this.mAnfragenPanel.getAnfragenTablePanel().setVisible(false);
                } else if (event.getComponent().getName().equals("schliessen")) {
                    ArrayList<AnfragenContainer> dummy = this.mAnfragenPanel.getAnfragenleiste().getAnfragenContainerList();
                    for (int ii = 0; ii < dummy.size(); ++ii) {
                        if (dummy.get(ii).getSchliessenIcon() != event.getComponent()) continue;
                        this.mAnfragenPanel.getAnfragenleiste().removeAnfrageContainer(ii);
                    }
                } else if (event.getComponent().getName().equals("OPENALL")) {
                    this.mAnfragenPanel.getAnfragenTablePanel().handleOpenAll();
                } else if (event.getComponent().getName().equals("CLOSEALL")) {
                    this.mAnfragenPanel.getAnfragenTablePanel().handleCloseAll();
                }
            }
            finally {
                this.mAnfragenPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(0));
                this.mAnfragenPanel.getAnfragenTablePanel().getAnfragenTable().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void checkInaktivAnfrageToDelete(int anfrageId) {
        ArrayList<AnfragenContainer> dummy = this.mAnfragenPanel.getAnfragenleiste().getAnfragenContainerList();
        for (int ii = 0; ii < dummy.size(); ++ii) {
            if (dummy.get(ii).getAnfragenId() != anfrageId) continue;
            this.mAnfragenPanel.getAnfragenleiste().removeAnfrageContainer(ii);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        AnfragenContainer container = this.mAnfragenPanel.getAnfragenleiste().getAnfragenContainerList().get(this.mAnfragenPanel.getAnfragenleiste().getAnfragenContainerList().size() - 1);
        container.getSchliessenIcon().addMouseListener(mInstance);
        container.getAnfragenNameLabel().addMouseListener(mInstance);
        container.getDocumentIcon().addMouseListener(mInstance);
    }

    @Override
    public void editingCanceled(ChangeEvent arg0) {
    }

    @Override
    public void editingStopped(ChangeEvent arg0) {
    }

    public boolean isAnfrageGeladen() {
        return this.mAnfrageGeladen;
    }

    public void sucheAnfragen() {
        try {
            ArrayList anfragen = (ArrayList)AnfragenDataLoader.sucheAnfrage(this.mAnfragenPanel.getSuchkriterienPanel().getSucheBean());
            this.mAnfragenPanel.getAnfragenTablePanel().setTablePanel(anfragen);
            this.mAnfragenPanel.getAnfragenTablePanel().setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    static {
        LOESCHEN_MELDUNG_ANFRAGE = Resource.getInstance().getLoeschenMeldungAnfrage();
        ANFRAGE_GESPERRT = Resource.getInstance().getAnfrageGesperrt();
        ANFRGE_GESPERRT_MSG = Resource.getInstance().getAnfrgeGesperrtMsg();
    }
}

