/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.anfrage.AnfrageSucheBean;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JDateField;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JTextField;
import de.esg.zub.utilities.viewcomp.JTextFieldDateEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class SuchkriterienPanel
extends JPanel {
    private static final String VIN = "VIN:";
    private MarkenLayout mMarkenLayout;
    private JLabel mProductNameLabel;
    private JTextField mProductNameField;
    private JLabel mDateLabel;
    private JLabel mDateLabel2;
    private JLabel mKundenNummerLabel;
    private JFormattedTextField mKundenNummerField;
    private JLabel mErstellerLabel;
    private JTextField mErstellerField;
    private JLabel mKundenNameLabel;
    private JTextField mKundenNameField;
    public static final int MAX_LENGTH_KUNDENNAME = 40;
    private static final int LENGTH_VIN = 7;
    private static final String PATTERN_VIN = "[A-Za-z0-9]{0,7}";
    private static final int LENGTH_KUNDENNR = 7;
    public static final String PATTERN_KUNDENNR = "[0-9*]{0,7}";
    private JLabel mVinLabel;
    private JFormattedTextField mVinField;
    private JCheckBox mSucheNurEigeneCheck;
    private JCheckBox mSucheFilialeCheck;
    private JDateField mVonDateChooser;
    private JDateField mBisDateChooser;
    private JLabelButton mSearchButton;
    private JLabelButton mResetButton;

    public SuchkriterienPanel(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setLayout(new GridBagLayout());
        this.setSuchkriterienPanel();
        this.setMaximumSize(new Dimension(600, 200));
        this.setMinimumSize(new Dimension(600, 200));
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
        this.validate();
        this.updateUI();
    }

    private void setSuchkriterienPanel() {
        JLabel suchKriterien = this.mMarkenLayout.getBoldHeaderLabel(Resource.getInstance().getEingabeSuchkriterien());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 2, 11, new Insets(5, 5, 0, 5));
        suchKriterien.setForeground(Color.GRAY);
        this.add((Component)suchKriterien, gbc);
        GridBagConstraints gbc2 = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 1, 17, new Insets(0, 0, 0, 0));
        this.add((Component)this.setPanel(), gbc2);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 1, 17, new Insets(0, 0, 0, 0));
        this.add((Component)this.setButtonInfo(), gbc);
        this.updateUI();
    }

    private JPanel setButtonInfo() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel buttonInfo = new JPanel(new GridBagLayout());
        buttonInfo.setBackground(Color.WHITE);
        this.mSearchButton = new JLabelButton(Resource.getInstance().getSuchen(), "Search", true, this.mMarkenLayout);
        this.mSearchButton.setLayout(this.mMarkenLayout);
        this.mResetButton = new JLabelButton(Resource.getInstance().getZuruecksetzen(), "Reset", true, this.mMarkenLayout);
        this.mResetButton.setLayout(this.mMarkenLayout);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(10, 0, 10, 20));
        buttonInfo.add((Component)this.mSearchButton, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(10, 0, 10, 0));
        buttonInfo.add((Component)this.mResetButton, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(10, 0, 10, 20));
        buttonInfo.add((Component)this.mSearchButton, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(10, 0, 10, 0));
        buttonInfo.add((Component)this.mResetButton, gbc);
        return buttonInfo;
    }

    private JPanel setPanel() {
        JPanel suchPanel = new JPanel();
        suchPanel.setLayout(new GridBagLayout());
        suchPanel.setBackground(Color.WHITE);
        this.mKundenNameLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getNameKunde() + ":");
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(3, 0, 0, 40));
        suchPanel.add((Component)this.mKundenNameLabel, gbc);
        this.mKundenNameField = this.mMarkenLayout.getTextField();
        this.mKundenNameField.setMaxCharacters(40);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mKundenNameField, gbc);
        this.mKundenNummerLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getNummerKunde() + ":");
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(3, 0, 0, 0));
        suchPanel.add((Component)this.mKundenNummerLabel, gbc);
        this.mKundenNummerField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter(PATTERN_KUNDENNR));
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mKundenNummerField, gbc);
        this.mProductNameLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getProduktbenennung() + ":");
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 10));
        suchPanel.add((Component)this.mProductNameLabel, gbc);
        this.mProductNameField = this.mMarkenLayout.getTextField();
        this.mProductNameField.setMaxCharacters(40);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mProductNameField, gbc);
        this.mDateLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getErstellungsdatumvon());
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 25));
        suchPanel.add((Component)this.mDateLabel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 0, 25));
        this.mVonDateChooser = new JDateField();
        ((JTextFieldDateEditor)this.mVonDateChooser.getDateEditor()).setMaxCharacters(10);
        this.mVonDateChooser.getDateEditor().setDateFormatString("dd.MM.yyyy");
        this.mVonDateChooser.setFont(Constants.Layout.getZubDefaultFont());
        this.setJDateChooserAnfrage(this.mVonDateChooser);
        suchPanel.add((Component)this.mVonDateChooser, gbc);
        this.mDateLabel2 = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getBis());
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mDateLabel2, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 0, 25));
        this.mBisDateChooser = new JDateField();
        ((JTextFieldDateEditor)this.mBisDateChooser.getDateEditor()).setMaxCharacters(10);
        this.mBisDateChooser.getDateEditor().setDateFormatString("dd.MM.yyyy");
        this.mBisDateChooser.setFont(Constants.Layout.getZubDefaultFont());
        this.setJDateChooserAnfrage(this.mBisDateChooser);
        suchPanel.add((Component)this.mBisDateChooser, gbc);
        this.mVinLabel = this.mMarkenLayout.getBoldLabel(VIN);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mVinLabel, gbc);
        this.mVinField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter(PATTERN_VIN));
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 0, 0, 25));
        suchPanel.add((Component)this.mVinField, gbc);
        this.mVinField.setEditable(!GlobalObjects.getInstance().getIpacData().isStartedFromISPA());
        this.mVinField.setEnabled(!GlobalObjects.getInstance().getIpacData().isStartedFromISPA());
        this.mErstellerLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getBearbeiter() + ":");
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mErstellerLabel, gbc);
        this.mErstellerField = this.mMarkenLayout.getTextField();
        this.mErstellerField.setMaxCharacters(20);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 0, 0, 25));
        suchPanel.add((Component)this.mErstellerField, gbc);
        JLabel sucheFilText = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getSuchenUeber());
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 0, 0, 0));
        suchPanel.add((Component)sucheFilText, gbc);
        this.mSucheFilialeCheck = new JCheckBox(Resource.getInstance().getAlleFilialen());
        this.mSucheFilialeCheck.setBackground(Color.WHITE);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mSucheFilialeCheck, gbc);
        JLabel sucheNurEigeneText = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getSuche());
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)sucheNurEigeneText, gbc);
        this.mSucheNurEigeneCheck = new JCheckBox(Resource.getInstance().getNurEigene());
        this.mSucheNurEigeneCheck.setBackground(Color.WHITE);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mSucheNurEigeneCheck, gbc);
        return suchPanel;
    }

    private JDateField setJDateChooserAnfrage(JDateField datechooser) {
        datechooser.setIcon(new ImageIcon(ImageCache.getInstance().getImage("Icons/kalender_icon.gif")));
        datechooser.setBackground(this.mMarkenLayout.getPrimaryBackground());
        datechooser.getCalendarButton().setBackground(this.mMarkenLayout.getPrimaryBackground());
        return datechooser;
    }

    public void resetFields() {
        this.mProductNameField.setText("");
        ((JTextFieldDateEditor)this.mBisDateChooser.getDateEditor().getUiComponent()).setText("");
        ((JTextFieldDateEditor)this.mVonDateChooser.getDateEditor().getUiComponent()).setText("");
        this.mKundenNummerField.setText("");
        this.mErstellerField.setText("");
        this.mKundenNameField.setText("");
        if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.mVinField.setText("");
        }
        this.mSucheFilialeCheck.setSelected(false);
        this.mSucheNurEigeneCheck.setSelected(false);
    }

    public AnfrageSucheBean getSucheBean() {
        AnfrageSucheBean bean = new AnfrageSucheBean();
        if (this.mKundenNameField.getText().length() > 40) {
            bean.setKundenName(this.mKundenNameField.getText().substring(0, 40));
        } else {
            bean.setKundenName(this.mKundenNameField.getText());
        }
        bean.setKundenNummer(this.mKundenNummerField.getText());
        bean.setErsteller(this.mErstellerField.getText());
        bean.setProduktName(this.mProductNameField.getText());
        bean.setVin(this.mVinField.getText().toUpperCase());
        bean.setAlleFilialenSuchen(this.mSucheFilialeCheck.isSelected());
        bean.setNurEigeneAnfragenSuchen(this.mSucheNurEigeneCheck.isSelected());
        if (this.mBisDateChooser.getDate() != null) {
            bean.setErstellungsDatumBis(((JTextFieldDateEditor)this.mBisDateChooser.getDateEditor().getUiComponent()).getText());
        }
        if (this.mVonDateChooser.getDate() != null) {
            bean.setErstellungsDatumVon(((JTextFieldDateEditor)this.mVonDateChooser.getDateEditor().getUiComponent()).getText());
        }
        return bean;
    }

    public JLabelButton getSearchButton() {
        return this.mSearchButton;
    }

    public JLabelButton getResetButton() {
        return this.mResetButton;
    }

    public JTextField getProductNameField() {
        return this.mProductNameField;
    }

    public JFormattedTextField getClientNumberField() {
        return this.mKundenNummerField;
    }

    public JTextField getOriginatorField() {
        return this.mErstellerField;
    }

    public JTextField getClientNameField() {
        return this.mKundenNameField;
    }

    public JFormattedTextField getVinField() {
        return this.mVinField;
    }

    public void setVinField(String vin) {
        this.mVinField.setText(vin);
    }

    public JCheckBox getSucheNurEigeneCheck() {
        return this.mSucheNurEigeneCheck;
    }

    public JCheckBox getSucheFilialeCheck() {
        return this.mSucheFilialeCheck;
    }
}

