/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.angebot;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.anfrage.AnfragenTableHeaderRenderer;
import de.esg.zub.configurator.content.anfrage.AnfragenTableModel;
import de.esg.zub.configurator.content.angebot.AngebotsTableCellRenderer;
import de.esg.zub.configurator.content.angebot.AngebotsTableModel;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.AngebotsSuche;
import webetk.resources.Resource;

public class AngebotsTablePanel
extends JPanel {
    private static Logger log = Logger.getLogger(AngebotsTablePanel.class);
    private JTable mAngebotsTable;
    private JScrollPane mAnfrageTableScrollPane;
    private JLabel mHeaderLabel;
    private MarkenLayout mMarkenLayout;
    private GridBagConstraints gbc;
    private JLabelButton mLoeschenButton;
    private JLabelButton mDruckenButton;
    private JLabelButton mVorlageButton;
    private JLabel mPlatzhalter;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public AngebotsTablePanel(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setLayout(new GridBagLayout());
        this.setBackground(this.mMarkenLayout.getSecondaryBackground());
        this.createComponents();
        this.setTablePanel(this.getDummyArray());
    }

    private void createComponents() {
        this.mHeaderLabel = this.mMarkenLayout.getBoldHeaderLabel(Resource.getInstance().getAngebote() + ":");
        this.mAngebotsTable = new JTable();
        this.mAngebotsTable.setName("ANGEBOTSTABELLE");
        this.mAnfrageTableScrollPane = new JScrollPane(this.mAngebotsTable);
        this.mPlatzhalter = new JLabel();
        this.setButtons();
    }

    public void setTablePanel(ArrayList<AngebotsSuche> angebote) {
        this.mHeaderLabel.setForeground(Color.GRAY);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 20, 0, 20));
        this.add((Component)this.mHeaderLabel, this.gbc);
        AngebotsTableCellRenderer atcr = new AngebotsTableCellRenderer(this.mMarkenLayout);
        this.mAngebotsTable.setDefaultRenderer(JLabel.class, atcr);
        this.mAngebotsTable.setDefaultRenderer(ImageIcon.class, atcr);
        this.mAngebotsTable.setDefaultRenderer(String.class, atcr);
        this.mAngebotsTable.setModel(new AngebotsTableModel(angebote));
        this.mAngebotsTable.setSelectionBackground(Color.WHITE);
        this.setTableHeader();
        this.mAngebotsTable.getTableHeader().setBackground(Color.GRAY);
        this.mAngebotsTable.getTableHeader().setForeground(Color.WHITE);
        this.mAngebotsTable.setShowVerticalLines(false);
        this.mAngebotsTable.setShowHorizontalLines(false);
        this.calculateTableSize();
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 1, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.mAnfrageTableScrollPane, this.gbc);
        this.updateUI();
    }

    private void setButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(this.mMarkenLayout.getSecondaryBackground());
        buttonPanel.setLayout(new GridBagLayout());
        this.mLoeschenButton = new JLabelButton(Resource.getInstance().getStornieren(), "", true, this.mMarkenLayout);
        this.mLoeschenButton.setLayout(this.mMarkenLayout);
        this.mVorlageButton = new JLabelButton(Resource.getInstance().getAlsVorlage(), "", true, this.mMarkenLayout);
        this.mVorlageButton.setLayout(this.mMarkenLayout);
        this.mDruckenButton = new JLabelButton(Resource.getInstance().getDrucken(), "", true, this.mMarkenLayout);
        this.mDruckenButton.setLayout(this.mMarkenLayout);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 13, new Insets(10, 0, 0, 25));
        buttonPanel.add((Component)this.mVorlageButton, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(10, 0, 0, 25));
        buttonPanel.add((Component)this.mDruckenButton, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 0, 0, 0));
        buttonPanel.add((Component)this.mLoeschenButton, this.gbc);
        if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.mLoeschenButton.setCursor(Cursor.getPredefinedCursor(0));
            this.mDruckenButton.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 2, 15, new Insets(10, 0, 0, 10));
        this.add((Component)buttonPanel, this.gbc);
    }

    private void setTableHeader() {
        this.mAngebotsTable.getTableHeader().setFont(Constants.Layout.getZubDefaultFont());
        this.mAngebotsTable.getTableHeader().setDefaultRenderer(new AnfragenTableHeaderRenderer(this.mMarkenLayout));
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(15);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(1).setMaxWidth(15);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(35);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(180);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(3).setPreferredWidth(180);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(4).setMinWidth(100);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(4).setMaxWidth(100);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(5).setMinWidth(100);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(5).setMaxWidth(100);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(6).setPreferredWidth(180);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(180);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(7).setMinWidth(35);
        this.mAngebotsTable.getTableHeader().getColumnModel().getColumn(7).setMaxWidth(35);
        this.mAngebotsTable.getTableHeader().setReorderingAllowed(false);
    }

    public JTable getAngebotsTable() {
        return this.mAngebotsTable;
    }

    public void handleRemoveRow(MouseEvent event) {
        int rowIndex = this.mAngebotsTable.rowAtPoint(new Point(event.getX(), event.getY()));
        ((AnfragenTableModel)this.mAngebotsTable.getModel()).removeRow(rowIndex);
        this.mAnfrageTableScrollPane.setMinimumSize(new Dimension(800, this.mAngebotsTable.getRowCount() * this.mAngebotsTable.getRowHeight() + 24));
        this.mAnfrageTableScrollPane.setMaximumSize(new Dimension(800, this.mAngebotsTable.getRowCount() * this.mAngebotsTable.getRowHeight() + 24));
        this.updateUI();
    }

    public void calculateTableSize() {
        int anzahlZeilen = 0;
        anzahlZeilen = this.mAngebotsTable.getRowCount() < 12 ? this.mAngebotsTable.getRowCount() : 11;
        this.mAnfrageTableScrollPane.setMinimumSize(new Dimension(800, anzahlZeilen * this.mAngebotsTable.getRowHeight() + 24));
        this.mAnfrageTableScrollPane.setMaximumSize(new Dimension(800, anzahlZeilen * this.mAngebotsTable.getRowHeight() + 24));
        int abstandY = 0;
        abstandY = this.mAngebotsTable.getRowCount() <= 11 ? (11 - this.mAngebotsTable.getRowCount()) * this.mAngebotsTable.getRowHeight() : 0;
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 3, 1, 1.0, 100.0, 1, 10, new Insets(abstandY, 0, 0, 0));
        this.add((Component)this.mPlatzhalter, this.gbc);
        this.updateUI();
    }

    public JLabelButton getLoeschenButton() {
        return this.mLoeschenButton;
    }

    public JLabelButton getDruckenButton() {
        return this.mDruckenButton;
    }

    public JLabelButton getVorlageButton() {
        return this.mVorlageButton;
    }

    public ArrayList<AngebotsSuche> getDummyArray() {
        ArrayList<AngebotsSuche> dummy = new ArrayList<AngebotsSuche>();
        for (int i = 0; i < 5; ++i) {
            AngebotsSuche angebot = new AngebotsSuche();
            angebot.setAngebotsName("TESTANGEBOT " + i);
            angebot.setAngebotsNummer(123456 + i);
            try {
                angebot.setErstellungsDatum(sdf.parse("20022007"));
                angebot.setBindeFrist(sdf.parse("20022007"));
            }
            catch (ParseException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            dummy.add(angebot);
        }
        return dummy;
    }

    public int getAngebotIdFromRow(MouseEvent event) {
        int rowIndex = this.mAngebotsTable.rowAtPoint(new Point(event.getX(), event.getY()));
        if (!((AngebotsTableModel)this.mAngebotsTable.getModel()).getAngebote().get(rowIndex).isStorniert()) {
            return ((AngebotsTableModel)this.mAngebotsTable.getModel()).getAngebotsIdFromRow(rowIndex);
        }
        return -1;
    }

    public void removeSelectedRows() {
        ((AngebotsTableModel)this.mAngebotsTable.getModel()).removeSelectedRows();
    }
}

