/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.angebot;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.angebot.AngebotsSucheBean;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JDateField;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JTextField;
import de.esg.zub.utilities.viewcomp.JTextFieldDateEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class SuchkriterienPanel2
extends JPanel {
    private static final String VIN = "VIN:";
    private MarkenLayout mMarkenLayout;
    private JLabel mProductNameLabel;
    private JTextField mProductNameField;
    private JLabel mDateLabel;
    private JLabel mDateLabel2;
    private JLabel mKundenNummerLabel;
    private JFormattedTextField mKundenNummerField;
    private JLabel mErstellerLabel;
    private JTextField mErstellerField;
    private JLabel mKundenNameLabel;
    private JTextField mKundenNameField;
    private JLabel mAngebotsNummer;
    private JTextField mAngebotsNrField;
    private JLabel mBindefristText;
    private JFormattedTextField mBindefristDauerField;
    private JLabel mVinLabel;
    private JFormattedTextField mVinField;
    private JCheckBox mSucheNurEigeneCheck;
    private JCheckBox mSucheFilialeCheck;
    private JDateField mVonDateChooser;
    private JDateField mBisDateChooser;
    private JLabelButton mSearchButton;
    private JLabelButton mResetButton;
    private static final int BINDEFRIST_LENGTH = 2;
    private static final String PATTERN_BINDEFRIST = "[0-9]{0,2}";
    private static final int LENGTH_VIN = 7;
    private static final String PATTERN_VIN = "[A-Za-z0-9]{0,7}";
    private GridBagConstraints gbc = new GridBagConstraints();
    private GridBagConstraints gbc2 = new GridBagConstraints();

    public SuchkriterienPanel2(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setLayout(new GridBagLayout());
        this.setSuchkriterienPanel();
        this.setMaximumSize(new Dimension(600, 245));
        this.setMinimumSize(new Dimension(600, 245));
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
        this.validate();
        this.updateUI();
    }

    private void setSuchkriterienPanel() {
        JLabel suchKriterien = this.mMarkenLayout.getBoldHeaderLabel(Resource.getInstance().getEingabeSuchkriterien());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 2, 11, new Insets(7, 5, 0, 5));
        suchKriterien.setForeground(Color.GRAY);
        this.add((Component)suchKriterien, this.gbc);
        this.gbc2 = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 1, 17, new Insets(0, 0, 0, 0));
        this.add((Component)this.setPanel(), this.gbc2);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 1, 17, new Insets(0, 0, 0, 0));
        this.add((Component)this.setButtonInfo(), this.gbc);
        this.updateUI();
    }

    private JPanel setButtonInfo() {
        JPanel buttonInfo = new JPanel(new GridBagLayout());
        buttonInfo.setBackground(Color.WHITE);
        this.mSearchButton = new JLabelButton(Resource.getInstance().getSuchen(), "Search", true, this.mMarkenLayout);
        this.mSearchButton.setLayout(this.mMarkenLayout);
        this.mResetButton = new JLabelButton(Resource.getInstance().getZuruecksetzen(), "Reset", true, this.mMarkenLayout);
        this.mResetButton.setLayout(this.mMarkenLayout);
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(10, 0, 10, 20));
        buttonInfo.add((Component)this.mSearchButton, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 10, new Insets(10, 0, 10, 0));
        buttonInfo.add((Component)this.mResetButton, gbc);
        return buttonInfo;
    }

    private JPanel setPanel() {
        JPanel suchPanel = new JPanel();
        suchPanel.setLayout(new GridBagLayout());
        suchPanel.setBackground(Color.WHITE);
        this.mAngebotsNummer = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getAngebotsnummer() + ":");
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 0, 0, 40));
        suchPanel.add((Component)this.mAngebotsNummer, this.gbc);
        this.mAngebotsNrField = this.mMarkenLayout.getTextField();
        this.mAngebotsNrField.setMaxCharacters(7);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mAngebotsNrField, this.gbc);
        this.mBindefristText = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getAblaufBindefrist());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(2, 0, 0, 0));
        suchPanel.add((Component)this.mBindefristText, this.gbc);
        this.mBindefristDauerField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter(PATTERN_BINDEFRIST));
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mBindefristDauerField, this.gbc);
        JLabel inTagen = this.mMarkenLayout.getLabel(Resource.getInstance().getInTagen());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)inTagen, this.gbc);
        this.mKundenNameLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getNameKunde() + ":");
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 16, new Insets(3, 0, 0, 40));
        suchPanel.add((Component)this.mKundenNameLabel, this.gbc);
        this.mKundenNameField = this.mMarkenLayout.getTextField();
        this.mKundenNameField.setMaxCharacters(40);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mKundenNameField, this.gbc);
        this.mKundenNummerLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getNummerKunde() + ":");
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, 16, new Insets(3, 0, 0, 0));
        suchPanel.add((Component)this.mKundenNummerLabel, this.gbc);
        this.mKundenNummerField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter("[0-9*]{0,7}"));
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mKundenNummerField, this.gbc);
        this.mProductNameLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getProduktbenennung());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 10));
        suchPanel.add((Component)this.mProductNameLabel, this.gbc);
        this.mProductNameField = this.mMarkenLayout.getTextField();
        this.mProductNameField.setMaxCharacters(40);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 2, 18, new Insets(2, 0, 8, 25));
        suchPanel.add((Component)this.mProductNameField, this.gbc);
        this.mDateLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getErstellungsdatumvon());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 25));
        suchPanel.add((Component)this.mDateLabel, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 0, 25));
        this.mVonDateChooser = new JDateField();
        ((JTextFieldDateEditor)this.mVonDateChooser.getDateEditor()).setMaxCharacters(10);
        this.mVonDateChooser.setFont(Constants.Layout.getZubDefaultFont());
        this.setJDateChooserAnfrage(this.mVonDateChooser);
        suchPanel.add((Component)this.mVonDateChooser, this.gbc);
        this.mDateLabel2 = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getBis());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mDateLabel2, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 2, 18, new Insets(2, 0, 0, 25));
        this.mBisDateChooser = new JDateField();
        ((JTextFieldDateEditor)this.mBisDateChooser.getDateEditor()).setMaxCharacters(10);
        this.mBisDateChooser.setFont(Constants.Layout.getZubDefaultFont());
        this.setJDateChooserAnfrage(this.mBisDateChooser);
        suchPanel.add((Component)this.mBisDateChooser, this.gbc);
        this.mVinLabel = this.mMarkenLayout.getBoldLabel(VIN);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mVinLabel, this.gbc);
        this.mVinField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter(PATTERN_VIN));
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 0, 0, 25));
        suchPanel.add((Component)this.mVinField, this.gbc);
        this.mVinField.setEditable(!GlobalObjects.getInstance().getIpacData().isStartedFromISPA());
        this.mVinField.setEnabled(!GlobalObjects.getInstance().getIpacData().isStartedFromISPA());
        this.mErstellerLabel = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getBearbeiter() + ":");
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mErstellerLabel, this.gbc);
        this.mErstellerField = this.mMarkenLayout.getTextField();
        this.mErstellerField.setMaxCharacters(20);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 2, 18, new Insets(0, 0, 0, 25));
        suchPanel.add((Component)this.mErstellerField, this.gbc);
        JLabel sucheFilText = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getSuchenUeber());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 0, 16, new Insets(5, 0, 0, 0));
        suchPanel.add((Component)sucheFilText, this.gbc);
        this.mSucheFilialeCheck = new JCheckBox(Resource.getInstance().getAlleFilialen());
        this.mSucheFilialeCheck.setBackground(Color.WHITE);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mSucheFilialeCheck, this.gbc);
        JLabel sucheNurEigeneText = this.mMarkenLayout.getBoldLabel(Resource.getInstance().getSuche());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)sucheNurEigeneText, this.gbc);
        this.mSucheNurEigeneCheck = new JCheckBox(Resource.getInstance().getSucheEigenerAngebote());
        this.mSucheNurEigeneCheck.setBackground(Color.WHITE);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        suchPanel.add((Component)this.mSucheNurEigeneCheck, this.gbc);
        return suchPanel;
    }

    private JDateField setJDateChooserAnfrage(JDateField datechooser) {
        datechooser.setIcon(new ImageIcon(ImageCache.getInstance().getImage("Icons/kalender_icon.gif")));
        datechooser.setBackground(this.mMarkenLayout.getPrimaryBackground());
        datechooser.getCalendarButton().setBackground(this.mMarkenLayout.getPrimaryBackground());
        return datechooser;
    }

    public void resetFields() {
        this.mProductNameField.setText("");
        ((JTextFieldDateEditor)this.mBisDateChooser.getDateEditor().getUiComponent()).setText("");
        ((JTextFieldDateEditor)this.mVonDateChooser.getDateEditor().getUiComponent()).setText("");
        this.mKundenNummerField.setText("");
        this.mErstellerField.setText("");
        this.mKundenNameField.setText("");
        if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.mVinField.setText("");
        }
        this.mSucheFilialeCheck.setSelected(false);
        this.mSucheNurEigeneCheck.setSelected(false);
        this.mAngebotsNrField.setText("");
        this.mBindefristDauerField.setText("");
    }

    public AngebotsSucheBean getSucheBean() {
        AngebotsSucheBean bean = new AngebotsSucheBean();
        bean.setAngebotsNummer(this.mAngebotsNrField.getText());
        if (this.mKundenNameField.getText().length() > 40) {
            bean.setKundenName(this.mKundenNameField.getText().substring(0, 40));
        } else {
            bean.setKundenName(this.mKundenNameField.getText());
        }
        bean.setKundenNummer(this.mKundenNummerField.getText());
        bean.setErsteller(this.mErstellerField.getText());
        bean.setProduktName(this.mProductNameField.getText());
        bean.setAlleFilialenSuchen(this.mSucheFilialeCheck.isSelected());
        bean.setNurEigeneAnfragenSuchen(this.mSucheNurEigeneCheck.isSelected());
        if (this.mBisDateChooser.getDate() != null) {
            bean.setErstellungsDatumBis(((JTextFieldDateEditor)this.mBisDateChooser.getDateEditor().getUiComponent()).getText());
        }
        if (this.mVonDateChooser.getDate() != null) {
            bean.setErstellungsDatumVon(((JTextFieldDateEditor)this.mVonDateChooser.getDateEditor().getUiComponent()).getText());
        }
        if (this.mBindefristDauerField.getText() != null && this.mBindefristDauerField.getText().length() > 0) {
            bean.setBindeFristTage(this.mBindefristDauerField.getText());
        }
        if (this.mVinField.getText() != null && this.mVinField.getText().length() > 0) {
            bean.setVin(this.mVinField.getText().toUpperCase());
        }
        return bean;
    }

    public JLabelButton getSearchButton() {
        return this.mSearchButton;
    }

    public JLabelButton getResetButton() {
        return this.mResetButton;
    }

    public JTextField getProductNameField() {
        return this.mProductNameField;
    }

    public JFormattedTextField getClientNumberField() {
        return this.mKundenNummerField;
    }

    public JTextField getOriginatorField() {
        return this.mErstellerField;
    }

    public JTextField getClientNameField() {
        return this.mKundenNameField;
    }

    public JFormattedTextField getVinField() {
        return this.mVinField;
    }

    public void setVinField(String vin) {
        this.mVinField.setText(vin);
    }

    public JCheckBox getSucheNurEigeneCheck() {
        return this.mSucheNurEigeneCheck;
    }

    public JCheckBox getSucheFilialeCheck() {
        return this.mSucheFilialeCheck;
    }

    public JFormattedTextField getBindefristDauerField() {
        return this.mBindefristDauerField;
    }
}

