/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.common.AbstractPanel;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import webetk.app.Bedingungsmenge;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.resources.Resource;

public class FahrzeugPanel
extends AbstractPanel {
    private static final int MAX_TEXTWIDTH = 300;
    protected JLabel labFahrzeugText1;
    protected JLabel labFahrzeugText2;
    protected JLabel labFahrzeugText3;
    protected FontMetrics fontMetrics = null;

    public FahrzeugPanel(MarkenLayout layout) {
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.labFahrzeugText1 = new JLabel();
        this.labFahrzeugText2 = new JLabel();
        this.labFahrzeugText3 = new JLabel();
        gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.labFahrzeugText1, gbc);
        gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.labFahrzeugText2, gbc);
        gbc = this.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 10, 0));
        this.mPanel.add((Component)this.labFahrzeugText3, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)new JLabel(), gbc);
        this.setLayout(layout);
        this.mPanel.validate();
    }

    public void updateFahrzeugPanel(Vorgang vorgang) {
        String produktBeschreibung = vorgang.getPlainProduktName();
        Fahrzeug fahrzeug = vorgang.getFahrzeug();
        boolean angebot = vorgang.getKonfiguration().getAngebot() != null;
        String text1 = "<b>";
        text1 = angebot ? text1 + Resource.getInstance().getAngebotFuer() : text1 + Resource.getInstance().getAnfrageFuer();
        text1 = text1 + " " + produktBeschreibung;
        StringBuilder text2 = new StringBuilder("");
        String text3 = "";
        if (fahrzeug != null) {
            String ausstattung;
            text2.append(Resource.getInstance().getFuerFahrzeug() + " " + fahrzeug.getBaureiheBezeichnung() + " ");
            if (!fahrzeug.hasSichtschutz()) {
                text2.append(fahrzeug.getModellBezeichnung() + " ");
            }
            text2.append(fahrzeug.getKatalogausf());
            if (fahrzeug.getLenkung() != null && !fahrzeug.getLenkung().equals("kA")) {
                text2.append(" " + fahrzeug.getLenkung());
            }
            if (fahrzeug.getGetriebe() != null && !fahrzeug.getGetriebe().equals("kA")) {
                text2.append(" " + fahrzeug.getGetriebe());
            }
            text3 = (ausstattung = this.getAusstattungsString(fahrzeug)) == null || ausstattung.trim().length() == 0 ? " " : Resource.getInstance().getMitAusstattung() + " " + this.getAusstattungsString(fahrzeug);
        }
        this.updateLabel(this.labFahrzeugText1, text1, 300);
        this.updateLabel(this.labFahrzeugText2, text2.toString(), 300);
        this.updateLabel(this.labFahrzeugText3, text3, 300);
    }

    private JLabel updateLabel(JLabel lab, String text, int maxWidth) {
        if (this.fontMetrics.stringWidth(text) > maxWidth) {
            int ii = 1;
            while (this.fontMetrics.stringWidth(text.substring(0, text.length() - ii)) > maxWidth - 10) {
                ++ii;
            }
            String labText = "<html>" + text.substring(0, text.length() - ii) + "...</html>";
            String toolText = "<html>" + text.replaceAll("[,]", "<p>") + "</html>";
            lab.setToolTipText(toolText);
            lab.setText(labText);
        } else {
            lab.setText("<html>" + text + "</html>");
            lab.setToolTipText(null);
        }
        return lab;
    }

    private String getAusstattungsString(Fahrzeug fahrzeug) {
        Bedingungsmenge oBedingungen = fahrzeug.getBedingungsMenge();
        StringBuilder sb = new StringBuilder();
        try {
            oBedingungen.goFirst();
            while (true) {
                if (oBedingungen.isCurrentBteBedingung()) {
                    String sBenennung = oBedingungen.getCurrentBenennung();
                    String sCode = oBedingungen.getCurrentCode();
                    Long id = oBedingungen.getCurrentId();
                    String bedWert = oBedingungen.getBedWert(id);
                    if (bedWert != null && bedWert.equals("1")) {
                        sb.append(sCode);
                        sb.append(" ");
                        sb.append(sBenennung);
                        sb.append(", ");
                    }
                }
                if (oBedingungen.hasNext()) {
                    oBedingungen.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sb.length() < 2) {
            return null;
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Override
    protected void setLayout(MarkenLayout layout) {
        super.setLayout(layout);
        this.fontMetrics = this.labFahrzeugText1.getFontMetrics(this.labFahrzeugText1.getFont());
        this.mPanel.setBackground(this.background);
        this.labFahrzeugText1.setForeground(this.textColor);
        this.labFahrzeugText2.setForeground(this.textColor);
        this.labFahrzeugText3.setForeground(this.textColor);
    }
}

