/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.common.AbstractPanel;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TextFieldPatternFormatter;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class FirmaPanel
extends AbstractPanel {
    protected JFormattedTextField tfKundenNr;
    protected JLabel labKundeIcon;
    protected JLabel lab;

    public FirmaPanel(MarkenLayout layout) {
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        Pattern pKundennummer = Pattern.compile("[0-9]{0,7}");
        TextFieldPatternFormatter formatter = new TextFieldPatternFormatter(pKundennummer);
        formatter.setAllowsInvalid(false);
        this.tfKundenNr = new JFormattedTextField(formatter);
        this.tfKundenNr.setBackground(Color.WHITE);
        this.tfKundenNr.setPreferredSize(new Dimension(60, 20));
        this.tfKundenNr.addMouseListener(new HilfeMouseListener("i50086"));
        this.labKundeIcon = new JLabel(new ImageIcon());
        this.labKundeIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.labKundeIcon.setName("DIALOG_KUNDE");
        this.lab = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.tfKundenNr, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 16, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.labKundeIcon, gbc);
        JLabel empty = new JLabel();
        gbc = this.setGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)empty, gbc);
        gbc = this.setGridBagConstraints(3, 0, 1, 1, 0.01, 0.0, 2, 13, new Insets(0, 0, 7, 0));
        this.mPanel.add((Component)this.lab, gbc);
        this.setLayout(layout);
        this.mPanel.validate();
    }

    @Override
    protected void setLayout(MarkenLayout layout) {
        super.setLayout(layout);
        this.mPanel.setBackground(this.background);
        this.lab.setForeground(this.textColor);
        this.labKundeIcon.setIcon(new ImageIcon(ImageCache.getInstance().getImage(layout.getIconPath() + "suchen_aktiv.gif")));
    }

    public void updateFirmaPanel(String firmenAnschrift, String kundennr) {
        Color textfieldColor = Color.BLACK;
        if (firmenAnschrift != null) {
            this.lab.setText(firmenAnschrift);
        }
        if (kundennr == null) {
            this.tfKundenNr.setText("");
        } else {
            this.tfKundenNr.setText(kundennr);
            this.tfKundenNr.setForeground(textfieldColor);
        }
        this.mPanel.validate();
        this.mPanel.updateUI();
    }

    public JFormattedTextField getTfKundenNr() {
        return this.tfKundenNr;
    }

    public JLabel getLabKundeIcon() {
        return this.labKundeIcon;
    }

    public void setAngebotsSicht(boolean flag) {
        this.tfKundenNr.setEnabled(!flag);
        this.tfKundenNr.setEditable(!flag);
        if (flag) {
            this.labKundeIcon.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.labKundeIcon.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

