/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ControllerConfigurationPanel;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.marketing.Bestandteil;
import de.esg.zub.configurator.content.marketing.MarketingDataloader;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.content.marketing.MarketingPanel;
import de.esg.zub.configurator.content.marketing.TextPanel;
import de.esg.zub.configurator.content.marketing.ZusatzproduktInfoPanel;
import de.esg.zub.configurator.content.marketing.ZusatzproduktLabel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.utilities.viewcomp.JRadioButton;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;
import webetk.communication.CommunicationException;
import webetk.resources.Resource;

public class ControllerMarketingPanel
extends Observable
implements ActionListener,
MouseListener,
Observer {
    private static ControllerMarketingPanel mInstance;
    static Logger log;
    private ArrayList<ZusatzproduktLabel> mZusatzprodukteLabels = null;
    private ArrayList<ZusatzproduktInfoPanel> mZusatzproduktInfoPanels = null;
    private ArrayList<JButton> mSeitenButtons = null;
    private MarketingModel mModel;
    private MarketingPanel mMarketingView;
    private boolean mAngebotsSicht;

    private ControllerMarketingPanel() {
    }

    public static ControllerMarketingPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerMarketingPanel();
            mInstance.setMarketingView(new MarketingPanel(WorkflowController.getInstance().getMarkenLayout()));
            HilfeMouseListener hilfeListener = new HilfeMouseListener("i500511");
            mInstance.getMarketingView().getIconEinkaufswagen().addMouseListener(mInstance);
            mInstance.getMarketingView().getIconEinkaufswagen().addMouseListener(hilfeListener);
            mInstance.getMarketingView().getIconTaschenrechner().addMouseListener(mInstance);
            mInstance.getMarketingView().getIconTaschenrechner().addMouseListener(hilfeListener);
            ControllerMarketingPanel.mInstance.mMarketingView.getWeiterePanel().addMouseListener(mInstance);
            ControllerMarketingPanel.mInstance.mMarketingView.getOpenIconWeitere().addMouseListener(mInstance);
            mInstance.getMarketingView().getOpenIconWeitere().addMouseListener(hilfeListener);
            ControllerMarketingPanel.mInstance.mMarketingView.getCloseIconWeitere().addMouseListener(mInstance);
            mInstance.getMarketingView().getCloseIconWeitere().addMouseListener(hilfeListener);
            ControllerMarketingPanel.mInstance.mMarketingView.getZusatzPanel().addMouseListener(mInstance);
            ControllerMarketingPanel.mInstance.mMarketingView.getOpenIconZusatz().addMouseListener(mInstance);
            mInstance.getMarketingView().getOpenIconZusatz().addMouseListener(hilfeListener);
            ControllerMarketingPanel.mInstance.mMarketingView.getCloseIconZusatz().addMouseListener(mInstance);
            mInstance.getMarketingView().getCloseIconZusatz().addMouseListener(hilfeListener);
            mInstance.getMarketingView().addObserver(mInstance);
        }
        return mInstance;
    }

    public void init() {
        if (WorkflowController.getInstance().isNewKonfiguration()) {
            this.newKonfiguration();
            this.setAngebotsSicht(false);
        } else {
            this.oldKonfiguration();
        }
        ControllerMiniaturansicht.getInstance().getMiniaturMarketing().setBorder();
    }

    public void newKonfiguration() {
        AbstractState oldState = WorkflowController.getInstance().getPreviousState();
        if (oldState.getName().equals("PRODUCTLIST")) {
            this.createModelDB();
        } else if (oldState.getName().equals("CONFIG")) {
            this.createModelDB();
        } else if (!oldState.getName().equals("FBI")) {
            this.mModel.resetAlleSelektionen();
            this.mModel.setMarketingProduct(this.mModel.getMarketingProdukt(), false);
            this.mModel.setTextBnb(null);
            this.mMarketingView.setMarketingPanel();
        }
        this.mMarketingView.setLayout(WorkflowController.getInstance().getMarkenLayout());
        MainController.getInstance().getMainFrame().getMainPanel().addMarketingPanel();
        ControllerMiniaturansicht.getInstance().init();
        MainController.getInstance().getMainFrame().validate();
        MainController.getInstance().getMainFrame().getStatusBar().removeAllStatusFromIndex(4);
        MainController.getInstance().getMainFrame().getStatusBar().addNewStatus(" > " + Resource.getInstance().getSchritt() + " 1: " + Resource.getInstance().getMarketingsicht(), "MARKETING");
        MainController.getInstance().getMainFrame().getStatusBar().addNewStatus(" > " + Resource.getInstance().getSchritt() + " 2: " + Resource.getInstance().getTechnischeSicht(), "TECHNIK");
        MainController.getInstance().getMainFrame().getStatusBar().addNewStatus(" > " + Resource.getInstance().getSchritt() + " 3: " + Resource.getInstance().getKalkulationssicht(), "KALKULATION");
    }

    public void oldKonfiguration() {
        MainController.getInstance().getMainFrame().getMainPanel().addMarketingPanel();
        if (this.mMarketingView.getLastShown().equals("INFO")) {
            this.mMarketingView.aufZuklappenWeitere();
        } else if (this.mMarketingView.getLastShown().equals("ZUSATZ")) {
            this.mMarketingView.aufZuklappenZusatz();
        }
        MainController.getInstance().getMainFrame().validate();
    }

    public void refreshMarketingPanel(MarketingModel model) {
        this.refreshMarketingPanel(model, false, 0);
    }

    public void refreshMarketingPanel(MarketingModel model, boolean fehlerFall, int error) {
        this.mModel = model;
        this.mMarketingView.setModel(this.mModel);
        this.mMarketingView.setMarketingPanel();
        if (this.mModel.getMarketingProdukt().getEinzelteile() != null && this.mModel.getMarketingProdukt().getEinzelteile().size() > 0) {
            this.changeTextanzeige();
        }
        if (!fehlerFall) {
            this.setViewAktiv(fehlerFall);
        }
        this.mMarketingView.getTextPanel().setFehlerFall(fehlerFall);
        if (this.mModel.getMarketingProdukt().getAlleVarianten() != null && this.mModel.getMarketingProdukt().getAlternativen().size() != 0 && (error == 2 || error == 3) && fehlerFall) {
            this.mMarketingView.getTextPanel().showAlternativenPanel();
        } else if (this.mModel.getBestandteile() != null && this.mModel.getMarketingProdukt().getBestandTeile().size() != 0 && fehlerFall) {
            this.mMarketingView.getTextPanel().showBestandteilePanel();
        }
        if (this.mModel.hasZusatz()) {
            this.mMarketingView.getOptionalPanel().refreshZusatzprodukte();
        }
        if (!fehlerFall) {
            this.setViewAktiv(false);
            this.mMarketingView.setIcon("KONFIGURATION");
        } else {
            this.mMarketingView.setIcon("EINKAUFWAGEN");
        }
        this.mMarketingView.setLayout(WorkflowController.getInstance().getMarkenLayout());
        ControllerMiniaturansicht.getInstance().init();
        ControllerMiniaturansicht.getInstance().showMiniaturansichten();
    }

    private static MarketingProdukt getData(String btenr, String bildPosNr, ProduktListenElement produktListeneElem) {
        log.debug((Object)"Performing Getting Data for MarketinView");
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            return MarketingDataloader.getMarketingProdukt(btenr, bildPosNr, produktListeneElem, produktListeneElem != null ? produktListeneElem.getUnterkategorie().isLifestyle() : false);
        }
        catch (CommunicationException ex) {
            log.error((Object)"ControllerMarketingPanel: ", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        catch (NoDataFoundException e) {
            log.error((Object)"Keine Daten f\u00fcr die Marketingsicht des Produkts gefunden!", (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        catch (Exception e) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), e.getMessage(), ControllerMarketingPanel.getInstance().getModel().getDialogTitel(), 0);
            return null;
        }
    }

    private void createModelDB() {
        ProduktListenElement produktListeneElem;
        String bildposnr;
        this.mModel = new MarketingModel();
        String btenr = GlobalObjects.getInstance().getIpacData().getSelectedBte();
        MarketingProdukt marketingProdukt = ControllerMarketingPanel.getData(btenr, bildposnr = GlobalObjects.getInstance().getIpacData().getSelectedBnb(), produktListeneElem = GlobalObjects.getInstance().getIpacData().getSelectedProdukt());
        if (marketingProdukt != null) {
            this.mModel.setMarketingProduct(marketingProdukt, false);
            this.mMarketingView.setModel(this.mModel);
            this.mMarketingView.setMarketingPanel();
            if (this.mModel.hasZusatz()) {
                this.mMarketingView.getOptionalPanel().addObserver(this);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg != null && arg.equals(this.mMarketingView.getTextPanel().getVariantenZuAlternativen())) {
            for (JComboBox variante : this.mMarketingView.getTextPanel().getVariantenZuAlternativen().values()) {
                variante.removeAll();
                variante.addActionListener(mInstance);
            }
        } else if (arg != null && arg.equals(this.mMarketingView.getTextPanel())) {
            mInstance.getMarketingView().getTextPanel().addObserver(mInstance);
        } else if (arg != null && arg.equals(this.mMarketingView.getTextPanel().getDynamicLabels())) {
            for (int i = 0; i < this.mMarketingView.getTextPanel().getDynamicLabels().size(); ++i) {
                this.mMarketingView.getTextPanel().getDynamicLabels().get(i).addMouseListener(this);
            }
        } else if (arg != null && arg.equals(this.mModel.getBestandteile())) {
            for (Bestandteil part : this.mModel.getBestandteile()) {
                JComboBox combo = part.getVariantenCombo();
                if (combo == null) continue;
                combo.removeActionListener(mInstance);
                combo.addActionListener(mInstance);
            }
        } else if (arg != null && arg.equals(this.mMarketingView.getTextPanel().getAlternativesRadioButtons())) {
            for (int i = 0; i < this.mMarketingView.getTextPanel().getAlternativesRadioButtons().size(); ++i) {
                this.mMarketingView.getTextPanel().getAlternativesRadioButtons().get(i).removeAll();
                this.mMarketingView.getTextPanel().getAlternativesRadioButtons().get(i).addActionListener(mInstance);
            }
            this.updateSelectedAlternative(this.mModel.getSelectedAlternative());
        } else if (arg != null && arg.equals(this.mMarketingView.getTextPanel().getEinzelteilCheckBoxes())) {
            for (int i = 0; i < this.mMarketingView.getTextPanel().getEinzelteilCheckBoxes().size(); ++i) {
                this.mMarketingView.getTextPanel().getEinzelteilCheckBoxes().get(i).removeAll();
                this.mMarketingView.getTextPanel().getEinzelteilCheckBoxes().get(i).addActionListener(mInstance);
            }
            this.updateSelectedEinzelteile();
        }
        if (arg != null && arg.equals(this.mMarketingView.getTextPanel().getVariantenZuEinzelteile())) {
            for (JComboBox variante : this.mMarketingView.getTextPanel().getVariantenZuEinzelteile().values()) {
                variante.removeAll();
                variante.addActionListener(mInstance);
            }
        } else if (arg != null && arg.equals(this.mMarketingView.getOptionalPanel())) {
            this.mZusatzprodukteLabels = this.mMarketingView.getOptionalPanel().getImageButtons();
            if (this.mZusatzprodukteLabels != null) {
                for (int i = 0; i < this.mZusatzprodukteLabels.size(); ++i) {
                    this.mZusatzprodukteLabels.get(i).addMouseListener(mInstance);
                    this.mZusatzprodukteLabels.get(i).getCheck().addActionListener(mInstance);
                }
            }
            this.mZusatzproduktInfoPanels = this.mMarketingView.getOptionalPanel().getInfoPanelsProdukte();
            if (this.mZusatzproduktInfoPanels != null) {
                for (int i = 0; i < this.mZusatzproduktInfoPanels.size(); ++i) {
                    ArrayList<Baureihe> baureiheList = this.mZusatzproduktInfoPanels.get(i).getBaureihenList();
                    baureiheList = NavigationPanelDataLoader.loadBaureihenElemente(((ProduktListenElement)this.mModel.getMarketingProdukt().getZusatzProdukte().get(i)).getBteNr(), ((ProduktListenElement)this.mModel.getMarketingProdukt().getZusatzProdukte().get(i)).getBildPosNr());
                    this.mZusatzproduktInfoPanels.get(i).createBaureihenTooltip(baureiheList);
                }
            }
            this.mSeitenButtons = this.mMarketingView.getOptionalPanel().getNextButtons();
            if (this.mSeitenButtons != null) {
                for (int i = 0; i < this.mSeitenButtons.size(); ++i) {
                    this.mSeitenButtons.get(i).addMouseListener(mInstance);
                }
            }
            this.mSeitenButtons = this.mMarketingView.getOptionalPanel().getNextButtonsPIAS();
            if (this.mSeitenButtons != null) {
                for (int i = 0; i < this.mSeitenButtons.size(); ++i) {
                    this.mSeitenButtons.get(i).addMouseListener(mInstance);
                }
            }
        } else if (arg != null && arg.equals(this.mMarketingView.getBlaetternPanel())) {
            if (this.mModel.getMarketingProdukt().getImages().size() > 1) {
                this.mMarketingView.getBlaetternPanel().getBlaetternVor().addMouseListener(this);
                this.mMarketingView.getBlaetternPanel().getBlaetternZurueck().addMouseListener(this);
                this.mModel.setIndexAnzahlMaxImage(this.mModel.getMarketingProdukt().getImages().size() - 1);
                this.mMarketingView.enableDisableBlaetternLabels();
            } else {
                this.mMarketingView.getBlaetternPanel().enableBlaetternVor(false);
                this.mMarketingView.getBlaetternPanel().enableBlaetternZurueck(false);
            }
        }
    }

    public void setViewAktiv(boolean flag) {
        if (this.mModel != null) {
            if (!flag) {
                this.mMarketingView.getTextPanel().setCombosEditable(flag);
                if (this.mModel.hasZusatz()) {
                    this.mZusatzprodukteLabels = this.mMarketingView.getOptionalPanel().getImageButtons();
                    if (this.mZusatzprodukteLabels != null) {
                        for (int i = 0; i < this.mZusatzprodukteLabels.size(); ++i) {
                            this.mZusatzprodukteLabels.get(i).removeMouseListener(mInstance);
                            this.mZusatzprodukteLabels.get(i).getCheck().removeMouseListener(ControllerMarketingPanel.getInstance());
                            this.mZusatzprodukteLabels.get(i).getCheck().setEnabled(false);
                        }
                    }
                }
            } else {
                if (this.mModel.hasZusatz()) {
                    this.mZusatzprodukteLabels = this.mMarketingView.getOptionalPanel().getImageButtons();
                    if (this.mZusatzprodukteLabels != null) {
                        for (int i = 0; i < this.mZusatzprodukteLabels.size(); ++i) {
                            this.mZusatzprodukteLabels.get(i).addMouseListener(mInstance);
                            this.mZusatzprodukteLabels.get(i).getCheck().addMouseListener(ControllerMarketingPanel.getInstance());
                            this.mZusatzprodukteLabels.get(i).getCheck().setEnabled(true);
                        }
                    }
                }
                this.mMarketingView.getTextPanel().setCombosEditable(flag);
                this.mMarketingView.getMarketingPanel().updateUI();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            JComboBox combo = (JComboBox)e.getSource();
            this.handleAuswahlVariante(combo);
        } else if (e.getSource() instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)e.getSource();
            this.handleAuswahlAlternative(radio);
        }
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            if (checkBox.getName().equals("OPTIONAL")) {
                this.handleAuswahlOptional(checkBox);
            }
            if (checkBox.getName().equals("HP_EINZELTEIL")) {
                this.handleAuswahlEinzelteil(checkBox);
            }
        }
    }

    private void handleAuswahlVariante(JComboBox combo) {
        Variante selVar = null;
        if (combo.getSelectedIndex() > 0) {
            selVar = (Variante)combo.getSelectedItem();
            if (selVar.toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                combo.setToolTipText(selVar.toString());
            } else {
                combo.setToolTipText(null);
            }
        }
        if (combo.getName().equals("HP_ALTERNATIV")) {
            this.mModel.setSelectedVariante(selVar);
            if (selVar == null || selVar.getGrafik() == null || selVar.getGrafik().getImageData() == null) {
                this.mMarketingView.changeBnbPicture(this.mModel.getSelectedAlternative());
            } else {
                this.mMarketingView.changePicture(selVar);
            }
        }
        if (combo.getName().equals("HP_OBLIGAT") || combo.getName().equals("HP_PAKET")) {
            for (Bestandteil part : this.mModel.getBestandteile()) {
                JComboBox varCombo = part.getVariantenCombo();
                if (varCombo != combo) continue;
                part.setSelectedVariante(selVar);
                this.mMarketingView.changePicture(selVar);
            }
        }
        if (combo.getName().equals("HP_EINZELTEIL")) {
            if (selVar == null || selVar.getGrafik() == null || selVar.getGrafik().getImageData() == null) {
                this.mMarketingView.changeBnbPicture(this.mModel.getEinzelteil(combo.getActionCommand()));
            } else {
                this.mMarketingView.changePicture(selVar);
            }
        }
        this.updateSelectedVarianten(combo.getActionCommand(), selVar);
        this.mMarketingView.setPreis();
    }

    private void handleAuswahlAlternative(JRadioButton radio) {
        for (int i = 0; i < this.mMarketingView.getTextPanel().getAlternativesRadioButtons().size(); ++i) {
            if (radio != this.mMarketingView.getTextPanel().getAlternativesRadioButtons().get(i)) continue;
            String bnbPos = this.mMarketingView.getTextPanel().getAlternativesRadioButtons().get(i).getActionCommand();
            this.mModel.setSelectedAlternative(bnbPos);
            this.mMarketingView.getTextPanel().updateVariantenZuSelectedAlt(bnbPos);
            Bnb alter = this.mModel.getSelectedAlternative();
            Variante selVariante = this.mModel.getSelectedVariante();
            alter.setSelectedVariante(selVariante);
            this.updateSelectedAlternative(alter);
            if (selVariante == null || selVariante.getGrafik() == null || selVariante.getGrafik().getImageData() == null) {
                this.mMarketingView.changeBnbPicture(alter);
            } else {
                this.mMarketingView.changePicture(selVariante);
            }
            this.mMarketingView.setPreis();
            return;
        }
    }

    private void handleAuswahlOptional(JCheckBox check) {
        for (int i = 0; i < this.mMarketingView.getOptionalPanel().getImageButtons().size(); ++i) {
            if (!this.mMarketingView.getOptionalPanel().getImageButtons().get(i).getCheck().equals(check)) continue;
            ProduktListenElement zusatzPr = this.mModel.getSelectedZusatzprodukt(i);
            if (this.mMarketingView.getOptionalPanel().getImageButtons().get(i).getCheck().isSelected()) {
                this.mModel.setIndexSelectedZusatzprodukte(i);
                this.updateSelectedZusatzprodukt(zusatzPr, true);
                continue;
            }
            this.mModel.removeIndexSelectedZusatzprodukt(i);
            this.updateSelectedZusatzprodukt(zusatzPr, false);
        }
    }

    public void handleAuswahlEinzelteil(JCheckBox check) {
        String bildPosNr = check.getActionCommand();
        for (Bnb einzelteil : this.mModel.getMarketingProdukt().getEinzelteile()) {
            JComboBox varianten = this.mMarketingView.getTextPanel().getVariantenZuEinzelteile().get(bildPosNr);
            if (check.isSelected()) {
                if (einzelteil.getBildPos() != bildPosNr) continue;
                if (varianten != null) {
                    varianten.setEnabled(true);
                    varianten.updateUI();
                    if (varianten.getItemCount() == 2) {
                        varianten.setSelectedIndex(1);
                        einzelteil.setSelectedVariante((Variante)varianten.getSelectedItem());
                    } else if (varianten.getItemCount() > 2 && varianten.getSelectedItem() instanceof String) {
                        einzelteil.setSelectedVariante(null);
                    } else {
                        einzelteil.setSelectedVariante((Variante)varianten.getSelectedItem());
                    }
                } else {
                    einzelteil.setSelectedVariante(null);
                }
                this.mModel.addSelectedEinzelteil(einzelteil);
                break;
            }
            if (einzelteil.getBildPos() != bildPosNr) continue;
            this.mModel.removeSelectedEinzelteil(einzelteil);
            if (varianten == null) break;
            varianten.setEnabled(false);
            varianten.updateUI();
            break;
        }
        if (this.mMarketingView.getMarkenLayout().isBMWMotorrad()) {
            this.changeTextanzeige();
        }
        this.updateSelectedEinzelteile();
        this.mMarketingView.setPreis();
    }

    private void updateSelectedAlternative(Bnb alternative) {
        if (alternative != null) {
            ArrayList varianten;
            ArrayList<Bnb> selectedBnbs = this.mModel.getMarketingProdukt().getSelectedBnbsMitVarianten();
            for (int i = 0; i < selectedBnbs.size(); ++i) {
                if (!selectedBnbs.get(i).getElementArt().equals("HP_ALTERNATIV")) continue;
                selectedBnbs.remove(i);
                break;
            }
            if ((varianten = (ArrayList)this.mModel.getMarketingProdukt().getVariantenZuAlternativen().get(alternative.getBildPos())) != null && varianten.size() == 1) {
                JComboBox varCombo = this.mMarketingView.getTextPanel().getVariantenZuAlternativen().get(alternative.getBildPos());
                varCombo.setSelectedItem(varianten.get(0));
                alternative.setSelectedVariante((Variante)varianten.get(0));
                this.mModel.setSelectedVariante((Variante)varianten.get(0));
            }
            selectedBnbs.add(alternative);
        }
    }

    private void updateSelectedEinzelteile() {
        if (this.mModel.getSelectedEinzelteile() != null) {
            ArrayList<Bnb> selectedBnbs = this.mModel.getMarketingProdukt().getSelectedBnbsMitVarianten();
            Iterator<Bnb> iter = selectedBnbs.iterator();
            while (iter.hasNext()) {
                Bnb bnb = iter.next();
                if (bnb == null || !bnb.getElementArt().equals("HP_EINZELTEIL")) continue;
                iter.remove();
            }
            selectedBnbs.addAll(this.mModel.getSelectedEinzelteile());
        }
    }

    private void updateSelectedZusatzprodukt(ProduktListenElement zusatzPr, boolean isSelected) {
        ArrayList<Bnb> selectedBnbs = this.mModel.getMarketingProdukt().getSelectedBnbsMitVarianten();
        if (!isSelected) {
            for (int i = 0; i < selectedBnbs.size(); ++i) {
                if (!selectedBnbs.get(i).getBildPos().equals(zusatzPr.getBildPosNr())) continue;
                selectedBnbs.remove(i);
                break;
            }
        } else {
            Bnb bnb = new Bnb();
            bnb.setBildPos(zusatzPr.getBildPosNr());
            bnb.setBteNr(zusatzPr.getBteNr());
            bnb.setBnbName(zusatzPr.getProduktName());
            bnb.setElementArt("OPTIONAL");
            if (zusatzPr.getVariante() != null) {
                bnb.setSelectedVariante(zusatzPr.getVariante());
            }
            selectedBnbs.add(bnb);
        }
    }

    public void updateSelectedVarianten(String bildPosNr, Variante variante) {
        ArrayList<Bnb> selectedBnbs = this.mModel.getMarketingProdukt().getSelectedBnbsMitVarianten();
        for (int i = 0; i < selectedBnbs.size(); ++i) {
            if (!selectedBnbs.get(i).getBildPos().equals(bildPosNr)) continue;
            selectedBnbs.get(i).setSelectedVariante(variante);
            break;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.getButton() == 3) {
            return;
        }
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mMarketingView.getIconEinkaufswagen().setCursor(Cursor.getPredefinedCursor(3));
            this.mMarketingView.getIconTaschenrechner().setCursor(Cursor.getPredefinedCursor(3));
            if (event.getComponent().getName().startsWith("ButtonPIAS", 0)) {
                this.mMarketingView.getOptionalPanel().setPiasProdukte(Integer.parseInt(event.getComponent().getName().substring(10)));
            } else if (event.getComponent().getName().startsWith("Button", 0)) {
                this.mMarketingView.getOptionalPanel().setImagePanel(Integer.parseInt(event.getComponent().getName().substring(6)));
            } else if (event.getComponent().getName().equals("EINKAUFSWAGEN")) {
                if (!this.mAngebotsSicht) {
                    if (!WorkflowController.getInstance().isAddKonfiguration()) {
                        if (ControllerMenuBar.getInstance().checkAnzahlVorgaenge()) {
                            WorkflowController.getInstance().changeState("FBI");
                        }
                    } else {
                        ControllerMiniaturansicht.getInstance().getMiniaturKalkulation().removeBorder();
                        ControllerMiniaturansicht.getInstance().getMiniaturMarketing().removeBorder();
                        ControllerMiniaturansicht.getInstance().getMiniaturTechnik().setBorder();
                        WorkflowController.getInstance().changeState("TECHNIK");
                    }
                }
            } else if (event.getComponent().getName().equals("Alternativen")) {
                this.mMarketingView.getTextPanel().showAlternativenPanel();
            } else if (event.getComponent().getName().equals("Bestandteile")) {
                this.mMarketingView.getTextPanel().showBestandteilePanel();
            } else if (event.getComponent().getName().equals("Einzelteile")) {
                this.mMarketingView.getTextPanel().showEinzelteilePanel();
            } else if (event.getComponent().getName().equals("Text")) {
                this.mMarketingView.getTextPanel().showTextPanel();
            } else if (event.getComponent().getName().equals("KONFIGURATION")) {
                if (!this.mAngebotsSicht && this.checkAnzahlKonfigurationen()) {
                    WorkflowController.getInstance().setNewKonfiguration(true);
                    WorkflowController.getInstance().setAddKonfiguration(true);
                    WorkflowController.getInstance().setAddKonfigurationDataSet(false);
                    this.mMarketingView.setLastShown("");
                    WorkflowController.getInstance().setFzBedIdentified(false);
                    WorkflowController.getInstance().changeState("MARKETING");
                }
            } else if (event.getComponent().getName().equals("CLOSE_WEITERE") || event.getComponent().getName().equals("OPEN_WEITERE") || event.getComponent().getName().equals("INFO")) {
                if (!(this.mMarketingView.isWeitereInaktiv() || WorkflowController.getInstance().getActiveState().getName().equals("FBI") || ControllerMainPanel.getInstance().getMainPanel().isFbaVisible())) {
                    this.mMarketingView.aufZuklappenWeitere();
                }
            } else if (event.getComponent().getName().equals("CLOSE_ZUSATZ") || event.getComponent().getName().equals("OPEN_ZUSATZ") || event.getComponent().getName().equals("ZUSATZ")) {
                if (!(this.mMarketingView.isZusatzInaktiv() || WorkflowController.getInstance().getActiveState().getName().equals("FBI") || ControllerMainPanel.getInstance().getMainPanel().isFbaVisible())) {
                    this.mMarketingView.aufZuklappenZusatz();
                }
            } else if (event.getComponent().getName().equals("Vor Blaettern") && this.mMarketingView.getBlaetternPanel().isBlaetternVorEnable()) {
                this.mModel.setIndexAktuellesImage(this.mModel.getIndexAktuellesImage() + 1);
                this.mMarketingView.getBackgrImagePanel().setNewImage(this.mModel.getBteImage(this.mModel.getIndexAktuellesImage()));
                this.mMarketingView.getBlaetternPanel().setBildName(this.mModel.getMarketingProdukt().getImages().get(this.mModel.getIndexAktuellesImage()).getProduktName());
                this.mMarketingView.getBlaetternPanel().enableBlaetternZurueck(true);
                if (this.mModel.getIndexAktuellesImage() == this.mModel.getIndexAnzahlMaxImage()) {
                    this.mMarketingView.getBlaetternPanel().enableBlaetternVor(false);
                }
            } else if (event.getComponent().getName().equals("Zurueck Blaettern") && this.mMarketingView.getBlaetternPanel().isBlaetternZurueckEnable()) {
                this.mModel.setIndexAktuellesImage(this.mModel.getIndexAktuellesImage() - 1);
                this.mMarketingView.getBackgrImagePanel().setNewImage(this.mModel.getBteImage(this.mModel.getIndexAktuellesImage()));
                this.mMarketingView.getBlaetternPanel().setBildName(this.mModel.getMarketingProdukt().getImages().get(this.mModel.getIndexAktuellesImage()).getProduktName());
                this.mMarketingView.getBlaetternPanel().enableBlaetternVor(true);
                if (this.mModel.getIndexAktuellesImage() == 0) {
                    this.mMarketingView.getBlaetternPanel().enableBlaetternZurueck(false);
                }
            } else if (this.mZusatzprodukteLabels != null && event.getComponent() instanceof ZusatzproduktLabel || event.getComponent() instanceof JCheckBox) {
                for (int i = 0; i < this.mZusatzprodukteLabels.size(); ++i) {
                    if (event.getComponent().getName().equals(this.mZusatzprodukteLabels.get(i).getName())) {
                        this.mMarketingView.getOptionalPanel().setOptionInformation(i);
                        continue;
                    }
                    this.mZusatzprodukteLabels.get(i).removeLabelBorder();
                }
            }
        }
        finally {
            this.mMarketingView.getIconEinkaufswagen().setCursor(Cursor.getPredefinedCursor(12));
            this.mMarketingView.getIconTaschenrechner().setCursor(Cursor.getPredefinedCursor(12));
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    public MarketingModel getModel() {
        return this.mModel;
    }

    public void setModel(MarketingModel model) {
        this.mModel = model;
    }

    public MarketingPanel getMarketingView() {
        return this.mMarketingView;
    }

    public void setMarketingView(MarketingPanel marketingView) {
        this.mMarketingView = marketingView;
    }

    public boolean checkAnzahlKonfigurationen() {
        if (!ControllerConfigurationPanel.getInstance().checkAnzahlConfiguration()) {
            MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(Resource.getInstance().getMaxcountkonfig());
        }
        return ControllerConfigurationPanel.getInstance().checkAnzahlConfiguration();
    }

    public void setAngebotsSicht(boolean flag) {
        this.mAngebotsSicht = flag;
        this.setViewAktiv(!flag);
        this.mMarketingView.setIcon("EINKAUFWAGEN");
    }

    public void changeTextanzeige() {
        ArrayList<Bnb> selEinzelteile = this.mModel.getSelectedEinzelteile();
        if (selEinzelteile != null && selEinzelteile.size() == 1) {
            if (selEinzelteile.get(0).getDetailText() != null && selEinzelteile.get(0).getDetailText() != "") {
                this.mMarketingView.getTextPanel().showNewMarketingText(selEinzelteile.get(0).getDetailText());
            }
            if (this.hasWeitereInfoBNBText(selEinzelteile.get(0))) {
                this.mModel.setTextBnb(selEinzelteile.get(0));
            } else {
                this.mModel.setTextBnb(null);
            }
        } else {
            this.mMarketingView.getTextPanel().showNewMarketingText(this.mModel.getMaketingText());
            this.mModel.setTextBnb(null);
        }
        this.mMarketingView.changeReiterWeitereInfo();
        this.mMarketingView.getTextPanel().showEinzelteilePanel();
    }

    private boolean hasWeitereInfoBNBText(Bnb bnb) {
        return bnb.getDetailText() != null && bnb.getDetailText() != "" || bnb.getVerkaufsinfo() != null && bnb.getVerkaufsinfo() != "" || bnb.getHinweise() != null && bnb.getHinweise() != "" || bnb.getCrossSelling() != null && bnb.getCrossSelling() != "" || bnb.getSonstiges() != null && bnb.getSonstiges() != "" || bnb.getErsatzTeile() != null && bnb.getErsatzTeile() != "";
    }

    static {
        log = Logger.getLogger(ControllerMarketingPanel.class);
    }
}

