/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.content.marketing.FBIModel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.utilities.viewcomp.JScrollPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baujahr;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.Getriebe;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.Lenkung;
import webetk.app.zub.suche.Modell;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class FBI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FBIModel mModel;
    private Bedingungsmenge mBedMenge;
    private JLabel dialogLabel = null;
    private static final int LENGTH_VIN = 7;
    private static final String PATTERN_VIN = "[A-Za-z0-9]{0,7}";
    public static final int MAX_COMBO_LENGTH = 20;
    private static final String ABBRUCH = "Abbrechen";
    private static final String WEITER = "\u00dcbernehmen";
    private static final String PRUEFEN = "Pruefen";
    private JPanel mFahrzeugPanel;
    private JPanel etcPanel;
    private JLabel vinLabel;
    private JFormattedTextField mVinTextField;
    private JLabel orLabel;
    private JLabel mBauart;
    private JComboBox bauartComboBox;
    private JLabel mBaureihe;
    private JComboBox baureihenComboBox;
    private JComboBox karosserieComboBox;
    private JComboBox modellComboBox;
    private JComboBox katalogausfuehrungComboBox;
    private JComboBox lenkungComboBox;
    private JComboBox baujahrComboBox;
    private JComboBox getriebeComboBox;
    private JComboBox zulassungsmonatComboBox;
    private JLabel karosserieLabel;
    private JLabel modellLabel;
    private JLabel next;
    private JLabel katalogLabel;
    private JLabel mLenkungsLabel;
    private JScrollPane mBedScrollPane;
    private JPanel mBedingungsPanelContainer;
    private JPanel mBedingungsPanel;
    private JLabel platzhalterProdBed;
    private ArrayList<JCheckBox> mBedingungsCheckboxes = null;
    private JPanel mButtonPanel;
    private JLabelButton mUebernehmenButton;
    private JLabelButton mAbbrechenButton;
    private JLabelButton mPruefenButton;
    private MarkenLayout mLayout;
    private JLabel mBaujahrLabel;
    private JLabel mGetriebeLabel;
    private JLabel mZulassungsLabel;
    private JLabel prodbedLabel;
    private JLabel mWeiterMeldung;
    private boolean mComponentsCreated = false;
    private String mLanguage;

    public FBI(MarkenLayout layout) {
        this.mLayout = layout;
        this.setLayout(new GridBagLayout());
        this.createComponents();
    }

    public void setModel(FBIModel model) {
        if (this.mLanguage == null || !this.mLanguage.equals(GlobalObjects.getInstance().getLanguage())) {
            this.createComponents();
        }
        this.mModel = model;
        this.removeAll();
        this.setFbi();
        this.setLayout(this.mLayout);
    }

    private void createComponents() {
        this.mLanguage = GlobalObjects.getInstance().getLanguage();
        this.vinLabel = new JLabel("VIN");
        this.orLabel = new JLabel(Resource.getInstance().getOder());
        this.mBauart = new JLabel(Resource.getInstance().getBauart() + ":");
        this.mBaureihe = new JLabel(Resource.getInstance().getBaureihe() + ":");
        this.karosserieLabel = new JLabel(Resource.getInstance().getKarosserie() + ":");
        this.modellLabel = new JLabel(Resource.getInstance().getModell() + ":");
        this.katalogLabel = new JLabel(Resource.getInstance().getKatalogausfuehrung() + ":");
        this.mLenkungsLabel = new JLabel(Resource.getInstance().getLenkung() + ":");
        this.mBaujahrLabel = new JLabel(Resource.getInstance().getBaujahr() + ":");
        this.mGetriebeLabel = new JLabel(Resource.getInstance().getGetriebe() + ":");
        this.mZulassungsLabel = new JLabel(Resource.getInstance().getZulassungsmonat() + ":");
        this.mVinTextField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter(PATTERN_VIN));
        this.setSize(this.mVinTextField, new Dimension(120, 20));
        this.bauartComboBox = new JComboBox();
        this.setSize(this.bauartComboBox, new Dimension(160, 20));
        this.baureihenComboBox = new JComboBox();
        this.baureihenComboBox.setRenderer(new BaureihenComboBoxRenderer());
        this.setSize(this.baureihenComboBox, new Dimension(160, 20));
        this.karosserieComboBox = new JComboBox();
        this.setSize(this.karosserieComboBox, new Dimension(160, 20));
        this.karosserieComboBox.setName("Karosserie");
        this.modellComboBox = new JComboBox();
        this.modellComboBox.setRenderer(new ModellComboBoxRenderer());
        this.setSize(this.modellComboBox, new Dimension(160, 20));
        this.modellComboBox.setName("Modell");
        this.katalogausfuehrungComboBox = new JComboBox();
        this.setSize(this.katalogausfuehrungComboBox, new Dimension(160, 20));
        this.katalogausfuehrungComboBox.setName("Katalog");
        this.lenkungComboBox = new JComboBox();
        this.lenkungComboBox.setName("Lenkung");
        this.baujahrComboBox = new JComboBox();
        this.baujahrComboBox.setName("Baujahr");
        this.getriebeComboBox = new JComboBox();
        this.getriebeComboBox.setName("Getriebe");
        this.zulassungsmonatComboBox = new JComboBox();
        this.zulassungsmonatComboBox.setName("Zulassungsmonat");
        this.etcPanel = new JPanel();
        this.etcPanel.setLayout(new GridBagLayout());
        this.etcPanel.setBorder(new EmptyBorder(0, -5, 0, -5));
        this.mWeiterMeldung = new JLabel(Resource.getInstance().getWeitertext());
        this.mButtonPanel = new JPanel();
        this.mButtonPanel.setLayout(new GridBagLayout());
        this.mUebernehmenButton = new JLabelButton(Resource.getInstance().getUebernehmen(), WEITER, false, this.mLayout);
        this.mAbbrechenButton = new JLabelButton(Resource.getInstance().getSchlieszen(), ABBRUCH, true, this.mLayout);
        this.mPruefenButton = new JLabelButton("Pr\u00fcfen", PRUEFEN, false, this.mLayout);
        this.next = new JLabel(new ImageIcon(ImageCache.getInstance().getImage("Icons/Grp/enter-arrow-right.gif")));
        this.mBedingungsPanelContainer = new JPanel();
        this.mBedingungsPanelContainer.setLayout(new GridBagLayout());
        this.mBedScrollPane = new JScrollPane();
        this.mBedScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mBedingungsPanel = new JPanel();
        this.mBedingungsPanel.setLayout(new GridBagLayout());
        this.mBedScrollPane.setViewportView(this.mBedingungsPanel);
        this.mComponentsCreated = true;
    }

    public void setFbi() {
        GridBagConstraints gbc2 = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(5, 5, 5, 0));
        this.add((Component)this.setFahrzeugPanel(), gbc2);
        gbc2 = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 3, 17, new Insets(10, 5, 5, 5));
        this.add((Component)new JLabel(), gbc2);
        this.mBedingungsCheckboxes = null;
        gbc2 = this.mLayout.setGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(5, 0, 5, 5));
        this.add((Component)this.getBedingungsPanel(), gbc2);
        gbc2 = this.mLayout.setGridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 1, 17, new Insets(5, 0, 5, 0));
        this.add((Component)this.setButtonPanel(), gbc2);
        this.updateUI();
        this.setVisible(true);
    }

    private JPanel setFahrzeugPanel() {
        this.mFahrzeugPanel = new JPanel();
        this.mFahrzeugPanel.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(790, 170));
        this.setMinimumSize(new Dimension(790, 170));
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 5, 0, 0));
        this.mFahrzeugPanel.add((Component)this.vinLabel, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 0, 13, new Insets(5, 5, 0, 0));
        this.mFahrzeugPanel.add((Component)this.mVinTextField, gbc);
        if (this.mModel.isVinIdentified()) {
            this.mVinTextField.setText(this.mModel.getFahrzeug().getFahrgestellnummer());
        } else {
            this.mVinTextField.setText("");
        }
        if (this.mModel.isVinIdentified() || this.mModel.isAttrIdentified()) {
            this.mVinTextField.setEnabled(false);
        } else {
            this.mVinTextField.setEnabled(true);
        }
        gbc = this.mLayout.setGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 2, 13, new Insets(5, 5, 0, 0));
        this.dialogLabel = this.getKundenDialogLabel();
        this.mFahrzeugPanel.add((Component)this.dialogLabel, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 2, 13, new Insets(5, 5, 0, 0));
        this.orLabel.setMinimumSize(new Dimension(101, 20));
        this.orLabel.setPreferredSize(new Dimension(101, 20));
        this.mFahrzeugPanel.add((Component)this.orLabel, gbc);
        if (this.mLayout.isBMWMotorrad()) {
            this.initBauarten();
        } else {
            this.initBaureihen();
        }
        JLabel platzhalter2 = new JLabel("");
        platzhalter2.setMinimumSize(new Dimension(100, 20));
        platzhalter2.setPreferredSize(new Dimension(100, 20));
        gbc = this.mLayout.setGridBagConstraints(6, 2, 5, 1, 1.0, 0.0, 2, 13, new Insets(5, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)platzhalter2, gbc);
        gbc.gridwidth = 3;
        this.updateUI();
        return this.mFahrzeugPanel;
    }

    public void setVinAttributes() {
        if (this.mLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.initBaureihen();
        } else {
            this.initBauarten();
        }
    }

    public void clearFBI() {
        this.baureihenComboBox.removeAllItems();
        this.karosserieComboBox.removeAllItems();
        this.modellComboBox.removeAllItems();
        this.katalogausfuehrungComboBox.removeAllItems();
        this.lenkungComboBox.removeAllItems();
        this.baujahrComboBox.removeAllItems();
        this.getriebeComboBox.removeAllItems();
        this.zulassungsmonatComboBox.removeAllItems();
        this.mVinTextField.setText("");
        this.setInitialeAnzeige();
    }

    public void initBauarten() {
        this.bauartComboBox.removeAllItems();
        boolean initBaureihe = false;
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified()) {
            this.setInitialeAnzeige();
            this.bauartComboBox.addItem(Resource.getInstance().getAuswaehlen());
            for (Bauart bauart : this.mModel.getListBauarten()) {
                this.bauartComboBox.addItem(bauart.getBezeichnung());
            }
            if (this.mModel.getBauart() != null) {
                for (int ii = 0; ii < this.bauartComboBox.getItemCount(); ++ii) {
                    if (!this.bauartComboBox.getItemAt(ii).equals(this.mModel.getBauart().getBezeichnung())) continue;
                    this.bauartComboBox.setSelectedItem(this.bauartComboBox.getItemAt(ii));
                    this.mModel.setListBaureihen((ArrayList)this.mModel.getListBauarten().get(ii - 1).getBaureihe());
                    initBaureihe = true;
                }
            } else if (this.bauartComboBox.getItemCount() == 2) {
                this.bauartComboBox.setSelectedIndex(1);
                this.mModel.setBauart(this.mModel.getListBauarten().get(0));
                initBaureihe = true;
            }
        } else {
            this.bauartComboBox.addItem(this.mModel.getFahrzeug().getBauartBezeichnung());
            initBaureihe = true;
        }
        if (initBaureihe) {
            this.initBaureihen();
        }
        this.bauartComboBox.updateUI();
        if (this.mLayout.isBMWMotorrad()) {
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 5, 0, 0));
            this.mFahrzeugPanel.add((Component)this.mBauart, gbc);
            gbc = this.mLayout.setGridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 0, 17, new Insets(5, 5, 0, 0));
            this.mFahrzeugPanel.add((Component)this.bauartComboBox, gbc);
        }
    }

    public void initBaureihen() {
        this.baureihenComboBox.removeAllItems();
        boolean initKarosserieformen = false;
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified()) {
            this.setInitialeAnzeige();
            this.mModel.setBaureihenTooltip(new ArrayList<String>());
            this.baureihenComboBox.addItem(Resource.getInstance().getAuswaehlen());
            this.mModel.getBaureihenTooltip().add(0, Resource.getInstance().getAuswaehlen());
            for (Baureihe baureihe : this.mModel.getListBaureihen()) {
                this.baureihenComboBox.addItem(baureihe.getBezeichnung());
                this.mModel.getBaureihenTooltip().add(baureihe.getBezeichnung());
            }
            if (this.mModel.getBaureihe() != null) {
                for (int ii = 0; ii < this.baureihenComboBox.getItemCount(); ++ii) {
                    if (!this.baureihenComboBox.getItemAt(ii).equals(this.mModel.getBaureihe().getBezeichnung())) continue;
                    this.baureihenComboBox.setSelectedItem(this.baureihenComboBox.getItemAt(ii));
                    initKarosserieformen = true;
                }
            } else if (this.baureihenComboBox.getItemCount() == 2) {
                this.baureihenComboBox.setSelectedIndex(1);
                this.mModel.setBaureihe(this.mModel.getListBaureihen().get(0));
                initKarosserieformen = true;
            }
        } else {
            this.baureihenComboBox.addItem(this.mModel.getFahrzeug().getBaureiheBezeichnung());
            initKarosserieformen = true;
        }
        if (initKarosserieformen) {
            this.initKarosserieformen();
        }
        this.baureihenComboBox.updateUI();
        int yCoordinate = 2;
        if (this.mLayout.isBMWMotorrad()) {
            yCoordinate = 3;
        }
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, yCoordinate, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.mBaureihe, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, yCoordinate, 3, 1, 0.0, 0.0, 0, 17, new Insets(5, 5, 5, 0));
        this.mBaureihe.setVisible(true);
        this.baureihenComboBox.setVisible(true);
        this.mFahrzeugPanel.add((Component)this.baureihenComboBox, gbc);
    }

    public void initKarosserieformen() {
        boolean initModelle = false;
        this.karosserieComboBox.removeAllItems();
        this.setPreferredSize(new Dimension(808, 200));
        this.setMinimumSize(new Dimension(808, 200));
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified()) {
            this.anzeigeNurBisKarosserie();
            this.karosserieComboBox.addItem(Resource.getInstance().getAuswaehlen());
            for (KarosserieForm karosserie : (ArrayList)this.mModel.getBaureihe().getKarosserieForm()) {
                this.karosserieComboBox.addItem(karosserie.getBezeichnung());
            }
            if (this.mModel.getKarosserieform() != null) {
                for (int ii = 0; ii < this.karosserieComboBox.getItemCount(); ++ii) {
                    if (!this.karosserieComboBox.getItemAt(ii).equals(this.mModel.getKarosserieform().getBezeichnung())) continue;
                    this.karosserieComboBox.setSelectedItem(this.karosserieComboBox.getItemAt(ii));
                    initModelle = true;
                }
            } else if (this.karosserieComboBox.getItemCount() == 2) {
                this.mModel.setKarosserieform(this.mModel.getBaureihe().getKarosserieForm().get(0));
                this.karosserieComboBox.setSelectedIndex(1);
                if (this.mModel.getKarosserieform() == null || this.mModel.getKarosserieform().getModelle() == null) {
                    ControllerFBI.getInstance().ladeModelle(0);
                }
                initModelle = true;
            }
        } else {
            this.karosserieComboBox.addItem(this.mModel.getFahrzeug().getKarosserieBezeichnung());
            initModelle = true;
        }
        if (initModelle) {
            this.initModelle();
        }
        if (this.mLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 2, 13, new Insets(0, 5, 5, 0));
            this.mFahrzeugPanel.add((Component)this.karosserieLabel, gbc);
            gbc = this.mLayout.setGridBagConstraints(2, 4, 3, 1, 1.0, 0.0, 0, 17, new Insets(0, 5, 5, 0));
            this.mFahrzeugPanel.add((Component)this.karosserieComboBox, gbc);
            this.karosserieLabel.setVisible(true);
            this.karosserieComboBox.setVisible(true);
        }
        this.mFahrzeugPanel.updateUI();
    }

    public void initModelle() {
        this.modellComboBox.removeAllItems();
        this.modellLabel.setVisible(true);
        this.modellComboBox.setVisible(true);
        this.setPreferredSize(new Dimension(808, 230));
        this.setMinimumSize(new Dimension(808, 230));
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified()) {
            this.anzeigeNurBisModelle();
            this.mModel.setModellTooltip(new ArrayList<String>());
            this.modellComboBox.addItem(Resource.getInstance().getAuswaehlen());
            this.mModel.getModellTooltip().add(0, Resource.getInstance().getAuswaehlen());
            for (Modell modell : (ArrayList)this.mModel.getKarosserieform().getModelle()) {
                this.modellComboBox.addItem(modell.getModell());
                this.mModel.getModellTooltip().add(modell.getModell());
            }
            if (this.mModel.getModell() != null) {
                for (int ii = 0; ii < this.modellComboBox.getItemCount(); ++ii) {
                    if (!this.modellComboBox.getItemAt(ii).equals(this.mModel.getModell().getModell())) continue;
                    this.modellComboBox.setSelectedItem(this.modellComboBox.getItemAt(ii));
                    this.initKatalogausfuehrungen();
                }
            } else if (this.modellComboBox.getItemCount() == 2) {
                this.mModel.setModell(this.mModel.getKarosserieform().getModelle().get(0));
                this.modellComboBox.setSelectedIndex(1);
                this.initKatalogausfuehrungen();
            }
        } else {
            this.modellComboBox.addItem(this.mModel.getFahrzeug().getModellBezeichnung());
            this.initKatalogausfuehrungen();
        }
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 2, 13, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.modellLabel, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, 5, 3, 1, 1.0, 0.0, 0, 17, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.modellComboBox, gbc);
        this.mFahrzeugPanel.updateUI();
    }

    public void initKatalogausfuehrungen() {
        this.katalogausfuehrungComboBox.removeAllItems();
        this.katalogausfuehrungComboBox.setVisible(true);
        this.katalogLabel.setVisible(true);
        boolean initLenkung = false;
        this.setPreferredSize(new Dimension(808, 260));
        this.setMinimumSize(new Dimension(808, 260));
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified()) {
            this.anzeigeNurBisKatalog();
            this.katalogausfuehrungComboBox.addItem(Resource.getInstance().getAuswaehlen());
            for (KatalogAusfuehrung katalog : (ArrayList)this.mModel.getModell().getKatalogausfuehrungen()) {
                this.katalogausfuehrungComboBox.addItem(katalog.getKatalogAusfuehrung());
            }
            if (this.mModel.getSelectedKatalogausf\u00fchrung() != null) {
                for (int ii = 0; ii < this.katalogausfuehrungComboBox.getItemCount(); ++ii) {
                    if (!this.katalogausfuehrungComboBox.getItemAt(ii).equals(this.mModel.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung())) continue;
                    if (this.mModel.getSelectedKatalogausf\u00fchrung().getLenkungen() == null) {
                        ControllerFBI.getInstance().ladeKatalogausf\u00fchrung(ii - 1);
                    }
                    this.katalogausfuehrungComboBox.setSelectedItem(this.katalogausfuehrungComboBox.getItemAt(ii));
                    if (!this.mModel.isLenkungNoetig() && !this.mModel.isGetriebeNoetig() && !this.mModel.isDatumNoetig()) continue;
                    initLenkung = true;
                }
            } else if (this.katalogausfuehrungComboBox.getItemCount() == 2) {
                this.katalogausfuehrungComboBox.setSelectedIndex(1);
                this.mModel.setSelectedKatalogausf\u00fchrung(this.mModel.getModell().getKatalogausfuehrungen().get(0));
                this.mModel.setIndexSelectedKatalogausf\u00fchrung(this.katalogausfuehrungComboBox.getSelectedIndex() - 1);
                if (this.mModel.isLenkungNoetig() || this.mModel.isGetriebeNoetig() || this.mModel.isDatumNoetig()) {
                    initLenkung = true;
                }
            }
        } else {
            this.katalogausfuehrungComboBox.addItem(this.mModel.getFahrzeug().getKatalogausf());
            if (this.mModel.isLenkungNoetig() || this.mModel.isGetriebeNoetig() || this.mModel.isDatumNoetig() || this.mModel.isVinIdentified()) {
                initLenkung = true;
            }
        }
        if (initLenkung) {
            if (this.mLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                this.initLenkungen();
            } else {
                this.anzeigeBaujahrMotorrad();
                this.initBaujahre();
            }
        }
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 2, 13, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.katalogLabel, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, 6, 3, 1, 1.0, 0.0, 0, 17, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.katalogausfuehrungComboBox, gbc);
        this.mFahrzeugPanel.updateUI();
    }

    public void initLenkungen() {
        this.lenkungComboBox.removeAllItems();
        this.anzeigeBisLenkung();
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified() || this.mModel.getFahrzeug().getLenkung() == null || "".equals(this.mModel.getFahrzeug().getLenkung()) || this.mModel.getFahrzeug().getLenkung().equals("kA")) {
            this.lenkungComboBox.addItem(Resource.getInstance().getAuswaehlen());
            for (Lenkung lenkung : (ArrayList)this.mModel.getSelectedKatalogausf\u00fchrung().getLenkungen()) {
                this.lenkungComboBox.addItem(lenkung.getLenkung());
            }
            if (this.mModel.getSelectedLenkung() != null) {
                for (int ii = 0; ii < this.lenkungComboBox.getItemCount(); ++ii) {
                    if (!this.lenkungComboBox.getItemAt(ii).equals(this.mModel.getSelectedLenkung().getLenkung())) continue;
                    this.lenkungComboBox.setSelectedItem(this.lenkungComboBox.getItemAt(ii));
                    this.aktiviereGetriebeComboBox(true);
                }
            }
            if (this.lenkungComboBox.getItemCount() == 2) {
                this.lenkungComboBox.setSelectedIndex(1);
                this.mModel.setIndexSelectedLenkung(0);
                this.aktiviereGetriebeComboBox(true);
            }
        } else {
            this.lenkungComboBox.addItem(this.mModel.getFahrzeug().getLenkung());
            this.mModel.setIndexSelectedLenkung(0);
            this.aktiviereGetriebeComboBox(true);
        }
    }

    private void initGetriebe() {
        this.getriebeComboBox.removeAllItems();
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified() || this.mModel.getFahrzeug() == null || this.mModel.getFahrzeug().getGetriebe() == null || "".equals(this.mModel.getFahrzeug().getGetriebe()) || this.mModel.getFahrzeug().getGetriebe().equals("kA")) {
            this.getriebeComboBox.addItem(Resource.getInstance().getAuswaehlen());
            for (Getriebe getriebe : (ArrayList)this.mModel.getSelectedLenkung().getGetriebe()) {
                this.getriebeComboBox.addItem(getriebe.getGetriebe());
            }
            if (this.mModel.isGetriebeNoetig() || this.mModel.isDatumNoetig()) {
                if (this.mModel.getSelectedGetriebe() != null) {
                    for (int ii = 0; ii < this.getriebeComboBox.getItemCount(); ++ii) {
                        if (!this.getriebeComboBox.getItemAt(ii).equals(this.mModel.getSelectedGetriebe().getGetriebe())) continue;
                        this.getriebeComboBox.setSelectedItem(this.getriebeComboBox.getItemAt(ii));
                        this.aktiviereBaujahreComboBox(true);
                    }
                }
                if (this.getriebeComboBox.getItemCount() == 2) {
                    this.getriebeComboBox.setSelectedIndex(1);
                    this.mModel.setIndexSelectedGetriebe(0);
                    this.aktiviereBaujahreComboBox(true);
                }
            } else {
                this.aktiviereGetriebeComboBox(false);
            }
        } else {
            this.getriebeComboBox.addItem(this.mModel.getFahrzeug().getGetriebe());
            this.aktiviereBaujahreComboBox(true);
        }
    }

    private void initBaujahre() {
        this.baujahrComboBox.removeAllItems();
        if (this.mModel.getFahrzeug() == null) {
            this.mModel.setFahrzeug(GlobalObjects.getInstance().getIpacData().getFahrzeug());
        }
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified() || this.mModel.getFahrzeug() == null || this.mModel.getFahrzeug().getBaujahr() == null || "".equals(this.mModel.getFahrzeug().getBaujahr()) || this.mModel.getFahrzeug().getBaujahr().equals("kA")) {
            this.baujahrComboBox.addItem(Resource.getInstance().getAuswaehlen());
            if (WorkflowController.getInstance().getMarkenLayout().getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                if (this.mModel.getSelectedGetriebe() == null || this.mModel.getSelectedGetriebe().getBaujahre() == null) {
                    ControllerFBI.getInstance().ladeKatalogausf\u00fchrung(this.katalogausfuehrungComboBox.getSelectedIndex());
                }
                for (Baujahr baujahr : (ArrayList)this.mModel.getSelectedGetriebe().getBaujahre()) {
                    this.baujahrComboBox.addItem(baujahr.getBaujahr());
                }
            } else {
                if (this.mModel.getSelectedKatalogausf\u00fchrung() == null || this.mModel.getSelectedKatalogausf\u00fchrung().getBaujahreMotorrad() == null) {
                    ControllerFBI.getInstance().ladeKatalogausf\u00fchrung(this.katalogausfuehrungComboBox.getSelectedIndex());
                }
                for (Baujahr baujahr : (ArrayList)this.mModel.getSelectedKatalogausf\u00fchrung().getBaujahreMotorrad()) {
                    this.baujahrComboBox.addItem(baujahr.getBaujahr());
                }
            }
            if (this.mModel.isDatumNoetig()) {
                if (this.mModel.getSelectedBaujahr() != null) {
                    for (int ii = 0; ii < this.baujahrComboBox.getItemCount(); ++ii) {
                        if (!this.baujahrComboBox.getItemAt(ii).equals(this.mModel.getSelectedBaujahr().getBaujahr())) continue;
                        this.baujahrComboBox.setSelectedItem(this.baujahrComboBox.getItemAt(ii));
                        this.aktiviereZulassungsComboBox(true);
                    }
                }
                this.zulassungsmonatComboBox.addItem(Resource.getInstance().getAuswaehlen());
                if (this.mLayout.isBMWMotorrad()) {
                    this.anzeigeBaujahrMotorrad();
                }
                if (this.baujahrComboBox.getItemCount() == 2) {
                    this.baujahrComboBox.setSelectedIndex(1);
                    this.mModel.setIndexSelectedBaujahr(0);
                    this.aktiviereZulassungsComboBox(true);
                }
            } else {
                this.aktiviereBaujahreComboBox(false);
                this.aktiviereZulassungsComboBox(false);
            }
        } else {
            this.baujahrComboBox.addItem(this.mModel.getFahrzeug().getBaujahr());
            this.aktiviereZulassungsComboBox(true);
        }
    }

    private void initZulassungsMonate() {
        this.zulassungsmonatComboBox.removeAllItems();
        if (this.mModel.getFahrzeug() == null) {
            this.mModel.setFahrzeug(GlobalObjects.getInstance().getIpacData().getFahrzeug());
        }
        if (!this.mModel.isVinIdentified() && !this.mModel.isAttrIdentified() || this.mModel.getFahrzeug() == null || this.mModel.getFahrzeug().getZulassungsmonat() == null || "".equals(this.mModel.getFahrzeug().getZulassungsmonat()) || this.mModel.getFahrzeug().getZulassungsmonat().equals("kA")) {
            this.zulassungsmonatComboBox.addItem(Resource.getInstance().getAuswaehlen());
            for (String monat : (ArrayList)this.mModel.getSelectedBaujahr().getMonate()) {
                this.zulassungsmonatComboBox.addItem(monat);
            }
            if (this.mModel.getSelectedZulassungsmonat() != null) {
                for (int ii = 0; ii < this.zulassungsmonatComboBox.getItemCount(); ++ii) {
                    if (!this.zulassungsmonatComboBox.getItemAt(ii).equals(this.mModel.getSelectedZulassungsmonat())) continue;
                    this.zulassungsmonatComboBox.setSelectedItem(this.zulassungsmonatComboBox.getItemAt(ii));
                }
            }
            if (this.zulassungsmonatComboBox.getItemCount() == 2) {
                this.zulassungsmonatComboBox.setSelectedIndex(1);
            }
        } else {
            this.zulassungsmonatComboBox.addItem(this.mModel.getFahrzeug().getZulassungsmonat());
            this.baujahrComboBox.setEnabled(true);
        }
    }

    public void setInitialeAnzeigeMotorrad() {
        this.setPreferredSize(new Dimension(808, 170));
        this.setMinimumSize(new Dimension(808, 170));
        this.baureihenComboBox.setVisible(false);
        this.mBaureihe.setVisible(false);
        this.karosserieLabel.setVisible(false);
        this.karosserieComboBox.setVisible(false);
        this.anzeigeNurBisKarosserie();
        this.updateUI();
    }

    public void setInitialeAnzeige() {
        this.setPreferredSize(new Dimension(808, 170));
        this.setMinimumSize(new Dimension(808, 170));
        this.karosserieLabel.setVisible(false);
        this.karosserieComboBox.setVisible(false);
        this.anzeigeNurBisKarosserie();
        this.updateUI();
    }

    public void anzeigeNurBisKarosserie() {
        this.modellLabel.setVisible(false);
        this.modellComboBox.setVisible(false);
        this.anzeigeNurBisModelle();
        this.setPreferredSize(new Dimension(808, 200));
        this.setMinimumSize(new Dimension(808, 200));
    }

    public void anzeigeNurBisModelle() {
        this.katalogLabel.setVisible(false);
        this.katalogausfuehrungComboBox.setVisible(false);
        this.anzeigeNurBisKatalog();
        this.setPreferredSize(new Dimension(808, 230));
        this.setMinimumSize(new Dimension(808, 230));
    }

    public void anzeigeNurBisKatalog() {
        this.lenkungComboBox.setVisible(false);
        this.baujahrComboBox.setVisible(false);
        this.getriebeComboBox.setVisible(false);
        this.zulassungsmonatComboBox.setVisible(false);
        this.mLenkungsLabel.setVisible(false);
        this.mBaujahrLabel.setVisible(false);
        this.mGetriebeLabel.setVisible(false);
        this.mZulassungsLabel.setVisible(false);
        this.setPreferredSize(new Dimension(808, 260));
        this.setMinimumSize(new Dimension(808, 260));
    }

    private void anzeigeBisLenkung() {
        this.lenkungComboBox.setVisible(true);
        this.getriebeComboBox.setVisible(true);
        this.baujahrComboBox.setVisible(true);
        this.zulassungsmonatComboBox.setVisible(true);
        this.mLenkungsLabel.setVisible(true);
        this.mGetriebeLabel.setVisible(true);
        this.mBaujahrLabel.setVisible(true);
        this.mZulassungsLabel.setVisible(true);
        this.lenkungComboBox.setEnabled(true);
        this.aktiviereGetriebeComboBox(false);
        this.aktiviereBaujahreComboBox(false);
        this.aktiviereZulassungsComboBox(false);
        this.layoutLastComboBoxen();
        if (this.mLayout.isBMWMotorrad()) {
            this.lenkungComboBox.setVisible(false);
            this.getriebeComboBox.setVisible(false);
            this.mLenkungsLabel.setVisible(false);
            this.mGetriebeLabel.setVisible(false);
            this.baujahrComboBox.setEnabled(true);
        }
        this.mFahrzeugPanel.updateUI();
    }

    private void anzeigeBaujahrMotorrad() {
        this.baujahrComboBox.setVisible(true);
        this.zulassungsmonatComboBox.setVisible(true);
        this.mBaujahrLabel.setVisible(true);
        this.mZulassungsLabel.setVisible(true);
        this.baujahrComboBox.setEnabled(true);
        this.aktiviereZulassungsComboBox(false);
        this.layoutLastComboBoxenMotorrad();
        this.mFahrzeugPanel.updateUI();
    }

    private void layoutLastComboBoxen() {
        this.setPreferredSize(new Dimension(808, 310));
        this.setMinimumSize(new Dimension(808, 310));
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 0, 17, new Insets(0, 5, 5, 5));
        if (this.mLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.lenkungComboBox.setVisible(true);
            this.etcPanel.add((Component)this.mLenkungsLabel, gbc);
            gbc = this.mLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 0, 17, new Insets(0, 0, 5, 0));
            this.lenkungComboBox.setMinimumSize(new Dimension(80, 20));
            this.lenkungComboBox.setPreferredSize(new Dimension(80, 20));
            this.lenkungComboBox.setMaximumSize(new Dimension(80, 20));
            this.etcPanel.add((Component)this.lenkungComboBox, gbc);
            this.getriebeComboBox.setVisible(true);
            this.getriebeComboBox.setMinimumSize(new Dimension(80, 20));
            this.getriebeComboBox.setPreferredSize(new Dimension(80, 20));
            this.getriebeComboBox.setMaximumSize(new Dimension(80, 20));
            gbc = this.mLayout.setGridBagConstraints(2, 0, 2, 1, 1.0, 1.0, 0, 17, new Insets(0, 5, 5, 0));
            this.etcPanel.add((Component)this.mGetriebeLabel, gbc);
            gbc.gridy = 1;
            this.etcPanel.add((Component)this.getriebeComboBox, gbc);
        }
        this.baujahrComboBox.setVisible(true);
        this.baujahrComboBox.setMinimumSize(new Dimension(80, 20));
        this.baujahrComboBox.setPreferredSize(new Dimension(80, 20));
        this.baujahrComboBox.setMaximumSize(new Dimension(80, 20));
        gbc = this.mLayout.setGridBagConstraints(4, 0, 2, 1, 1.0, 1.0, 0, 17, new Insets(0, 5, 5, 0));
        this.etcPanel.add((Component)this.mBaujahrLabel, gbc);
        gbc.gridy = 1;
        this.etcPanel.add((Component)this.baujahrComboBox, gbc);
        this.mZulassungsLabel.setVisible(true);
        this.zulassungsmonatComboBox.setVisible(true);
        this.zulassungsmonatComboBox.setMinimumSize(new Dimension(80, 20));
        this.zulassungsmonatComboBox.setPreferredSize(new Dimension(80, 20));
        this.zulassungsmonatComboBox.setMaximumSize(new Dimension(80, 20));
        gbc = this.mLayout.setGridBagConstraints(6, 0, 2, 1, 1.0, 1.0, 0, 17, new Insets(0, 5, 5, 2));
        this.etcPanel.add((Component)this.mZulassungsLabel, gbc);
        gbc.gridy = 1;
        this.etcPanel.add((Component)this.zulassungsmonatComboBox, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 7, 20, 4, 1.0, 1.0, 2, 17, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.etcPanel, gbc);
    }

    private void layoutLastComboBoxenMotorrad() {
        this.setPreferredSize(new Dimension(808, 320));
        this.setMinimumSize(new Dimension(808, 320));
        this.baujahrComboBox.setVisible(true);
        this.setSize(this.baujahrComboBox, new Dimension(160, 20));
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 2, 13, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.mBaujahrLabel, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, 7, 3, 1, 1.0, 0.0, 0, 17, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.baujahrComboBox, gbc);
        this.mZulassungsLabel.setVisible(true);
        this.zulassungsmonatComboBox.setVisible(true);
        this.setSize(this.zulassungsmonatComboBox, new Dimension(160, 20));
        gbc = this.mLayout.setGridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 2, 13, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.mZulassungsLabel, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, 8, 3, 1, 1.0, 0.0, 0, 17, new Insets(0, 5, 5, 0));
        this.mFahrzeugPanel.add((Component)this.zulassungsmonatComboBox, gbc);
    }

    public void aktiviereGetriebeComboBox(boolean enable) {
        this.getriebeComboBox.setEnabled(enable);
        if (!enable) {
            this.getriebeComboBox.removeAllItems();
            this.getriebeComboBox.addItem(Resource.getInstance().getAuswaehlen());
        } else {
            this.initGetriebe();
        }
        this.getriebeComboBox.updateUI();
        this.mFahrzeugPanel.updateUI();
    }

    public void aktiviereBaujahreComboBox(boolean enable) {
        this.baujahrComboBox.setEnabled(enable);
        if (!enable) {
            this.baujahrComboBox.removeAllItems();
            this.baujahrComboBox.addItem(Resource.getInstance().getAuswaehlen());
        } else {
            this.initBaujahre();
        }
        this.baujahrComboBox.updateUI();
        this.mFahrzeugPanel.updateUI();
    }

    public void aktiviereZulassungsComboBox(boolean enable) {
        this.zulassungsmonatComboBox.setEnabled(enable);
        if (!enable) {
            this.zulassungsmonatComboBox.removeAllItems();
            this.zulassungsmonatComboBox.addItem(Resource.getInstance().getAuswaehlen());
        } else {
            this.initZulassungsMonate();
        }
        this.zulassungsmonatComboBox.updateUI();
        this.mFahrzeugPanel.updateUI();
    }

    public void setWeiterMeldung() {
        this.mWeiterMeldung.setVisible(true);
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 2, 20, 1, 1.0, 1.0, 0, 17, new Insets(5, 5, 5, 5));
        this.etcPanel.add((Component)this.mWeiterMeldung, gbc);
        this.updateUI();
    }

    public JPanel getBedingungsPanel() {
        this.mBedingungsPanelContainer.removeAll();
        this.mBedingungsPanel.removeAll();
        this.mBedingungsPanelContainer.setPreferredSize(new Dimension(300, 40));
        this.mBedingungsPanelContainer.setMinimumSize(new Dimension(300, 40));
        GridBagConstraints gbcTest = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(5, 5, 5, 0));
        this.mBedingungsPanelContainer.add((Component)this.mBedScrollPane, gbcTest);
        return this.mBedingungsPanelContainer;
    }

    public void cleanBedingungsPanel() {
        this.mBedingungsPanelContainer.removeAll();
        this.mBedingungsPanel.removeAll();
    }

    public void setBedingungen2() {
        this.mBedingungsPanelContainer.removeAll();
        this.mBedingungsPanel.removeAll();
        int gridY = 0;
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, gridY, 1, 1, 1.0, 0.0, 0, 17, new Insets(5, 5, 0, 0));
        if (this.mModel.getBTEBedingungsmenge().getBedingungsmenge().alleWerteGesetzt() || this.mModel.getBTEBedingungsmenge() == null) {
            this.prodbedLabel = new JLabel(Resource.getInstance().getKeineBedingungen());
            this.prodbedLabel.setForeground(this.mLayout.getPrimaryForeground());
            this.mBedingungsPanel.add((Component)this.prodbedLabel, gbc);
            this.mUebernehmenButton.setEnabled(true, this.mLayout);
            this.mPruefenButton.setEnabled(true, this.mLayout);
            this.setKeineBedingungenLabel();
        } else {
            if (this.mModel.getBTEBedingungsmenge() != null) {
                this.mBedingungsCheckboxes = new ArrayList();
                BTEBedingungsmenge oBedingungen = this.mModel.getBTEBedingungsmenge();
                this.mBedMenge = oBedingungen.getBedingungsmenge();
                try {
                    oBedingungen.goFirst();
                    while (true) {
                        Long lBedId = oBedingungen.getCurrentId();
                        boolean bIsBteBed = oBedingungen.isBteBedingung(lBedId);
                        String sCode = oBedingungen.getCurrentCode();
                        String sBenennung = oBedingungen.getCurrentBenennung();
                        String sWert = oBedingungen.getCurrentWert();
                        if (!sWert.equals("1") && !sWert.equals("2")) {
                            if (bIsBteBed && this.mModel.getMarketingProdukt().getSalaid() != lBedId.longValue()) {
                                String text = sCode == null || sCode.equals("") ? sBenennung : sBenennung + "  (" + sCode + ")";
                                JCheckBox prodbedCheckBox = new JCheckBox(text);
                                if (prodbedCheckBox.getText().length() > 35) {
                                    prodbedCheckBox.setToolTipText(text);
                                }
                                prodbedCheckBox.setName(String.valueOf(lBedId));
                                prodbedCheckBox.setBackground(this.mLayout.getPrimaryBackground());
                                prodbedCheckBox.setForeground(this.mLayout.getPrimaryForeground());
                                prodbedCheckBox.addMouseListener(new HilfeMouseListener("i50097"));
                                this.mBedingungsPanel.add((Component)prodbedCheckBox, gbc);
                                this.mBedingungsPanel.validate();
                                this.mBedingungsCheckboxes.add(prodbedCheckBox);
                                gbc = this.mLayout.setGridBagConstraints(0, ++gridY, 1, 1, 1.0, 0.0, 0, 17, new Insets(5, 5, 0, 0));
                            } else {
                                this.mBedMenge.setBedWert(lBedId, new Bedingungswert("1"));
                            }
                        }
                        if (!oBedingungen.hasNext()) break;
                        oBedingungen.next();
                    }
                    if (this.mBedingungsCheckboxes.size() == 0) {
                        this.setKeineBedingungenLabel();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.mUebernehmenButton.setEnabled(true, this.mLayout);
            this.mPruefenButton.setEnabled(true, this.mLayout);
        }
        this.platzhalterProdBed = new JLabel(" ");
        gbc = this.mLayout.setGridBagConstraints(0, ++gridY, 1, 1, 1.0, 1.0, 0, 17, new Insets(0, 0, 0, 0));
        this.mBedingungsPanel.add((Component)this.platzhalterProdBed, gbc);
        this.mBedScrollPane.setViewportView(this.mBedingungsPanel);
        GridBagConstraints gbcTest = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(5, 5, 5, 0));
        this.mBedingungsPanelContainer.add((Component)this.mBedScrollPane, gbcTest);
        this.validate();
        this.updateUI();
    }

    private void setKeineBedingungenLabel() {
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(5, 5, 0, 0));
        this.prodbedLabel = new JLabel(Resource.getInstance().getKeineBedingungen());
        this.prodbedLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.mBedingungsPanel.add((Component)this.prodbedLabel, gbc);
        this.mUebernehmenButton.setEnabled(true, this.mLayout);
        this.mPruefenButton.setEnabled(true, this.mLayout);
    }

    public JPanel setButtonPanel() {
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 13, new Insets(10, 0, 10, 15));
        this.mButtonPanel.add((Component)this.mUebernehmenButton, gbc);
        gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(10, 0, 10, 15));
        this.mButtonPanel.add((Component)this.mPruefenButton, gbc);
        gbc = this.mLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 0, 10, 0));
        this.mButtonPanel.add((Component)this.mAbbrechenButton, gbc);
        return this.mButtonPanel;
    }

    public void aktiviereWeiterPfeil(boolean flag) {
        if (flag) {
            this.next.setCursor(Cursor.getPredefinedCursor(12));
            this.next.addMouseListener(ControllerFBI.getInstance());
        } else {
            this.next.removeMouseListener(ControllerFBI.getInstance());
        }
        this.updateUI();
    }

    public void setLayout(MarkenLayout layout) {
        this.mLayout = layout;
        this.mAbbrechenButton.setForeground(this.mLayout.getEnabledButtonForeground());
        this.mAbbrechenButton.setBackground(this.mLayout.getEnabledButtonBackground());
        this.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, this.mLayout.getSelectedReiterBackground()));
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.mFahrzeugPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mBedingungsPanelContainer.setBackground(this.mLayout.getPrimaryBackground());
        this.mBedingungsPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mBedScrollPane.setBackground(this.mLayout.getPrimaryBackground());
        this.mButtonPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.next.setBackground(this.mLayout.getPrimaryBackground());
        this.next.setForeground(this.mLayout.getPrimaryForeground());
        this.etcPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mFahrzeugPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mLayout.getBorderColor()), Resource.getInstance().getFahrzeug(), 1, 2, Constants.Layout.getZubBoldFont(), this.mLayout.getBorderTextColor()));
        this.mBedingungsPanelContainer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mLayout.getBorderColor()), Resource.getInstance().getBedingung(), 1, 2, Constants.Layout.getZubBoldFont(), this.mLayout.getBorderTextColor()));
        this.vinLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.orLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.mBauart.setForeground(this.mLayout.getPrimaryForeground());
        this.mBaureihe.setForeground(this.mLayout.getPrimaryForeground());
        this.karosserieLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.modellLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.katalogLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.mLenkungsLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.mBaujahrLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.mGetriebeLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.mZulassungsLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.validate();
    }

    public JLabel getKundenDialogLabel() {
        if (this.dialogLabel == null) {
            this.dialogLabel = new JLabel(new ImageIcon(ImageCache.getInstance().getImage("Icons/kunde_keyreader.jpg")));
            this.dialogLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.dialogLabel.setName("DIALOG_VIN");
        }
        return this.dialogLabel;
    }

    public JLabelButton getUebernehmenButton() {
        return this.mUebernehmenButton;
    }

    public JLabelButton getPruefenButton() {
        return this.mPruefenButton;
    }

    public JComboBox getBaujahrComboBox() {
        return this.baujahrComboBox;
    }

    public JFormattedTextField getVinTextField() {
        return this.mVinTextField;
    }

    public void setVinText(String vin) {
        this.mVinTextField.setText(vin);
    }

    public boolean checkPlausibilitaetenVin() {
        String text = this.mVinTextField.getText();
        if (text.length() <= 0) {
            return false;
        }
        if (text.length() != 7) {
            JOptionPane.showMessageDialog((Component)this, Resource.getInstance().getFzgidInvalidFzgnr(), Resource.getInstance().getInformation(), 1);
        }
        return text.length() == 7;
    }

    public JLabelButton getAbbrechenButton() {
        return this.mAbbrechenButton;
    }

    public JComboBox getLenkungComboBox() {
        return this.lenkungComboBox;
    }

    public JComboBox getGetriebeComboBox() {
        return this.getriebeComboBox;
    }

    public JComboBox getZulassungsmonatComboBox() {
        return this.zulassungsmonatComboBox;
    }

    public JComboBox getBaureihenComboBox() {
        return this.baureihenComboBox;
    }

    public JComboBox getKarosserieComboBox() {
        return this.karosserieComboBox;
    }

    public JComboBox getKatalogausfuehrungComboBox() {
        return this.katalogausfuehrungComboBox;
    }

    public JComboBox getModellComboBox() {
        return this.modellComboBox;
    }

    public JLabel getNext() {
        return this.next;
    }

    public ArrayList<JCheckBox> getBedingungsCheckboxes() {
        return this.mBedingungsCheckboxes;
    }

    private void setSize(Component component, Dimension size) {
        component.setMinimumSize(size);
        component.setMaximumSize(size);
        component.setPreferredSize(size);
    }

    public Bedingungsmenge getBedMenge() {
        return this.mBedMenge;
    }

    public void setBedMenge(Bedingungsmenge menge) {
        this.mBedMenge = menge;
    }

    public String getSelectedModellText() {
        if (this.modellComboBox != null) {
            return (String)this.modellComboBox.getSelectedItem();
        }
        return "";
    }

    public String getSelectedBaureihenText() {
        if (this.baureihenComboBox != null) {
            return (String)this.baureihenComboBox.getSelectedItem();
        }
        return "";
    }

    public JComboBox getBauartComboBox() {
        return this.bauartComboBox;
    }

    public void setBauartComboBox(JComboBox bauartComboBox) {
        this.bauartComboBox = bauartComboBox;
    }

    public boolean isComponentsCreated() {
        return this.mComponentsCreated;
    }

    public void setComponentsCreated(boolean componentsCreated) {
        this.mComponentsCreated = componentsCreated;
    }

    class BaureihenComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        BaureihenComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index && FBI.this.mModel.getBaureihenTooltip() != null && FBI.this.mModel.getBaureihenTooltip().size() > 0) {
                    if (list.getModel().getElementAt(index).toString().length() > 20) {
                        list.setToolTipText(FBI.this.mModel.getBaureihenTooltip().get(index));
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value != null && value.getClass().toString().equals(String.class.toString())) {
                String modell = (String)value;
                if (modell.length() > 20) {
                    this.setText(modell.substring(0, 20) + "...");
                } else {
                    this.setText(modell);
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    class ModellComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        ModellComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index && FBI.this.mModel.getModellTooltip() != null && FBI.this.mModel.getModellTooltip().size() > 0) {
                    if (list.getModel().getElementAt(index).toString().length() > 20) {
                        list.setToolTipText(FBI.this.mModel.getModellTooltip().get(index));
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value != null && value.getClass().toString().equals(String.class.toString())) {
                String modell = (String)value;
                if (modell.length() > 20) {
                    this.setText(modell.substring(0, 20) + "...");
                } else {
                    this.setText(modell);
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

