/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.content.marketing.FBIModel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import webetk.NoBrandAuthorizationException;
import webetk.NoDataFoundException;
import webetk.app.BTEBedingungsmenge;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfZubMarketing;
import webetk.communication.transferables.TrfZubTechnisch;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.javaclient.utils.BooleanWrapper;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class FBIDataloader {
    static Logger log = Logger.getLogger(FBIDataloader.class);

    public static BTEBedingungsmenge getBedingungen(MarketingProdukt mProdukt) {
        return FBIDataloader.getBedingungen(ControllerFBI.getModel().getFahrzeug(), mProdukt);
    }

    public static BTEBedingungsmenge getBedingungen(Fahrzeug fahrzeug, MarketingProdukt mProdukt) {
        log.debug((Object)"Performing Getting Bedingungen");
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        TrfZubTechnisch trfTechnik = new TrfZubTechnisch(null);
        trfTechnik.setValue("marketingProdukt", mProdukt);
        trfTechnik.setValue("fzgsucheinfo_app", fahrzeug);
        trfTechnik.setValue("art", "FZG");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTechnik, Command.ERMITTLE_BEDINGUNGEN_TECHNISCHES_PRODUKT);
        }
        catch (CommunicationException ex) {
            log.error((Object)"ControllerMarketingPanel: ", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfTechnik.getError() != null) {
            if (trfTechnik.getError() instanceof NoDataFoundException) {
                log.error((Object)"Keine Daten f\u00fcr die Marketingsicht des Produkts gefunden!", (Throwable)trfTechnik.getError());
                MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTechnik.getError());
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), trfTechnik.getError().getMessage(), ControllerFBI.getModel().getDialogTitel(), 0);
            return null;
        }
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        ControllerFBI.getModel().createFahrzeugFromFzIdInfo((FzgSucheInfo)trfTechnik.getValue("fzgsucheinfo_app"));
        return (BTEBedingungsmenge)trfTechnik.getValue("bteBedingung");
    }

    public void getFImitAttr() {
        log.debug((Object)"Performing Change FzgId");
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        FBIModel model = ControllerFBI.getModel();
        String sVollstaendigeFI = model.isVollstaendigeFI() ? "true" : "false";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        trfFI.setValue("marke", loginInfo.getMarke());
        trfFI.setValue("produktart", loginInfo.getProdukart());
        trfFI.setValue("katalogumfang", loginInfo.getKatalogUmfang());
        trfFI.setValue("bauart", model.getBauart().getBauart());
        trfFI.setValue("baureihe", model.getBaureihe().getBaureihe());
        trfFI.setValue("karosserie", model.getKarosserieform().getKarosserieForm());
        trfFI.setValue("modell", model.getModell().getModell());
        trfFI.setValue("region", model.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung());
        if (model.getSelectedLenkung() != null) {
            trfFI.setValue("lenkung", model.getSelectedLenkung().getLenkung());
        }
        if (model.getSelectedGetriebe() != null) {
            trfFI.setValue("getriebe", model.getSelectedGetriebe().getGetriebe());
        }
        if (model.getSelectedBaujahr() != null) {
            trfFI.setValue("baujahr", model.getSelectedBaujahr().getBaujahr());
        }
        if (model.getSelectedZulassungsmonat() != null) {
            trfFI.setValue("zulmonat", model.getSelectedZulassungsmonat());
        }
        if (model.getSelectedBaujahr() == null && WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
            trfFI.setValue("baujahr", "kA");
        }
        if (model.getSelectedZulassungsmonat() == null && WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
            trfFI.setValue("zulmonat", "kA");
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.RESET_FAHRZEUGIDENTIFIKATION);
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.CHANGE_FAHRZEUGIDENTIFIKATION);
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
        }
        catch (CommunicationException ex) {
            log.error((Object)"DlgFzgIdController: ", (Throwable)ex);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFI.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return;
        }
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)trfFI.getValue("fzgsucheinfo_app");
        ControllerFBI.getModel().createFahrzeugFromFzIdInfo2(oFzgSucheInfo);
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void ermittleZusatzAttrib(Fahrzeug fahrzeug, MarketingProdukt produkt) throws Exception {
        if (fahrzeug.getModellspalte() == -1L || fahrzeug.getModellspalte() == 0L) {
            TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
            String sVollstaendigeFI = "true";
            trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
            LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
            trfFI.setValue("marke", loginInfo.getMarke());
            trfFI.setValue("produktart", loginInfo.getProdukart());
            trfFI.setValue("katalogumfang", loginInfo.getKatalogUmfang());
            trfFI.setValue("bauart", fahrzeug.getBauart());
            trfFI.setValue("baureihe", fahrzeug.getBaureihe());
            trfFI.setValue("karosserie", fahrzeug.getKarosserie());
            trfFI.setValue("modell", fahrzeug.getModell());
            trfFI.setValue("region", fahrzeug.getKatalogausf());
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.RESET_FAHRZEUGIDENTIFIKATION);
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.CHANGE_FAHRZEUGIDENTIFIKATION);
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
            if (trfFI.getError() != null) {
                throw trfFI.getError();
            }
            JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
            fahrzeug.setModellspalte(oFzgIdInfo.getModellspalte());
            if (oFzgIdInfo.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                if (oFzgIdInfo.getBauartBezeichnung() != null && oFzgIdInfo.getBauartBezeichnung().length() > 0) {
                    fahrzeug.setBauartBezeichnung(oFzgIdInfo.getBauartBezeichnung());
                }
                if (oFzgIdInfo.getBaureiheBezeichnung() != null && oFzgIdInfo.getBaureiheBezeichnung().length() > 0) {
                    fahrzeug.setBaureiheBezeichnung(oFzgIdInfo.getBaureiheBezeichnung());
                }
            } else {
                if (oFzgIdInfo.getBaureiheBezeichnung() != null && oFzgIdInfo.getBaureiheBezeichnung().length() > 0) {
                    fahrzeug.setBaureiheBezeichnung(oFzgIdInfo.getBaureiheBezeichnung());
                }
                if (oFzgIdInfo.getKarosserieBezeichnung() != null && oFzgIdInfo.getKarosserieBezeichnung().length() > 0) {
                    fahrzeug.setKarosserieBezeichnung(oFzgIdInfo.getKarosserieBezeichnung());
                }
            }
        }
        TrfZubMarketing trfMar = new TrfZubMarketing(null);
        trfMar.setValue("fahrzeug", fahrzeug);
        trfMar.setValue("marketingProdukt", produkt);
        GlobalObjects.getInstance().getServiceExecutor().executeService(trfMar, Command.ERMITTLE_ZUSATZFZATTRIBUTE);
        boolean lenkungNoetig = (Boolean)trfMar.getValue("lenkungNoetig");
        boolean getriebeNoetig = (Boolean)trfMar.getValue("getriebeNoetig");
        boolean datumNoetig = (Boolean)trfMar.getValue("datumNoetig");
        produkt.setLenkungNoetig(lenkungNoetig);
        produkt.setGetriebeNoetig(getriebeNoetig);
        produkt.setDatumNoetig(datumNoetig);
    }

    public static void ermittleFahrzeugId(Fahrzeug fahrzeug) throws Exception {
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        String sVollstaendigeFI = "true";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        trfFI.setValue("marke", loginInfo.getMarke());
        trfFI.setValue("produktart", loginInfo.getProdukart());
        trfFI.setValue("katalogumfang", loginInfo.getKatalogUmfang());
        trfFI.setValue("bauart", fahrzeug.getBauart());
        trfFI.setValue("baureihe", fahrzeug.getBaureihe());
        trfFI.setValue("karosserie", fahrzeug.getKarosserie());
        trfFI.setValue("modell", fahrzeug.getModell());
        trfFI.setValue("region", fahrzeug.getKatalogausf());
        trfFI.setValue("lenkung", fahrzeug.getLenkung());
        trfFI.setValue("getriebe", fahrzeug.getGetriebe());
        trfFI.setValue("baujahr", fahrzeug.getBaujahr());
        trfFI.setValue("zulmonat", fahrzeug.getZulassungsmonat());
        GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.RESET_FAHRZEUGIDENTIFIKATION);
        GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.CHANGE_FAHRZEUGIDENTIFIKATION);
        GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
        if (trfFI.getError() != null) {
            throw trfFI.getError();
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        fahrzeug.setModellspalte(oFzgIdInfo.getModellspalte());
        if (oFzgIdInfo.getBaureiheBezeichnung() != null && oFzgIdInfo.getBaureiheBezeichnung().length() > 0) {
            fahrzeug.setBaureiheBezeichnung(oFzgIdInfo.getBaureiheBezeichnung());
        }
        if (oFzgIdInfo.getKarosserieBezeichnung() != null && oFzgIdInfo.getKarosserieBezeichnung().length() > 0) {
            fahrzeug.setKarosserieBezeichnung(oFzgIdInfo.getKarosserieBezeichnung());
        }
    }

    public static FzgSucheInfo getFIByFahrgesellnummer(String sFgstnr) {
        BooleanWrapper bVINSpecAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bIGDOMAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bVINSpecVerwendenUser = new BooleanWrapper(false);
        BooleanWrapper bIGDOMVerwendenUser = new BooleanWrapper(false);
        FBIDataloader.ermitteleAusstattungUeber(bVINSpecAngeschlossen, bIGDOMAngeschlossen, bVINSpecVerwendenUser, bIGDOMVerwendenUser);
        String sVINSpecKontaktieren = bVINSpecAngeschlossen.getValue() && bVINSpecVerwendenUser.getValue() ? "true" : "false";
        boolean bIGDOMKontaktieren = bIGDOMAngeschlossen.getValue() && bIGDOMVerwendenUser.getValue();
        String sIGDOMKontaktieren = bIGDOMKontaktieren ? "true" : "false";
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(bIGDOMKontaktieren);
        trfFI.setValue("isvollstaendigefi", "false");
        trfFI.setValue("fgstnr", sFgstnr);
        trfFI.setValue("vinspec_schnittstelle_kontaktieren", sVINSpecKontaktieren);
        trfFI.setValue("igdom_schnittstelle_kontaktieren", sIGDOMKontaktieren);
        if (GlobalObjects.getInstance().getIpacData().getIspaAusstattungen() != null && GlobalObjects.getInstance().getIpacData().getIspaAusstattungen().length > 0) {
            ArrayList<EtkScoreVerbauung> ispaAusstattung = new ArrayList<EtkScoreVerbauung>();
            ispaAusstattung.addAll(Arrays.asList(GlobalObjects.getInstance().getIpacData().getIspaAusstattungen()));
            trfFI.setValue("score_ausstattungsinfo", ispaAusstattung);
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
        }
        catch (CommunicationException ex) {
            log.error((Object)"DlgFzgIdController: ", (Throwable)ex);
            return null;
        }
        if (trfFI.getError() != null) {
            if (trfFI.getError() instanceof CommunicationException) {
                CommunicationException error = (CommunicationException)trfFI.getError();
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
                MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getZentraleSucheConnectionFehler(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                return null;
            }
            if (trfFI.getError() instanceof NoDataFoundException) {
                MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getFahrgestellnummerNoData(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                return null;
            }
            if (trfFI.getError() instanceof NoBrandAuthorizationException) {
                MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getKeineMarkenberechtigung(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return null;
        }
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)trfFI.getValue("fzgsucheinfo_app");
        if (!FBIDataloader.checkFahrzeugDaten(oFzgSucheInfo)) {
            JOptionPane.showMessageDialog((Component)ControllerMainPanel.getInstance().getMainPanel(), "<html>" + Resource.getInstance().getFahrgestellnummerNoData() + "</html>", "Information", 1);
            return null;
        }
        return oFzgSucheInfo;
    }

    public static boolean checkFahrzeugDaten(FzgSucheInfo fahrzeug) {
        if (fahrzeug == null) {
            return false;
        }
        if (fahrzeug.getMarke() == null) {
            return false;
        }
        if (!fahrzeug.getMarke().equals(GlobalObjects.getInstance().getSessionInfo().getMarke())) {
            return false;
        }
        return fahrzeug.getProduktart().equals(GlobalObjects.getInstance().getSessionInfo().getProdukart());
    }

    public static void ermitteleAusstattungUeber(BooleanWrapper bVINSpecAngeschlossen, BooleanWrapper bIGDOMAngeschlossen, BooleanWrapper bVINSpecGewaehlt, BooleanWrapper bIGDOMGewaehlt) {
        bVINSpecAngeschlossen.setValue(GlobalObjects.getInstance().isVINSpecAktiv());
        bIGDOMAngeschlossen.setValue(GlobalObjects.getInstance().hasNetz());
        String sAktuelleSchnittstelle = GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle();
        if (bVINSpecAngeschlossen.getValue() || bIGDOMAngeschlossen.getValue()) {
            if (sAktuelleSchnittstelle.equals("keine")) {
                bIGDOMGewaehlt.setValue(false);
                bVINSpecGewaehlt.setValue(false);
            } else if (sAktuelleSchnittstelle.equals("vinspec") && bVINSpecAngeschlossen.getValue()) {
                bVINSpecGewaehlt.setValue(true);
                bIGDOMGewaehlt.setValue(false);
            } else if (sAktuelleSchnittstelle.equals("igdom") && bIGDOMAngeschlossen.getValue()) {
                bVINSpecGewaehlt.setValue(false);
                bIGDOMGewaehlt.setValue(true);
            } else if (bVINSpecAngeschlossen.getValue()) {
                bVINSpecGewaehlt.setValue(true);
                bIGDOMGewaehlt.setValue(false);
            } else if (bIGDOMAngeschlossen.getValue()) {
                bVINSpecGewaehlt.setValue(false);
                bIGDOMGewaehlt.setValue(true);
            } else {
                bVINSpecGewaehlt.setValue(false);
                bIGDOMGewaehlt.setValue(false);
            }
        } else {
            bIGDOMGewaehlt.setValue(false);
            bVINSpecGewaehlt.setValue(false);
        }
    }
}

