/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.configurator.content.marketing.Bestandteil;
import de.esg.zub.utilities.CurrencyFormatter;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.ImageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import webetk.app.bteinfo.Info;
import webetk.app.zub.common.Preise;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;
import webetk.resources.Resource;

public class MarketingModel {
    private static final Logger logger = Logger.getLogger(MarketingModel.class);
    public static final String BNB_TEXT = "1";
    public static final String BTE_TEXT = "2";
    private MarketingProdukt mMarketingProdukt;
    private ArrayList<Bestandteil> bestandteile = new ArrayList();
    private ArrayList<String> mLinks;
    private boolean mZusatz = false;
    private ArrayList<ImageIcon> mImageIconZusatz;
    private ArrayList<String> mNamesZusatzKurz = new ArrayList();
    private ArrayList<String> mNamesZusatzLang = new ArrayList();
    private ArrayList<Integer> mAvailabilityZusatz;
    private ArrayList<String> mPiasZusatzprodukte;
    private ArrayList<ArrayList<Baureihe>> mBaureihenZusatzprodukte;
    private ArrayList<String> mDescriptionZusatzprodukte;
    private ArrayList<String> mPriceZusatzprodukte;
    private ArrayList<String> mLinksZusatzprodukte;
    private ArrayList<Integer> mIndexSelectedZusatzprodukte;
    private Variante selectedVariante;
    private Bnb selectedAlternative;
    private ArrayList<Bnb> selectedEinzelteile;
    private List<Integer> mVerbaubareVarianten;
    private List<Bnb> mVerbaubareAlternativen;
    private List<ProduktListenElement> mVerbaubareZusatzprodukte;
    private int indexAktuellesImage;
    private int indexAnzahlMaxImage;
    private Bnb textBnb = null;

    public MarketingModel() {
        this.mImageIconZusatz = new ArrayList();
        this.mAvailabilityZusatz = new ArrayList();
        this.mLinksZusatzprodukte = new ArrayList();
        this.mPriceZusatzprodukte = new ArrayList();
        this.mBaureihenZusatzprodukte = new ArrayList();
        this.mDescriptionZusatzprodukte = new ArrayList();
        this.mPiasZusatzprodukte = new ArrayList();
    }

    public void setMarketingProduct(MarketingProdukt produkt, boolean load) {
        int jj;
        this.mMarketingProdukt = produkt;
        this.bestandteile = new ArrayList();
        for (jj = 0; jj < produkt.getBestandTeile().size(); ++jj) {
            Bnb bestTeil = produkt.getBestandTeile().get(jj);
            Bestandteil bestandteil = new Bestandteil(bestTeil.getBnbName(), bestTeil.getBildPos(), bestTeil.getElementArt(), (ArrayList)produkt.getVariantenZuBestandteile().get(bestTeil.getBildPos()));
            this.bestandteile.add(jj, bestandteil);
        }
        if (!load) {
            this.mIndexSelectedZusatzprodukte = new ArrayList();
        }
        this.mImageIconZusatz = new ArrayList();
        this.mBaureihenZusatzprodukte = new ArrayList();
        this.mNamesZusatzKurz = new ArrayList();
        this.mNamesZusatzLang = new ArrayList();
        this.mPriceZusatzprodukte = new ArrayList();
        this.mDescriptionZusatzprodukte = new ArrayList();
        this.mAvailabilityZusatz = new ArrayList();
        if (produkt.getZusatzProdukte().size() != 0) {
            this.mZusatz = true;
            for (jj = 0; jj < produkt.getZusatzProdukte().size(); ++jj) {
                ImageIcon icon = null;
                ProduktListenElement elem = (ProduktListenElement)produkt.getZusatzProdukte().get(jj);
                icon = elem.getThumbNail() == null || elem.getThumbNail().getImageData() == null ? new ImageIcon(ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg")) : ImageUtils.getImageIcon(elem.getThumbNail().getImageData());
                this.mImageIconZusatz.add(icon);
                this.mBaureihenZusatzprodukte.add((ArrayList)elem.getBaureihen());
                if (elem.getVariante() != null) {
                    this.mNamesZusatzKurz.add(elem.getProduktNamePlain() + " in " + elem.getVariante().getName());
                    this.mNamesZusatzLang.add("<html>" + elem.getProduktNamePlain() + "<br> in " + elem.getVariante().getName() + "</html>");
                } else {
                    this.mNamesZusatzKurz.add(elem.getProduktNamePlain());
                    this.mNamesZusatzLang.add(elem.getProduktNamePlain());
                }
                this.mPriceZusatzprodukte.add(CurrencyFormatter.getInstance().getFormattedCurrency(elem.getPrice()));
                this.mDescriptionZusatzprodukte.add(elem.getDetailText());
                this.mAvailabilityZusatz.add(elem.getVerfuegbarkeit());
            }
        }
        this.setLinks(new ArrayList<String>());
        if (produkt.getPiasZusatzProdukte() != null && !produkt.getPiasZusatzProdukte().equals("")) {
            this.cleanText(produkt.getPiasZusatzProdukte());
        }
        this.setSelectedBnbsMitVarianten();
    }

    public void setSelectedBnbsMitVarianten() {
        ArrayList<Bnb> selectedBnbsMitVarianten = new ArrayList<Bnb>();
        if (this.getSelectedAlternative() != null) {
            Bnb alter = this.getSelectedAlternative();
            alter.setSelectedVariante(this.selectedVariante);
            selectedBnbsMitVarianten.add(alter);
        }
        for (int i = 0; i < this.mMarketingProdukt.getBestandTeile().size(); ++i) {
            Bnb bestandteil = this.mMarketingProdukt.getBestandTeile().get(i);
            if (this.bestandteile.get(i).getVarianten() != null && this.bestandteile.get(i).getVarianten().size() > 0) {
                Variante variante = this.bestandteile.get(i).getSelectedVariante();
                bestandteil.setSelectedVariante(variante);
            }
            selectedBnbsMitVarianten.add(bestandteil);
        }
        if (this.getSelectedEinzelteile() != null) {
            for (Bnb einzelteil : this.selectedEinzelteile) {
                selectedBnbsMitVarianten.add(einzelteil);
            }
        }
        for (int i = 0; i < this.getSelectedZusatzprodukte().size(); ++i) {
            ProduktListenElement zusatzPr = this.getSelectedZusatzprodukte().get(i);
            Bnb bnb = new Bnb();
            bnb.setBildPos(zusatzPr.getBildPosNr());
            bnb.setBteNr(zusatzPr.getBteNr());
            bnb.setBnbName(zusatzPr.getProduktName());
            bnb.setElementArt("OPTIONAL");
            bnb.setSelectedVariante(zusatzPr.getVariante());
            selectedBnbsMitVarianten.add(bnb);
        }
        this.mMarketingProdukt.setSelectedBnbsMitVarianten(selectedBnbsMitVarianten);
    }

    public int getMaxVariantenZeilen() {
        int maxZeilen = 0;
        HashMap varZuAlt = this.mMarketingProdukt.getVariantenZuAlternativen();
        if (varZuAlt != null) {
            Collection c = varZuAlt.values();
            for (ArrayList var : c) {
                if (maxZeilen >= var.size()) continue;
                maxZeilen = var.size();
            }
        }
        return maxZeilen;
    }

    private ArrayList<String> cleanText(String text) {
        int beginIndex = 0;
        int endIndex = 0;
        String dummy = text;
        endIndex = text.indexOf("#");
        if (this.mPiasZusatzprodukte != null) {
            this.mPiasZusatzprodukte = new ArrayList();
        }
        if (endIndex != -1) {
            while (beginIndex + 2 < text.length()) {
                this.mPiasZusatzprodukte.add(text.substring(beginIndex, endIndex));
                if (endIndex != text.length()) {
                    beginIndex = endIndex + 1;
                    dummy = text.substring(beginIndex, text.length());
                    if (dummy.contains("#")) {
                        endIndex = beginIndex + dummy.indexOf("#");
                        continue;
                    }
                    endIndex = text.length();
                    continue;
                }
                beginIndex = endIndex;
            }
        } else {
            this.mPiasZusatzprodukte.add(text);
        }
        return this.mPiasZusatzprodukte;
    }

    public String getProductName() {
        if (this.mMarketingProdukt.getProduktName() != null) {
            return this.mMarketingProdukt.getProduktName();
        }
        return "";
    }

    public String getProductNamePlain() {
        if (this.mMarketingProdukt.getProduktNamePlain() != null) {
            return this.mMarketingProdukt.getProduktNamePlain();
        }
        return "";
    }

    public String getMaketingText() {
        return this.mMarketingProdukt.getDetailText();
    }

    public ArrayList<Bestandteil> getBestandteile() {
        return this.bestandteile;
    }

    public ImageIcon getSelectedImage(Variante variante) {
        if (this.mMarketingProdukt.getBildPosNr() != null || variante == null) {
            return this.getBteImage(0);
        }
        if (variante.getGrafik().getImageData() != null) {
            ImageIcon newImage = ImageUtils.getImageIcon(variante.getGrafik().getImageData());
            return this.pruefeSizeImage(newImage, variante.getGrafik());
        }
        return this.getBteImage(0);
    }

    private ImageIcon pruefeSizeImage(ImageIcon newImage, Zubehoergrafik source) {
        if (newImage.getIconWidth() > 400 || newImage.getIconHeight() > 290) {
            newImage = new ImageIcon(ImageUtils.getScaledImage(source.getImageData(), 400, -1));
        } else if (newImage.getIconWidth() < 160 || newImage.getIconHeight() < 120) {
            newImage = new ImageIcon(ImageUtils.getScaledImage(source.getImageData(), 400, 253));
        }
        return newImage;
    }

    public ImageIcon getBteImage(int i) {
        if (this.mMarketingProdukt.getImages().size() > 0) {
            ImageIcon newImage = ImageUtils.getImageIcon(this.mMarketingProdukt.getImages().get(i).getImageData());
            return this.pruefeSizeImage(newImage, this.mMarketingProdukt.getImages().get(i));
        }
        return new ImageIcon(ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg"));
    }

    public ImageIcon getThumbnail() {
        Zubehoergrafik thumbnail = this.mMarketingProdukt.getThumbnail();
        if (thumbnail != null && thumbnail.getImageData() != null) {
            ImageIcon imageIcon = ImageUtils.getImageIcon(thumbnail.getImageData());
            if (imageIcon.getIconWidth() < 101 && imageIcon.getIconHeight() < 71) {
                return imageIcon;
            }
            return ImageUtils.getScaledImageIcon(thumbnail.getImageData(), 100, 70);
        }
        logger.error((Object)"Keine Thumbnail-Grafik zu Produkt gefunden");
        return new ImageIcon(ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg").getScaledInstance(Constants.BildGroessen.THUMBNAIL_MAX_SIZE.width, Constants.BildGroessen.THUMBNAIL_MAX_SIZE.height, 4));
    }

    public Double getPriceAsDouble() {
        Double preis = null;
        Preise preise = GlobalObjects.getInstance().getIpacData().getPreise();
        if (preise != null) {
            String bnbNr = this.mMarketingProdukt.getBildPosNr();
            ArrayList<Bnb> bnbsVarianten = this.mMarketingProdukt.getSelectedBnbsMitVarianten();
            preis = preise.getAbPreis(bnbNr, bnbsVarianten);
        }
        return preis;
    }

    public String getPrice() {
        return CurrencyFormatter.getInstance().getFormattedCurrency(this.getPriceAsDouble());
    }

    public ArrayList<String> getLinks() {
        return this.mLinks;
    }

    public void setLinks(ArrayList<String> links) {
        this.mLinks = links;
    }

    public ImageIcon getImagesZusatzprodukte(int i) {
        return this.mImageIconZusatz.get(i);
    }

    public ArrayList<String> getNamesZusatzprodukte() {
        return this.mNamesZusatzKurz;
    }

    public ArrayList<String> getNamesZusatzprodukteLang() {
        return this.mNamesZusatzLang;
    }

    public String getTeaserZusatzprodukte(int i) {
        return ((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getTeaser();
    }

    public String getDetailtextZusatzprodukte(int i) {
        if (((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getDetailText() != null) {
            if (!((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getDetailText().equals("")) {
                return ((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getDetailText();
            }
            if (((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getTeaser() != null) {
                return ((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getTeaser();
            }
        } else if (((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getTeaser() != null) {
            return ((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(i)).getTeaser();
        }
        return "";
    }

    public ArrayList<String> getPriceZusatzprodukte() {
        return this.mPriceZusatzprodukte;
    }

    public ArrayList<String> getLinksZusatzprodukte() {
        return this.mLinksZusatzprodukte;
    }

    public Variante getErsteSelektierteVariante() {
        Variante variante = null;
        if (this.mMarketingProdukt.getSelectedBnbsMitVarianten() != null && this.mMarketingProdukt.getSelectedBnbsMitVarianten().size() > 0) {
            for (int i = 0; i < this.mMarketingProdukt.getSelectedBnbsMitVarianten().size() && ((variante = this.mMarketingProdukt.getSelectedBnbsMitVarianten().get(i).getSelectedVariante()) == null || variante.getVarianteId() == 0); ++i) {
            }
        }
        return variante;
    }

    public boolean hasZusatz() {
        if (this.mZusatz) {
            return this.mZusatz;
        }
        return this.mMarketingProdukt.getPiasZusatzProdukte() != null && !this.mMarketingProdukt.getPiasZusatzProdukte().equals("");
    }

    public void setZusatz(boolean zusatz) {
        this.mZusatz = zusatz;
    }

    public Bnb getSelectedAlternative() {
        return this.selectedAlternative;
    }

    public ArrayList<ProduktListenElement> getSelectedZusatzprodukte() {
        ArrayList<ProduktListenElement> selektionZusatz = new ArrayList<ProduktListenElement>();
        if (this.mIndexSelectedZusatzprodukte != null) {
            for (Integer store : this.mIndexSelectedZusatzprodukte) {
                selektionZusatz.add((ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(store));
            }
        }
        return selektionZusatz;
    }

    public ProduktListenElement getSelectedZusatzprodukt(int selIndex) {
        return (ProduktListenElement)this.mMarketingProdukt.getZusatzProdukte().get(selIndex);
    }

    public void setIndexSelectedZusatzprodukte(int selectedZusatzprodukte) {
        if (!this.mIndexSelectedZusatzprodukte.contains(selectedZusatzprodukte)) {
            this.mIndexSelectedZusatzprodukte.add(selectedZusatzprodukte);
        }
    }

    public void removeIndexSelectedZusatzprodukt(int selectedZusatzprodukte) {
        Iterator<Integer> it = this.mIndexSelectedZusatzprodukte.iterator();
        while (it.hasNext()) {
            Integer store = it.next();
            if (store != selectedZusatzprodukte) continue;
            it.remove();
        }
    }

    public void resetAlleSelektionen() {
        this.selectedVariante = null;
        this.selectedAlternative = null;
        this.selectedEinzelteile = null;
        for (int i = 0; i < this.bestandteile.size(); ++i) {
            this.bestandteile.get(i).setSelectedVariante(null);
        }
        this.mIndexSelectedZusatzprodukte = null;
    }

    public String getDialogTitel() {
        return Resource.getInstance().getFehlerLadenMarketingdaten();
    }

    public MarketingProdukt getMarketingProdukt() {
        return this.mMarketingProdukt;
    }

    public ArrayList<Integer> getIndexSelectedZusatzprodukte() {
        return this.mIndexSelectedZusatzprodukte;
    }

    public ArrayList<Baureihe> getBaureihenZusatzprodukte(int pos) {
        return this.mBaureihenZusatzprodukte.get(pos);
    }

    public ArrayList<String> getDescriptionZusatzprodukte() {
        return this.mDescriptionZusatzprodukte;
    }

    public List<Bnb> getVerbaubareAlternativen() {
        return this.mVerbaubareAlternativen;
    }

    public void setVerbaubareAlternativen(List<Bnb> verbaubareAlternativen) {
        this.mVerbaubareAlternativen = verbaubareAlternativen;
    }

    public List<Integer> getVerbaubareVarianten() {
        return this.mVerbaubareVarianten;
    }

    public void setVerbaubareVarianten(List<Integer> verbaubareVarianten) {
        this.mVerbaubareVarianten = verbaubareVarianten;
    }

    public List<ProduktListenElement> getVerbaubareZusatzprodukte() {
        return this.mVerbaubareZusatzprodukte;
    }

    public void setVerbaubareZusatzprodukte(List<ProduktListenElement> verbaubareZusatzprodukte) {
        this.mVerbaubareZusatzprodukte = verbaubareZusatzprodukte;
    }

    public Info getMarketingRelevantenKommentar() {
        return this.mMarketingProdukt.getBteKommentar();
    }

    public ArrayList<String> getPiasZusatzprodukte() {
        return this.mPiasZusatzprodukte;
    }

    public boolean hasWeitereInfo() {
        if (this.textBnb == null) {
            if (this.mMarketingProdukt.getNutzen() != null && !this.mMarketingProdukt.getNutzen().equals("")) {
                return true;
            }
            if (this.getMarketingRelevantenKommentar() != null && this.getMarketingRelevantenKommentar().getHinweise() != null && this.getMarketingRelevantenKommentar().getHinweise().size() > 0) {
                return true;
            }
            if (this.mMarketingProdukt.getWettbewerb() != null && !this.mMarketingProdukt.getWettbewerb().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getZusatzNutzen() != null && !this.mMarketingProdukt.getZusatzNutzen().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getTippsUndTricks() != null && !this.mMarketingProdukt.getTippsUndTricks().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getWeitergehendeInformationen() != null && !this.mMarketingProdukt.getWeitergehendeInformationen().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getVerkaufsinfo() != null && !this.mMarketingProdukt.getVerkaufsinfo().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getHinweise() != null && !this.mMarketingProdukt.getHinweise().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getCrossSelling() != null && !this.mMarketingProdukt.getCrossSelling().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getErsatzTeile() != null && !this.mMarketingProdukt.getErsatzTeile().equals("")) {
                return true;
            }
            if (this.mMarketingProdukt.getDetails() != null && !this.mMarketingProdukt.getDetails().equals("")) {
                return true;
            }
            return this.mMarketingProdukt.getSonstiges() != null && !this.mMarketingProdukt.getSonstiges().equals("");
        }
        if (this.textBnb.getVerkaufsinfo() != null && !this.textBnb.getVerkaufsinfo().equals("")) {
            return true;
        }
        if (this.textBnb.getHinweise() != null && !this.textBnb.getHinweise().equals("")) {
            return true;
        }
        if (this.textBnb.getCrossSelling() != null && !this.textBnb.getCrossSelling().equals("")) {
            return true;
        }
        if (this.textBnb.getErsatzTeile() != null && !this.textBnb.getErsatzTeile().equals("")) {
            return true;
        }
        if (this.textBnb.getDetails() != null && !this.textBnb.getDetails().equals("")) {
            return true;
        }
        if (this.textBnb.getSonstiges() != null && !this.textBnb.getSonstiges().equals("")) {
            return true;
        }
        return true;
    }

    public void setBestandteile(ArrayList<Bestandteil> bestandteile) {
        this.bestandteile = bestandteile;
    }

    public int getIndexAktuellesImage() {
        return this.indexAktuellesImage;
    }

    public void setIndexAktuellesImage(int indexAktuellesImage) {
        this.indexAktuellesImage = indexAktuellesImage;
    }

    public int getIndexAnzahlMaxImage() {
        return this.indexAnzahlMaxImage;
    }

    public void setIndexAnzahlMaxImage(int indexAnzahlMaxImage) {
        this.indexAnzahlMaxImage = indexAnzahlMaxImage;
    }

    public Variante getSelectedVariante() {
        return this.selectedVariante;
    }

    public void setSelectedVariante(Variante selectedVariante) {
        this.selectedVariante = selectedVariante;
    }

    public void setSelectedAlternative(String position) {
        for (Bnb alter : (ArrayList)this.mMarketingProdukt.getAlternativen()) {
            if (!alter.getBildPos().equals(position)) continue;
            this.selectedAlternative = alter;
        }
    }

    public void setSelectedAlternative(Bnb alternative) {
        this.selectedAlternative = alternative;
    }

    public ArrayList<Bnb> getSelectedEinzelteile() {
        return this.selectedEinzelteile;
    }

    public void setSelectedEinzelteile(ArrayList<Bnb> selectedEinzelteile) {
        this.selectedEinzelteile = selectedEinzelteile;
    }

    public Bnb getEinzelteil(String bildPosNr) {
        Bnb bnb = null;
        for (Bnb einzelteil : (ArrayList)this.mMarketingProdukt.getEinzelteile()) {
            if (!einzelteil.getBildPos().equals(bildPosNr)) continue;
            bnb = einzelteil;
            break;
        }
        return bnb;
    }

    public void addSelectedEinzelteil(Bnb selEinzelteil) {
        if (this.selectedEinzelteile == null) {
            this.selectedEinzelteile = new ArrayList();
        }
        if (!this.selectedEinzelteile.contains(selEinzelteil)) {
            this.selectedEinzelteile.add(selEinzelteil);
        }
    }

    public void removeSelectedEinzelteil(Bnb selEinzelteil) {
        if (this.selectedEinzelteile != null && this.selectedEinzelteile.contains(selEinzelteil)) {
            this.selectedEinzelteile.remove(selEinzelteil);
        }
    }

    public Bnb getTextBnb() {
        return this.textBnb;
    }

    public void setTextBnb(Bnb bnb) {
        this.textBnb = bnb;
    }

    public boolean habenBestandteileVarianten() {
        if (this.getBestandteile().size() > 0) {
            for (Bestandteil part : this.getBestandteile()) {
                ArrayList<Variante> varianten = part.getVarianten();
                if (varianten.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }
}

